/*
 * Decompiled with CFR 0.152.
 */
package com.github.rumsfield.konquest.command;

import com.github.rumsfield.konquest.Konquest;
import com.github.rumsfield.konquest.command.CommandBase;
import com.github.rumsfield.konquest.model.KonPlayer;
import com.github.rumsfield.konquest.model.KonPrefixType;
import com.github.rumsfield.konquest.utility.ChatUtil;
import com.github.rumsfield.konquest.utility.MessagePath;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class PrefixCommand
extends CommandBase {
    public PrefixCommand() {
        super("prefix", true, false);
        this.setOptionalArgs(true);
        this.addArgument(this.newArg("menu", true, false));
        this.addArgument(this.newArg("clear", true, false));
        this.addArgument(this.newArg("set", true, false).sub(this.newArg("title", false, false)));
    }

    @Override
    public void execute(Konquest konquest, CommandSender sender, List<String> args) {
        KonPlayer player = konquest.getPlayerManager().getPlayer(sender);
        if (player == null) {
            this.sendInvalidSenderMessage(sender);
            return;
        }
        Player bukkitPlayer = player.getBukkitPlayer();
        if (!konquest.getAccomplishmentManager().isEnabled()) {
            ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.GENERIC_ERROR_DISABLED.getMessage(new Object[0]));
            return;
        }
        if (player.isBarbarian()) {
            ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.GENERIC_ERROR_DENY_BARBARIAN.getMessage(new Object[0]));
            return;
        }
        if (args.isEmpty()) {
            konquest.getDisplayManager().displayPrefixMenu(player);
        } else {
            String subCmd = args.get(0);
            switch (subCmd.toLowerCase()) {
                case "menu": {
                    konquest.getDisplayManager().displayPrefixMenu(player);
                    break;
                }
                case "clear": {
                    konquest.getAccomplishmentManager().disablePlayerPrefix(player);
                    break;
                }
                case "set": {
                    if (args.size() == 2) {
                        String titleName = args.get(1);
                        if (KonPrefixType.isPrefixName(titleName)) {
                            KonPrefixType prefix = KonPrefixType.getPrefixByName(titleName);
                            konquest.getAccomplishmentManager().applyPlayerPrefix(player, prefix);
                            break;
                        }
                        ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.GENERIC_ERROR_UNKNOWN_NAME.getMessage(titleName));
                        break;
                    }
                    this.sendInvalidArgMessage(sender);
                    break;
                }
                default: {
                    this.sendInvalidArgMessage(sender);
                }
            }
        }
    }

    @Override
    public List<String> tabComplete(Konquest konquest, CommandSender sender, List<String> args) {
        String subCmd;
        KonPlayer player = konquest.getPlayerManager().getPlayer(sender);
        if (player == null) {
            return Collections.emptyList();
        }
        ArrayList<String> tabList = new ArrayList<String>();
        if (args.size() == 1) {
            tabList.add("menu");
            tabList.add("clear");
            tabList.add("set");
        } else if (args.size() == 2 && (subCmd = args.get(0)).equalsIgnoreCase("set")) {
            tabList.addAll(player.getPlayerPrefix().getPrefixNames());
        }
        return this.matchLastArgToList(tabList, args);
    }
}

