/*
 * Decompiled with CFR 0.152.
 */
package com.github.rumsfield.konquest.command;

import com.github.rumsfield.konquest.Konquest;
import com.github.rumsfield.konquest.command.CommandBase;
import com.github.rumsfield.konquest.model.KonKingdom;
import com.github.rumsfield.konquest.model.KonOfflinePlayer;
import com.github.rumsfield.konquest.model.KonPlayer;
import com.github.rumsfield.konquest.utility.ChatUtil;
import com.github.rumsfield.konquest.utility.MessagePath;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class ScoreCommand
extends CommandBase {
    public ScoreCommand() {
        super("score", true, false);
        this.setOptionalArgs(true);
        this.addArgument(this.newArg("menu", true, false));
        this.addArgument(this.newArg("all", true, false));
        List<String> argNames = Arrays.asList("player", "kingdom");
        this.addArgument(this.newArg(argNames, true, false).sub(this.newArg("name", false, false)));
    }

    @Override
    public void execute(Konquest konquest, CommandSender sender, List<String> args) {
        KonPlayer player = konquest.getPlayerManager().getPlayer(sender);
        if (player == null) {
            this.sendInvalidSenderMessage(sender);
            return;
        }
        Player bukkitPlayer = player.getBukkitPlayer();
        if (args.isEmpty()) {
            konquest.getDisplayManager().displayScoreMenu(player);
            if (!player.isBarbarian() && !player.getKingdom().isPeaceful()) {
                int kingdomScore = konquest.getKingdomManager().getKingdomScore(player.getKingdom());
                int playerScore = konquest.getKingdomManager().getPlayerScore(player);
                ChatUtil.sendNotice((CommandSender)bukkitPlayer, MessagePath.COMMAND_SCORE_NOTICE_SCORE.getMessage(playerScore, player.getKingdom().getName(), kingdomScore));
            }
        } else {
            switch (args.get(0).toLowerCase()) {
                case "menu": {
                    konquest.getDisplayManager().displayScoreMenu(player);
                    break;
                }
                case "all": {
                    ChatUtil.sendNotice((CommandSender)bukkitPlayer, String.valueOf(ChatColor.GOLD) + MessagePath.COMMAND_SCORE_NOTICE_ALL_HEADER.getMessage(new Object[0]));
                    for (KonKingdom allKingdom : konquest.getKingdomManager().getKingdoms()) {
                        if (allKingdom.isPeaceful()) continue;
                        int score = konquest.getKingdomManager().getKingdomScore(allKingdom);
                        String color = konquest.getDisplaySecondaryColor(player.getKingdom(), allKingdom);
                        ChatUtil.sendMessage((CommandSender)bukkitPlayer, color + allKingdom.getName() + String.valueOf(ChatColor.GOLD) + ": " + String.valueOf(ChatColor.DARK_PURPLE) + score);
                    }
                    break;
                }
                case "player": {
                    if (args.size() != 2) {
                        this.sendInvalidArgMessage(sender);
                        return;
                    }
                    String playerName = args.get(1);
                    KonOfflinePlayer scorePlayer = konquest.getPlayerManager().getOfflinePlayerFromName(playerName);
                    if (scorePlayer == null) {
                        ChatUtil.sendError(sender, MessagePath.GENERIC_ERROR_UNKNOWN_NAME.getMessage(playerName));
                        return;
                    }
                    if (scorePlayer.isBarbarian()) {
                        ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.COMMAND_SCORE_ERROR_BARBARIAN.getMessage(scorePlayer.getOfflineBukkitPlayer().getName()));
                        break;
                    }
                    if (scorePlayer.getKingdom().isPeaceful()) {
                        ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.COMMAND_SCORE_ERROR_PEACEFUL.getMessage(scorePlayer.getKingdom().getName()));
                        break;
                    }
                    int kingdomScore = konquest.getKingdomManager().getKingdomScore(scorePlayer.getKingdom());
                    int playerScore = konquest.getKingdomManager().getPlayerScore(scorePlayer);
                    ChatUtil.sendNotice((CommandSender)bukkitPlayer, MessagePath.COMMAND_SCORE_NOTICE_PLAYER.getMessage(scorePlayer.getOfflineBukkitPlayer().getName(), playerScore, scorePlayer.getKingdom().getName(), kingdomScore));
                    konquest.getDisplayManager().displayScorePlayerMenu(player, scorePlayer);
                    break;
                }
                case "kingdom": {
                    if (args.size() != 2) {
                        this.sendInvalidArgMessage(sender);
                        return;
                    }
                    String kingdomName = args.get(1);
                    if (!konquest.getKingdomManager().isKingdom(kingdomName)) {
                        ChatUtil.sendError(sender, MessagePath.GENERIC_ERROR_UNKNOWN_NAME.getMessage(kingdomName));
                        return;
                    }
                    KonKingdom scoreKingdom = konquest.getKingdomManager().getKingdom(kingdomName);
                    if (scoreKingdom.isPeaceful()) {
                        ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.COMMAND_SCORE_ERROR_PEACEFUL.getMessage(scoreKingdom.getName()));
                        break;
                    }
                    int kingdomScore = konquest.getKingdomManager().getKingdomScore(scoreKingdom);
                    ChatUtil.sendNotice((CommandSender)bukkitPlayer, MessagePath.COMMAND_SCORE_NOTICE_KINGDOM.getMessage(scoreKingdom.getName(), kingdomScore));
                    konquest.getDisplayManager().displayScoreKingdomMenu(player, scoreKingdom);
                    break;
                }
                default: {
                    this.sendInvalidArgMessage(sender);
                }
            }
        }
    }

    @Override
    public List<String> tabComplete(Konquest konquest, CommandSender sender, List<String> args) {
        ArrayList<String> tabList = new ArrayList<String>();
        if (args.size() == 1) {
            tabList.add("menu");
            tabList.add("all");
            tabList.add("player");
            tabList.add("kingdom");
        } else if (args.size() == 2) {
            String type;
            switch (type = args.get(0).toLowerCase()) {
                case "player": {
                    for (OfflinePlayer bukkitOfflinePlayer : konquest.getPlayerManager().getAllOfflinePlayers()) {
                        tabList.add(bukkitOfflinePlayer.getName());
                    }
                    break;
                }
                case "kingdom": {
                    tabList.addAll(konquest.getKingdomManager().getKingdomNames());
                    break;
                }
            }
        }
        return this.matchLastArgToList(tabList, args);
    }
}

