/*
 * Decompiled with CFR 0.152.
 */
package com.github.rumsfield.konquest.command;

import com.github.rumsfield.konquest.Konquest;
import com.github.rumsfield.konquest.KonquestPlugin;
import com.github.rumsfield.konquest.api.event.player.KonquestPlayerSettleEvent;
import com.github.rumsfield.konquest.api.event.town.KonquestTownSettleEvent;
import com.github.rumsfield.konquest.command.CommandBase;
import com.github.rumsfield.konquest.model.KonDirective;
import com.github.rumsfield.konquest.model.KonKingdom;
import com.github.rumsfield.konquest.model.KonPlayer;
import com.github.rumsfield.konquest.model.KonStatsType;
import com.github.rumsfield.konquest.model.KonTown;
import com.github.rumsfield.konquest.utility.ChatUtil;
import com.github.rumsfield.konquest.utility.CorePath;
import com.github.rumsfield.konquest.utility.HelperUtil;
import com.github.rumsfield.konquest.utility.MessagePath;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class SettleCommand
extends CommandBase {
    public SettleCommand() {
        super("settle", true, false);
        this.addArgument(this.newArg("name", false, false));
    }

    @Override
    public void execute(Konquest konquest, CommandSender sender, List<String> args) {
        KonPlayer player = konquest.getPlayerManager().getPlayer(sender);
        if (player == null) {
            this.sendInvalidSenderMessage(sender);
            return;
        }
        if (args.isEmpty()) {
            ChatUtil.sendError(sender, MessagePath.COMMAND_SETTLE_ERROR_MISSING_NAME.getMessage(new Object[0]));
        } else if (args.size() > 1) {
            ChatUtil.sendError(sender, MessagePath.COMMAND_SETTLE_ERROR_SPACE_NAME.getMessage(new Object[0]));
        } else {
            boolean isOfficerOnly;
            if (player.isBarbarian()) {
                ChatUtil.sendError(sender, MessagePath.GENERIC_ERROR_DENY_BARBARIAN.getMessage(new Object[0]));
                return;
            }
            Player bukkitPlayer = player.getBukkitPlayer();
            if (!bukkitPlayer.hasPermission("konquest.create.town")) {
                ChatUtil.sendError(sender, MessagePath.GENERIC_ERROR_NO_PERMISSION.getMessage(new Object[0]) + " konquest.create.town");
                return;
            }
            if (konquest.getIntegrationManager().getWorldGuard().isEnabled()) {
                Location settleLoc = bukkitPlayer.getLocation();
                int radius = konquest.getCore().getInt(CorePath.TOWNS_INIT_RADIUS.getPath());
                World locWorld = settleLoc.getWorld();
                for (Point point : HelperUtil.getAreaPoints(settleLoc, radius)) {
                    if (konquest.getIntegrationManager().getWorldGuard().isChunkClaimAllowed(locWorld, point, bukkitPlayer)) continue;
                    ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.REGION_ERROR_CLAIM_DENY.getMessage(new Object[0]));
                    return;
                }
            }
            KonKingdom settleKingdom = player.getKingdom();
            World settleWorld = bukkitPlayer.getLocation().getWorld();
            if (settleWorld != null) {
                boolean isPerWorld = konquest.getCore().getBoolean(CorePath.KINGDOMS_MAX_TOWN_LIMIT_PER_WORLD.getPath(), false);
                int maxTownLimit = konquest.getCore().getInt(CorePath.KINGDOMS_MAX_TOWN_LIMIT.getPath(), 0);
                if ((maxTownLimit = Math.max(maxTownLimit, 0)) != 0) {
                    int numTownsInWorld = 0;
                    if (isPerWorld) {
                        for (KonTown town : settleKingdom.getCapitalTowns()) {
                            if (!town.getWorld().equals((Object)settleWorld)) continue;
                            ++numTownsInWorld;
                        }
                    } else {
                        numTownsInWorld = settleKingdom.getCapitalTowns().size();
                    }
                    if (numTownsInWorld >= maxTownLimit) {
                        if (isPerWorld) {
                            ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.COMMAND_SETTLE_ERROR_FAIL_LIMIT_WORLD.getMessage(numTownsInWorld, maxTownLimit));
                        } else {
                            ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.COMMAND_SETTLE_ERROR_FAIL_LIMIT_ALL.getMessage(numTownsInWorld, maxTownLimit));
                        }
                        return;
                    }
                }
            }
            if ((isOfficerOnly = konquest.getCore().getBoolean(CorePath.TOWNS_SETTLE_OFFICER_ONLY.getPath(), false)) && !settleKingdom.isOfficer(bukkitPlayer.getUniqueId())) {
                ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.COMMAND_SETTLE_ERROR_OFFICER_ONLY.getMessage(new Object[0]));
                return;
            }
            double cost = konquest.getCore().getDouble(CorePath.FAVOR_TOWNS_COST_SETTLE.getPath());
            double settleCost = konquest.getKingdomManager().getSettleCost(player);
            if (cost > 0.0 && KonquestPlugin.getBalance((OfflinePlayer)bukkitPlayer) < settleCost) {
                ChatUtil.sendError(sender, MessagePath.GENERIC_ERROR_NO_FAVOR.getMessage(settleCost));
                return;
            }
            String townName = args.get(0);
            if (konquest.validateName(townName, (CommandSender)bukkitPlayer) != 0) {
                return;
            }
            KonquestPlayerSettleEvent invokeEvent = new KonquestPlayerSettleEvent(konquest, player, player.getKingdom(), bukkitPlayer.getLocation(), townName);
            Konquest.callKonquestEvent(invokeEvent);
            if (invokeEvent.isCancelled()) {
                return;
            }
            int settleStatus = konquest.getKingdomManager().createTown(bukkitPlayer.getLocation(), townName, player.getKingdom().getName());
            if (settleStatus == 0) {
                KonTown town = player.getKingdom().getTown(townName);
                konquest.getKingdomManager().teleportAwayFromCenter(town);
                ChatUtil.sendNotice(sender, MessagePath.COMMAND_SETTLE_NOTICE_SUCCESS.getMessage(townName));
                ChatUtil.sendBroadcast(MessagePath.COMMAND_SETTLE_BROADCAST_SETTLE.getMessage(bukkitPlayer.getName(), townName, player.getKingdom().getName()));
                int starterShieldDuration = konquest.getCore().getInt(CorePath.TOWNS_SHIELD_NEW_TOWNS.getPath(), 0);
                if (starterShieldDuration > 0) {
                    konquest.getShieldManager().shieldSet(town, starterShieldDuration);
                }
                Konquest.playTownSettleSound(bukkitPlayer.getLocation());
                town.setPlayerLord(player.getOfflineBukkitPlayer());
                konquest.getDirectiveManager().updateDirectiveProgress(player, KonDirective.SETTLE_TOWN);
                konquest.getAccomplishmentManager().modifyPlayerStat(player, KonStatsType.SETTLED, 1);
                konquest.getKingdomManager().updatePlayerMembershipStats(player);
                konquest.getMapHandler().drawLabelTerritory(town);
                konquest.getMapHandler().drawLabelTerritory(town.getKingdom().getCapital());
                KonquestTownSettleEvent invokePostEvent = new KonquestTownSettleEvent(konquest, town, player, town.getKingdom());
                Konquest.callKonquestEvent(invokePostEvent);
            } else {
                switch (settleStatus) {
                    case 1: {
                        ChatUtil.sendError(sender, MessagePath.COMMAND_SETTLE_ERROR_FAIL_OVERLAP.getMessage(new Object[0]));
                        ChatUtil.sendNotice(sender, MessagePath.COMMAND_SETTLE_NOTICE_MAP_HINT.getMessage(new Object[0]));
                        break;
                    }
                    case 2: {
                        ChatUtil.sendError(sender, MessagePath.COMMAND_SETTLE_ERROR_FAIL_PLACEMENT.getMessage(new Object[0]));
                        ChatUtil.sendNotice(sender, MessagePath.COMMAND_SETTLE_NOTICE_MAP_HINT.getMessage(new Object[0]));
                        break;
                    }
                    case 3: {
                        ChatUtil.sendError(sender, MessagePath.COMMAND_SETTLE_ERROR_FAIL_NAME.getMessage(new Object[0]));
                        break;
                    }
                    case 4: {
                        ChatUtil.sendError(sender, MessagePath.COMMAND_SETTLE_ERROR_FAIL_TEMPLATE.getMessage(new Object[0]));
                        break;
                    }
                    case 5: {
                        ChatUtil.sendError(sender, MessagePath.GENERIC_ERROR_INVALID_WORLD.getMessage(new Object[0]));
                        break;
                    }
                    case 6: {
                        int distance = konquest.getTerritoryManager().getDistanceToClosestTerritory(bukkitPlayer.getLocation());
                        int min_distance_sanc = konquest.getCore().getInt(CorePath.TOWNS_MIN_DISTANCE_SANCTUARY.getPath());
                        int min_distance_town = konquest.getCore().getInt(CorePath.TOWNS_MIN_DISTANCE_TOWN.getPath());
                        int min_distance = Math.min(min_distance_sanc, min_distance_town);
                        ChatUtil.sendError(sender, MessagePath.COMMAND_SETTLE_ERROR_FAIL_PROXIMITY.getMessage(distance, min_distance));
                        ChatUtil.sendNotice(sender, MessagePath.COMMAND_SETTLE_NOTICE_MAP_HINT.getMessage(new Object[0]));
                        break;
                    }
                    case 7: {
                        int distance = konquest.getTerritoryManager().getDistanceToClosestTerritory(bukkitPlayer.getLocation());
                        int max_distance_all = konquest.getCore().getInt(CorePath.TOWNS_MAX_DISTANCE_ALL.getPath());
                        ChatUtil.sendError(sender, MessagePath.COMMAND_SETTLE_ERROR_FAIL_MAX.getMessage(distance, max_distance_all));
                        ChatUtil.sendNotice(sender, MessagePath.COMMAND_SETTLE_NOTICE_MAP_HINT.getMessage(new Object[0]));
                        break;
                    }
                    case 21: {
                        ChatUtil.sendError(sender, MessagePath.GENERIC_ERROR_INTERNAL.getMessage(new Object[0]));
                        break;
                    }
                    case 22: {
                        ChatUtil.sendError(sender, MessagePath.COMMAND_SETTLE_ERROR_FAIL_FLAT.getMessage(new Object[0]));
                        break;
                    }
                    case 23: {
                        ChatUtil.sendError(sender, MessagePath.COMMAND_SETTLE_ERROR_FAIL_HEIGHT.getMessage(new Object[0]));
                        break;
                    }
                    case 12: {
                        ChatUtil.sendError(sender, MessagePath.COMMAND_SETTLE_ERROR_FAIL_HEIGHT.getMessage(new Object[0]));
                        break;
                    }
                    case 13: {
                        ChatUtil.sendError(sender, MessagePath.COMMAND_SETTLE_ERROR_FAIL_INIT.getMessage(new Object[0]));
                        break;
                    }
                    case 14: {
                        ChatUtil.sendError(sender, MessagePath.COMMAND_SETTLE_ERROR_FAIL_AIR.getMessage(new Object[0]));
                        break;
                    }
                    case 15: {
                        ChatUtil.sendError(sender, MessagePath.COMMAND_SETTLE_ERROR_FAIL_WATER.getMessage(new Object[0]));
                        break;
                    }
                    case 16: {
                        ChatUtil.sendError(sender, MessagePath.COMMAND_SETTLE_ERROR_FAIL_CONTAINER.getMessage(new Object[0]));
                        break;
                    }
                    default: {
                        ChatUtil.sendError(sender, MessagePath.GENERIC_ERROR_INTERNAL.getMessage(new Object[0]));
                    }
                }
            }
            if (cost > 0.0 && settleStatus == 0 && KonquestPlugin.withdrawPlayer((OfflinePlayer)bukkitPlayer, settleCost)) {
                konquest.getAccomplishmentManager().modifyPlayerStat(player, KonStatsType.FAVOR, (int)settleCost);
            }
        }
    }

    @Override
    public List<String> tabComplete(Konquest konquest, CommandSender sender, List<String> args) {
        ArrayList<String> tabList = new ArrayList<String>();
        if (args.size() == 1) {
            tabList.add("***");
        }
        return this.matchLastArgToList(tabList, args);
    }
}

