/*
 * Decompiled with CFR 0.152.
 */
package com.github.rumsfield.konquest.command;

import com.github.rumsfield.konquest.Konquest;
import com.github.rumsfield.konquest.KonquestPlugin;
import com.github.rumsfield.konquest.api.model.KonquestDiplomacyType;
import com.github.rumsfield.konquest.command.CommandBase;
import com.github.rumsfield.konquest.model.KonKingdom;
import com.github.rumsfield.konquest.model.KonPlayer;
import com.github.rumsfield.konquest.model.KonStatsType;
import com.github.rumsfield.konquest.model.KonTerritory;
import com.github.rumsfield.konquest.model.KonTown;
import com.github.rumsfield.konquest.model.KonUpgrade;
import com.github.rumsfield.konquest.utility.ChatUtil;
import com.github.rumsfield.konquest.utility.CorePath;
import com.github.rumsfield.konquest.utility.HelperUtil;
import com.github.rumsfield.konquest.utility.MessagePath;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.MapMeta;
import org.bukkit.map.MapRenderer;
import org.bukkit.map.MapView;

public class SpyCommand
extends CommandBase {
    public SpyCommand() {
        super("spy", true, false);
    }

    @Override
    public void execute(Konquest konquest, CommandSender sender, List<String> args) {
        KonPlayer player = konquest.getPlayerManager().getPlayer(sender);
        if (player == null) {
            this.sendInvalidSenderMessage(sender);
            return;
        }
        if (!args.isEmpty()) {
            this.sendInvalidArgMessage(sender);
            return;
        }
        Player bukkitPlayer = player.getBukkitPlayer();
        World bukkitWorld = bukkitPlayer.getWorld();
        if (!konquest.isWorldValid(bukkitWorld)) {
            ChatUtil.sendError(sender, MessagePath.GENERIC_ERROR_INVALID_WORLD.getMessage(new Object[0]));
            return;
        }
        double cost = konquest.getCore().getDouble(CorePath.FAVOR_COST_SPY.getPath(), 0.0);
        if (cost > 0.0 && KonquestPlugin.getBalance((OfflinePlayer)bukkitPlayer) < cost) {
            ChatUtil.sendError(sender, MessagePath.GENERIC_ERROR_NO_FAVOR.getMessage(cost));
            return;
        }
        if (bukkitPlayer.getInventory().firstEmpty() == -1) {
            ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.COMMAND_SPY_ERROR_INVENTORY.getMessage(new Object[0]));
            return;
        }
        KonKingdom playerKingdom = player.getKingdom();
        List<KonKingdom> enemyKingdoms = playerKingdom.getActiveRelationKingdoms(KonquestDiplomacyType.WAR);
        KonTerritory closestTerritory = null;
        int minDistance = Integer.MAX_VALUE;
        for (KonKingdom kingdom : enemyKingdoms) {
            for (KonTown konTown : kingdom.getCapitalTowns()) {
                int townDist;
                int upgradeLevel = konquest.getUpgradeManager().getTownUpgradeLevel(konTown, KonUpgrade.COUNTER);
                if (upgradeLevel >= 1 || (townDist = HelperUtil.chunkDistance(bukkitPlayer.getLocation(), konTown.getCenterLoc())) == -1 || townDist >= minDistance) continue;
                minDistance = townDist;
                closestTerritory = konTown;
            }
        }
        if (closestTerritory == null) {
            ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.COMMAND_SPY_ERROR_TOWN.getMessage(new Object[0]));
            return;
        }
        ChatUtil.printDebug("Generating map...");
        ItemStack item = new ItemStack(Material.FILLED_MAP, 1);
        MapMeta meta = (MapMeta)item.getItemMeta();
        meta.setColor(Color.RED);
        meta.setLocationName(closestTerritory.getName());
        MapView view = Bukkit.getServer().createMap(bukkitPlayer.getWorld());
        view.setCenterX(closestTerritory.getCenterLoc().getBlockX());
        view.setCenterZ(closestTerritory.getCenterLoc().getBlockZ());
        view.setScale(MapView.Scale.FARTHEST);
        view.setTrackingPosition(true);
        view.setUnlimitedTracking(true);
        view.setLocked(false);
        for (MapRenderer ren : view.getRenderers()) {
            if (ren == null) continue;
            ren.initialize(view);
        }
        meta.setMapView(view);
        meta.setLore(Arrays.asList(String.valueOf(ChatColor.RESET) + String.valueOf(ChatColor.AQUA) + closestTerritory.getName(), String.valueOf(ChatColor.RED) + "Spy Map", String.valueOf(ChatColor.YELLOW) + "Centered on an enemy Town"));
        item.setItemMeta((ItemMeta)meta);
        PlayerInventory playerInventory = bukkitPlayer.getInventory();
        playerInventory.setItem(playerInventory.firstEmpty(), playerInventory.getItemInMainHand());
        playerInventory.setItemInMainHand(item);
        if (KonquestPlugin.withdrawPlayer((OfflinePlayer)bukkitPlayer, cost)) {
            konquest.getAccomplishmentManager().modifyPlayerStat(player, KonStatsType.FAVOR, (int)cost);
        }
        String dist = minDistance < 32 ? MessagePath.COMMAND_SPY_NOTICE_NEARBY.getMessage(new Object[0]) : (minDistance < 64 ? MessagePath.COMMAND_SPY_NOTICE_REGIONAL.getMessage(new Object[0]) : (minDistance < 128 ? MessagePath.COMMAND_SPY_NOTICE_FARAWAY.getMessage(new Object[0]) : MessagePath.COMMAND_SPY_NOTICE_VERY_DISTANT.getMessage(new Object[0])));
        ChatUtil.sendNotice((CommandSender)bukkitPlayer, MessagePath.COMMAND_SPY_NOTICE_SUCCESS.getMessage(dist));
    }

    @Override
    public List<String> tabComplete(Konquest konquest, CommandSender sender, List<String> args) {
        return Collections.emptyList();
    }
}

