/*
 * Decompiled with CFR 0.152.
 */
package com.github.rumsfield.konquest.command;

import com.github.rumsfield.konquest.Konquest;
import com.github.rumsfield.konquest.KonquestPlugin;
import com.github.rumsfield.konquest.api.model.KonquestTerritoryType;
import com.github.rumsfield.konquest.api.model.KonquestUpgrade;
import com.github.rumsfield.konquest.command.CommandBase;
import com.github.rumsfield.konquest.manager.DisplayManager;
import com.github.rumsfield.konquest.model.KonArmor;
import com.github.rumsfield.konquest.model.KonKingdom;
import com.github.rumsfield.konquest.model.KonOfflinePlayer;
import com.github.rumsfield.konquest.model.KonPlayer;
import com.github.rumsfield.konquest.model.KonShield;
import com.github.rumsfield.konquest.model.KonStatsType;
import com.github.rumsfield.konquest.model.KonTown;
import com.github.rumsfield.konquest.model.KonTownOption;
import com.github.rumsfield.konquest.model.KonUpgrade;
import com.github.rumsfield.konquest.utility.ChatUtil;
import com.github.rumsfield.konquest.utility.CompatibilityUtil;
import com.github.rumsfield.konquest.utility.CorePath;
import com.github.rumsfield.konquest.utility.HelperUtil;
import com.github.rumsfield.konquest.utility.MessagePath;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.entity.Villager;

public class TownCommand
extends CommandBase {
    public TownCommand() {
        super("town", true, false);
        this.setOptionalArgs(true);
        this.addArgument(this.newArg("menu", true, false));
        this.addArgument(this.newArg("invites", true, false));
        this.addArgument(this.newArg("requests", true, false));
        this.addArgument(this.newArg("join", true, false).sub(this.newArg("town", false, false)));
        this.addArgument(this.newArg("leave", true, false).sub(this.newArg("town", false, false)));
        this.addArgument(this.newArg("lord", true, false).sub(this.newArg("town", false, false)));
        List<String> requestsArgNames = Arrays.asList("accept", "deny");
        List<String> optionsArgNames = Arrays.asList("true", "false");
        List<String> residentArgNames = Arrays.asList("invite", "kick", "promote", "demote", "lord");
        this.addArgument(this.newArg("manage", true, false).sub(this.newArg("town", false, true).sub(this.newArg("menu", true, false)).sub(this.newArg("plots", true, false)).sub(this.newArg("destroy", true, false)).sub(this.newArg("rename", true, false).sub(this.newArg("name", false, false))).sub(this.newArg("upgrade", true, true).sub(this.newArg("name", false, false))).sub(this.newArg("shield", true, true).sub(this.newArg("name", false, false))).sub(this.newArg("armor", true, true).sub(this.newArg("name", false, false))).sub(this.newArg("specialize", true, true).sub(this.newArg("name", false, false))).sub(this.newArg("option", true, true).sub(this.newArg("name", false, true).sub(this.newArg(optionsArgNames, true, false)))).sub(this.newArg("requests", true, true).sub(this.newArg("player", false, false).sub(this.newArg(requestsArgNames, true, false)))).sub(this.newArg("resident", true, false).sub(this.newArg(residentArgNames, true, false).sub(this.newArg("player", false, false))))));
    }

    private KonTown getVerifyTown(KonPlayer player, String townName) {
        KonTown town = null;
        if (!townName.isEmpty()) {
            town = townName.equalsIgnoreCase("capital") ? player.getKingdom().getCapital() : player.getKingdom().getTownCapital(townName);
        }
        if (town == null) {
            ChatUtil.sendError(player, MessagePath.GENERIC_ERROR_BAD_NAME.getMessage(townName));
        }
        return town;
    }

    private String formatOptionLine(KonTownOption option, KonTown town) {
        boolean val = town.getTownOption(option);
        String optionLabel = option.toString();
        String optionValue = DisplayManager.boolean2Lang(val) + " " + DisplayManager.boolean2Symbol(val);
        String optionDescription = option.getDescription();
        return String.valueOf(ChatColor.GOLD) + optionLabel + " - " + String.valueOf(ChatColor.RESET) + optionValue + " " + String.valueOf(ChatColor.LIGHT_PURPLE) + optionDescription;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void execute(Konquest konquest, CommandSender sender, List<String> args) {
        int MAX_LIST_NAMES = 10;
        KonPlayer player = konquest.getPlayerManager().getPlayer(sender);
        if (player == null) {
            ChatUtil.printDebug("Command executed with null player", true);
            ChatUtil.sendError(sender, MessagePath.GENERIC_ERROR_INTERNAL.getMessage(new Object[0]));
            return;
        }
        Player bukkitPlayer = player.getBukkitPlayer();
        UUID playerID = bukkitPlayer.getUniqueId();
        if (player.isBarbarian()) {
            ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.GENERIC_ERROR_DENY_BARBARIAN.getMessage(new Object[0]));
            return;
        }
        if (args.isEmpty()) {
            konquest.getDisplayManager().displayTownMenu(player);
            return;
        }
        String subCmd = args.get(0);
        switch (subCmd.toLowerCase()) {
            case "menu": {
                konquest.getDisplayManager().displayTownMenu(player);
                return;
            }
            case "invites": {
                if (args.size() == 1) {
                    String nameListStr = this.formatStringListLimited(konquest.getKingdomManager().getInviteTownNames(player), 10);
                    ChatUtil.sendNotice((CommandSender)bukkitPlayer, MessagePath.COMMAND_TOWN_NOTICE_INVITE_LIST.getMessage(new Object[0]));
                    ChatUtil.sendMessage((CommandSender)bukkitPlayer, nameListStr);
                    return;
                }
                this.sendInvalidArgMessage((CommandSender)bukkitPlayer);
                return;
            }
            case "requests": {
                if (args.size() == 1) {
                    String nameListStr = this.formatStringListLimited(konquest.getKingdomManager().getRequestTownNames(player), 10);
                    ChatUtil.sendNotice((CommandSender)bukkitPlayer, MessagePath.COMMAND_TOWN_NOTICE_REQUEST_TOWN_LIST.getMessage(new Object[0]));
                    ChatUtil.sendMessage((CommandSender)bukkitPlayer, nameListStr);
                    return;
                }
                this.sendInvalidArgMessage((CommandSender)bukkitPlayer);
                return;
            }
            case "join": {
                if (args.size() != 2) {
                    this.sendInvalidArgMessage((CommandSender)bukkitPlayer);
                    return;
                }
                KonTown town = this.getVerifyTown(player, args.get(1));
                if (town == null) {
                    return;
                }
                konquest.getKingdomManager().menuJoinTownRequest(player, town);
                return;
            }
            case "leave": {
                if (args.size() != 2) {
                    this.sendInvalidArgMessage((CommandSender)bukkitPlayer);
                    return;
                }
                KonTown town = this.getVerifyTown(player, args.get(1));
                if (town == null) {
                    return;
                }
                konquest.getKingdomManager().menuLeaveTown(player, town);
                return;
            }
            case "lord": {
                if (args.size() != 2) {
                    this.sendInvalidArgMessage((CommandSender)bukkitPlayer);
                    return;
                }
                KonTown town = this.getVerifyTown(player, args.get(1));
                if (town == null) {
                    return;
                }
                konquest.getKingdomManager().lordTownTakeover(player, town);
                return;
            }
            case "manage": {
                if (args.size() < 2) {
                    this.sendInvalidArgMessage((CommandSender)bukkitPlayer);
                    return;
                }
                KonTown town = this.getVerifyTown(player, args.get(1));
                if (town == null) {
                    return;
                }
                boolean notifyLordTakeover = false;
                if (!town.isLordValid()) {
                    if (town.isPlayerKnight(player.getOfflineBukkitPlayer())) {
                        notifyLordTakeover = true;
                    } else if (town.isPlayerResident(player.getOfflineBukkitPlayer()) && town.getPlayerKnights().isEmpty()) {
                        notifyLordTakeover = true;
                    } else if (town.getPlayerResidents().isEmpty()) {
                        notifyLordTakeover = true;
                    }
                }
                if (notifyLordTakeover) {
                    ChatUtil.sendNotice((CommandSender)bukkitPlayer, MessagePath.COMMAND_TOWN_NOTICE_NO_LORD.getMessage(town.getName(), town.getTravelName()));
                }
                if (!town.isPlayerLord(player.getOfflineBukkitPlayer()) && !town.isPlayerKnight(player.getOfflineBukkitPlayer())) {
                    ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.GENERIC_ERROR_NO_ALLOW.getMessage(new Object[0]));
                    return;
                }
                if (args.size() == 2) {
                    konquest.getDisplayManager().displayTownManagementMenu(player, town, false);
                    return;
                }
                String manageSubCmd = args.get(2);
                switch (manageSubCmd.toLowerCase()) {
                    case "plots": {
                        if (!town.isLord(playerID)) {
                            ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.GENERIC_ERROR_NO_ALLOW.getMessage(new Object[0]));
                            return;
                        }
                        if (args.size() == 3) {
                            konquest.getDisplayManager().displayTownPlotMenu(player, town);
                            return;
                        }
                        this.sendInvalidArgMessage((CommandSender)bukkitPlayer);
                        return;
                    }
                    case "destroy": {
                        if (!town.isLord(playerID)) {
                            ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.GENERIC_ERROR_NO_ALLOW.getMessage(new Object[0]));
                            return;
                        }
                        if (!konquest.getKingdomManager().getIsTownDestroyLordEnable()) {
                            ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.GENERIC_ERROR_DISABLED.getMessage(new Object[0]));
                            return;
                        }
                        if (args.size() == 3) {
                            konquest.getKingdomManager().menuDestroyTown(town, player);
                            return;
                        }
                        this.sendInvalidArgMessage((CommandSender)bukkitPlayer);
                        return;
                    }
                    case "rename": {
                        if (!town.isLord(playerID)) {
                            ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.GENERIC_ERROR_NO_ALLOW.getMessage(new Object[0]));
                            return;
                        }
                        if (args.size() != 4) {
                            this.sendInvalidArgMessage((CommandSender)bukkitPlayer);
                            return;
                        }
                        String newTownName = args.get(3);
                        double cost = konquest.getCore().getDouble(CorePath.FAVOR_TOWNS_COST_RENAME.getPath(), 0.0);
                        if (cost > 0.0 && KonquestPlugin.getBalance((OfflinePlayer)bukkitPlayer) < cost) {
                            ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.GENERIC_ERROR_NO_FAVOR.getMessage(cost));
                            return;
                        }
                        String oldTownName = town.getName();
                        if (!konquest.getKingdomManager().isTown(oldTownName)) {
                            ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.GENERIC_ERROR_BAD_NAME.getMessage(oldTownName));
                            return;
                        }
                        if (konquest.validateName(newTownName, (CommandSender)bukkitPlayer) != 0) {
                            return;
                        }
                        boolean success = konquest.getKingdomManager().renameTown(oldTownName, newTownName, town.getKingdom().getName());
                        if (!success) {
                            ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.GENERIC_ERROR_INTERNAL.getMessage(new Object[0]));
                            return;
                        }
                        Iterator<OfflinePlayer> iterator = town.getPlayerResidents().iterator();
                        while (true) {
                            if (!iterator.hasNext()) {
                                if (!(cost > 0.0)) return;
                                if (!KonquestPlugin.withdrawPlayer((OfflinePlayer)bukkitPlayer, cost)) return;
                                konquest.getAccomplishmentManager().modifyPlayerStat(player, KonStatsType.FAVOR, (int)cost);
                                return;
                            }
                            OfflinePlayer resident = iterator.next();
                            if (!resident.isOnline()) continue;
                            ChatUtil.sendNotice((CommandSender)((Player)resident), MessagePath.COMMAND_TOWN_NOTICE_RENAME.getMessage(bukkitPlayer.getName(), oldTownName, newTownName));
                        }
                    }
                    case "upgrade": {
                        if (!konquest.getUpgradeManager().isEnabled()) {
                            ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.GENERIC_ERROR_DISABLED.getMessage(new Object[0]));
                            return;
                        }
                        if (!town.isLord(playerID)) {
                            ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.GENERIC_ERROR_NO_ALLOW.getMessage(new Object[0]));
                            return;
                        }
                        HashMap<KonquestUpgrade, Integer> availableUpgrades = konquest.getUpgradeManager().getAvailableUpgrades(town);
                        if (args.size() == 3) {
                            ArrayList<KonUpgrade> allUpgrades = new ArrayList<KonUpgrade>();
                            for (KonUpgrade upgrade : KonUpgrade.values()) {
                                if (!availableUpgrades.containsKey(upgrade)) continue;
                                allUpgrades.add(upgrade);
                            }
                            ChatUtil.sendNotice((CommandSender)bukkitPlayer, MessagePath.MENU_UPGRADE_TITLE.getMessage(new Object[0]));
                            Iterator iterator = allUpgrades.iterator();
                            while (iterator.hasNext()) {
                                KonUpgrade upgrade = (KonUpgrade)iterator.next();
                                int upgradeLevel = availableUpgrades.get(upgrade);
                                String upgradeInfo = String.valueOf(ChatColor.GOLD) + upgrade.toString() + " - " + String.valueOf(ChatColor.RESET) + upgrade.getName() + " " + upgradeLevel + " " + String.valueOf(ChatColor.LIGHT_PURPLE) + upgrade.getLevelDescription(upgradeLevel);
                                ChatUtil.sendMessage((CommandSender)bukkitPlayer, upgradeInfo);
                            }
                            return;
                        }
                        if (args.size() != 4) {
                            this.sendInvalidArgMessage((CommandSender)bukkitPlayer);
                            return;
                        }
                        String upgradeName = args.get(3);
                        KonUpgrade upgrade = KonUpgrade.getUpgrade(upgradeName);
                        if (upgrade == null) {
                            ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.GENERIC_ERROR_UNKNOWN_NAME.getMessage(upgradeName));
                            return;
                        }
                        if (!availableUpgrades.containsKey(upgrade)) {
                            ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.COMMAND_TOWN_ERROR_UPGRADE_UNAVAILABLE.getMessage(upgradeName, town.getName()));
                            return;
                        }
                        int upgradeLevel = availableUpgrades.get(upgrade);
                        konquest.getUpgradeManager().addTownUpgrade(town, upgrade, upgradeLevel, player.getBukkitPlayer());
                        return;
                    }
                    case "shield": {
                        if (!konquest.getShieldManager().isShieldsEnabled()) {
                            ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.GENERIC_ERROR_DISABLED.getMessage(new Object[0]));
                            return;
                        }
                        if (args.size() == 3) {
                            String shieldTime = HelperUtil.getTimeFormat(town.getRemainingShieldTimeSeconds(), "");
                            ChatUtil.sendNotice((CommandSender)bukkitPlayer, MessagePath.COMMAND_TOWN_NOTICE_SHIELD_LIST.getMessage(shieldTime, town.getName()));
                            Iterator<KonShield> upgrade = konquest.getShieldManager().getShields().iterator();
                            while (upgrade.hasNext()) {
                                KonShield shield = upgrade.next();
                                String shieldName = shield.getId();
                                String shieldDuration = HelperUtil.getTimeFormat(shield.getDurationSeconds(), "");
                                int shieldCost = konquest.getShieldManager().getTotalCostShield(shield, town);
                                String shieldInfo = String.valueOf(ChatColor.GOLD) + shieldName + " - " + String.valueOf(ChatColor.RESET) + shieldDuration + ", " + String.valueOf(ChatColor.DARK_AQUA) + MessagePath.LABEL_COST.getMessage(new Object[0]) + " " + KonquestPlugin.getCurrencyFormat(shieldCost);
                                ChatUtil.sendMessage((CommandSender)bukkitPlayer, shieldInfo);
                            }
                            return;
                        }
                        if (args.size() != 4) {
                            this.sendInvalidArgMessage((CommandSender)bukkitPlayer);
                            return;
                        }
                        String shieldName = args.get(3);
                        KonShield shield = konquest.getShieldManager().getShield(shieldName);
                        if (shield == null) {
                            ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.GENERIC_ERROR_UNKNOWN_NAME.getMessage(shieldName));
                            return;
                        }
                        konquest.getShieldManager().activateTownShield(shield, town, player.getBukkitPlayer(), false);
                        return;
                    }
                    case "armor": {
                        if (!konquest.getShieldManager().isArmorsEnabled()) {
                            ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.GENERIC_ERROR_DISABLED.getMessage(new Object[0]));
                            return;
                        }
                        if (args.size() == 3) {
                            String armorBlocks = "" + town.getArmorBlocks();
                            ChatUtil.sendNotice((CommandSender)bukkitPlayer, MessagePath.COMMAND_TOWN_NOTICE_ARMOR_LIST.getMessage(armorBlocks, town.getName()));
                            Iterator<KonArmor> shield = konquest.getShieldManager().getArmors().iterator();
                            while (shield.hasNext()) {
                                KonArmor armor = shield.next();
                                String armorName = armor.getId();
                                String armorAmount = "" + armor.getBlocks();
                                int armorCost = konquest.getShieldManager().getTotalCostArmor(armor, town);
                                String armorInfo = String.valueOf(ChatColor.GOLD) + armorName + " - " + String.valueOf(ChatColor.RESET) + armorAmount + ", " + String.valueOf(ChatColor.DARK_AQUA) + MessagePath.LABEL_COST.getMessage(new Object[0]) + " " + KonquestPlugin.getCurrencyFormat(armorCost);
                                ChatUtil.sendMessage((CommandSender)bukkitPlayer, armorInfo);
                            }
                            return;
                        }
                        if (args.size() != 4) {
                            this.sendInvalidArgMessage((CommandSender)bukkitPlayer);
                            return;
                        }
                        String armorName = args.get(3);
                        KonArmor armor = konquest.getShieldManager().getArmor(armorName);
                        if (armor == null) {
                            ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.GENERIC_ERROR_UNKNOWN_NAME.getMessage(armorName));
                            return;
                        }
                        konquest.getShieldManager().activateTownArmor(armor, town, player.getBukkitPlayer(), false);
                        return;
                    }
                    case "specialize": {
                        if (!town.isLord(playerID)) {
                            ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.GENERIC_ERROR_NO_ALLOW.getMessage(new Object[0]));
                            return;
                        }
                        if (!konquest.getKingdomManager().getIsDiscountEnable()) {
                            ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.GENERIC_ERROR_DISABLED.getMessage(new Object[0]));
                            return;
                        }
                        if (args.size() == 3) {
                            String specialName = town.getSpecializationName();
                            ChatUtil.sendNotice((CommandSender)bukkitPlayer, MessagePath.COMMAND_TOWN_NOTICE_SPECIALIZE_LIST.getMessage(town.getName(), specialName));
                            return;
                        }
                        if (args.size() != 4) {
                            this.sendInvalidArgMessage((CommandSender)bukkitPlayer);
                            return;
                        }
                        String professionName = args.get(3);
                        Villager.Profession profession = CompatibilityUtil.getProfessionFromName(professionName);
                        if (profession == null) {
                            ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.GENERIC_ERROR_UNKNOWN_NAME.getMessage(professionName));
                            return;
                        }
                        konquest.getKingdomManager().menuChangeTownSpecialization(town, profession, player, false);
                        return;
                    }
                    case "option": {
                        if (!town.isLord(playerID)) {
                            ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.GENERIC_ERROR_NO_ALLOW.getMessage(new Object[0]));
                            return;
                        }
                        if (args.size() == 3) {
                            KonTownOption[] professionName = KonTownOption.values();
                            int profession = professionName.length;
                            int armor = 0;
                            while (armor < profession) {
                                KonTownOption option = professionName[armor];
                                if (konquest.getKingdomManager().isTownOptionFeatureEnabled(option)) {
                                    String optionInfo = this.formatOptionLine(option, town);
                                    ChatUtil.sendMessage(sender, optionInfo);
                                }
                                ++armor;
                            }
                            return;
                        }
                        if (args.size() >= 4) {
                            String optionName = args.get(3);
                            KonTownOption option = KonTownOption.getOption(optionName);
                            if (option == null) {
                                ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.GENERIC_ERROR_UNKNOWN_NAME.getMessage(optionName));
                                return;
                            }
                            if (!konquest.getKingdomManager().isTownOptionFeatureEnabled(option)) {
                                ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.GENERIC_ERROR_DISABLED.getMessage(new Object[0]));
                                return;
                            }
                            if (args.size() == 4) {
                                String optionInfo = this.formatOptionLine(option, town);
                                ChatUtil.sendMessage((CommandSender)bukkitPlayer, optionInfo);
                                return;
                            }
                            if (args.size() == 5) {
                                String newValStr = args.get(4);
                                if (newValStr.equalsIgnoreCase("true")) {
                                    konquest.getKingdomManager().setTownOption(option, town, (CommandSender)bukkitPlayer, true);
                                    return;
                                }
                                if (newValStr.equalsIgnoreCase("false")) {
                                    konquest.getKingdomManager().setTownOption(option, town, (CommandSender)bukkitPlayer, false);
                                    return;
                                }
                                ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.GENERIC_ERROR_UNKNOWN_NAME.getMessage(newValStr));
                                return;
                            }
                            this.sendInvalidArgMessage((CommandSender)bukkitPlayer);
                            return;
                        }
                        this.sendInvalidArgMessage((CommandSender)bukkitPlayer);
                        return;
                    }
                    case "requests": {
                        boolean response;
                        if (args.size() == 3) {
                            ArrayList<String> requestPlayerNames = new ArrayList<String>();
                            Iterator<OfflinePlayer> option = town.getJoinRequests().iterator();
                            while (true) {
                                if (!option.hasNext()) {
                                    String nameListStr = this.formatStringListLimited(requestPlayerNames, 10);
                                    ChatUtil.sendNotice((CommandSender)bukkitPlayer, MessagePath.COMMAND_TOWN_NOTICE_REQUEST_PLAYER_LIST.getMessage(town.getName()));
                                    ChatUtil.sendMessage((CommandSender)bukkitPlayer, nameListStr);
                                    return;
                                }
                                OfflinePlayer requester = option.next();
                                requestPlayerNames.add(requester.getName());
                            }
                        }
                        if (args.size() != 5) {
                            this.sendInvalidArgMessage((CommandSender)bukkitPlayer);
                            return;
                        }
                        String requesterName = args.get(3);
                        String requestDecision = args.get(4);
                        KonOfflinePlayer requester = konquest.getPlayerManager().getOfflinePlayerFromName(requesterName);
                        if (requester == null) {
                            ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.GENERIC_ERROR_UNKNOWN_NAME.getMessage(requesterName));
                            return;
                        }
                        if (requestDecision.equalsIgnoreCase("accept")) {
                            response = true;
                        } else {
                            if (!requestDecision.equalsIgnoreCase("deny")) {
                                this.sendInvalidArgMessage((CommandSender)bukkitPlayer);
                                return;
                            }
                            response = false;
                        }
                        konquest.getKingdomManager().menuRespondTownRequest(player, requester.getOfflineBukkitPlayer(), town, response);
                        return;
                    }
                    case "resident": {
                        if (args.size() != 5) {
                            this.sendInvalidArgMessage((CommandSender)bukkitPlayer);
                            return;
                        }
                        String residentSubCmd = args.get(3);
                        String residentPlayerName = args.get(4);
                        KonOfflinePlayer residentPlayer = konquest.getPlayerManager().getOfflinePlayerFromName(residentPlayerName);
                        if (residentPlayer == null) {
                            ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.GENERIC_ERROR_UNKNOWN_NAME.getMessage(residentPlayerName));
                            return;
                        }
                        switch (residentSubCmd.toLowerCase()) {
                            case "invite": {
                                konquest.getKingdomManager().addTownPlayer(player, residentPlayer, town);
                                return;
                            }
                            case "kick": {
                                konquest.getKingdomManager().kickTownPlayer(player, residentPlayer, town);
                                return;
                            }
                            case "promote": {
                                konquest.getKingdomManager().menuPromoteDemoteTownKnight(player, residentPlayer.getOfflineBukkitPlayer(), town, true);
                                return;
                            }
                            case "demote": {
                                konquest.getKingdomManager().menuPromoteDemoteTownKnight(player, residentPlayer.getOfflineBukkitPlayer(), town, false);
                                return;
                            }
                            case "lord": {
                                konquest.getKingdomManager().menuTransferTownLord(player, residentPlayer.getOfflineBukkitPlayer(), town, false);
                                return;
                            }
                        }
                        this.sendInvalidArgMessage((CommandSender)bukkitPlayer);
                        return;
                    }
                }
                this.sendInvalidArgMessage((CommandSender)bukkitPlayer);
                return;
            }
        }
        this.sendInvalidArgMessage((CommandSender)bukkitPlayer);
    }

    @Override
    public List<String> tabComplete(Konquest konquest, CommandSender sender, List<String> args) {
        ArrayList<String> tabList;
        block88: {
            int numArgs;
            KonKingdom kingdom;
            block91: {
                block90: {
                    block89: {
                        KonPlayer player;
                        block87: {
                            player = konquest.getPlayerManager().getPlayer(sender);
                            if (player == null) {
                                return Collections.emptyList();
                            }
                            kingdom = player.getKingdom();
                            if (kingdom == null) {
                                return Collections.emptyList();
                            }
                            tabList = new ArrayList<String>();
                            numArgs = args.size();
                            if (numArgs != 1) break block87;
                            tabList.add("menu");
                            tabList.add("invites");
                            tabList.add("requests");
                            tabList.add("join");
                            tabList.add("leave");
                            tabList.add("lord");
                            tabList.add("manage");
                            break block88;
                        }
                        if (numArgs != 2) break block89;
                        switch (args.get(0).toLowerCase()) {
                            case "join": {
                                for (KonTown town : kingdom.getCapitalTowns()) {
                                    if (town.isPlayerResident((OfflinePlayer)player.getBukkitPlayer())) continue;
                                    if (town.getTerritoryType().equals((Object)KonquestTerritoryType.CAPITAL)) {
                                        tabList.add(town.getKingdom().getName());
                                        tabList.add("capital");
                                        continue;
                                    }
                                    tabList.add(town.getName());
                                }
                                break block88;
                            }
                            case "leave": {
                                for (KonTown town : kingdom.getCapitalTowns()) {
                                    if (!town.isPlayerResident((OfflinePlayer)player.getBukkitPlayer())) continue;
                                    if (town.getTerritoryType().equals((Object)KonquestTerritoryType.CAPITAL)) {
                                        tabList.add(town.getKingdom().getName());
                                        tabList.add("capital");
                                        continue;
                                    }
                                    tabList.add(town.getName());
                                }
                                break block88;
                            }
                            case "lord": {
                                for (KonTown town : kingdom.getCapitalTowns()) {
                                    if (town.isLordValid()) continue;
                                    if (town.getTerritoryType().equals((Object)KonquestTerritoryType.CAPITAL)) {
                                        tabList.add(town.getKingdom().getName());
                                        tabList.add("capital");
                                        continue;
                                    }
                                    tabList.add(town.getName());
                                }
                                break block88;
                            }
                            case "manage": {
                                for (KonTown town : kingdom.getCapitalTowns()) {
                                    if (!town.isPlayerKnight((OfflinePlayer)player.getBukkitPlayer())) continue;
                                    if (town.getTerritoryType().equals((Object)KonquestTerritoryType.CAPITAL)) {
                                        tabList.add(town.getKingdom().getName());
                                        tabList.add("capital");
                                        continue;
                                    }
                                    tabList.add(town.getName());
                                }
                                break;
                            }
                        }
                        break block88;
                    }
                    if (numArgs != 3) break block90;
                    if (args.get(0).equalsIgnoreCase("manage")) {
                        tabList.add("rename");
                        tabList.add("option");
                        tabList.add("requests");
                        tabList.add("resident");
                        if (konquest.getKingdomManager().getIsDiscountEnable()) {
                            tabList.add("specialize");
                        }
                        if (konquest.getShieldManager().isArmorsEnabled()) {
                            tabList.add("armor");
                        }
                        if (konquest.getShieldManager().isShieldsEnabled()) {
                            tabList.add("shield");
                        }
                        if (konquest.getUpgradeManager().isEnabled()) {
                            tabList.add("upgrade");
                        }
                        if (konquest.getPlotManager().isEnabled()) {
                            tabList.add("plots");
                        }
                        if (konquest.getKingdomManager().getIsTownDestroyLordEnable()) {
                            tabList.add("destroy");
                        }
                    }
                    break block88;
                }
                if (numArgs != 4) break block91;
                String townName = args.get(1);
                switch (args.get(2).toLowerCase()) {
                    case "rename": {
                        tabList.add("***");
                        break;
                    }
                    case "upgrade": {
                        if (!konquest.getUpgradeManager().isEnabled()) break;
                        for (KonUpgrade upgrade : KonUpgrade.values()) {
                            tabList.add(upgrade.toString());
                        }
                        break block88;
                    }
                    case "shield": {
                        if (!konquest.getShieldManager().isShieldsEnabled()) break;
                        for (KonShield shield : konquest.getShieldManager().getShields()) {
                            tabList.add(shield.getId());
                        }
                        break block88;
                    }
                    case "armor": {
                        if (!konquest.getShieldManager().isArmorsEnabled()) break;
                        for (KonArmor armor : konquest.getShieldManager().getArmors()) {
                            tabList.add(armor.getId());
                        }
                        break block88;
                    }
                    case "specialize": {
                        if (!konquest.getKingdomManager().getIsDiscountEnable()) break;
                        for (Villager.Profession profession : CompatibilityUtil.getProfessions()) {
                            tabList.add(CompatibilityUtil.getProfessionName(profession));
                        }
                        break block88;
                    }
                    case "option": {
                        KonTown town = kingdom.getTownCapital(townName);
                        if (town == null) {
                            return Collections.emptyList();
                        }
                        for (KonTownOption option : KonTownOption.values()) {
                            if (town.isTownOptionOverridden(option)) continue;
                            tabList.add(option.toString());
                        }
                        break block88;
                    }
                    case "requests": {
                        KonTown town = kingdom.getTownCapital(townName);
                        if (town == null) {
                            return Collections.emptyList();
                        }
                        for (OfflinePlayer requester : town.getJoinRequests()) {
                            tabList.add(requester.getName());
                        }
                        break block88;
                    }
                    case "resident": {
                        tabList.add("invite");
                        tabList.add("kick");
                        tabList.add("promote");
                        tabList.add("demote");
                        tabList.add("lord");
                    }
                }
                break block88;
            }
            if (numArgs != 5) break block88;
            switch (args.get(2).toLowerCase()) {
                case "option": {
                    tabList.add("true");
                    tabList.add("false");
                    break;
                }
                case "requests": {
                    tabList.add("accept");
                    tabList.add("deny");
                    break;
                }
                case "resident": {
                    String townName = args.get(1);
                    KonTown town = kingdom.getTownCapital(townName);
                    if (town == null) {
                        return Collections.emptyList();
                    }
                    switch (args.get(3).toLowerCase()) {
                        case "invite": {
                            for (KonOfflinePlayer offlinePlayer : konquest.getPlayerManager().getAllKonquestOfflinePlayers()) {
                                String name = offlinePlayer.getOfflineBukkitPlayer().getName();
                                if (name == null || !kingdom.equals(offlinePlayer.getKingdom()) || town.isPlayerResident(offlinePlayer.getOfflineBukkitPlayer())) continue;
                                tabList.add(name);
                            }
                            break block88;
                        }
                        case "kick": {
                            for (KonOfflinePlayer offlinePlayer : konquest.getPlayerManager().getAllKonquestOfflinePlayers()) {
                                String name = offlinePlayer.getOfflineBukkitPlayer().getName();
                                if (name == null || !town.isPlayerResident(offlinePlayer.getOfflineBukkitPlayer())) continue;
                                tabList.add(name);
                            }
                            break block88;
                        }
                        case "promote": {
                            for (OfflinePlayer offlinePlayer : town.getPlayerResidentsOnly()) {
                                String name = offlinePlayer.getName();
                                if (name == null) continue;
                                tabList.add(name);
                            }
                            break block88;
                        }
                        case "demote": {
                            for (OfflinePlayer offlinePlayer : town.getPlayerKnightsOnly()) {
                                String name = offlinePlayer.getName();
                                if (name == null) continue;
                                tabList.add(name);
                            }
                            break block88;
                        }
                        case "lord": {
                            for (OfflinePlayer offlinePlayer : town.getPlayerResidents()) {
                                String name = offlinePlayer.getName();
                                if (name == null || town.isLord(offlinePlayer.getUniqueId())) continue;
                                tabList.add(name);
                            }
                        }
                    }
                }
            }
        }
        return this.matchLastArgToList(tabList, args);
    }
}

