/*
 * Decompiled with CFR 0.152.
 */
package com.github.rumsfield.konquest.command;

import com.github.rumsfield.konquest.Konquest;
import com.github.rumsfield.konquest.api.model.KonquestTerritoryType;
import com.github.rumsfield.konquest.command.CommandBase;
import com.github.rumsfield.konquest.manager.KingdomManager;
import com.github.rumsfield.konquest.manager.TravelManager;
import com.github.rumsfield.konquest.model.KonCamp;
import com.github.rumsfield.konquest.model.KonCapital;
import com.github.rumsfield.konquest.model.KonKingdom;
import com.github.rumsfield.konquest.model.KonPlayer;
import com.github.rumsfield.konquest.model.KonPropertyFlag;
import com.github.rumsfield.konquest.model.KonSanctuary;
import com.github.rumsfield.konquest.model.KonTerritory;
import com.github.rumsfield.konquest.model.KonTown;
import com.github.rumsfield.konquest.utility.ChatUtil;
import com.github.rumsfield.konquest.utility.CorePath;
import com.github.rumsfield.konquest.utility.MessagePath;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class TravelCommand
extends CommandBase {
    public TravelCommand() {
        super("travel", true, false);
        this.setOptionalArgs(true);
        this.addArgument(this.newArg("menu", true, false));
        List<String> argNames = Arrays.asList("town", "kingdom", "sanctuary");
        this.addArgument(this.newArg(argNames, true, false).sub(this.newArg("name", false, false)));
        argNames = Arrays.asList("capital", "home", "camp", "wild");
        this.addArgument(this.newArg(argNames, true, false));
    }

    @Override
    public void execute(Konquest konquest, CommandSender sender, List<String> args) {
        TravelManager.TravelDestination destination;
        KonPlayer player = konquest.getPlayerManager().getPlayer(sender);
        if (player == null) {
            this.sendInvalidSenderMessage(sender);
            return;
        }
        KingdomManager kManager = konquest.getKingdomManager();
        Player bukkitPlayer = player.getBukkitPlayer();
        World bukkitWorld = bukkitPlayer.getWorld();
        if (!konquest.isWorldValid(bukkitWorld)) {
            ChatUtil.sendError(sender, MessagePath.GENERIC_ERROR_INVALID_WORLD.getMessage(new Object[0]));
            return;
        }
        boolean blockEnemyTravel = konquest.getCore().getBoolean(CorePath.KINGDOMS_NO_ENEMY_TRAVEL.getPath());
        boolean blockCampTravel = konquest.getCore().getBoolean(CorePath.CAMPS_NO_ENEMY_TRAVEL.getPath());
        Location playerLoc = bukkitPlayer.getLocation();
        if (konquest.getTerritoryManager().isChunkClaimed(playerLoc)) {
            boolean isCampTravelBlocked;
            KonTerritory locTerritory = konquest.getTerritoryManager().getChunkTerritory(playerLoc);
            assert (locTerritory != null);
            KonKingdom locKingdom = locTerritory.getKingdom();
            boolean isKingdomTravelAllowed = locTerritory.getTerritoryType().equals((Object)KonquestTerritoryType.SANCTUARY) || locKingdom.equals(player.getKingdom()) || kManager.isPlayerPeace(player, locKingdom) || kManager.isPlayerTrade(player, locKingdom) || kManager.isPlayerAlly(player, locKingdom);
            boolean bl = isCampTravelBlocked = locTerritory instanceof KonCamp && !((KonCamp)locTerritory).isPlayerOwner((OfflinePlayer)bukkitPlayer);
            if (blockEnemyTravel && !isKingdomTravelAllowed || blockCampTravel && isCampTravelBlocked) {
                ChatUtil.sendError(sender, MessagePath.COMMAND_TRAVEL_ERROR_ENEMY_TERRITORY.getMessage(new Object[0]));
                return;
            }
        }
        if (args.isEmpty() || args.get(0).equalsIgnoreCase("menu")) {
            konquest.getDisplayManager().displayTravelMenu(player);
            return;
        }
        String travelType = args.get(0);
        Location travelLoc = null;
        KonTerritory travelTerritory = null;
        boolean isSanctuaryTravel = konquest.getCore().getBoolean(CorePath.TRAVEL_ENABLE_SANCTUARY.getPath(), false);
        boolean isCapitalTravel = konquest.getCore().getBoolean(CorePath.TRAVEL_ENABLE_CAPITAL.getPath(), false);
        boolean isCampTravel = konquest.getCore().getBoolean(CorePath.TRAVEL_ENABLE_CAMP.getPath(), false);
        boolean isHomeTravel = konquest.getCore().getBoolean(CorePath.TRAVEL_ENABLE_HOME.getPath(), false);
        boolean isWildTravel = konquest.getCore().getBoolean(CorePath.TRAVEL_ENABLE_WILD.getPath(), false);
        boolean isTownTravel = konquest.getCore().getBoolean(CorePath.TRAVEL_ENABLE_TOWNS.getPath(), false);
        switch (travelType.toLowerCase()) {
            case "capital": {
                if (player.isBarbarian()) {
                    ChatUtil.sendError(sender, MessagePath.GENERIC_ERROR_DENY_BARBARIAN.getMessage(new Object[0]));
                    return;
                }
                if (!isCapitalTravel) {
                    ChatUtil.sendError(sender, MessagePath.GENERIC_ERROR_DISABLED.getMessage(new Object[0]));
                    return;
                }
                KonCapital travelCapital = player.getKingdom().getCapital();
                if (travelCapital == null) {
                    ChatUtil.sendError(sender, MessagePath.GENERIC_ERROR_INTERNAL.getMessage(new Object[0]));
                    return;
                }
                if (!travelCapital.getPropertyValue(KonPropertyFlag.TRAVEL)) {
                    ChatUtil.sendKonBlockedFlagTitle(player);
                    ChatUtil.sendError(sender, MessagePath.COMMAND_TRAVEL_ERROR_DISABLED.getMessage(new Object[0]));
                    return;
                }
                travelLoc = travelCapital.getSpawnLoc();
                destination = TravelManager.TravelDestination.CAPITAL;
                travelTerritory = travelCapital;
                break;
            }
            case "camp": {
                if (!player.isBarbarian()) {
                    ChatUtil.sendError(sender, MessagePath.GENERIC_ERROR_NO_ALLOW.getMessage(new Object[0]));
                    return;
                }
                if (!konquest.getCampManager().isCampSet(player)) {
                    ChatUtil.sendError(sender, MessagePath.COMMAND_TRAVEL_ERROR_NO_CAMP.getMessage(new Object[0]));
                    return;
                }
                if (!isCampTravel) {
                    ChatUtil.sendError(sender, MessagePath.GENERIC_ERROR_DISABLED.getMessage(new Object[0]));
                    return;
                }
                KonCamp travelCamp = konquest.getCampManager().getCamp(player);
                travelLoc = travelCamp.getSpawnLoc();
                destination = TravelManager.TravelDestination.CAMP;
                travelTerritory = travelCamp;
                break;
            }
            case "home": {
                if (player.isBarbarian()) {
                    ChatUtil.sendError(sender, MessagePath.GENERIC_ERROR_NO_ALLOW.getMessage(new Object[0]));
                    return;
                }
                Location bedLoc = player.getBukkitPlayer().getBedSpawnLocation();
                if (bedLoc == null) {
                    ChatUtil.sendError(sender, MessagePath.COMMAND_TRAVEL_ERROR_NO_HOME.getMessage(new Object[0]));
                    return;
                }
                if (!isHomeTravel) {
                    ChatUtil.sendError(sender, MessagePath.GENERIC_ERROR_DISABLED.getMessage(new Object[0]));
                    return;
                }
                travelLoc = bedLoc;
                destination = TravelManager.TravelDestination.HOME;
                break;
            }
            case "wild": {
                if (!isWildTravel) {
                    ChatUtil.sendError(sender, MessagePath.GENERIC_ERROR_DISABLED.getMessage(new Object[0]));
                    return;
                }
                destination = TravelManager.TravelDestination.WILD;
                konquest.getTravelManager().submitWildTravel(bukkitPlayer);
                break;
            }
            case "sanctuary": {
                if (args.size() != 2) {
                    this.sendInvalidArgMessage(sender);
                    return;
                }
                if (!isSanctuaryTravel) {
                    ChatUtil.sendError(sender, MessagePath.GENERIC_ERROR_DISABLED.getMessage(new Object[0]));
                    return;
                }
                String sanctuaryName = args.get(1);
                if (konquest.getSanctuaryManager().isSanctuary(sanctuaryName)) {
                    KonSanctuary travelSanctuary = konquest.getSanctuaryManager().getSanctuary(sanctuaryName);
                    if (travelSanctuary == null) {
                        ChatUtil.sendError(sender, MessagePath.GENERIC_ERROR_INTERNAL.getMessage(new Object[0]));
                        return;
                    }
                    if (!travelSanctuary.getPropertyValue(KonPropertyFlag.TRAVEL)) {
                        ChatUtil.sendKonBlockedFlagTitle(player);
                        ChatUtil.sendError(sender, MessagePath.COMMAND_TRAVEL_ERROR_DISABLED.getMessage(new Object[0]));
                        return;
                    }
                    travelLoc = travelSanctuary.getSpawnLoc();
                    destination = TravelManager.TravelDestination.SANCTUARY;
                    travelTerritory = travelSanctuary;
                    break;
                }
                ChatUtil.sendError(sender, MessagePath.GENERIC_ERROR_UNKNOWN_NAME.getMessage(sanctuaryName));
                return;
            }
            case "kingdom": {
                if (args.size() != 2) {
                    this.sendInvalidArgMessage(sender);
                    return;
                }
                if (!isCapitalTravel) {
                    ChatUtil.sendError(sender, MessagePath.GENERIC_ERROR_DISABLED.getMessage(new Object[0]));
                    return;
                }
                String kingdomName = args.get(1);
                if (konquest.getKingdomManager().isKingdom(kingdomName)) {
                    if (player.isBarbarian()) {
                        ChatUtil.sendError(sender, MessagePath.GENERIC_ERROR_NO_ALLOW.getMessage(new Object[0]));
                        return;
                    }
                    KonCapital travelKingdom = konquest.getKingdomManager().getCapital(kingdomName);
                    if (travelKingdom == null) {
                        ChatUtil.sendError(sender, MessagePath.GENERIC_ERROR_INTERNAL.getMessage(new Object[0]));
                        return;
                    }
                    if (!player.getKingdom().equals(travelKingdom.getKingdom()) && !konquest.getKingdomManager().isPlayerAlly(player, travelKingdom.getKingdom())) {
                        ChatUtil.sendError(sender, MessagePath.GENERIC_ERROR_NO_ALLOW.getMessage(new Object[0]));
                        return;
                    }
                    if (!travelKingdom.getPropertyValue(KonPropertyFlag.TRAVEL)) {
                        ChatUtil.sendKonBlockedFlagTitle(player);
                        ChatUtil.sendError(sender, MessagePath.COMMAND_TRAVEL_ERROR_DISABLED.getMessage(new Object[0]));
                        return;
                    }
                    travelLoc = travelKingdom.getSpawnLoc();
                    destination = TravelManager.TravelDestination.CAPITAL;
                    travelTerritory = travelKingdom;
                    break;
                }
                ChatUtil.sendError(sender, MessagePath.GENERIC_ERROR_UNKNOWN_NAME.getMessage(kingdomName));
                return;
            }
            case "town": {
                if (args.size() != 2) {
                    this.sendInvalidArgMessage(sender);
                    return;
                }
                if (!isTownTravel) {
                    ChatUtil.sendError(sender, MessagePath.GENERIC_ERROR_DISABLED.getMessage(new Object[0]));
                    return;
                }
                String townName = args.get(1);
                if (konquest.getKingdomManager().isTown(townName)) {
                    if (player.isBarbarian()) {
                        ChatUtil.sendError(sender, MessagePath.GENERIC_ERROR_NO_ALLOW.getMessage(new Object[0]));
                        return;
                    }
                    KonTown travelTown = konquest.getKingdomManager().getTown(townName);
                    if (travelTown == null) {
                        ChatUtil.sendError(sender, MessagePath.GENERIC_ERROR_INTERNAL.getMessage(new Object[0]));
                        return;
                    }
                    if (!player.getKingdom().equals(travelTown.getKingdom()) && !konquest.getKingdomManager().isPlayerAlly(player, travelTown.getKingdom())) {
                        ChatUtil.sendError(sender, MessagePath.COMMAND_TRAVEL_ERROR_NO_TOWN.getMessage(new Object[0]));
                        return;
                    }
                    if (!travelTown.getPropertyValue(KonPropertyFlag.TRAVEL)) {
                        ChatUtil.sendKonBlockedFlagTitle(player);
                        ChatUtil.sendError(sender, MessagePath.COMMAND_TRAVEL_ERROR_DISABLED.getMessage(new Object[0]));
                        return;
                    }
                    if (travelTown.isPlayerTravelDisabled(bukkitPlayer.getUniqueId())) {
                        String cooldown = travelTown.getPlayerTravelCooldownString(bukkitPlayer.getUniqueId());
                        ChatUtil.sendError(sender, MessagePath.COMMAND_TRAVEL_ERROR_COOLDOWN.getMessage(cooldown, travelTown.getName()));
                        return;
                    }
                    travelLoc = travelTown.getSpawnLoc();
                    destination = TravelManager.TravelDestination.TOWN;
                    travelTerritory = travelTown;
                    break;
                }
                ChatUtil.sendError(sender, MessagePath.GENERIC_ERROR_UNKNOWN_NAME.getMessage(townName));
                return;
            }
            default: {
                this.sendInvalidArgMessage(sender);
                return;
            }
        }
        konquest.getTravelManager().submitTravel(bukkitPlayer, destination, travelTerritory, travelLoc);
    }

    @Override
    public List<String> tabComplete(Konquest konquest, CommandSender sender, List<String> args) {
        ArrayList<String> tabList;
        block15: {
            boolean isTownTravel;
            boolean isCapitalTravel;
            boolean isSanctuaryTravel;
            KonPlayer player;
            block14: {
                player = konquest.getPlayerManager().getPlayer(sender);
                if (player == null) {
                    return Collections.emptyList();
                }
                tabList = new ArrayList<String>();
                isSanctuaryTravel = konquest.getCore().getBoolean(CorePath.TRAVEL_ENABLE_SANCTUARY.getPath(), false);
                isCapitalTravel = konquest.getCore().getBoolean(CorePath.TRAVEL_ENABLE_CAPITAL.getPath(), false);
                isTownTravel = konquest.getCore().getBoolean(CorePath.TRAVEL_ENABLE_TOWNS.getPath(), false);
                boolean isHomeTravel = konquest.getCore().getBoolean(CorePath.TRAVEL_ENABLE_HOME.getPath(), false);
                boolean isCampTravel = konquest.getCore().getBoolean(CorePath.TRAVEL_ENABLE_CAMP.getPath(), false);
                boolean isWildTravel = konquest.getCore().getBoolean(CorePath.TRAVEL_ENABLE_WILD.getPath(), false);
                if (args.size() != 1) break block14;
                tabList.add("menu");
                if (isWildTravel) {
                    tabList.add("wild");
                }
                if (isSanctuaryTravel) {
                    tabList.add("sanctuary");
                }
                if (player.isBarbarian() && isCampTravel) {
                    tabList.add("camp");
                }
                if (!player.isBarbarian() && isHomeTravel) {
                    tabList.add("home");
                }
                if (!player.isBarbarian() && isCapitalTravel) {
                    tabList.add("capital");
                    tabList.add("kingdom");
                }
                if (player.isBarbarian() || !isTownTravel) break block15;
                tabList.add("town");
                break block15;
            }
            if (args.size() == 2) {
                String travelType = args.get(0);
                if (isSanctuaryTravel && travelType.equalsIgnoreCase("sanctuary")) {
                    tabList.addAll(konquest.getSanctuaryManager().getSanctuaryNames());
                } else if (isCapitalTravel && travelType.equalsIgnoreCase("kingdom")) {
                    for (KonKingdom kingdom : konquest.getKingdomManager().getKingdoms()) {
                        if (!player.getKingdom().equals(kingdom) && !konquest.getKingdomManager().isKingdomAlliance(player.getKingdom(), kingdom)) continue;
                        tabList.add(kingdom.getName());
                    }
                } else if (isTownTravel && travelType.equalsIgnoreCase("town")) {
                    for (KonKingdom kingdom : konquest.getKingdomManager().getKingdoms()) {
                        if (!player.getKingdom().equals(kingdom) && !konquest.getKingdomManager().isKingdomAlliance(player.getKingdom(), kingdom)) continue;
                        tabList.addAll(kingdom.getTownNames());
                    }
                }
            }
        }
        return this.matchLastArgToList(tabList, args);
    }
}

