/*
 * Decompiled with CFR 0.152.
 */
package com.github.rumsfield.konquest.command;

import com.github.rumsfield.konquest.Konquest;
import com.github.rumsfield.konquest.command.CommandBase;
import com.github.rumsfield.konquest.model.KonPlayer;
import com.github.rumsfield.konquest.utility.ChatUtil;
import com.github.rumsfield.konquest.utility.CorePath;
import com.github.rumsfield.konquest.utility.MessagePath;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class UnclaimCommand
extends CommandBase {
    public UnclaimCommand() {
        super("unclaim", true, false);
        this.setOptionalArgs(true);
        this.addArgument(this.newArg("auto", true, false));
        this.addArgument(this.newArg("radius", true, false).sub(this.newArg("value", false, false)));
    }

    @Override
    public void execute(Konquest konquest, CommandSender sender, List<String> args) {
        KonPlayer player = konquest.getPlayerManager().getPlayer(sender);
        if (player == null) {
            this.sendInvalidSenderMessage(sender);
            return;
        }
        Player bukkitPlayer = player.getBukkitPlayer();
        World bukkitWorld = bukkitPlayer.getWorld();
        boolean isEnabled = konquest.getCore().getBoolean(CorePath.TOWNS_ALLOW_UNCLAIM.getPath(), false);
        if (!isEnabled) {
            ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.GENERIC_ERROR_DISABLED.getMessage(new Object[0]));
            return;
        }
        if (!konquest.isWorldValid(bukkitWorld)) {
            ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.GENERIC_ERROR_INVALID_WORLD.getMessage(new Object[0]));
            return;
        }
        if (player.isBarbarian()) {
            ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.GENERIC_ERROR_DENY_BARBARIAN.getMessage(new Object[0]));
            return;
        }
        if (args.isEmpty()) {
            konquest.getTerritoryManager().unclaimForPlayer(player, bukkitPlayer.getLocation());
        } else {
            String unclaimMode;
            switch (unclaimMode = args.get(0)) {
                case "radius": {
                    if (args.size() != 2) {
                        this.sendInvalidArgMessage((CommandSender)bukkitPlayer);
                        return;
                    }
                    boolean min = true;
                    int max = 5;
                    int radius = Integer.parseInt(args.get(1));
                    if (radius < 1 || radius > 5) {
                        ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.COMMAND_UNCLAIM_ERROR_RADIUS.getMessage(1, 5));
                        return;
                    }
                    konquest.getTerritoryManager().unclaimRadiusForPlayer(player, bukkitPlayer.getLocation(), radius);
                    break;
                }
                case "auto": {
                    boolean isUnclaimSuccess;
                    boolean doAuto = false;
                    if (player.isAutoFollowActive()) {
                        if (player.getAutoFollow().equals((Object)KonPlayer.FollowType.UNCLAIM)) {
                            ChatUtil.sendNotice((CommandSender)bukkitPlayer, MessagePath.GENERIC_NOTICE_DISABLE_AUTO.getMessage(new Object[0]));
                            player.setAutoFollow(KonPlayer.FollowType.NONE);
                        } else {
                            doAuto = true;
                        }
                    } else {
                        doAuto = true;
                    }
                    if (!doAuto || !(isUnclaimSuccess = konquest.getTerritoryManager().unclaimForPlayer(player, bukkitPlayer.getLocation()))) break;
                    ChatUtil.sendNotice((CommandSender)bukkitPlayer, MessagePath.GENERIC_NOTICE_ENABLE_AUTO.getMessage(new Object[0]));
                    player.setAutoFollow(KonPlayer.FollowType.UNCLAIM);
                    break;
                }
                default: {
                    this.sendInvalidArgMessage((CommandSender)bukkitPlayer);
                }
            }
        }
    }

    @Override
    public List<String> tabComplete(Konquest konquest, CommandSender sender, List<String> args) {
        ArrayList<String> tabList = new ArrayList<String>();
        if (args.size() == 1) {
            tabList.add("radius");
            tabList.add("auto");
        } else if (args.size() == 2 && args.get(0).equalsIgnoreCase("radius")) {
            tabList.add("#");
        }
        return this.matchLastArgToList(tabList, args);
    }
}

