/*
 * Decompiled with CFR 0.152.
 */
package com.github.rumsfield.konquest.command.admin;

import com.github.rumsfield.konquest.Konquest;
import com.github.rumsfield.konquest.command.CommandBase;
import com.github.rumsfield.konquest.command.admin.AdminCommandType;
import com.github.rumsfield.konquest.utility.ChatUtil;
import com.github.rumsfield.konquest.utility.MessagePath;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bukkit.command.CommandSender;
import org.bukkit.util.StringUtil;

public class AdminCommand
extends CommandBase {
    public AdminCommand() {
        super("admin", false, false);
        this.addArgument(this.newArg("sub-command", false, false));
    }

    @Override
    public void execute(Konquest konquest, CommandSender sender, List<String> args) {
        AdminCommandType adminCommand = AdminCommandType.HELP;
        if (!args.isEmpty()) {
            String konquestAdminCommandName = args.remove(0);
            adminCommand = AdminCommandType.getCommand(konquestAdminCommandName);
        }
        if (!adminCommand.isSenderHasPermission(sender)) {
            ChatUtil.sendError(sender, MessagePath.GENERIC_ERROR_NO_PERMISSION.getMessage(new Object[0]) + " " + AdminCommandType.HELP.permission());
            return;
        }
        CommandBase konquestAdminCommand = adminCommand.command();
        if (!konquestAdminCommand.validateSender(sender)) {
            ChatUtil.sendError(sender, MessagePath.GENERIC_ERROR_NO_PLAYER.getMessage(new Object[0]));
            return;
        }
        try {
            konquestAdminCommand.execute(konquest, sender, args);
        }
        catch (Exception me) {
            String message = "Failed to execute command ADMIN " + adminCommand.toString();
            ChatUtil.sendError(sender, MessagePath.GENERIC_ERROR_INTERNAL_MESSAGE.getMessage(message));
            ChatUtil.printConsoleError(message);
            me.printStackTrace();
        }
    }

    @Override
    public List<String> tabComplete(Konquest konquest, CommandSender sender, List<String> args) {
        AdminCommandType commandArg;
        String konquestAdminCommandName;
        ArrayList<String> tabList = new ArrayList<String>();
        if (args.size() == 1) {
            ArrayList<String> baseList = new ArrayList<String>();
            for (AdminCommandType cmd : AdminCommandType.values()) {
                if (!cmd.isSenderHasPermission(sender)) continue;
                baseList.add(cmd.toString().toLowerCase());
            }
            StringUtil.copyPartialMatches((String)args.get(0), baseList, tabList);
            Collections.sort(tabList);
        } else if (args.size() >= 2 && AdminCommandType.contains(konquestAdminCommandName = args.remove(0)) && (commandArg = AdminCommandType.getCommand(konquestAdminCommandName)).isSenderHasPermission(sender)) {
            tabList.addAll(commandArg.command().tabComplete(konquest, sender, args));
        }
        return tabList;
    }
}

