/*
 * Decompiled with CFR 0.152.
 */
package com.github.rumsfield.konquest.command.admin;

import com.github.rumsfield.konquest.command.CommandBase;
import com.github.rumsfield.konquest.command.admin.BypassAdminCommand;
import com.github.rumsfield.konquest.command.admin.CampAdminCommand;
import com.github.rumsfield.konquest.command.admin.CaptureAdminCommand;
import com.github.rumsfield.konquest.command.admin.ClaimAdminCommand;
import com.github.rumsfield.konquest.command.admin.EventAdminCommand;
import com.github.rumsfield.konquest.command.admin.FlagAdminCommand;
import com.github.rumsfield.konquest.command.admin.HelpAdminCommand;
import com.github.rumsfield.konquest.command.admin.KingdomAdminCommand;
import com.github.rumsfield.konquest.command.admin.MonumentAdminCommand;
import com.github.rumsfield.konquest.command.admin.ReloadAdminCommand;
import com.github.rumsfield.konquest.command.admin.RuinAdminCommand;
import com.github.rumsfield.konquest.command.admin.SanctuaryAdminCommand;
import com.github.rumsfield.konquest.command.admin.SaveAdminCommand;
import com.github.rumsfield.konquest.command.admin.SetTravelAdminCommand;
import com.github.rumsfield.konquest.command.admin.StatAdminCommand;
import com.github.rumsfield.konquest.command.admin.TownAdminCommand;
import com.github.rumsfield.konquest.command.admin.TravelAdminCommand;
import com.github.rumsfield.konquest.command.admin.UnclaimAdminCommand;
import com.github.rumsfield.konquest.utility.MessagePath;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;

public enum AdminCommandType {
    HELP(Material.REDSTONE_TORCH, "konquest.admin.help", new HelpAdminCommand(), MessagePath.DESCRIPTION_ADMIN_HELP.getMessage(new Object[0])),
    BYPASS(Material.SPECTRAL_ARROW, "konquest.admin.bypass", new BypassAdminCommand(), MessagePath.DESCRIPTION_ADMIN_BYPASS.getMessage(new Object[0])),
    KINGDOM(Material.DIAMOND_HELMET, "konquest.admin.kingdom", new KingdomAdminCommand(), MessagePath.DESCRIPTION_ADMIN_KINGDOM.getMessage(new Object[0])),
    TOWN(Material.OBSIDIAN, "konquest.admin.town", new TownAdminCommand(), MessagePath.DESCRIPTION_ADMIN_TOWN.getMessage(new Object[0])),
    CAMP(Material.ORANGE_BED, "konquest.admin.camp", new CampAdminCommand(), MessagePath.DESCRIPTION_ADMIN_CAMP.getMessage(new Object[0])),
    CLAIM(Material.DIAMOND_SHOVEL, "konquest.admin.claim", new ClaimAdminCommand(), MessagePath.DESCRIPTION_ADMIN_CLAIM.getMessage(new Object[0])),
    UNCLAIM(Material.COBWEB, "konquest.admin.unclaim", new UnclaimAdminCommand(), MessagePath.DESCRIPTION_ADMIN_UNCLAIM.getMessage(new Object[0])),
    CAPTURE(Material.FISHING_ROD, "konquest.admin.capture", new CaptureAdminCommand(), MessagePath.DESCRIPTION_ADMIN_CAPTURE.getMessage(new Object[0])),
    MONUMENT(Material.CRAFTING_TABLE, "konquest.admin.monument", new MonumentAdminCommand(), MessagePath.DESCRIPTION_ADMIN_MONUMENT.getMessage(new Object[0])),
    RUIN(Material.MOSSY_COBBLESTONE, "konquest.admin.ruin", new RuinAdminCommand(), MessagePath.DESCRIPTION_ADMIN_RUIN.getMessage(new Object[0])),
    SANCTUARY(Material.SMOOTH_QUARTZ, "konquest.admin.sanctuary", new SanctuaryAdminCommand(), MessagePath.DESCRIPTION_ADMIN_SANCTUARY.getMessage(new Object[0])),
    TRAVEL(Material.COMPASS, "konquest.admin.travel", new TravelAdminCommand(), MessagePath.DESCRIPTION_ADMIN_TRAVEL.getMessage(new Object[0])),
    SETTRAVEL(Material.OAK_SIGN, "konquest.admin.settravel", new SetTravelAdminCommand(), MessagePath.DESCRIPTION_ADMIN_SETTRAVEL.getMessage(new Object[0])),
    FLAG(Material.ORANGE_BANNER, "konquest.admin.flag", new FlagAdminCommand(), MessagePath.DESCRIPTION_ADMIN_FLAG.getMessage(new Object[0])),
    EVENT(Material.CLOCK, "konquest.admin.event", new EventAdminCommand(), MessagePath.DESCRIPTION_ADMIN_EVENT.getMessage(new Object[0])),
    STAT(Material.BOOKSHELF, "konquest.admin.stat", new StatAdminCommand(), MessagePath.DESCRIPTION_ADMIN_STAT.getMessage(new Object[0])),
    SAVE(Material.TOTEM_OF_UNDYING, "konquest.admin.save", new SaveAdminCommand(), MessagePath.DESCRIPTION_ADMIN_SAVE.getMessage(new Object[0])),
    RELOAD(Material.GLOWSTONE, "konquest.admin.reload", new ReloadAdminCommand(), MessagePath.DESCRIPTION_ADMIN_RELOAD.getMessage(new Object[0]));

    private final Material iconMaterial;
    private final String permission;
    private final CommandBase command;
    private final String description;

    private AdminCommandType(Material iconMaterial, String permission, CommandBase command, String description) {
        this.iconMaterial = iconMaterial;
        this.permission = permission;
        this.command = command;
        this.description = description;
    }

    public Material iconMaterial() {
        return this.iconMaterial;
    }

    public String permission() {
        return this.permission;
    }

    public CommandBase command() {
        return this.command;
    }

    public String description() {
        return this.description;
    }

    public boolean isSenderHasPermission(CommandSender sender) {
        if (this.permission.isEmpty()) {
            return true;
        }
        return sender.hasPermission(this.permission);
    }

    public boolean isSenderAllowed(CommandSender sender) {
        return this.command.isSenderAllowed(sender);
    }

    public String baseUsage() {
        return this.command.getBaseUsage();
    }

    public List<String> argumentUsage() {
        return this.command.getArgumentUsage();
    }

    public static AdminCommandType getCommand(String command) {
        AdminCommandType result = HELP;
        for (AdminCommandType cmd : AdminCommandType.values()) {
            if (!cmd.toString().equalsIgnoreCase(command)) continue;
            result = cmd;
        }
        return result;
    }

    public static boolean contains(String command) {
        boolean result = false;
        for (AdminCommandType cmd : AdminCommandType.values()) {
            if (!cmd.toString().equalsIgnoreCase(command)) continue;
            result = true;
        }
        return result;
    }
}

