/*
 * Decompiled with CFR 0.152.
 */
package com.github.rumsfield.konquest.command.admin;

import com.github.rumsfield.konquest.Konquest;
import com.github.rumsfield.konquest.command.CommandBase;
import com.github.rumsfield.konquest.model.KonOfflinePlayer;
import com.github.rumsfield.konquest.model.KonPlayer;
import com.github.rumsfield.konquest.utility.ChatUtil;
import com.github.rumsfield.konquest.utility.HelperUtil;
import com.github.rumsfield.konquest.utility.MessagePath;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.data.BlockData;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class CampAdminCommand
extends CommandBase {
    public CampAdminCommand() {
        super("camp", true, true);
        List<String> argNames = Arrays.asList("create", "remove");
        this.addArgument(this.newArg(argNames, true, false).sub(this.newArg("player", false, false)));
    }

    @Override
    public void execute(Konquest konquest, CommandSender sender, List<String> args) {
        KonPlayer player = konquest.getPlayerManager().getPlayer(sender);
        if (player == null) {
            this.sendInvalidSenderMessage(sender);
            return;
        }
        if (args.size() != 2) {
            this.sendInvalidArgMessage(sender);
            return;
        }
        String cmdMode = args.get(0);
        String playerName = args.get(1);
        KonOfflinePlayer targetPlayer = konquest.getPlayerManager().getOfflinePlayerFromName(playerName);
        if (targetPlayer == null) {
            ChatUtil.sendError(sender, MessagePath.GENERIC_ERROR_UNKNOWN_NAME.getMessage(new Object[0]));
            return;
        }
        String targetName = targetPlayer.getOfflineBukkitPlayer().getName();
        if (cmdMode.equalsIgnoreCase("create")) {
            int yFloor;
            if (!(sender instanceof Player)) {
                ChatUtil.sendError(sender, MessagePath.GENERIC_ERROR_NO_PLAYER.getMessage(new Object[0]));
                return;
            }
            Location campLoc = ((Player)sender).getLocation();
            if (konquest.isWorldIgnored(campLoc.getWorld())) {
                ChatUtil.sendError(sender, MessagePath.GENERIC_ERROR_INVALID_WORLD.getMessage(new Object[0]));
                return;
            }
            if (!targetPlayer.isBarbarian()) {
                ChatUtil.sendError(sender, MessagePath.GENERIC_ERROR_INVALID_PLAYER.getMessage(new Object[0]));
                return;
            }
            if (konquest.getCampManager().isCampSet(targetPlayer)) {
                ChatUtil.sendError(sender, MessagePath.COMMAND_ADMIN_CAMP_ERROR_CREATE_EXIST.getMessage(new Object[0]));
                return;
            }
            Chunk chunk = campLoc.getChunk();
            Point point = HelperUtil.toPoint(campLoc);
            int xLocal = campLoc.getBlockX() - point.x * 16;
            int zLocal = campLoc.getBlockZ() - point.y * 16;
            for (yFloor = chunk.getChunkSnapshot(true, false, false).getHighestBlockYAt(xLocal, zLocal); (chunk.getBlock(xLocal, yFloor, zLocal).isPassable() || !chunk.getBlock(xLocal, yFloor, zLocal).getType().isOccluding()) && yFloor > 0; --yFloor) {
            }
            campLoc.setY((double)(yFloor + 1));
            BlockState bedFoot = campLoc.getBlock().getState();
            BlockState bedHead = bedFoot.getBlock().getRelative(BlockFace.SOUTH).getState();
            BlockData bedHeadData = Bukkit.getServer().createBlockData("minecraft:white_bed[facing=south,occupied=false,part=head]");
            BlockData bedFootData = Bukkit.getServer().createBlockData("minecraft:white_bed[facing=south,occupied=false,part=foot]");
            bedFoot.setBlockData(bedFootData);
            bedHead.setBlockData(bedHeadData);
            bedFoot.update(true, false);
            bedHead.update(true, true);
            int status = konquest.getCampManager().addCamp(campLoc, targetPlayer);
            switch (status) {
                case 0: {
                    ChatUtil.sendNotice(sender, MessagePath.COMMAND_ADMIN_CAMP_NOTICE_CREATE.getMessage(targetName));
                    break;
                }
                case 1: {
                    ChatUtil.sendError(sender, MessagePath.PROTECTION_ERROR_CAMP_FAIL_OVERLAP.getMessage(new Object[0]));
                    break;
                }
                case 2: {
                    ChatUtil.sendError(sender, MessagePath.PROTECTION_ERROR_CAMP_CREATE.getMessage(new Object[0]));
                    break;
                }
                case 3: {
                    ChatUtil.sendError(sender, MessagePath.PROTECTION_ERROR_CAMP_FAIL_BARBARIAN.getMessage(new Object[0]));
                    break;
                }
                case 4: {
                    ChatUtil.sendError(sender, MessagePath.GENERIC_ERROR_DISABLED.getMessage(new Object[0]));
                    break;
                }
                case 5: {
                    ChatUtil.sendError(sender, MessagePath.GENERIC_ERROR_INVALID_WORLD.getMessage(new Object[0]));
                    break;
                }
                case 6: {
                    ChatUtil.sendError(sender, MessagePath.PROTECTION_ERROR_CAMP_FAIL_OFFLINE.getMessage(new Object[0]));
                    break;
                }
                default: {
                    ChatUtil.sendError(sender, MessagePath.GENERIC_ERROR_INTERNAL.getMessage(new Object[0]));
                    break;
                }
            }
        } else if (cmdMode.equalsIgnoreCase("remove")) {
            if (!konquest.getCampManager().isCampSet(targetPlayer)) {
                ChatUtil.sendError(sender, MessagePath.COMMAND_ADMIN_CAMP_ERROR_DESTROY_EXIST.getMessage(new Object[0]));
                return;
            }
            boolean status = konquest.getCampManager().removeCamp(targetPlayer);
            if (status) {
                ChatUtil.sendNotice(sender, MessagePath.COMMAND_ADMIN_CAMP_NOTICE_DESTROY.getMessage(targetName));
                KonPlayer onlineOwner = konquest.getPlayerManager().getPlayerFromName(playerName);
                if (onlineOwner != null) {
                    ChatUtil.sendError((CommandSender)onlineOwner.getBukkitPlayer(), MessagePath.PROTECTION_NOTICE_CAMP_DESTROY_OWNER.getMessage(new Object[0]));
                }
            } else {
                ChatUtil.sendError(sender, MessagePath.GENERIC_ERROR_FAILED.getMessage(new Object[0]));
            }
        } else {
            this.sendInvalidArgMessage(sender);
        }
    }

    @Override
    public List<String> tabComplete(Konquest konquest, CommandSender sender, List<String> args) {
        ArrayList<String> tabList = new ArrayList<String>();
        if (args.size() == 1) {
            tabList.add("create");
            tabList.add("remove");
        } else if (args.size() == 2) {
            tabList.addAll(konquest.getPlayerManager().getAllPlayerNames());
        }
        return this.matchLastArgToList(tabList, args);
    }
}

