/*
 * Decompiled with CFR 0.152.
 */
package com.github.rumsfield.konquest.command.admin;

import com.github.rumsfield.konquest.Konquest;
import com.github.rumsfield.konquest.command.CommandBase;
import com.github.rumsfield.konquest.model.KonKingdom;
import com.github.rumsfield.konquest.model.KonTerritory;
import com.github.rumsfield.konquest.model.KonTown;
import com.github.rumsfield.konquest.utility.ChatUtil;
import com.github.rumsfield.konquest.utility.MessagePath;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.command.CommandSender;

public class CaptureAdminCommand
extends CommandBase {
    public CaptureAdminCommand() {
        super("capture", false, true);
        this.addArgument(this.newArg("town", false, false).sub(this.newArg("kingdom", false, false)));
    }

    @Override
    public void execute(Konquest konquest, CommandSender sender, List<String> args) {
        if (args.size() != 2) {
            this.sendInvalidArgMessage(sender);
        }
        String townName = args.get(0);
        String kingdomName = args.get(1);
        if (!konquest.getKingdomManager().isKingdom(kingdomName)) {
            ChatUtil.sendError(sender, MessagePath.GENERIC_ERROR_UNKNOWN_NAME.getMessage(kingdomName));
            return;
        }
        KonKingdom kingdom = konquest.getKingdomManager().getKingdom(kingdomName);
        assert (kingdom != null);
        if (!kingdom.isCreated() || kingdom.hasTown(townName) || kingdom.hasCapital(townName)) {
            ChatUtil.sendError(sender, MessagePath.GENERIC_ERROR_NO_ALLOW.getMessage(new Object[0]));
            return;
        }
        KonTerritory town = null;
        boolean isCapital = false;
        for (KonKingdom testKingdom : konquest.getKingdomManager().getKingdoms()) {
            if (testKingdom.hasTown(townName)) {
                town = testKingdom.getTown(townName);
                continue;
            }
            if (!testKingdom.hasCapital(townName)) continue;
            town = testKingdom.getCapital();
            isCapital = true;
        }
        if (town == null) {
            ChatUtil.sendError(sender, MessagePath.GENERIC_ERROR_UNKNOWN_NAME.getMessage(townName));
            return;
        }
        String townKingdomName = town.getKingdom().getName();
        KonTown capturedTown = null;
        capturedTown = isCapital ? konquest.getKingdomManager().captureCapital(townKingdomName, kingdom) : konquest.getKingdomManager().captureTown(townName, town.getKingdom().getName(), kingdom);
        if (capturedTown != null) {
            String newKingdomName = kingdom.getName();
            if (isCapital) {
                ChatUtil.sendBroadcast(MessagePath.PROTECTION_NOTICE_KINGDOM_CONQUER.getMessage(townKingdomName, newKingdomName));
            } else {
                ChatUtil.sendBroadcast(MessagePath.PROTECTION_NOTICE_CONQUER.getMessage(townName));
            }
            ChatUtil.sendNotice(sender, MessagePath.GENERIC_NOTICE_SUCCESS.getMessage(new Object[0]));
            int x = capturedTown.getCenterLoc().getBlockX();
            int y = capturedTown.getCenterLoc().getBlockY();
            int z = capturedTown.getCenterLoc().getBlockZ();
            konquest.getMapHandler().postBroadcast(MessagePath.PROTECTION_NOTICE_CONQUER.getMessage(capturedTown.getName()) + " (" + x + "," + y + "," + z + ")");
        } else {
            ChatUtil.sendError(sender, MessagePath.GENERIC_ERROR_FAILED.getMessage(new Object[0]));
        }
    }

    @Override
    public List<String> tabComplete(Konquest konquest, CommandSender sender, List<String> args) {
        ArrayList<String> tabList = new ArrayList<String>();
        if (args.size() == 1) {
            for (KonKingdom kingdom : konquest.getKingdomManager().getKingdoms()) {
                tabList.addAll(kingdom.getTownNames());
                tabList.add(kingdom.getName());
            }
        } else if (args.size() == 2) {
            tabList.addAll(konquest.getKingdomManager().getKingdomNames());
        }
        return this.matchLastArgToList(tabList, args);
    }
}

