/*
 * Decompiled with CFR 0.152.
 */
package com.github.rumsfield.konquest.command.admin;

import com.github.rumsfield.konquest.Konquest;
import com.github.rumsfield.konquest.command.CommandBase;
import com.github.rumsfield.konquest.model.KonPlayer;
import com.github.rumsfield.konquest.utility.ChatUtil;
import com.github.rumsfield.konquest.utility.MessagePath;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;

public class ClaimAdminCommand
extends CommandBase {
    public ClaimAdminCommand() {
        super("claim", true, true);
        this.setOptionalArgs(true);
        List<String> argNames = Arrays.asList("undo", "auto");
        this.addArgument(this.newArg(argNames, true, false));
        this.addArgument(this.newArg("radius", true, false).sub(this.newArg("value", false, false)));
    }

    @Override
    public void execute(Konquest konquest, CommandSender sender, List<String> args) {
        KonPlayer player = konquest.getPlayerManager().getPlayer(sender);
        if (player == null) {
            this.sendInvalidSenderMessage(sender);
            return;
        }
        Location playerLoc = player.getBukkitPlayer().getLocation();
        if (!konquest.isWorldValid(playerLoc.getWorld())) {
            ChatUtil.sendError(sender, MessagePath.GENERIC_ERROR_INVALID_WORLD.getMessage(new Object[0]));
            return;
        }
        if (args.isEmpty()) {
            konquest.getTerritoryManager().claimForAdmin(player, playerLoc);
            return;
        }
        switch (args.get(0).toLowerCase()) {
            case "radius": {
                int radius;
                if (args.size() != 2) {
                    this.sendInvalidArgMessage(sender);
                    return;
                }
                try {
                    radius = Integer.parseInt(args.get(1));
                }
                catch (NumberFormatException e) {
                    ChatUtil.sendError(sender, MessagePath.GENERIC_ERROR_INTERNAL_MESSAGE.getMessage(e.getMessage()));
                    return;
                }
                boolean min = true;
                int max = 16;
                if (radius < 1 || radius > 16) {
                    ChatUtil.sendError(sender, MessagePath.COMMAND_CLAIM_ERROR_RADIUS.getMessage(1, 16));
                    return;
                }
                konquest.getTerritoryManager().claimRadiusForAdmin(player, playerLoc, radius);
                break;
            }
            case "auto": {
                boolean doAuto = false;
                if (player.isAutoFollowActive()) {
                    if (player.getAutoFollow().equals((Object)KonPlayer.FollowType.ADMIN_CLAIM)) {
                        ChatUtil.sendNotice(sender, MessagePath.GENERIC_NOTICE_DISABLE_AUTO.getMessage(new Object[0]));
                        player.setAutoFollow(KonPlayer.FollowType.NONE);
                    } else {
                        doAuto = true;
                    }
                } else {
                    doAuto = true;
                }
                if (!doAuto) break;
                konquest.getTerritoryManager().claimForAdmin(player, playerLoc);
                ChatUtil.sendNotice(sender, MessagePath.GENERIC_NOTICE_ENABLE_AUTO.getMessage(new Object[0]));
                player.setAutoFollow(KonPlayer.FollowType.ADMIN_CLAIM);
                break;
            }
            case "undo": {
                boolean isUndoSuccess = konquest.getTerritoryManager().claimUndoForAdmin(player);
                if (isUndoSuccess) {
                    ChatUtil.sendNotice(sender, MessagePath.GENERIC_NOTICE_SUCCESS.getMessage(new Object[0]));
                    break;
                }
                ChatUtil.sendError(sender, MessagePath.GENERIC_ERROR_FAILED.getMessage(new Object[0]));
                break;
            }
            default: {
                this.sendInvalidArgMessage(sender);
            }
        }
    }

    @Override
    public List<String> tabComplete(Konquest konquest, CommandSender sender, List<String> args) {
        ArrayList<String> tabList = new ArrayList<String>();
        if (args.size() == 1) {
            tabList.add("radius");
            tabList.add("auto");
            tabList.add("undo");
        } else if (args.size() == 2 && args.get(0).equalsIgnoreCase("radius")) {
            tabList.add("#");
        }
        return this.matchLastArgToList(tabList, args);
    }
}

