/*
 * Decompiled with CFR 0.152.
 */
package com.github.rumsfield.konquest.command.admin;

import com.github.rumsfield.konquest.Konquest;
import com.github.rumsfield.konquest.command.CommandBase;
import com.github.rumsfield.konquest.model.KonGlobalEvent;
import com.github.rumsfield.konquest.model.KonGlobalEventEffect;
import com.github.rumsfield.konquest.utility.ChatUtil;
import com.github.rumsfield.konquest.utility.MessagePath;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.bukkit.command.CommandSender;

public class EventAdminCommand
extends CommandBase {
    public EventAdminCommand() {
        super("event", false, true);
        this.addArgument(this.newArg("create", true, false).sub(this.newArg("name", false, false)));
        this.addArgument(this.newArg("remove", true, false).sub(this.newArg("name", false, false)));
        this.addArgument(this.newArg("start", true, false).sub(this.newArg("name", false, true).sub(this.newArg("now", true, false)).sub(this.newArg("year", false, false).sub(this.newArg("month", false, false).sub(this.newArg("day", false, true).sub(this.newArg("hour", false, true).sub(this.newArg("minute", false, false))))))));
        List<String> timeNames = Arrays.asList("days", "hours", "minutes");
        this.addArgument(this.newArg("duration", true, false).sub(this.newArg("name", false, false).sub(this.newArg(timeNames, true, false).sub(this.newArg("time", false, false)))));
        this.addArgument(this.newArg("repetition", true, false).sub(this.newArg("name", false, false).sub(this.newArg(timeNames, true, false).sub(this.newArg("time", false, false)))));
        List<String> argNames = Arrays.asList("add", "remove");
        this.addArgument(this.newArg("effect", true, false).sub(this.newArg("name", false, false).sub(this.newArg(argNames, true, false).sub(this.newArg("effect", false, false)))));
        List<String> valueNames = Arrays.asList("true", "false");
        this.addArgument(this.newArg("enable", true, false).sub(this.newArg("name", false, false).sub(this.newArg(valueNames, true, false))));
    }

    @Override
    public void execute(Konquest konquest, CommandSender sender, List<String> args) {
        if (!konquest.getGlobalEventManager().isEnabled()) {
            ChatUtil.sendError(sender, MessagePath.GENERIC_ERROR_DISABLED.getMessage(new Object[0]));
            return;
        }
        if (args.size() >= 2) {
            String cmdName = args.get(0);
            String eventName = args.get(1);
            if (!cmdName.equalsIgnoreCase("create") && !konquest.getGlobalEventManager().isEvent(eventName)) {
                ChatUtil.sendError(sender, MessagePath.GENERIC_ERROR_UNKNOWN_NAME.getMessage(eventName));
                return;
            }
            switch (cmdName) {
                case "create": {
                    if (args.size() != 2) {
                        this.sendInvalidArgMessage(sender);
                        return;
                    }
                    if (konquest.validateName(eventName, sender) != 0) {
                        return;
                    }
                    boolean createEnabled = true;
                    long createStart = 0L;
                    long createDuration = 3600000L;
                    long createRepetition = 0L;
                    boolean status = konquest.getGlobalEventManager().createEvent(eventName, createEnabled, createStart, createDuration, createRepetition, Collections.emptyList());
                    if (status) {
                        ChatUtil.sendNotice(sender, MessagePath.COMMAND_ADMIN_EVENT_NOTICE_CREATE.getMessage(eventName));
                        break;
                    }
                    ChatUtil.sendError(sender, MessagePath.GENERIC_ERROR_TAKEN_NAME.getMessage(new Object[0]));
                    return;
                }
                case "remove": {
                    if (args.size() != 2) {
                        this.sendInvalidArgMessage(sender);
                        return;
                    }
                    konquest.getGlobalEventManager().cancelEvent(eventName);
                    ChatUtil.sendNotice(sender, MessagePath.COMMAND_ADMIN_EVENT_NOTICE_REMOVE.getMessage(eventName));
                    break;
                }
                case "start": {
                    if (args.size() == 3 && args.get(2).equalsIgnoreCase("now")) {
                        konquest.getGlobalEventManager().startEvent(eventName);
                        ChatUtil.sendNotice(sender, MessagePath.COMMAND_ADMIN_EVENT_NOTICE_START_NOW.getMessage(eventName));
                        break;
                    }
                    if (args.size() == 5 || args.size() == 6 || args.size() == 7) {
                        int startYear = 0;
                        int startMonth = 1;
                        int startDay = 1;
                        int startHour = 0;
                        int startMinute = 0;
                        try {
                            startYear = Integer.parseInt(args.get(2));
                            startMonth = Integer.parseInt(args.get(3));
                            startDay = Integer.parseInt(args.get(4));
                            if (args.size() >= 6) {
                                startHour = Integer.parseInt(args.get(5));
                            }
                            if (args.size() == 7) {
                                startMinute = Integer.parseInt(args.get(6));
                            }
                        }
                        catch (NumberFormatException e) {
                            ChatUtil.sendError(sender, MessagePath.GENERIC_ERROR_INTERNAL.getMessage(e.getMessage()));
                            return;
                        }
                        if (startYear < 2000) {
                            ChatUtil.sendError(sender, MessagePath.COMMAND_ADMIN_EVENT_ERROR_YEAR.getMessage(new Object[0]));
                            return;
                        }
                        if (startMonth < 1 || startMonth > 12) {
                            ChatUtil.sendError(sender, MessagePath.COMMAND_ADMIN_EVENT_ERROR_MONTH.getMessage(new Object[0]));
                            return;
                        }
                        if (startDay < 1 || startDay > 31) {
                            ChatUtil.sendError(sender, MessagePath.COMMAND_ADMIN_EVENT_ERROR_DAY.getMessage(new Object[0]));
                            return;
                        }
                        if (startHour < 0 || startHour > 23) {
                            ChatUtil.sendError(sender, MessagePath.COMMAND_ADMIN_EVENT_ERROR_HOUR.getMessage(new Object[0]));
                            return;
                        }
                        if (startMinute < 0 || startMinute > 59) {
                            ChatUtil.sendError(sender, MessagePath.COMMAND_ADMIN_EVENT_ERROR_MINUTE.getMessage(new Object[0]));
                            return;
                        }
                        DateFormat df = DateFormat.getDateTimeInstance(3, 3);
                        try {
                            df.getCalendar().set(1, startYear);
                            df.getCalendar().set(2, startMonth - 1);
                            df.getCalendar().set(5, startDay);
                            df.getCalendar().set(11, startHour);
                            df.getCalendar().set(12, startMinute);
                        }
                        catch (ArrayIndexOutOfBoundsException exc) {
                            ChatUtil.sendError(sender, MessagePath.GENERIC_ERROR_INTERNAL.getMessage(exc.getMessage()));
                            return;
                        }
                        Date startDate = df.getCalendar().getTime();
                        konquest.getGlobalEventManager().modifyEventStart(eventName, startDate);
                        ChatUtil.sendNotice(sender, MessagePath.COMMAND_ADMIN_EVENT_NOTICE_START_DATE.getMessage(df.format(startDate)));
                        break;
                    }
                    this.sendInvalidArgMessage(sender);
                    return;
                }
                case "duration": 
                case "repetition": {
                    long timeDuration;
                    double timeValue;
                    if (args.size() != 4) {
                        this.sendInvalidArgMessage(sender);
                        return;
                    }
                    String resolution = args.get(2);
                    try {
                        timeValue = Double.parseDouble(args.get(3));
                    }
                    catch (NumberFormatException e) {
                        ChatUtil.sendError(sender, MessagePath.GENERIC_ERROR_INTERNAL.getMessage(e.getMessage()));
                        return;
                    }
                    if (resolution.equalsIgnoreCase("days")) {
                        timeDuration = (long)(timeValue * 24.0 * 60.0 * 60.0 * 1000.0);
                    } else if (resolution.equalsIgnoreCase("hours")) {
                        timeDuration = (long)(timeValue * 60.0 * 60.0 * 1000.0);
                    } else if (resolution.equalsIgnoreCase("minutes")) {
                        timeDuration = (long)(timeValue * 60.0 * 1000.0);
                    } else {
                        this.sendInvalidArgMessage(sender);
                        return;
                    }
                    String timeFormat = timeValue + " " + resolution;
                    if (cmdName.equalsIgnoreCase("duration")) {
                        if (konquest.getGlobalEventManager().modifyEventDuration(eventName, timeDuration)) {
                            ChatUtil.sendNotice(sender, MessagePath.COMMAND_ADMIN_EVENT_NOTICE_DURATION.getMessage(eventName, timeFormat));
                            break;
                        }
                        ChatUtil.sendError(sender, MessagePath.COMMAND_ADMIN_EVENT_ERROR_DURATION.getMessage(new Object[0]));
                        break;
                    }
                    if (konquest.getGlobalEventManager().modifyEventRepetition(eventName, timeDuration)) {
                        ChatUtil.sendNotice(sender, MessagePath.COMMAND_ADMIN_EVENT_NOTICE_REPETITION.getMessage(eventName, timeFormat));
                        break;
                    }
                    ChatUtil.sendError(sender, MessagePath.COMMAND_ADMIN_EVENT_ERROR_REPETITION.getMessage(new Object[0]));
                    break;
                }
                case "effect": {
                    if (args.size() != 4) {
                        this.sendInvalidArgMessage(sender);
                        return;
                    }
                    String effectMode = args.get(2);
                    String effectName = args.get(3);
                    KonGlobalEventEffect eventEffect = KonGlobalEventEffect.getEffect(effectName);
                    if (eventEffect == null) {
                        ChatUtil.sendError(sender, MessagePath.GENERIC_ERROR_UNKNOWN_NAME.getMessage(effectName));
                        return;
                    }
                    KonGlobalEvent event = konquest.getGlobalEventManager().getEvent(eventName);
                    assert (event != null);
                    if (effectMode.equalsIgnoreCase("add")) {
                        boolean effectChangeStatus = event.addEffect(eventEffect);
                        if (effectChangeStatus) {
                            konquest.getGlobalEventManager().refreshDelayedEvents();
                            ChatUtil.sendNotice(sender, MessagePath.COMMAND_ADMIN_EVENT_NOTICE_EFFECT_ADD.getMessage(eventEffect.getTitle(), eventName));
                            break;
                        }
                        KonGlobalEventEffect conflictEffect = event.getConflictEffect(eventEffect);
                        String conflictEffectTitle = conflictEffect == null ? "unknown" : conflictEffect.getTitle();
                        ChatUtil.sendError(sender, MessagePath.COMMAND_ADMIN_EVENT_ERROR_EFFECT_CONFLICT.getMessage(conflictEffectTitle));
                        break;
                    }
                    if (effectMode.equalsIgnoreCase("remove")) {
                        boolean effectChangeStatus = event.removeEffect(eventEffect);
                        if (effectChangeStatus) {
                            konquest.getGlobalEventManager().refreshDelayedEvents();
                            ChatUtil.sendNotice(sender, MessagePath.COMMAND_ADMIN_EVENT_NOTICE_EFFECT_REMOVE.getMessage(eventEffect.getTitle(), eventName));
                            break;
                        }
                        ChatUtil.sendError(sender, MessagePath.COMMAND_ADMIN_EVENT_ERROR_EFFECT_MISSING.getMessage(new Object[0]));
                        break;
                    }
                    this.sendInvalidArgMessage(sender);
                    return;
                }
                case "enable": {
                    if (args.size() != 3) {
                        this.sendInvalidArgMessage(sender);
                        return;
                    }
                    String enableValue = args.get(2);
                    if (enableValue.equalsIgnoreCase("true")) {
                        konquest.getGlobalEventManager().enableEvent(eventName, true);
                        ChatUtil.sendNotice(sender, MessagePath.COMMAND_ADMIN_EVENT_NOTICE_ENABLE.getMessage(eventName));
                        break;
                    }
                    if (enableValue.equalsIgnoreCase("false")) {
                        konquest.getGlobalEventManager().enableEvent(eventName, false);
                        ChatUtil.sendNotice(sender, MessagePath.COMMAND_ADMIN_EVENT_NOTICE_DISABLE.getMessage(eventName));
                        break;
                    }
                    this.sendInvalidArgMessage(sender);
                    return;
                }
                default: {
                    this.sendInvalidArgMessage(sender);
                    break;
                }
            }
        } else {
            this.sendInvalidArgMessage(sender);
        }
    }

    @Override
    public List<String> tabComplete(Konquest konquest, CommandSender sender, List<String> args) {
        ArrayList<String> tabList;
        block45: {
            block48: {
                block47: {
                    block46: {
                        block44: {
                            tabList = new ArrayList<String>();
                            if (args.size() != 1) break block44;
                            tabList.add("create");
                            tabList.add("remove");
                            tabList.add("start");
                            tabList.add("duration");
                            tabList.add("repetition");
                            tabList.add("effect");
                            tabList.add("enable");
                            break block45;
                        }
                        if (args.size() != 2) break block46;
                        switch (args.get(0).toLowerCase()) {
                            case "create": {
                                tabList.add("***");
                                break;
                            }
                            case "remove": 
                            case "start": 
                            case "duration": 
                            case "repetition": 
                            case "effect": 
                            case "enable": {
                                tabList.addAll(konquest.getGlobalEventManager().getEventNames());
                                break;
                            }
                        }
                        break block45;
                    }
                    if (args.size() != 3) break block47;
                    switch (args.get(0).toLowerCase()) {
                        case "start": {
                            tabList.add("now");
                            tabList.add("YEAR");
                            break;
                        }
                        case "duration": 
                        case "repetition": {
                            tabList.add("days");
                            tabList.add("hours");
                            tabList.add("minutes");
                            break;
                        }
                        case "effect": {
                            tabList.add("add");
                            tabList.add("remove");
                            break;
                        }
                        case "enable": {
                            tabList.add("true");
                            tabList.add("false");
                            break;
                        }
                    }
                    break block45;
                }
                if (args.size() != 4) break block48;
                switch (args.get(0).toLowerCase()) {
                    case "start": {
                        if (args.get(2).equalsIgnoreCase("now")) break;
                        tabList.add("MONTH");
                        break;
                    }
                    case "duration": 
                    case "repetition": {
                        tabList.add("#");
                        break;
                    }
                    case "effect": {
                        for (KonGlobalEventEffect effect : KonGlobalEventEffect.values()) {
                            tabList.add(effect.toString());
                        }
                    }
                }
                break block45;
            }
            if (args.size() >= 5 && args.get(0).equalsIgnoreCase("start") && !args.get(2).equalsIgnoreCase("now")) {
                if (args.size() == 5) {
                    tabList.add("DAY");
                } else if (args.size() == 6) {
                    tabList.add("HOUR");
                } else if (args.size() == 7) {
                    tabList.add("MINUTE");
                }
            }
        }
        return this.matchLastArgToList(tabList, args);
    }
}

