/*
 * Decompiled with CFR 0.152.
 */
package com.github.rumsfield.konquest.command.admin;

import com.github.rumsfield.konquest.Konquest;
import com.github.rumsfield.konquest.command.CommandBase;
import com.github.rumsfield.konquest.manager.DisplayManager;
import com.github.rumsfield.konquest.model.KonBarDisplayer;
import com.github.rumsfield.konquest.model.KonKingdom;
import com.github.rumsfield.konquest.model.KonPropertyFlag;
import com.github.rumsfield.konquest.model.KonPropertyFlagHolder;
import com.github.rumsfield.konquest.model.KonRuin;
import com.github.rumsfield.konquest.model.KonSanctuary;
import com.github.rumsfield.konquest.model.KonTown;
import com.github.rumsfield.konquest.utility.ChatUtil;
import com.github.rumsfield.konquest.utility.MessagePath;
import com.github.rumsfield.konquest.utility.Timeable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;

public class FlagAdminCommand
extends CommandBase {
    public FlagAdminCommand() {
        super("flag", false, true);
        List<String> argNames = Arrays.asList("kingdom", "capital", "town", "sanctuary", "ruin");
        List<String> valueNames = Arrays.asList("true", "false");
        this.addArgument(this.newArg("set", true, false).sub(this.newArg(argNames, true, false).sub(this.newArg("name", false, false).sub(this.newArg("property", false, false).sub(this.newArg(valueNames, true, false))))));
        this.addArgument(this.newArg("show", true, false).sub(this.newArg(argNames, true, false).sub(this.newArg("name", false, true).sub(this.newArg("property", false, false)))));
        this.addArgument(this.newArg("reset", true, false).sub(this.newArg(argNames, true, false).sub(this.newArg("name", false, false))));
        this.addArgument(this.newArg("resetall", true, false).sub(this.newArg(argNames, true, false)));
    }

    private KonPropertyFlagHolder getFlagHolder(Konquest konquest, HolderType holderType, String name) {
        Timeable holder = null;
        switch (holderType.ordinal()) {
            case 0: {
                holder = konquest.getKingdomManager().getKingdom(name);
                break;
            }
            case 2: {
                if (!konquest.getKingdomManager().isKingdom(name)) break;
                holder = konquest.getKingdomManager().getKingdom(name).getCapital();
                break;
            }
            case 1: {
                holder = konquest.getKingdomManager().getTown(name);
                break;
            }
            case 4: {
                holder = konquest.getSanctuaryManager().getSanctuary(name);
                break;
            }
            case 3: {
                holder = konquest.getRuinManager().getRuin(name);
                break;
            }
        }
        return holder;
    }

    private ArrayList<KonPropertyFlagHolder> getFlagHolders(Konquest konquest, HolderType holderType) {
        ArrayList<KonPropertyFlagHolder> holders = new ArrayList<KonPropertyFlagHolder>();
        switch (holderType.ordinal()) {
            case 0: {
                holders.addAll(konquest.getKingdomManager().getKingdoms());
                break;
            }
            case 2: {
                for (KonKingdom kingdom : konquest.getKingdomManager().getKingdoms()) {
                    holders.add(kingdom.getCapital());
                }
                break;
            }
            case 1: {
                for (KonKingdom kingdom : konquest.getKingdomManager().getKingdoms()) {
                    holders.addAll(kingdom.getTowns());
                }
                break;
            }
            case 4: {
                holders.addAll(konquest.getSanctuaryManager().getSanctuaries());
                break;
            }
            case 3: {
                holders.addAll(konquest.getRuinManager().getRuins());
                break;
            }
        }
        return holders;
    }

    @Override
    public void execute(Konquest konquest, CommandSender sender, List<String> args) {
        if (args.size() < 2) {
            this.sendInvalidArgMessage(sender);
            return;
        }
        String subCmd = args.get(0);
        String type = args.get(1);
        String holderName = "";
        KonPropertyFlagHolder holder = null;
        KonPropertyFlag propertyFlag = null;
        boolean propertyValue = false;
        if (!HolderType.contains(type)) {
            ChatUtil.sendError(sender, MessagePath.GENERIC_ERROR_UNKNOWN_NAME.getMessage(type));
            return;
        }
        HolderType holderType = HolderType.getType(type);
        assert (holderType != null);
        String holderTypeLabel = holderType.getLabel();
        if (args.size() >= 3 && (holder = this.getFlagHolder(konquest, holderType, holderName = args.get(2))) == null) {
            ChatUtil.sendError(sender, MessagePath.GENERIC_ERROR_UNKNOWN_NAME.getMessage(holderName));
            return;
        }
        if (args.size() >= 4) {
            String propertyName = args.get(3);
            if (!KonPropertyFlag.contains(propertyName)) {
                ChatUtil.sendError(sender, MessagePath.GENERIC_ERROR_UNKNOWN_NAME.getMessage(propertyName));
                return;
            }
            propertyFlag = KonPropertyFlag.getFlag(propertyName);
            if (!holder.hasPropertyValue(propertyFlag)) {
                ChatUtil.sendError(sender, MessagePath.COMMAND_ADMIN_FLAG_ERROR_INVALID.getMessage(propertyFlag.toString(), holderTypeLabel));
                return;
            }
        }
        if (args.size() >= 5) {
            String valueStr = args.get(4);
            if (valueStr.equalsIgnoreCase("true")) {
                propertyValue = true;
            } else if (valueStr.equalsIgnoreCase("false")) {
                propertyValue = false;
            } else {
                this.sendInvalidArgMessage(sender);
                return;
            }
        }
        switch (subCmd.toLowerCase()) {
            case "set": {
                if (args.size() != 5) {
                    this.sendInvalidArgMessage(sender);
                    return;
                }
                if (holder.setPropertyValue(propertyFlag, propertyValue)) {
                    ChatUtil.sendNotice(sender, MessagePath.COMMAND_ADMIN_FLAG_NOTICE_SET.getMessage(propertyFlag.getName(), holderName, propertyValue));
                    if (!propertyFlag.equals((Object)KonPropertyFlag.ARENA) || !(holder instanceof KonSanctuary) && !(holder instanceof KonRuin)) break;
                    ((KonBarDisplayer)((Object)holder)).updateBarTitle();
                    break;
                }
                ChatUtil.sendError(sender, MessagePath.GENERIC_ERROR_FAILED.getMessage(new Object[0]));
                return;
            }
            case "show": {
                if (args.size() != 3 && args.size() != 4) {
                    this.sendInvalidArgMessage(sender);
                    return;
                }
                if (args.size() == 3) {
                    String header = MessagePath.COMMAND_ADMIN_FLAG_NOTICE_ALL_PROPERTIES.getMessage(new Object[0]) + " - " + holderTypeLabel + " " + holderName;
                    ChatUtil.sendNotice(sender, header);
                    for (KonPropertyFlag flag : KonPropertyFlag.values()) {
                        if (!holder.hasPropertyValue(flag)) continue;
                        String flagName = flag.getName();
                        String flagValue = holder.getPropertyValue(flag) ? "true" : String.valueOf(ChatColor.RED) + "false";
                        String flagDescription = flag.getDescription();
                        String infoLine = DisplayManager.loreFormat + String.valueOf((Object)flag) + ": " + DisplayManager.valueFormat + flagName + " = " + flagValue + String.valueOf(ChatColor.RESET) + " | " + flagDescription;
                        ChatUtil.sendMessage(sender, infoLine);
                    }
                    break;
                }
                if (args.size() != 4) break;
                String header = MessagePath.COMMAND_ADMIN_FLAG_NOTICE_SINGLE_PROPERTY.getMessage(new Object[0]) + " - " + holderTypeLabel + " " + holderName;
                ChatUtil.sendNotice(sender, header);
                String flagName = propertyFlag.getName();
                String flagValue = holder.getPropertyValue(propertyFlag) ? "true" : String.valueOf(ChatColor.RED) + "false";
                String flagDescription = propertyFlag.getDescription();
                String infoLine = DisplayManager.loreFormat + String.valueOf((Object)propertyFlag) + ": " + DisplayManager.valueFormat + flagName + " = " + flagValue + String.valueOf(ChatColor.RESET) + " | " + flagDescription;
                ChatUtil.sendMessage(sender, infoLine);
                break;
            }
            case "reset": {
                if (args.size() != 3) {
                    this.sendInvalidArgMessage(sender);
                    return;
                }
                holder.initProperties();
                String singleHeader = MessagePath.COMMAND_ADMIN_FLAG_NOTICE_RESET.getMessage(new Object[0]) + " - " + holderTypeLabel + "(1)";
                ChatUtil.sendNotice(sender, singleHeader);
                break;
            }
            case "resetall": {
                if (args.size() != 2) {
                    this.sendInvalidArgMessage(sender);
                    return;
                }
                ArrayList<KonPropertyFlagHolder> holders = this.getFlagHolders(konquest, holderType);
                for (KonPropertyFlagHolder aHolder : holders) {
                    aHolder.initProperties();
                }
                String multiHeader = MessagePath.COMMAND_ADMIN_FLAG_NOTICE_RESET.getMessage(new Object[0]) + " - " + holderTypeLabel + "(" + holders.size() + ")";
                ChatUtil.sendNotice(sender, multiHeader);
                break;
            }
            default: {
                this.sendInvalidArgMessage(sender);
            }
        }
    }

    @Override
    public List<String> tabComplete(Konquest konquest, CommandSender sender, List<String> args) {
        ArrayList<String> tabList;
        block33: {
            block36: {
                block35: {
                    block34: {
                        block32: {
                            tabList = new ArrayList<String>();
                            if (args.size() != 1) break block32;
                            tabList.add("show");
                            tabList.add("set");
                            tabList.add("reset");
                            tabList.add("resetall");
                            break block33;
                        }
                        if (args.size() != 2) break block34;
                        tabList.add("kingdom");
                        tabList.add("capital");
                        tabList.add("town");
                        tabList.add("sanctuary");
                        tabList.add("ruin");
                        break block33;
                    }
                    if (args.size() != 3) break block35;
                    if (args.get(0).equalsIgnoreCase("set") || args.get(0).equalsIgnoreCase("show") || args.get(0).equalsIgnoreCase("reset")) {
                        switch (args.get(1).toLowerCase()) {
                            case "kingdom": 
                            case "capital": {
                                tabList.addAll(konquest.getKingdomManager().getKingdomNames());
                                break;
                            }
                            case "town": {
                                tabList.addAll(konquest.getKingdomManager().getTownNames());
                                break;
                            }
                            case "sanctuary": {
                                tabList.addAll(konquest.getSanctuaryManager().getSanctuaryNames());
                                break;
                            }
                            case "ruin": {
                                tabList.addAll(konquest.getRuinManager().getRuinNames());
                                break;
                            }
                        }
                    }
                    break block33;
                }
                if (args.size() != 4) break block36;
                if (!args.get(0).equalsIgnoreCase("set") && !args.get(0).equalsIgnoreCase("show")) break block33;
                switch (args.get(1).toLowerCase()) {
                    case "kingdom": {
                        for (KonPropertyFlag flag : KonKingdom.getProperties()) {
                            tabList.add(flag.toString());
                        }
                        break block33;
                    }
                    case "capital": 
                    case "town": {
                        for (KonPropertyFlag flag : KonTown.getProperties()) {
                            tabList.add(flag.toString());
                        }
                        break block33;
                    }
                    case "sanctuary": {
                        for (KonPropertyFlag flag : KonSanctuary.getProperties()) {
                            tabList.add(flag.toString());
                        }
                        break block33;
                    }
                    case "ruin": {
                        for (KonPropertyFlag flag : KonRuin.getProperties()) {
                            tabList.add(flag.toString());
                        }
                        break block33;
                    }
                }
                break block33;
            }
            if (args.size() == 5 && args.get(0).equalsIgnoreCase("set")) {
                tabList.add("true");
                tabList.add("false");
            }
        }
        return this.matchLastArgToList(tabList, args);
    }

    public static enum HolderType {
        KINGDOM(MessagePath.LABEL_KINGDOM.getMessage(new Object[0])),
        TOWN(MessagePath.TERRITORY_TOWN.getMessage(new Object[0])),
        CAPITAL(MessagePath.TERRITORY_CAPITAL.getMessage(new Object[0])),
        RUIN(MessagePath.TERRITORY_RUIN.getMessage(new Object[0])),
        SANCTUARY(MessagePath.TERRITORY_SANCTUARY.getMessage(new Object[0]));

        private final String label;

        private HolderType(String label) {
            this.label = label;
        }

        public String getLabel() {
            return this.label;
        }

        public static boolean contains(String type) {
            for (HolderType check : HolderType.values()) {
                if (!check.toString().equalsIgnoreCase(type)) continue;
                return true;
            }
            return false;
        }

        public static HolderType getType(String type) {
            for (HolderType check : HolderType.values()) {
                if (!check.toString().equalsIgnoreCase(type)) continue;
                return check;
            }
            return null;
        }
    }
}

