/*
 * Decompiled with CFR 0.152.
 */
package com.github.rumsfield.konquest.command.admin;

import com.github.rumsfield.konquest.Konquest;
import com.github.rumsfield.konquest.command.CommandBase;
import com.github.rumsfield.konquest.command.CommandType;
import com.github.rumsfield.konquest.command.admin.AdminCommandType;
import com.github.rumsfield.konquest.utility.ChatUtil;
import com.github.rumsfield.konquest.utility.MessagePath;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;

public class HelpAdminCommand
extends CommandBase {
    public HelpAdminCommand() {
        super("help", false, true);
        this.setOptionalArgs(true);
        this.addArgument(this.newArg("page", false, false));
        this.addArgument(this.newArg("command", false, true).sub(this.newArg("page", false, false)));
    }

    @Override
    public void execute(Konquest konquest, CommandSender sender, List<String> args) {
        int MAX_LINES_PER_PAGE = 6;
        String argPage = "";
        String helpCommand = "";
        if (!args.isEmpty()) {
            if (AdminCommandType.contains(args.get(0))) {
                helpCommand = args.get(0);
                if (args.size() == 2) {
                    argPage = args.get(1);
                }
            } else {
                argPage = args.get(0);
            }
        }
        boolean isBaseHelp = true;
        ArrayList<Object> lines = new ArrayList<Object>();
        if (helpCommand.isEmpty()) {
            for (AdminCommandType cmd : AdminCommandType.values()) {
                if (!cmd.isSenderAllowed(sender) || !sender.hasPermission(cmd.permission())) continue;
                String message = cmd.baseUsage() + String.valueOf(ChatColor.WHITE) + " : " + cmd.description();
                lines.add(message);
            }
        } else {
            lines.addAll(AdminCommandType.getCommand(helpCommand).argumentUsage());
            isBaseHelp = false;
            helpCommand = CommandType.getCommand(helpCommand).toString().toLowerCase();
        }
        if (lines.isEmpty()) {
            ChatUtil.printConsoleError("Admin Command help is missing lines! Contact the plugin author.");
            ChatUtil.sendError(sender, MessagePath.GENERIC_ERROR_INTERNAL.getMessage(new Object[0]));
            return;
        }
        int numLines = lines.size();
        int maxPages = (int)Math.ceil((double)numLines / 6.0);
        int page = 1;
        if (!argPage.isEmpty()) {
            try {
                page = Integer.parseInt(argPage);
            }
            catch (NumberFormatException ignored) {
                ChatUtil.sendError(sender, MessagePath.COMMAND_HELP_ERROR_PAGE.getMessage(new Object[0]));
                this.sendInvalidArgMessage(sender);
                return;
            }
            page = Math.max(page, 1);
            page = Math.min(page, maxPages);
        }
        String pageDisplay = page + "/" + maxPages;
        ChatUtil.sendNotice(sender, MessagePath.COMMAND_HELP_NOTICE_HEADER.getMessage(pageDisplay));
        if (page == 1 && maxPages > 1) {
            if (isBaseHelp) {
                ChatUtil.sendNotice(sender, MessagePath.COMMAND_ADMIN_HELP_NOTICE_PAGE.getMessage(new Object[0]));
            } else {
                ChatUtil.sendNotice(sender, MessagePath.COMMAND_ADMIN_HELP_NOTICE_PAGE_COMMAND.getMessage(helpCommand));
            }
        }
        if (isBaseHelp) {
            ChatUtil.sendNotice(sender, MessagePath.COMMAND_ADMIN_HELP_NOTICE_DETAIL.getMessage(new Object[0]));
        } else {
            ChatUtil.sendNotice(sender, MessagePath.COMMAND_HELP_NOTICE_COMMAND.getMessage(new Object[0]));
        }
        int startIdx = (page - 1) * 6;
        int endIdx = startIdx + 6;
        for (int i = startIdx; i < endIdx && i < numLines; ++i) {
            ChatUtil.sendMessage(sender, "  " + (String)lines.get(i));
        }
    }

    @Override
    public List<String> tabComplete(Konquest konquest, CommandSender sender, List<String> args) {
        ArrayList<String> tabList = new ArrayList<String>();
        if (args.size() == 1) {
            tabList.add("#");
            for (AdminCommandType cmd : AdminCommandType.values()) {
                tabList.add(cmd.toString().toLowerCase());
            }
        } else if (args.size() == 2 && AdminCommandType.contains(args.get(0))) {
            tabList.add("#");
        }
        return this.matchLastArgToList(tabList, args);
    }
}

