/*
 * Decompiled with CFR 0.152.
 */
package com.github.rumsfield.konquest.command.admin;

import com.github.rumsfield.konquest.Konquest;
import com.github.rumsfield.konquest.api.model.KonquestDiplomacyType;
import com.github.rumsfield.konquest.command.CommandBase;
import com.github.rumsfield.konquest.model.KonKingdom;
import com.github.rumsfield.konquest.model.KonOfflinePlayer;
import com.github.rumsfield.konquest.model.KonPlayer;
import com.github.rumsfield.konquest.utility.ChatUtil;
import com.github.rumsfield.konquest.utility.ColorRGB;
import com.github.rumsfield.konquest.utility.CorePath;
import com.github.rumsfield.konquest.utility.MessagePath;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;

public class KingdomAdminCommand
extends CommandBase {
    public KingdomAdminCommand() {
        super("kingdom", false, true);
        this.addArgument(this.newArg("menu", true, false).sub(this.newArg("kingdom", false, false)));
        this.addArgument(this.newArg("create", true, false).sub(this.newArg("template", false, false).sub(this.newArg("name", false, false))));
        this.addArgument(this.newArg("remove", true, false).sub(this.newArg("kingdom", false, false)));
        this.addArgument(this.newArg("exile", true, false).sub(this.newArg("player", false, false)));
        this.addArgument(this.newArg("rename", true, false).sub(this.newArg("kingdom", false, false).sub(this.newArg("name", false, false))));
        this.addArgument(this.newArg("capital", true, false).sub(this.newArg("kingdom", false, false).sub(this.newArg("town", false, false))));
        List<String> accessArgNames = Arrays.asList("open", "closed");
        this.addArgument(this.newArg("access", true, false).sub(this.newArg("kingdom", false, false).sub(this.newArg(accessArgNames, true, false))));
        List<String> typeArgNames = Arrays.asList("admin", "player");
        this.addArgument(this.newArg("type", true, false).sub(this.newArg("kingdom", false, false).sub(this.newArg(typeArgNames, true, false))));
        this.addArgument(this.newArg("template", true, false).sub(this.newArg("kingdom", false, true).sub(this.newArg("monument", false, false))));
        this.addArgument(this.newArg("webcolor", true, false).sub(this.newArg("kingdom", false, true).sub(this.newArg("color", false, false))));
        this.addArgument(this.newArg("diplomacy", true, false).sub(this.newArg("kingdom", false, false).sub(this.newArg("kingdom", false, true).sub(this.newArg("relation", false, false)))));
        List<String> memberArgNames = Arrays.asList("add", "kick", "promote", "demote", "master");
        this.addArgument(this.newArg("member", true, false).sub(this.newArg("kingdom", false, false).sub(this.newArg(memberArgNames, true, false).sub(this.newArg("player", false, false)))));
    }

    @Override
    public void execute(Konquest konquest, CommandSender sender, List<String> args) {
        KonPlayer player;
        boolean isSenderPlayer;
        if (konquest.getSanctuaryManager().getNumTemplates() == 0) {
            ChatUtil.sendError(sender, MessagePath.COMMAND_ADMIN_KINGDOM_ERROR_NO_TEMPLATES.getMessage(new Object[0]));
        }
        boolean bl = isSenderPlayer = (player = konquest.getPlayerManager().getPlayer(sender)) != null;
        if (args.size() < 2) {
            this.sendInvalidArgMessage(sender);
            return;
        }
        String subCmd = args.get(0);
        String kingdomName = args.get(1);
        block15 : switch (subCmd.toLowerCase()) {
            case "menu": {
                if (!isSenderPlayer) {
                    ChatUtil.sendError(sender, MessagePath.GENERIC_ERROR_NO_PLAYER.getMessage(new Object[0]));
                    return;
                }
                if (!konquest.getKingdomManager().isKingdom(kingdomName)) {
                    ChatUtil.sendError(sender, MessagePath.GENERIC_ERROR_UNKNOWN_NAME.getMessage(kingdomName));
                    return;
                }
                KonKingdom kingdom = konquest.getKingdomManager().getKingdom(kingdomName);
                assert (kingdom != null);
                konquest.getDisplayManager().displayKingdomMenu(player, kingdom, true);
                break;
            }
            case "create": {
                if (!isSenderPlayer) {
                    ChatUtil.sendError(sender, MessagePath.GENERIC_ERROR_NO_PLAYER.getMessage(new Object[0]));
                    return;
                }
                if (args.size() != 3) {
                    this.sendInvalidArgMessage(sender);
                    return;
                }
                String templateName = args.get(1);
                String newKingdomName = args.get(2);
                if (konquest.validateName(newKingdomName, sender) != 0) {
                    return;
                }
                Location settleLoc = player.getBukkitPlayer().getLocation();
                if (!konquest.isWorldValid(settleLoc.getWorld())) {
                    ChatUtil.sendError(sender, MessagePath.GENERIC_ERROR_INVALID_WORLD.getMessage(new Object[0]));
                    return;
                }
                int status = konquest.getKingdomManager().createKingdom(settleLoc, newKingdomName, templateName, player, true);
                if (status == 0) {
                    KonKingdom createdKingdom = konquest.getKingdomManager().getKingdom(newKingdomName);
                    ChatUtil.sendBroadcast(MessagePath.COMMAND_ADMIN_KINGDOM_BROADCAST_CREATE.getMessage(newKingdomName));
                    konquest.getKingdomManager().teleportAwayFromCenter(createdKingdom.getCapital());
                    KonKingdom newKingdom = konquest.getKingdomManager().getKingdom(newKingdomName);
                    konquest.getDisplayManager().displayKingdomMenu(player, newKingdom, true);
                    break;
                }
                switch (status) {
                    case 1: {
                        ChatUtil.sendError(sender, MessagePath.GENERIC_ERROR_TAKEN_NAME.getMessage(new Object[0]));
                        break block15;
                    }
                    case 4: {
                        ChatUtil.sendError(sender, MessagePath.COMMAND_KINGDOM_ERROR_INVALID_TEMPLATE.getMessage(templateName));
                        break block15;
                    }
                    case 5: {
                        ChatUtil.sendError(sender, MessagePath.GENERIC_ERROR_INVALID_WORLD.getMessage(new Object[0]));
                        break block15;
                    }
                    case 6: {
                        int distance = konquest.getTerritoryManager().getDistanceToClosestTerritory(settleLoc);
                        int min_distance_sanc = konquest.getCore().getInt(CorePath.TOWNS_MIN_DISTANCE_SANCTUARY.getPath());
                        int min_distance_town = konquest.getCore().getInt(CorePath.TOWNS_MIN_DISTANCE_TOWN.getPath());
                        int min_distance = Math.min(min_distance_sanc, min_distance_town);
                        ChatUtil.sendError(sender, MessagePath.COMMAND_SETTLE_ERROR_FAIL_PROXIMITY.getMessage(distance, min_distance));
                        break block15;
                    }
                    case 7: {
                        int distance = konquest.getTerritoryManager().getDistanceToClosestTerritory(settleLoc);
                        int max_distance_all = konquest.getCore().getInt(CorePath.TOWNS_MAX_DISTANCE_ALL.getPath());
                        ChatUtil.sendError(sender, MessagePath.COMMAND_SETTLE_ERROR_FAIL_MAX.getMessage(distance, max_distance_all));
                        break block15;
                    }
                    case 8: {
                        ChatUtil.sendError(sender, MessagePath.COMMAND_SETTLE_ERROR_FAIL_PLACEMENT.getMessage(new Object[0]));
                        break block15;
                    }
                    case 12: {
                        ChatUtil.sendError(sender, MessagePath.COMMAND_SETTLE_ERROR_FAIL_HEIGHT.getMessage(new Object[0]));
                        break block15;
                    }
                    case 13: {
                        ChatUtil.sendError(sender, MessagePath.COMMAND_SETTLE_ERROR_FAIL_INIT.getMessage(new Object[0]));
                        break block15;
                    }
                    case 14: {
                        ChatUtil.sendError(sender, MessagePath.COMMAND_SETTLE_ERROR_FAIL_AIR.getMessage(new Object[0]));
                        break block15;
                    }
                    case 15: {
                        ChatUtil.sendError(sender, MessagePath.COMMAND_SETTLE_ERROR_FAIL_WATER.getMessage(new Object[0]));
                        break block15;
                    }
                    case 16: {
                        ChatUtil.sendError(sender, MessagePath.COMMAND_SETTLE_ERROR_FAIL_CONTAINER.getMessage(new Object[0]));
                        break block15;
                    }
                    case 22: {
                        ChatUtil.sendError(sender, MessagePath.COMMAND_SETTLE_ERROR_FAIL_FLAT.getMessage(new Object[0]));
                        break block15;
                    }
                    case 23: {
                        ChatUtil.sendError(sender, MessagePath.COMMAND_SETTLE_ERROR_FAIL_HEIGHT.getMessage(new Object[0]));
                        break block15;
                    }
                }
                ChatUtil.sendError(sender, MessagePath.GENERIC_ERROR_INTERNAL.getMessage(new Object[0]));
                break;
            }
            case "remove": {
                boolean pass = konquest.getKingdomManager().removeKingdom(kingdomName);
                if (!pass) {
                    ChatUtil.sendError(sender, MessagePath.GENERIC_ERROR_UNKNOWN_NAME.getMessage(kingdomName));
                    return;
                }
                ChatUtil.sendBroadcast(MessagePath.COMMAND_KINGDOM_BROADCAST_DISBAND.getMessage(kingdomName));
                break;
            }
            case "rename": {
                if (args.size() != 3) {
                    this.sendInvalidArgMessage(sender);
                    return;
                }
                String newName = args.get(2);
                if (!konquest.getKingdomManager().isKingdom(kingdomName)) {
                    ChatUtil.sendError(sender, MessagePath.GENERIC_ERROR_UNKNOWN_NAME.getMessage(kingdomName));
                    return;
                }
                KonKingdom kingdom = konquest.getKingdomManager().getKingdom(kingdomName);
                assert (kingdom != null);
                String oldName = kingdom.getName();
                if (konquest.validateName(newName, sender) != 0) {
                    return;
                }
                int renameStatus = konquest.getKingdomManager().renameKingdom(oldName, newName, player, true);
                switch (renameStatus) {
                    case 0: {
                        ChatUtil.sendNotice(sender, MessagePath.COMMAND_KINGDOM_NOTICE_RENAME.getMessage(newName));
                        ChatUtil.sendBroadcast(MessagePath.COMMAND_KINGDOM_BROADCAST_RENAME.getMessage(oldName, newName));
                        break block15;
                    }
                    case 1: {
                        ChatUtil.sendError(sender, MessagePath.GENERIC_ERROR_UNKNOWN_NAME.getMessage(new Object[0]));
                        break block15;
                    }
                    case 2: {
                        ChatUtil.sendError(sender, MessagePath.GENERIC_ERROR_TAKEN_NAME.getMessage(new Object[0]));
                        break block15;
                    }
                }
                ChatUtil.sendError(sender, MessagePath.GENERIC_ERROR_FAILED.getMessage(new Object[0]));
                break;
            }
            case "capital": {
                if (!konquest.getKingdomManager().getIsCapitalSwapEnable()) {
                    ChatUtil.sendError(sender, MessagePath.GENERIC_ERROR_DISABLED.getMessage(new Object[0]));
                    return;
                }
                if (args.size() != 3) {
                    this.sendInvalidArgMessage(sender);
                    return;
                }
                if (!konquest.getKingdomManager().isKingdom(kingdomName)) {
                    ChatUtil.sendError(sender, MessagePath.GENERIC_ERROR_UNKNOWN_NAME.getMessage(kingdomName));
                    return;
                }
                KonKingdom kingdom = konquest.getKingdomManager().getKingdom(kingdomName);
                assert (kingdom != null);
                String townName = args.get(2);
                if (!kingdom.hasTown(townName)) {
                    ChatUtil.sendError(sender, MessagePath.GENERIC_ERROR_BAD_NAME.getMessage(townName));
                    return;
                }
                boolean swapStatus = kingdom.swapCapitalToTown(kingdom.getTown(townName));
                if (swapStatus) {
                    ChatUtil.sendNotice(sender, MessagePath.GENERIC_NOTICE_SUCCESS.getMessage(new Object[0]));
                    break;
                }
                ChatUtil.sendError(sender, MessagePath.GENERIC_ERROR_FAILED.getMessage(new Object[0]));
                break;
            }
            case "exile": {
                if (args.size() != 2) {
                    this.sendInvalidArgMessage(sender);
                    return;
                }
                String exilePlayerName = args.get(1);
                KonOfflinePlayer exilePlayer = konquest.getPlayerManager().getOfflinePlayerFromName(exilePlayerName);
                if (exilePlayer == null) {
                    ChatUtil.sendError(sender, MessagePath.GENERIC_ERROR_UNKNOWN_NAME.getMessage(exilePlayerName));
                    return;
                }
                exilePlayerName = exilePlayer.getOfflineBukkitPlayer().getName();
                UUID exileUUID = exilePlayer.getOfflineBukkitPlayer().getUniqueId();
                int playerExileStatus = konquest.getKingdomManager().exilePlayerBarbarian(exileUUID, true, true, true, true);
                switch (playerExileStatus) {
                    case 0: {
                        ChatUtil.sendNotice(sender, MessagePath.COMMAND_KINGDOM_NOTICE_KICK.getMessage(exilePlayerName));
                        break block15;
                    }
                    case 1: {
                        ChatUtil.sendError(sender, MessagePath.COMMAND_KINGDOM_ERROR_KICK_BARBARIAN.getMessage(new Object[0]));
                        break block15;
                    }
                }
                ChatUtil.sendError(sender, MessagePath.GENERIC_ERROR_FAILED.getMessage(new Object[0]));
                break;
            }
            case "access": {
                if (args.size() != 3) {
                    this.sendInvalidArgMessage(sender);
                    return;
                }
                String accessType = args.get(2);
                if (!konquest.getKingdomManager().isKingdom(kingdomName)) {
                    ChatUtil.sendError(sender, MessagePath.GENERIC_ERROR_UNKNOWN_NAME.getMessage(kingdomName));
                    return;
                }
                KonKingdom kingdom = konquest.getKingdomManager().getKingdom(kingdomName);
                assert (kingdom != null);
                if (accessType.equalsIgnoreCase("open")) {
                    kingdom.setIsOpen(true);
                    ChatUtil.sendNotice(sender, MessagePath.COMMAND_KINGDOM_NOTICE_OPEN.getMessage(new Object[0]));
                    break;
                }
                if (accessType.equalsIgnoreCase("closed")) {
                    kingdom.setIsOpen(false);
                    ChatUtil.sendNotice(sender, MessagePath.COMMAND_KINGDOM_NOTICE_CLOSED.getMessage(new Object[0]));
                    break;
                }
                this.sendInvalidArgMessage(sender);
                break;
            }
            case "type": {
                if (args.size() != 3) {
                    this.sendInvalidArgMessage(sender);
                    return;
                }
                String kingdomType = args.get(2);
                if (!konquest.getKingdomManager().isKingdom(kingdomName)) {
                    ChatUtil.sendError(sender, MessagePath.GENERIC_ERROR_UNKNOWN_NAME.getMessage(kingdomName));
                    return;
                }
                KonKingdom kingdom = konquest.getKingdomManager().getKingdom(kingdomName);
                assert (kingdom != null);
                if (kingdomType.equalsIgnoreCase("admin")) {
                    kingdom.setIsAdminOperated(true);
                    kingdom.clearMaster();
                    ChatUtil.sendNotice(sender, MessagePath.COMMAND_ADMIN_KINGDOM_NOTICE_ADMIN_SET.getMessage(kingdom.getName()));
                    break;
                }
                if (kingdomType.equalsIgnoreCase("player")) {
                    kingdom.setIsAdminOperated(false);
                    ChatUtil.sendNotice(sender, MessagePath.COMMAND_ADMIN_KINGDOM_NOTICE_ADMIN_CLEAR.getMessage(kingdom.getName()));
                    break;
                }
                this.sendInvalidArgMessage(sender);
                break;
            }
            case "template": {
                if (!konquest.getKingdomManager().isKingdom(kingdomName)) {
                    ChatUtil.sendError(sender, MessagePath.GENERIC_ERROR_UNKNOWN_NAME.getMessage(kingdomName));
                    return;
                }
                KonKingdom kingdom = konquest.getKingdomManager().getKingdom(kingdomName);
                assert (kingdom != null);
                if (args.size() == 2) {
                    ChatUtil.sendNotice(sender, MessagePath.COMMAND_KINGDOM_NOTICE_TEMPLATE_CURRENT.getMessage(kingdom.getMonumentTemplateName()));
                    break;
                }
                if (args.size() == 3) {
                    String newTemplateName = args.get(2);
                    if (!konquest.getSanctuaryManager().isValidTemplate(newTemplateName)) {
                        ChatUtil.sendError(sender, MessagePath.COMMAND_KINGDOM_ERROR_INVALID_TEMPLATE.getMessage(newTemplateName));
                        return;
                    }
                    konquest.getKingdomManager().menuChangeKingdomTemplate(kingdom, konquest.getSanctuaryManager().getTemplate(newTemplateName), player, true);
                    break;
                }
                this.sendInvalidArgMessage(sender);
                break;
            }
            case "webcolor": {
                if (!konquest.getKingdomManager().isKingdom(kingdomName)) {
                    ChatUtil.sendError(sender, MessagePath.GENERIC_ERROR_UNKNOWN_NAME.getMessage(kingdomName));
                    return;
                }
                KonKingdom kingdom = konquest.getKingdomManager().getKingdom(kingdomName);
                assert (kingdom != null);
                if (args.size() == 2) {
                    int currentWebColor = kingdom.getWebColor();
                    String colorStr = "default";
                    if (currentWebColor != -1) {
                        colorStr = ChatUtil.reverseLookupColorRGB(currentWebColor);
                    }
                    ChatUtil.sendNotice(sender, MessagePath.COMMAND_KINGDOM_NOTICE_WEB_COLOR_SHOW.getMessage(kingdom.getName(), colorStr));
                    break;
                }
                if (args.size() == 3) {
                    String colorStr = args.get(2);
                    if (colorStr.equalsIgnoreCase("default")) {
                        kingdom.setWebColor(-1);
                    } else {
                        int newWebColor = ChatUtil.lookupColorRGB(colorStr);
                        if (newWebColor != -1) {
                            kingdom.setWebColor(newWebColor);
                        } else {
                            ChatUtil.sendError(sender, MessagePath.COMMAND_KINGDOM_ERROR_WEB_COLOR_INVALID.getMessage(new Object[0]));
                            return;
                        }
                    }
                    konquest.getMapHandler().drawUpdateTerritory(kingdom);
                    konquest.getIntegrationManager().getDiscordSrv().changeKingdomRole(kingdom.getName(), kingdom.getName(), kingdom.getWebColorFormal());
                    ChatUtil.sendNotice(sender, MessagePath.COMMAND_KINGDOM_NOTICE_WEB_COLOR_SET.getMessage(kingdom.getName(), colorStr));
                    break;
                }
                this.sendInvalidArgMessage(sender);
                break;
            }
            case "diplomacy": {
                if (!konquest.getKingdomManager().isKingdom(kingdomName)) {
                    ChatUtil.sendError(sender, MessagePath.GENERIC_ERROR_UNKNOWN_NAME.getMessage(kingdomName));
                    return;
                }
                KonKingdom kingdom = konquest.getKingdomManager().getKingdom(kingdomName);
                assert (kingdom != null);
                if (args.size() < 3) {
                    this.sendInvalidArgMessage(sender);
                }
                String otherKingdomName = args.get(2);
                if (!konquest.getKingdomManager().isKingdom(otherKingdomName)) {
                    ChatUtil.sendError(sender, MessagePath.GENERIC_ERROR_UNKNOWN_NAME.getMessage(otherKingdomName));
                    return;
                }
                KonKingdom otherKingdom = konquest.getKingdomManager().getKingdom(otherKingdomName);
                if (args.size() == 3) {
                    ChatUtil.sendNotice(sender, MessagePath.COMMAND_ADMIN_KINGDOM_NOTICE_DIPLOMACY.getMessage(kingdom.getName(), otherKingdom.getName(), kingdom.getActiveRelation(otherKingdom).toString()));
                    break;
                }
                if (args.size() == 4) {
                    KonquestDiplomacyType relation;
                    if (kingdom.isPeaceful() || otherKingdom.isPeaceful()) {
                        ChatUtil.sendError(sender, MessagePath.COMMAND_KINGDOM_ERROR_DIPLOMACY_PEACEFUL.getMessage(new Object[0]));
                        return;
                    }
                    String relationName = args.get(3);
                    try {
                        relation = KonquestDiplomacyType.valueOf(relationName.toUpperCase());
                    }
                    catch (IllegalArgumentException ex) {
                        ChatUtil.sendError(sender, MessagePath.GENERIC_ERROR_UNKNOWN_NAME.getMessage(relationName));
                        return;
                    }
                    konquest.getKingdomManager().menuChangeKingdomRelation(kingdom, otherKingdom, relation, player, sender, true);
                    break;
                }
                this.sendInvalidArgMessage(sender);
                break;
            }
            case "member": {
                if (!konquest.getKingdomManager().isKingdom(kingdomName)) {
                    ChatUtil.sendError(sender, MessagePath.GENERIC_ERROR_UNKNOWN_NAME.getMessage(kingdomName));
                    return;
                }
                KonKingdom kingdom = konquest.getKingdomManager().getKingdom(kingdomName);
                assert (kingdom != null);
                if (args.size() != 4) {
                    this.sendInvalidArgMessage(sender);
                    return;
                }
                String memberSubCmd = args.get(2);
                String playerName = args.get(3);
                KonOfflinePlayer offlinePlayer = konquest.getPlayerManager().getOfflinePlayerFromName(playerName);
                if (offlinePlayer == null) {
                    ChatUtil.sendError(sender, MessagePath.GENERIC_ERROR_UNKNOWN_NAME.getMessage(playerName));
                    return;
                }
                playerName = offlinePlayer.getOfflineBukkitPlayer().getName();
                UUID id = offlinePlayer.getOfflineBukkitPlayer().getUniqueId();
                switch (memberSubCmd.toLowerCase()) {
                    case "add": {
                        int memberAddStatus = konquest.getKingdomManager().assignPlayerKingdom(id, kingdom.getName(), true);
                        switch (memberAddStatus) {
                            case 0: {
                                ChatUtil.sendBroadcast(MessagePath.COMMAND_KINGDOM_BROADCAST_JOIN.getMessage(playerName, kingdom.getName()));
                                break block15;
                            }
                            case 5: {
                                ChatUtil.sendError(sender, MessagePath.COMMAND_KINGDOM_ERROR_INVITE_MEMBER.getMessage(playerName));
                                break block15;
                            }
                        }
                        ChatUtil.sendError(sender, MessagePath.GENERIC_ERROR_FAILED.getMessage(new Object[0]));
                        break block15;
                    }
                    case "kick": {
                        int memberKickStatus = konquest.getKingdomManager().exilePlayerBarbarian(id, true, false, false, true);
                        switch (memberKickStatus) {
                            case 0: {
                                ChatUtil.sendNotice(sender, MessagePath.COMMAND_KINGDOM_NOTICE_KICK.getMessage(playerName));
                                break block15;
                            }
                            case 1: {
                                ChatUtil.sendError(sender, MessagePath.COMMAND_KINGDOM_ERROR_KICK_BARBARIAN.getMessage(new Object[0]));
                                break block15;
                            }
                        }
                        ChatUtil.sendError(sender, MessagePath.GENERIC_ERROR_FAILED.getMessage(new Object[0]));
                        break block15;
                    }
                    case "promote": {
                        if (konquest.getKingdomManager().menuPromoteOfficer(offlinePlayer.getOfflineBukkitPlayer(), kingdom)) {
                            ChatUtil.sendNotice(sender, MessagePath.GENERIC_NOTICE_SUCCESS.getMessage(new Object[0]));
                            break block15;
                        }
                        ChatUtil.sendError(sender, MessagePath.GENERIC_ERROR_NO_ALLOW.getMessage(new Object[0]));
                        break block15;
                    }
                    case "demote": {
                        if (konquest.getKingdomManager().menuDemoteOfficer(offlinePlayer.getOfflineBukkitPlayer(), kingdom)) {
                            ChatUtil.sendNotice(sender, MessagePath.GENERIC_NOTICE_SUCCESS.getMessage(new Object[0]));
                            break block15;
                        }
                        ChatUtil.sendError(sender, MessagePath.GENERIC_ERROR_NO_ALLOW.getMessage(new Object[0]));
                        break block15;
                    }
                    case "master": {
                        konquest.getKingdomManager().menuTransferMaster(offlinePlayer.getOfflineBukkitPlayer(), kingdom, player);
                        break block15;
                    }
                }
                this.sendInvalidArgMessage(sender);
                return;
            }
            default: {
                this.sendInvalidArgMessage(sender);
            }
        }
    }

    @Override
    public List<String> tabComplete(Konquest konquest, CommandSender sender, List<String> args) {
        ArrayList<String> tabList = new ArrayList<String>();
        int numArgs = args.size();
        if (numArgs == 1) {
            tabList.add("menu");
            tabList.add("create");
            tabList.add("remove");
            tabList.add("rename");
            tabList.add("exile");
            tabList.add("access");
            tabList.add("type");
            tabList.add("template");
            tabList.add("webcolor");
            tabList.add("diplomacy");
            tabList.add("member");
            if (konquest.getKingdomManager().getIsCapitalSwapEnable()) {
                tabList.add("capital");
            }
        } else if (numArgs == 2) {
            if (args.get(0).equalsIgnoreCase("create")) {
                tabList.addAll(konquest.getSanctuaryManager().getAllValidTemplateNames());
            } else if (args.get(0).equalsIgnoreCase("exile")) {
                tabList.addAll(konquest.getPlayerManager().getAllPlayerNames());
            } else {
                tabList.addAll(konquest.getKingdomManager().getKingdomNames());
            }
        } else if (numArgs == 3) {
            switch (args.get(0).toLowerCase()) {
                case "create": 
                case "rename": {
                    tabList.add("***");
                    break;
                }
                case "capital": {
                    String targetKingdomName = args.get(1);
                    if (!konquest.getKingdomManager().isKingdom(targetKingdomName)) break;
                    tabList.addAll(konquest.getKingdomManager().getKingdom(targetKingdomName).getTownNames());
                    break;
                }
                case "access": {
                    tabList.add("open");
                    tabList.add("closed");
                    break;
                }
                case "type": {
                    tabList.add("admin");
                    tabList.add("player");
                    break;
                }
                case "template": {
                    tabList.addAll(konquest.getSanctuaryManager().getAllTemplateNames());
                    break;
                }
                case "webcolor": {
                    for (ColorRGB color : ColorRGB.values()) {
                        tabList.add(color.getName());
                    }
                    tabList.add("#rrggbb");
                    tabList.add("default");
                    break;
                }
                case "diplomacy": {
                    tabList.addAll(konquest.getKingdomManager().getKingdomNames());
                    break;
                }
                case "member": {
                    tabList.add("add");
                    tabList.add("kick");
                    tabList.add("promote");
                    tabList.add("demote");
                    tabList.add("master");
                    break;
                }
            }
        } else if (numArgs == 4) {
            block25 : switch (args.get(0).toLowerCase()) {
                case "diplomacy": {
                    String targetKingdomName = args.get(1);
                    String otherKingdomName = args.get(2);
                    if (!konquest.getKingdomManager().isKingdom(targetKingdomName) || !konquest.getKingdomManager().isKingdom(otherKingdomName)) break;
                    for (KonquestDiplomacyType relation : KonquestDiplomacyType.values()) {
                        if (!konquest.getKingdomManager().isValidRelationChoice(konquest.getKingdomManager().getKingdom(targetKingdomName), konquest.getKingdomManager().getKingdom(otherKingdomName), relation)) continue;
                        tabList.add(relation.toString());
                    }
                    break;
                }
                case "member": {
                    String memberKingdomName = args.get(1);
                    if (!konquest.getKingdomManager().isKingdom(memberKingdomName)) break;
                    KonKingdom kingdom = konquest.getKingdomManager().getKingdom(memberKingdomName);
                    switch (args.get(2).toLowerCase()) {
                        case "add": {
                            for (KonOfflinePlayer offlinePlayer : konquest.getPlayerManager().getAllKonquestOfflinePlayers()) {
                                String name = offlinePlayer.getOfflineBukkitPlayer().getName();
                                if (name == null || kingdom.isMember(offlinePlayer.getOfflineBukkitPlayer().getUniqueId())) continue;
                                tabList.add(name);
                            }
                            break block25;
                        }
                        case "kick": {
                            for (KonOfflinePlayer offlinePlayer : konquest.getPlayerManager().getAllKonquestOfflinePlayers()) {
                                String name = offlinePlayer.getOfflineBukkitPlayer().getName();
                                if (name == null || !kingdom.isMember(offlinePlayer.getOfflineBukkitPlayer().getUniqueId())) continue;
                                tabList.add(name);
                            }
                            break block25;
                        }
                        case "promote": {
                            for (OfflinePlayer offlinePlayer : kingdom.getPlayerMembersOnly()) {
                                String name = offlinePlayer.getName();
                                if (name == null) continue;
                                tabList.add(name);
                            }
                            break block25;
                        }
                        case "demote": {
                            for (OfflinePlayer offlinePlayer : kingdom.getPlayerOfficersOnly()) {
                                String name = offlinePlayer.getName();
                                if (name == null) continue;
                                tabList.add(name);
                            }
                            break block25;
                        }
                        case "master": {
                            for (OfflinePlayer offlinePlayer : kingdom.getPlayerMembers()) {
                                String name = offlinePlayer.getName();
                                if (name == null || kingdom.isMaster(offlinePlayer.getUniqueId())) continue;
                                tabList.add(name);
                            }
                        }
                    }
                    break;
                }
            }
        }
        return this.matchLastArgToList(tabList, args);
    }
}

