/*
 * Decompiled with CFR 0.152.
 */
package com.github.rumsfield.konquest.command.admin;

import com.github.rumsfield.konquest.Konquest;
import com.github.rumsfield.konquest.command.CommandBase;
import com.github.rumsfield.konquest.model.KonMonumentTemplate;
import com.github.rumsfield.konquest.model.KonPlayer;
import com.github.rumsfield.konquest.utility.ChatUtil;
import com.github.rumsfield.konquest.utility.MessagePath;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.CommandSender;

public class MonumentAdminCommand
extends CommandBase {
    public MonumentAdminCommand() {
        super("monument", true, true);
        this.addArgument(this.newArg("create", true, false).sub(this.newArg("name", false, true).sub(this.newArg("cost", false, false))));
        this.addArgument(this.newArg("reset", true, false).sub(this.newArg("monument", false, true).sub(this.newArg("cost", false, false))));
        this.addArgument(this.newArg("rename", true, false).sub(this.newArg("monument", false, false).sub(this.newArg("name", false, false))));
        this.addArgument(this.newArg("loot", true, false).sub(this.newArg("monument", false, true).sub(this.newArg("name", false, false))));
        List<String> argNames = Arrays.asList("remove", "show", "status");
        this.addArgument(this.newArg(argNames, true, false).sub(this.newArg("monument", false, false)));
    }

    @Override
    public void execute(Konquest konquest, CommandSender sender, List<String> args) {
        KonPlayer player = konquest.getPlayerManager().getPlayer(sender);
        if (player == null) {
            this.sendInvalidSenderMessage(sender);
            return;
        }
        if (args.size() != 2 && args.size() != 3) {
            this.sendInvalidArgMessage(sender);
            return;
        }
        Location playerLoc = player.getBukkitPlayer().getLocation();
        World bukkitWorld = playerLoc.getWorld();
        if (konquest.isWorldIgnored(bukkitWorld)) {
            ChatUtil.sendError(sender, MessagePath.GENERIC_ERROR_INVALID_WORLD.getMessage(new Object[0]));
            return;
        }
        if (player.isSettingRegion()) {
            ChatUtil.sendError(sender, MessagePath.GENERIC_ERROR_REGION.getMessage(new Object[0]));
            return;
        }
        String cmdMode = args.get(0);
        String templateName = args.get(1);
        if (cmdMode.equalsIgnoreCase("create")) {
            double costNum = 0.0;
            if (args.size() == 3) {
                try {
                    costNum = Double.parseDouble(args.get(2));
                }
                catch (NumberFormatException e) {
                    ChatUtil.sendError(sender, MessagePath.COMMAND_ADMIN_MONUMENT_ERROR_VALUE.getMessage(new Object[0]));
                    ChatUtil.sendError(sender, e.getMessage());
                    return;
                }
                costNum = Math.max(costNum, 0.0);
            }
            if (konquest.validateName(templateName, sender) != 0) {
                return;
            }
            player.settingRegion(KonPlayer.RegionType.MONUMENT);
            player.setRegionTemplateName(templateName);
            player.setRegionTemplateCost(costNum);
            ChatUtil.sendNotice(sender, MessagePath.COMMAND_ADMIN_MONUMENT_NOTICE_CREATE_1.getMessage(new Object[0]), ChatColor.LIGHT_PURPLE);
            ChatUtil.sendNotice(sender, MessagePath.GENERIC_NOTICE_CLICK_AIR.getMessage(new Object[0]));
        } else if (cmdMode.equalsIgnoreCase("reset")) {
            double costNum = 0.0;
            if (args.size() == 3) {
                try {
                    costNum = Double.parseDouble(args.get(2));
                }
                catch (NumberFormatException e) {
                    ChatUtil.sendError(sender, MessagePath.COMMAND_ADMIN_MONUMENT_ERROR_VALUE.getMessage(new Object[0]));
                    ChatUtil.sendError(sender, e.getMessage());
                    return;
                }
                costNum = Math.max(costNum, 0.0);
            }
            if (!konquest.getSanctuaryManager().isTemplate(templateName)) {
                ChatUtil.sendError(sender, MessagePath.GENERIC_ERROR_UNKNOWN_NAME.getMessage(templateName));
                return;
            }
            String sanctuaryName = konquest.getSanctuaryManager().getSanctuaryNameOfTemplate(templateName);
            if (konquest.getSanctuaryManager().isSanctuary(sanctuaryName)) {
                konquest.getSanctuaryManager().getSanctuary(sanctuaryName).stopTemplateBlanking(templateName);
            }
            player.settingRegion(KonPlayer.RegionType.MONUMENT);
            player.setRegionTemplateName(templateName);
            player.setRegionTemplateCost(costNum);
            ChatUtil.sendNotice(sender, MessagePath.COMMAND_ADMIN_MONUMENT_NOTICE_CREATE_1.getMessage(new Object[0]), ChatColor.LIGHT_PURPLE);
            ChatUtil.sendNotice(sender, MessagePath.GENERIC_NOTICE_CLICK_AIR.getMessage(new Object[0]));
        } else if (cmdMode.equalsIgnoreCase("remove")) {
            if (!konquest.getSanctuaryManager().isTemplate(templateName)) {
                ChatUtil.sendError(sender, MessagePath.GENERIC_ERROR_UNKNOWN_NAME.getMessage(templateName));
                return;
            }
            player.settingRegion(KonPlayer.RegionType.NONE);
            konquest.getSanctuaryManager().removeMonumentTemplate(templateName);
            ChatUtil.sendNotice(sender, MessagePath.COMMAND_ADMIN_MONUMENT_NOTICE_REMOVE.getMessage(templateName));
        } else if (cmdMode.equalsIgnoreCase("rename")) {
            String newTemplateName;
            if (!konquest.getSanctuaryManager().isTemplate(templateName)) {
                ChatUtil.sendError(sender, MessagePath.GENERIC_ERROR_UNKNOWN_NAME.getMessage(templateName));
                return;
            }
            if (args.size() != 3) {
                this.sendInvalidArgMessage(sender);
            }
            if (konquest.validateName(newTemplateName = args.get(2), sender) != 0) {
                return;
            }
            if (konquest.getSanctuaryManager().renameMonumentTemplate(templateName, newTemplateName)) {
                ChatUtil.sendNotice(sender, MessagePath.COMMAND_ADMIN_MONUMENT_NOTICE_RENAME.getMessage(templateName, newTemplateName));
            } else {
                ChatUtil.sendError(sender, MessagePath.GENERIC_ERROR_FAILED.getMessage(new Object[0]));
            }
        } else if (cmdMode.equalsIgnoreCase("loot")) {
            if (!konquest.getSanctuaryManager().isTemplate(templateName)) {
                ChatUtil.sendError(sender, MessagePath.GENERIC_ERROR_UNKNOWN_NAME.getMessage(templateName));
                return;
            }
            KonMonumentTemplate template = konquest.getSanctuaryManager().getTemplate(templateName);
            if (args.size() == 2) {
                String lootTableName = template.getLootTableName();
                ChatUtil.sendNotice(sender, MessagePath.GENERIC_NOTICE_LOOT_SHOW.getMessage(lootTableName));
            } else if (args.size() == 3) {
                String newTableName = args.get(2);
                if (!konquest.getLootManager().isMonumentLootTable(newTableName)) {
                    ChatUtil.sendError(sender, MessagePath.GENERIC_ERROR_LOOT_UNKNOWN.getMessage(newTableName));
                    return;
                }
                template.setLootTableName(newTableName);
                ChatUtil.sendNotice(sender, MessagePath.GENERIC_NOTICE_LOOT_SET.getMessage(newTableName));
            } else {
                this.sendInvalidArgMessage(sender);
            }
        } else if (cmdMode.equalsIgnoreCase("show")) {
            if (!konquest.getSanctuaryManager().isTemplate(templateName)) {
                ChatUtil.sendError(sender, MessagePath.GENERIC_ERROR_UNKNOWN_NAME.getMessage(templateName));
                return;
            }
            player.settingRegion(KonPlayer.RegionType.NONE);
            Location loc0 = konquest.getSanctuaryManager().getTemplate(templateName).getCornerOne();
            Location loc1 = konquest.getSanctuaryManager().getTemplate(templateName).getCornerTwo();
            player.startMonumentShow(loc0, loc1);
            String sanctuaryName = konquest.getSanctuaryManager().getSanctuaryNameOfTemplate(templateName);
            ChatUtil.sendNotice(sender, MessagePath.COMMAND_ADMIN_MONUMENT_NOTICE_SHOW.getMessage(templateName, sanctuaryName));
        } else if (cmdMode.equalsIgnoreCase("status")) {
            if (!konquest.getSanctuaryManager().isTemplate(templateName)) {
                ChatUtil.sendError(sender, MessagePath.GENERIC_ERROR_UNKNOWN_NAME.getMessage(templateName));
                return;
            }
            ChatColor loreColor = ChatColor.YELLOW;
            ChatColor valueColor = ChatColor.AQUA;
            KonMonumentTemplate template = konquest.getSanctuaryManager().getTemplate(templateName);
            String tempName = template.getName();
            String sanctuaryName = konquest.getSanctuaryManager().getSanctuaryNameOfTemplate(templateName);
            String cost = String.format("%.2f", template.getCost());
            String isValid = String.format("%s", template.isValid());
            String isBlanking = String.format("%s", template.isBlanking());
            String allBlocks = String.format("%d", template.getNumBlocks());
            String critBlocks = String.format("%d", template.getNumCriticals());
            String lootChests = String.format("%d", template.getNumLootChests());
            ChatUtil.sendNotice(sender, MessagePath.LABEL_MONUMENT_TEMPLATE.getMessage(new Object[0]) + " " + tempName);
            ChatUtil.sendMessage(sender, String.valueOf(loreColor) + MessagePath.TERRITORY_SANCTUARY.getMessage(new Object[0]) + ": " + String.valueOf(valueColor) + sanctuaryName);
            ChatUtil.sendMessage(sender, String.valueOf(loreColor) + MessagePath.LABEL_COST.getMessage(new Object[0]) + ": " + String.valueOf(valueColor) + cost);
            ChatUtil.sendMessage(sender, String.valueOf(loreColor) + MessagePath.LABEL_VALID.getMessage(new Object[0]) + ": " + String.valueOf(valueColor) + isValid);
            ChatUtil.sendMessage(sender, String.valueOf(loreColor) + MessagePath.LABEL_MODIFIED.getMessage(new Object[0]) + ": " + String.valueOf(valueColor) + isBlanking);
            ChatUtil.sendMessage(sender, String.valueOf(loreColor) + MessagePath.LABEL_BLOCKS.getMessage(new Object[0]) + ": " + String.valueOf(valueColor) + allBlocks);
            ChatUtil.sendMessage(sender, String.valueOf(loreColor) + MessagePath.LABEL_CRITICAL_HITS.getMessage(new Object[0]) + ": " + String.valueOf(valueColor) + critBlocks);
            ChatUtil.sendMessage(sender, String.valueOf(loreColor) + MessagePath.LABEL_LOOT_CHESTS.getMessage(new Object[0]) + ": " + String.valueOf(valueColor) + lootChests);
        } else {
            this.sendInvalidArgMessage(sender);
        }
    }

    @Override
    public List<String> tabComplete(Konquest konquest, CommandSender sender, List<String> args) {
        ArrayList<String> tabList = new ArrayList<String>();
        if (args.size() == 1) {
            tabList.add("create");
            tabList.add("remove");
            tabList.add("rename");
            tabList.add("loot");
            tabList.add("reset");
            tabList.add("show");
            tabList.add("status");
        } else if (args.size() == 2) {
            if (args.get(0).equalsIgnoreCase("create")) {
                tabList.add("***");
            } else {
                tabList.addAll(konquest.getSanctuaryManager().getAllTemplateNames());
            }
        } else if (args.size() == 3) {
            if (args.get(0).equalsIgnoreCase("create") || args.get(0).equalsIgnoreCase("reset")) {
                tabList.add("#");
            } else if (args.get(0).equalsIgnoreCase("rename")) {
                tabList.add("***");
            } else if (args.get(0).equalsIgnoreCase("loot")) {
                tabList.addAll(konquest.getLootManager().getMonumentLootTableKeys());
            }
        }
        return this.matchLastArgToList(tabList, args);
    }
}

