/*
 * Decompiled with CFR 0.152.
 */
package com.github.rumsfield.konquest.command.admin;

import com.github.rumsfield.konquest.Konquest;
import com.github.rumsfield.konquest.command.CommandBase;
import com.github.rumsfield.konquest.model.KonPlayer;
import com.github.rumsfield.konquest.model.KonRuin;
import com.github.rumsfield.konquest.utility.ChatUtil;
import com.github.rumsfield.konquest.utility.MessagePath;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;

public class RuinAdminCommand
extends CommandBase {
    public RuinAdminCommand() {
        super("ruin", true, true);
        this.addArgument(this.newArg("create", true, false).sub(this.newArg("name", false, false)));
        this.addArgument(this.newArg("rename", true, false).sub(this.newArg("ruin", false, false).sub(this.newArg("name", false, false))));
        this.addArgument(this.newArg("loot", true, false).sub(this.newArg("ruin", false, true).sub(this.newArg("name", false, false))));
        List<String> argNames = Arrays.asList("reset", "remove", "criticals", "spawns");
        this.addArgument(this.newArg(argNames, true, false).sub(this.newArg("ruin", false, false)));
    }

    @Override
    public void execute(Konquest konquest, CommandSender sender, List<String> args) {
        KonPlayer player = konquest.getPlayerManager().getPlayer(sender);
        if (player == null) {
            this.sendInvalidSenderMessage(sender);
            return;
        }
        if (args.size() != 2 && args.size() != 3) {
            this.sendInvalidArgMessage(sender);
            return;
        }
        String cmdMode = args.get(0);
        String ruinName = args.get(1);
        Location playerLoc = player.getBukkitPlayer().getLocation();
        if (konquest.isWorldIgnored(playerLoc.getWorld())) {
            ChatUtil.sendError(sender, MessagePath.GENERIC_ERROR_INVALID_WORLD.getMessage(new Object[0]));
            return;
        }
        if (cmdMode.equalsIgnoreCase("create")) {
            if (konquest.validateName(ruinName, sender) != 0) {
                return;
            }
            if (konquest.getRuinManager().addRuin(playerLoc, ruinName)) {
                ChatUtil.sendNotice(sender, MessagePath.COMMAND_ADMIN_RUIN_NOTICE_CREATE.getMessage(ruinName));
            } else {
                ChatUtil.sendError(sender, MessagePath.COMMAND_ADMIN_RUIN_ERROR_CREATE.getMessage(ruinName));
            }
        } else if (cmdMode.equalsIgnoreCase("remove")) {
            if (!konquest.getRuinManager().isRuin(ruinName)) {
                ChatUtil.sendError(sender, MessagePath.GENERIC_ERROR_UNKNOWN_NAME.getMessage(ruinName));
                return;
            }
            if (konquest.getRuinManager().removeRuin(ruinName)) {
                ChatUtil.sendNotice(sender, MessagePath.COMMAND_ADMIN_RUIN_NOTICE_REMOVE.getMessage(ruinName));
            } else {
                ChatUtil.sendError(sender, MessagePath.COMMAND_ADMIN_RUIN_ERROR_REMOVE.getMessage(ruinName));
            }
        } else if (cmdMode.equalsIgnoreCase("rename")) {
            if (args.size() != 3) {
                this.sendInvalidArgMessage(sender);
                return;
            }
            String newRuinName = args.get(2);
            if (!konquest.getRuinManager().isRuin(ruinName)) {
                ChatUtil.sendError(sender, MessagePath.GENERIC_ERROR_UNKNOWN_NAME.getMessage(ruinName));
                return;
            }
            if (konquest.validateName(newRuinName, sender) != 0) {
                return;
            }
            if (konquest.getRuinManager().renameRuin(ruinName, newRuinName)) {
                ChatUtil.sendNotice(sender, MessagePath.COMMAND_ADMIN_RUIN_NOTICE_RENAME.getMessage(ruinName, newRuinName));
            } else {
                ChatUtil.sendError(sender, MessagePath.COMMAND_ADMIN_RUIN_ERROR_RENAME.getMessage(ruinName, newRuinName));
            }
        } else if (cmdMode.equalsIgnoreCase("loot")) {
            if (!konquest.getRuinManager().isRuin(ruinName)) {
                ChatUtil.sendError(sender, MessagePath.GENERIC_ERROR_UNKNOWN_NAME.getMessage(ruinName));
                return;
            }
            KonRuin ruin = konquest.getRuinManager().getRuin(ruinName);
            if (args.size() == 2) {
                String lootTableName = ruin.getLootTableName();
                ChatUtil.sendNotice(sender, MessagePath.GENERIC_NOTICE_LOOT_SHOW.getMessage(lootTableName));
            } else if (args.size() == 3) {
                String newTableName = args.get(2);
                if (!konquest.getLootManager().isRuinLootTable(newTableName)) {
                    ChatUtil.sendError(sender, MessagePath.GENERIC_ERROR_LOOT_UNKNOWN.getMessage(newTableName));
                    return;
                }
                ruin.setLootTableName(newTableName);
                ChatUtil.sendNotice(sender, MessagePath.GENERIC_NOTICE_LOOT_SET.getMessage(newTableName));
            } else {
                this.sendInvalidArgMessage(sender);
            }
        } else if (cmdMode.equalsIgnoreCase("reset")) {
            if (!konquest.getRuinManager().isRuin(ruinName)) {
                ChatUtil.sendError(sender, MessagePath.GENERIC_ERROR_UNKNOWN_NAME.getMessage(ruinName));
                return;
            }
            if (konquest.getRuinManager().resetRuin(ruinName)) {
                ChatUtil.sendNotice(sender, MessagePath.COMMAND_ADMIN_RUIN_NOTICE_RESET.getMessage(ruinName));
            } else {
                ChatUtil.sendError(sender, MessagePath.COMMAND_ADMIN_RUIN_ERROR_RESET.getMessage(ruinName));
            }
        } else if (cmdMode.equalsIgnoreCase("criticals")) {
            if (player.isSettingRegion()) {
                ChatUtil.sendError(sender, MessagePath.GENERIC_ERROR_REGION.getMessage(new Object[0]));
                return;
            }
            if (!konquest.getRuinManager().isRuin(ruinName)) {
                ChatUtil.sendError(sender, MessagePath.GENERIC_ERROR_UNKNOWN_NAME.getMessage(ruinName));
                return;
            }
            konquest.getRuinManager().getRuin(ruinName).clearCriticalLocations();
            player.settingRegion(KonPlayer.RegionType.RUIN_CRITICAL);
            ChatUtil.sendNotice(sender, MessagePath.COMMAND_ADMIN_RUIN_NOTICE_CRITICALS.getMessage(ruinName), ChatColor.LIGHT_PURPLE);
            ChatUtil.sendNotice(sender, MessagePath.GENERIC_NOTICE_CLICK_AIR.getMessage(new Object[0]));
        } else if (cmdMode.equalsIgnoreCase("spawns")) {
            if (player.isSettingRegion()) {
                ChatUtil.sendError(sender, MessagePath.GENERIC_ERROR_REGION.getMessage(new Object[0]));
                return;
            }
            if (!konquest.getRuinManager().isRuin(ruinName)) {
                ChatUtil.sendError(sender, MessagePath.GENERIC_ERROR_UNKNOWN_NAME.getMessage(ruinName));
                return;
            }
            konquest.getRuinManager().getRuin(ruinName).clearSpawnLocations();
            player.settingRegion(KonPlayer.RegionType.RUIN_SPAWN);
            ChatUtil.sendNotice(sender, MessagePath.COMMAND_ADMIN_RUIN_NOTICE_SPAWNS.getMessage(ruinName), ChatColor.LIGHT_PURPLE);
            ChatUtil.sendNotice(sender, MessagePath.GENERIC_NOTICE_CLICK_AIR.getMessage(new Object[0]));
        } else {
            this.sendInvalidArgMessage(sender);
        }
    }

    @Override
    public List<String> tabComplete(Konquest konquest, CommandSender sender, List<String> args) {
        ArrayList<String> tabList = new ArrayList<String>();
        if (args.size() == 1) {
            tabList.add("create");
            tabList.add("remove");
            tabList.add("rename");
            tabList.add("loot");
            tabList.add("reset");
            tabList.add("criticals");
            tabList.add("spawns");
        } else if (args.size() == 2) {
            switch (args.get(0).toLowerCase()) {
                case "create": {
                    tabList.add("***");
                    break;
                }
                case "remove": 
                case "rename": 
                case "loot": 
                case "reset": 
                case "criticals": 
                case "spawns": {
                    tabList.addAll(konquest.getRuinManager().getRuinNames());
                }
            }
        } else if (args.size() == 3) {
            if (args.get(0).equalsIgnoreCase("rename")) {
                tabList.add("***");
            } else if (args.get(0).equalsIgnoreCase("loot")) {
                tabList.addAll(konquest.getLootManager().getRuinLootTableKeys());
            }
        }
        return this.matchLastArgToList(tabList, args);
    }
}

