/*
 * Decompiled with CFR 0.152.
 */
package com.github.rumsfield.konquest.command.admin;

import com.github.rumsfield.konquest.Konquest;
import com.github.rumsfield.konquest.command.CommandBase;
import com.github.rumsfield.konquest.model.KonPlayer;
import com.github.rumsfield.konquest.utility.ChatUtil;
import com.github.rumsfield.konquest.utility.MessagePath;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;

public class SanctuaryAdminCommand
extends CommandBase {
    public SanctuaryAdminCommand() {
        super("sanctuary", true, true);
        this.addArgument(this.newArg("create", true, false).sub(this.newArg("name", false, false)));
        this.addArgument(this.newArg("rename", true, false).sub(this.newArg("sanctuary", false, false).sub(this.newArg("name", false, false))));
        this.addArgument(this.newArg("remove", true, false).sub(this.newArg("sanctuary", false, false)));
    }

    @Override
    public void execute(Konquest konquest, CommandSender sender, List<String> args) {
        KonPlayer player = konquest.getPlayerManager().getPlayer(sender);
        if (player == null) {
            this.sendInvalidSenderMessage(sender);
            return;
        }
        if (args.size() != 2 && args.size() != 3) {
            this.sendInvalidArgMessage(sender);
            return;
        }
        String cmdMode = args.get(0);
        String sanctuaryName = args.get(1);
        Location playerLoc = player.getBukkitPlayer().getLocation();
        if (konquest.isWorldIgnored(playerLoc.getWorld())) {
            ChatUtil.sendError(sender, MessagePath.GENERIC_ERROR_INVALID_WORLD.getMessage(new Object[0]));
            return;
        }
        if (cmdMode.equalsIgnoreCase("create")) {
            if (konquest.validateName(sanctuaryName, sender) != 0) {
                return;
            }
            if (konquest.getSanctuaryManager().addSanctuary(playerLoc, sanctuaryName)) {
                ChatUtil.sendNotice(sender, MessagePath.COMMAND_ADMIN_SANCTUARY_NOTICE_CREATE.getMessage(sanctuaryName));
            } else {
                ChatUtil.sendError(sender, MessagePath.COMMAND_ADMIN_SANCTUARY_ERROR_CREATE.getMessage(sanctuaryName));
            }
        } else if (cmdMode.equalsIgnoreCase("remove")) {
            if (!konquest.getSanctuaryManager().isSanctuary(sanctuaryName)) {
                ChatUtil.sendError(sender, MessagePath.GENERIC_ERROR_UNKNOWN_NAME.getMessage(sanctuaryName));
                return;
            }
            if (konquest.getSanctuaryManager().removeSanctuary(sanctuaryName)) {
                ChatUtil.sendNotice(sender, MessagePath.COMMAND_ADMIN_SANCTUARY_NOTICE_REMOVE.getMessage(sanctuaryName));
            } else {
                ChatUtil.sendError(sender, MessagePath.COMMAND_ADMIN_SANCTUARY_ERROR_REMOVE.getMessage(sanctuaryName));
            }
        } else if (cmdMode.equalsIgnoreCase("rename")) {
            if (args.size() != 3) {
                this.sendInvalidArgMessage(sender);
                return;
            }
            String newSanctuaryName = args.get(2);
            if (!konquest.getSanctuaryManager().isSanctuary(sanctuaryName)) {
                ChatUtil.sendError(sender, MessagePath.GENERIC_ERROR_UNKNOWN_NAME.getMessage(sanctuaryName));
                return;
            }
            if (konquest.validateName(newSanctuaryName, sender) != 0) {
                return;
            }
            if (konquest.getSanctuaryManager().renameSanctuary(sanctuaryName, newSanctuaryName)) {
                ChatUtil.sendNotice(sender, MessagePath.COMMAND_ADMIN_SANCTUARY_NOTICE_RENAME.getMessage(sanctuaryName, newSanctuaryName));
            } else {
                ChatUtil.sendError(sender, MessagePath.COMMAND_ADMIN_SANCTUARY_ERROR_RENAME.getMessage(sanctuaryName, newSanctuaryName));
            }
        } else {
            this.sendInvalidArgMessage(sender);
        }
    }

    @Override
    public List<String> tabComplete(Konquest konquest, CommandSender sender, List<String> args) {
        ArrayList<String> tabList = new ArrayList<String>();
        if (args.size() == 1) {
            tabList.add("create");
            tabList.add("remove");
            tabList.add("rename");
        } else if (args.size() == 2) {
            switch (args.get(0).toLowerCase()) {
                case "create": {
                    tabList.add("***");
                    break;
                }
                case "remove": 
                case "rename": {
                    tabList.addAll(konquest.getSanctuaryManager().getSanctuaryNames());
                }
            }
        } else if (args.size() == 3 && args.get(0).equalsIgnoreCase("rename")) {
            tabList.add("***");
        }
        return this.matchLastArgToList(tabList, args);
    }
}

