/*
 * Decompiled with CFR 0.152.
 */
package com.github.rumsfield.konquest.command.admin;

import com.github.rumsfield.konquest.Konquest;
import com.github.rumsfield.konquest.command.CommandBase;
import com.github.rumsfield.konquest.model.KonPlayer;
import com.github.rumsfield.konquest.model.KonTerritory;
import com.github.rumsfield.konquest.utility.ChatUtil;
import com.github.rumsfield.konquest.utility.MessagePath;
import java.util.Collections;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;

public class SetTravelAdminCommand
extends CommandBase {
    public SetTravelAdminCommand() {
        super("settravel", true, true);
    }

    @Override
    public void execute(Konquest konquest, CommandSender sender, List<String> args) {
        KonPlayer player = konquest.getPlayerManager().getPlayer(sender);
        if (player == null) {
            this.sendInvalidSenderMessage(sender);
            return;
        }
        if (!args.isEmpty()) {
            this.sendInvalidArgMessage(sender);
            return;
        }
        Location playerLoc = player.getBukkitPlayer().getLocation();
        if (!konquest.isWorldValid(playerLoc.getWorld())) {
            ChatUtil.sendError(sender, MessagePath.GENERIC_ERROR_INVALID_WORLD.getMessage(new Object[0]));
            return;
        }
        if (konquest.getTerritoryManager().isChunkClaimed(playerLoc)) {
            KonTerritory territory = konquest.getTerritoryManager().getChunkTerritory(playerLoc);
            if (territory == null) {
                ChatUtil.sendError(sender, MessagePath.GENERIC_ERROR_INTERNAL.getMessage(new Object[0]));
                return;
            }
            territory.setSpawn(playerLoc);
            ChatUtil.sendNotice(sender, MessagePath.COMMAND_ADMIN_SETTRAVEL_NOTICE_SUCCESS.getMessage(territory.getName()));
        } else {
            ChatUtil.sendError(sender, MessagePath.COMMAND_ADMIN_SETTRAVEL_ERROR_FAIL.getMessage(new Object[0]));
        }
    }

    @Override
    public List<String> tabComplete(Konquest konquest, CommandSender sender, List<String> args) {
        return Collections.emptyList();
    }
}

