/*
 * Decompiled with CFR 0.152.
 */
package com.github.rumsfield.konquest.command.admin;

import com.github.rumsfield.konquest.Konquest;
import com.github.rumsfield.konquest.command.CommandBase;
import com.github.rumsfield.konquest.model.KonOfflinePlayer;
import com.github.rumsfield.konquest.model.KonPlayer;
import com.github.rumsfield.konquest.model.KonStats;
import com.github.rumsfield.konquest.model.KonStatsType;
import com.github.rumsfield.konquest.utility.ChatUtil;
import com.github.rumsfield.konquest.utility.MessagePath;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bukkit.command.CommandSender;

public class StatAdminCommand
extends CommandBase {
    public StatAdminCommand() {
        super("stat", false, true);
        List<String> argNames = Arrays.asList("show", "set", "add", "clear");
        this.addArgument(this.newArg(argNames, true, false).sub(this.newArg("player", false, false).sub(this.newArg("name", false, true).sub(this.newArg("value", false, false)))));
    }

    @Override
    public void execute(Konquest konquest, CommandSender sender, List<String> args) {
        KonStats stats;
        if (args.size() < 3) {
            this.sendInvalidArgMessage(sender);
            return;
        }
        String subCmd = args.get(0);
        String playerName = args.get(1);
        String statName = args.get(2);
        KonOfflinePlayer offlinePlayer = konquest.getPlayerManager().getOfflinePlayerFromName(playerName);
        if (offlinePlayer == null) {
            ChatUtil.sendError(sender, MessagePath.GENERIC_ERROR_UNKNOWN_NAME.getMessage(playerName));
            return;
        }
        String bukkitPlayerName = offlinePlayer.getOfflineBukkitPlayer().getName();
        KonPlayer player = konquest.getPlayerManager().getPlayerFromName(playerName);
        boolean isPlayerOnline = false;
        if (player == null) {
            stats = konquest.getDatabaseThread().getDatabase().pullPlayerStats(offlinePlayer.getOfflineBukkitPlayer());
        } else {
            stats = player.getPlayerStats();
            isPlayerOnline = true;
        }
        KonStatsType stat = KonStatsType.getStat(statName);
        if (stat == null) {
            ChatUtil.sendError(sender, MessagePath.COMMAND_ADMIN_STAT_ERROR_NAME.getMessage(statName));
            return;
        }
        String value = "";
        switch (subCmd.toLowerCase()) {
            case "show": {
                int currentValue = stats.getStat(stat);
                ChatUtil.sendNotice(sender, MessagePath.COMMAND_ADMIN_STAT_NOTICE_SHOW.getMessage(stat.toString(), bukkitPlayerName, currentValue));
                if (isPlayerOnline) break;
                stats = null;
                break;
            }
            case "set": {
                int valueNum;
                if (args.size() == 4) {
                    value = args.get(3);
                }
                try {
                    valueNum = Integer.parseInt(value);
                }
                catch (NumberFormatException e) {
                    ChatUtil.sendError(sender, MessagePath.COMMAND_ADMIN_STAT_ERROR_VALUE.getMessage(e.getMessage()));
                    return;
                }
                stats.setStat(stat, valueNum);
                ChatUtil.sendNotice(sender, MessagePath.COMMAND_ADMIN_STAT_NOTICE_SET.getMessage(stat.toString(), bukkitPlayerName, valueNum));
                if (!isPlayerOnline) {
                    konquest.getDatabaseThread().getDatabase().pushPlayerStats(offlinePlayer.getOfflineBukkitPlayer(), stats);
                    stats = null;
                    break;
                }
                konquest.getAccomplishmentManager().initPlayerPrefixes(player);
                break;
            }
            case "add": {
                int valueNum;
                if (args.size() == 4) {
                    value = args.get(3);
                }
                try {
                    valueNum = Integer.parseInt(value);
                }
                catch (NumberFormatException e) {
                    ChatUtil.sendError(sender, MessagePath.COMMAND_ADMIN_STAT_ERROR_VALUE.getMessage(e.getMessage()));
                    return;
                }
                int currentValue = stats.getStat(stat);
                int newValue = currentValue + valueNum;
                stats.setStat(stat, newValue);
                ChatUtil.sendNotice(sender, MessagePath.COMMAND_ADMIN_STAT_NOTICE_ADD.getMessage(valueNum, stat.toString(), bukkitPlayerName, newValue));
                if (!isPlayerOnline) {
                    konquest.getDatabaseThread().getDatabase().pushPlayerStats(offlinePlayer.getOfflineBukkitPlayer(), stats);
                    stats = null;
                    break;
                }
                konquest.getAccomplishmentManager().initPlayerPrefixes(player);
                break;
            }
            case "clear": {
                stats.setStat(stat, 0);
                ChatUtil.sendNotice(sender, MessagePath.COMMAND_ADMIN_STAT_NOTICE_CLEAR.getMessage(stat.toString(), bukkitPlayerName));
                if (!isPlayerOnline) {
                    konquest.getDatabaseThread().getDatabase().pushPlayerStats(offlinePlayer.getOfflineBukkitPlayer(), stats);
                    stats = null;
                    break;
                }
                konquest.getAccomplishmentManager().initPlayerPrefixes(player);
                break;
            }
            default: {
                this.sendInvalidArgMessage(sender);
            }
        }
    }

    @Override
    public List<String> tabComplete(Konquest konquest, CommandSender sender, List<String> args) {
        ArrayList<String> tabList = new ArrayList<String>();
        if (args.size() == 1) {
            tabList.add("show");
            tabList.add("set");
            tabList.add("add");
            tabList.add("clear");
        } else if (args.size() == 2) {
            for (KonOfflinePlayer offlinePlayer : konquest.getPlayerManager().getAllKonquestOfflinePlayers()) {
                tabList.add(offlinePlayer.getOfflineBukkitPlayer().getName());
            }
        } else if (args.size() == 3) {
            for (KonStatsType stat : KonStatsType.values()) {
                tabList.add(stat.toString());
            }
        } else if (args.size() == 4 && (args.get(0).equalsIgnoreCase("set") || args.get(0).equalsIgnoreCase("add"))) {
            tabList.add("#");
        }
        return this.matchLastArgToList(tabList, args);
    }
}

