/*
 * Decompiled with CFR 0.152.
 */
package com.github.rumsfield.konquest.command.admin;

import com.github.rumsfield.konquest.Konquest;
import com.github.rumsfield.konquest.api.model.KonquestTerritoryType;
import com.github.rumsfield.konquest.api.model.KonquestUpgrade;
import com.github.rumsfield.konquest.command.CommandBase;
import com.github.rumsfield.konquest.manager.DisplayManager;
import com.github.rumsfield.konquest.model.KonOfflinePlayer;
import com.github.rumsfield.konquest.model.KonPlayer;
import com.github.rumsfield.konquest.model.KonTown;
import com.github.rumsfield.konquest.model.KonTownOption;
import com.github.rumsfield.konquest.model.KonUpgrade;
import com.github.rumsfield.konquest.utility.ChatUtil;
import com.github.rumsfield.konquest.utility.CompatibilityUtil;
import com.github.rumsfield.konquest.utility.CorePath;
import com.github.rumsfield.konquest.utility.HelperUtil;
import com.github.rumsfield.konquest.utility.MessagePath;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Villager;

public class TownAdminCommand
extends CommandBase {
    public TownAdminCommand() {
        super("town", false, true);
        this.addArgument(this.newArg("menu", true, false).sub(this.newArg("town", false, false)));
        this.addArgument(this.newArg("create", true, false).sub(this.newArg("name", false, false).sub(this.newArg("kingdom", false, false))));
        this.addArgument(this.newArg("remove", true, false).sub(this.newArg("town", false, false).sub(this.newArg("kingdom", false, false))));
        this.addArgument(this.newArg("rename", true, false).sub(this.newArg("town", false, false).sub(this.newArg("name", false, false))));
        this.addArgument(this.newArg("plots", true, false).sub(this.newArg("town", false, false)));
        this.addArgument(this.newArg("specialize", true, false).sub(this.newArg("town", false, true).sub(this.newArg("name", false, false))));
        this.addArgument(this.newArg("upgrade", true, false).sub(this.newArg("town", false, true).sub(this.newArg("name", false, false).sub(this.newArg("level", false, false)))));
        List<String> optionsArgNames = Arrays.asList("true", "false");
        this.addArgument(this.newArg("upgrade", true, false).sub(this.newArg("town", false, true).sub(this.newArg("name", false, true).sub(this.newArg(optionsArgNames, true, false)))));
        List<String> shieldArmorArgNames = Arrays.asList("clear", "set", "add");
        this.addArgument(this.newArg("shield", true, false).sub(this.newArg("town", false, true).sub(this.newArg(shieldArmorArgNames, true, false).sub(this.newArg("amount", false, false)))));
        this.addArgument(this.newArg("armor", true, false).sub(this.newArg("town", false, true).sub(this.newArg(shieldArmorArgNames, true, false).sub(this.newArg("amount", false, false)))));
        List<String> residentArgNames = Arrays.asList("add", "kick", "promote", "demote", "lord");
        this.addArgument(this.newArg("resident", true, false).sub(this.newArg("town", false, false).sub(this.newArg(residentArgNames, true, false).sub(this.newArg("player", false, false)))));
    }

    private String formatOptionLine(KonTownOption option, KonTown town) {
        boolean val = town.getTownOption(option);
        String optionLabel = option.toString();
        String optionValue = DisplayManager.boolean2Lang(val) + " " + DisplayManager.boolean2Symbol(val);
        String optionDescription = option.getDescription();
        return String.valueOf(ChatColor.GOLD) + optionLabel + " - " + String.valueOf(ChatColor.RESET) + optionValue + " " + String.valueOf(ChatColor.LIGHT_PURPLE) + optionDescription;
    }

    @Override
    public void execute(Konquest konquest, CommandSender sender, List<String> args) {
        boolean isSenderPlayer;
        KonPlayer player = konquest.getPlayerManager().getPlayer(sender);
        boolean bl = isSenderPlayer = player != null;
        if (args.size() < 2) {
            this.sendInvalidArgMessage(sender);
            return;
        }
        String subCmd = args.get(0);
        String townName = args.get(1);
        KonTown town = null;
        if (!subCmd.equalsIgnoreCase("create") && (town = konquest.getKingdomManager().getTownCapital(townName)) == null) {
            ChatUtil.sendError(sender, MessagePath.GENERIC_ERROR_UNKNOWN_NAME.getMessage(townName));
            return;
        }
        block16 : switch (subCmd.toLowerCase()) {
            case "menu": {
                assert (town != null);
                if (!isSenderPlayer) {
                    ChatUtil.sendError(sender, MessagePath.GENERIC_ERROR_NO_PLAYER.getMessage(new Object[0]));
                    return;
                }
                konquest.getDisplayManager().displayTownManagementMenu(player, town, true);
                break;
            }
            case "create": {
                if (!isSenderPlayer) {
                    ChatUtil.sendError(sender, MessagePath.GENERIC_ERROR_NO_PLAYER.getMessage(new Object[0]));
                    return;
                }
                if (args.size() != 3) {
                    this.sendInvalidArgMessage(sender);
                    return;
                }
                String createKingdomName = args.get(2);
                if (konquest.validateName(townName, sender) != 0) {
                    return;
                }
                if (!konquest.getKingdomManager().isKingdom(createKingdomName)) {
                    ChatUtil.sendError(sender, MessagePath.GENERIC_ERROR_UNKNOWN_NAME.getMessage(createKingdomName));
                    return;
                }
                Location settleLoc = player.getBukkitPlayer().getLocation();
                if (!konquest.isWorldValid(settleLoc.getWorld())) {
                    ChatUtil.sendError(sender, MessagePath.GENERIC_ERROR_INVALID_WORLD.getMessage(new Object[0]));
                    return;
                }
                int exitCode = konquest.getKingdomManager().createTown(settleLoc, townName, createKingdomName);
                if (exitCode == 0) {
                    KonTown createdTown = konquest.getKingdomManager().getTown(townName);
                    if (createdTown != null) {
                        player.getBukkitPlayer().teleport(konquest.getKingdomManager().getKingdom(createKingdomName).getTown(townName).getSpawnLoc());
                        konquest.getMapHandler().drawLabelTerritory(createdTown);
                        konquest.getMapHandler().drawLabelTerritory(createdTown.getKingdom().getCapital());
                        ChatUtil.sendNotice(sender, MessagePath.COMMAND_SETTLE_NOTICE_SUCCESS.getMessage(townName));
                        break;
                    }
                    ChatUtil.sendError(sender, MessagePath.GENERIC_ERROR_INTERNAL.getMessage(new Object[0]));
                    return;
                }
                switch (exitCode) {
                    case 1: {
                        ChatUtil.sendError(sender, MessagePath.COMMAND_SETTLE_ERROR_FAIL_OVERLAP.getMessage(new Object[0]));
                        break block16;
                    }
                    case 2: {
                        ChatUtil.sendError(sender, MessagePath.COMMAND_SETTLE_ERROR_FAIL_PLACEMENT.getMessage(new Object[0]));
                        break block16;
                    }
                    case 3: {
                        ChatUtil.sendError(sender, MessagePath.COMMAND_SETTLE_ERROR_FAIL_NAME.getMessage(new Object[0]));
                        break block16;
                    }
                    case 4: {
                        ChatUtil.sendError(sender, MessagePath.COMMAND_SETTLE_ERROR_FAIL_TEMPLATE.getMessage(new Object[0]));
                        break block16;
                    }
                    case 5: {
                        ChatUtil.sendError(sender, MessagePath.GENERIC_ERROR_INVALID_WORLD.getMessage(new Object[0]));
                        break block16;
                    }
                    case 6: {
                        int distance = konquest.getTerritoryManager().getDistanceToClosestTerritory(settleLoc);
                        int min_distance_sanc = konquest.getCore().getInt(CorePath.TOWNS_MIN_DISTANCE_SANCTUARY.getPath());
                        int min_distance_town = konquest.getCore().getInt(CorePath.TOWNS_MIN_DISTANCE_TOWN.getPath());
                        int min_distance = Math.min(min_distance_sanc, min_distance_town);
                        ChatUtil.sendError(sender, MessagePath.COMMAND_SETTLE_ERROR_FAIL_PROXIMITY.getMessage(distance, min_distance));
                        break block16;
                    }
                    case 7: {
                        int distance = konquest.getTerritoryManager().getDistanceToClosestTerritory(settleLoc);
                        int max_distance_all = konquest.getCore().getInt(CorePath.TOWNS_MAX_DISTANCE_ALL.getPath());
                        ChatUtil.sendError(sender, MessagePath.COMMAND_SETTLE_ERROR_FAIL_MAX.getMessage(distance, max_distance_all));
                        break block16;
                    }
                    case 21: {
                        ChatUtil.sendError(sender, MessagePath.GENERIC_ERROR_INTERNAL.getMessage(new Object[0]));
                        break block16;
                    }
                    case 22: {
                        ChatUtil.sendError(sender, MessagePath.COMMAND_SETTLE_ERROR_FAIL_FLAT.getMessage(new Object[0]));
                        break block16;
                    }
                    case 23: {
                        ChatUtil.sendError(sender, MessagePath.COMMAND_SETTLE_ERROR_FAIL_HEIGHT.getMessage(new Object[0]));
                        break block16;
                    }
                    case 12: {
                        ChatUtil.sendError(sender, MessagePath.COMMAND_SETTLE_ERROR_FAIL_HEIGHT.getMessage(new Object[0]));
                        break block16;
                    }
                    case 13: {
                        ChatUtil.sendError(sender, MessagePath.COMMAND_SETTLE_ERROR_FAIL_INIT.getMessage(new Object[0]));
                        break block16;
                    }
                    case 14: {
                        ChatUtil.sendError(sender, MessagePath.COMMAND_SETTLE_ERROR_FAIL_AIR.getMessage(new Object[0]));
                        break block16;
                    }
                    case 15: {
                        ChatUtil.sendError(sender, MessagePath.COMMAND_SETTLE_ERROR_FAIL_WATER.getMessage(new Object[0]));
                        break block16;
                    }
                    case 16: {
                        ChatUtil.sendError(sender, MessagePath.COMMAND_SETTLE_ERROR_FAIL_CONTAINER.getMessage(new Object[0]));
                        break block16;
                    }
                }
                ChatUtil.sendError(sender, MessagePath.GENERIC_ERROR_INTERNAL.getMessage(new Object[0]));
                return;
            }
            case "remove": {
                assert (town != null);
                if (args.size() != 3) {
                    this.sendInvalidArgMessage(sender);
                    return;
                }
                String removeKingdomName = args.get(2);
                if (!konquest.getKingdomManager().isKingdom(removeKingdomName)) {
                    ChatUtil.sendError(sender, MessagePath.GENERIC_ERROR_UNKNOWN_NAME.getMessage(removeKingdomName));
                    return;
                }
                if (town.getTerritoryType().equals((Object)KonquestTerritoryType.CAPITAL)) {
                    ChatUtil.sendError(sender, MessagePath.GENERIC_ERROR_BAD_NAME.getMessage(townName));
                    return;
                }
                if (konquest.getKingdomManager().removeTown(townName, removeKingdomName)) {
                    ChatUtil.sendNotice(sender, MessagePath.GENERIC_NOTICE_SUCCESS.getMessage(new Object[0]));
                    break;
                }
                ChatUtil.sendError(sender, MessagePath.GENERIC_ERROR_UNKNOWN_NAME.getMessage(townName));
                return;
            }
            case "rename": {
                assert (town != null);
                if (args.size() != 3) {
                    this.sendInvalidArgMessage(sender);
                    return;
                }
                String newTownName = args.get(2);
                if (town.getKingdom().renameTown(townName, newTownName)) {
                    ChatUtil.sendNotice(sender, MessagePath.GENERIC_NOTICE_SUCCESS.getMessage(new Object[0]));
                    break;
                }
                ChatUtil.sendError(sender, MessagePath.GENERIC_ERROR_FAILED.getMessage(new Object[0]));
                break;
            }
            case "specialize": {
                assert (town != null);
                if (!konquest.getKingdomManager().getIsDiscountEnable()) {
                    ChatUtil.sendError(sender, MessagePath.GENERIC_ERROR_DISABLED.getMessage(new Object[0]));
                    return;
                }
                if (args.size() == 2) {
                    String specialName = town.getSpecializationName();
                    ChatUtil.sendNotice(sender, MessagePath.COMMAND_TOWN_NOTICE_SPECIALIZE_LIST.getMessage(town.getName(), specialName));
                    break;
                }
                if (args.size() == 3) {
                    String professionName = args.get(2);
                    Villager.Profession profession = CompatibilityUtil.getProfessionFromName(professionName);
                    if (profession == null) {
                        ChatUtil.sendError(sender, MessagePath.GENERIC_ERROR_UNKNOWN_NAME.getMessage(professionName));
                        return;
                    }
                    konquest.getKingdomManager().menuChangeTownSpecialization(town, profession, null, sender, true);
                    break;
                }
                this.sendInvalidArgMessage(sender);
                return;
            }
            case "upgrade": {
                assert (town != null);
                if (!konquest.getUpgradeManager().isEnabled()) {
                    ChatUtil.sendError(sender, MessagePath.GENERIC_ERROR_DISABLED.getMessage(new Object[0]));
                    return;
                }
                HashMap<KonquestUpgrade, Integer> availableUpgrades = konquest.getUpgradeManager().getAvailableUpgrades(town);
                if (args.size() == 2) {
                    ArrayList<KonUpgrade> allUpgrades = new ArrayList<KonUpgrade>();
                    for (KonUpgrade upgrade : KonUpgrade.values()) {
                        if (!availableUpgrades.containsKey(upgrade)) continue;
                        allUpgrades.add(upgrade);
                    }
                    ChatUtil.sendNotice(sender, MessagePath.MENU_UPGRADE_TITLE.getMessage(new Object[0]));
                    for (KonUpgrade upgrade : allUpgrades) {
                        int upgradeLevel = availableUpgrades.get(upgrade);
                        String upgradeInfo = String.valueOf(ChatColor.GOLD) + upgrade.toString() + " - " + String.valueOf(ChatColor.RESET) + upgrade.getName() + " " + upgradeLevel + " " + String.valueOf(ChatColor.LIGHT_PURPLE) + upgrade.getLevelDescription(upgradeLevel);
                        ChatUtil.sendMessage(sender, upgradeInfo);
                    }
                    break;
                }
                if (args.size() == 4) {
                    int upgradeLevel;
                    String upgradeName = args.get(2);
                    String upgradeLevelStr = args.get(3);
                    KonUpgrade upgrade = KonUpgrade.getUpgrade(upgradeName);
                    if (upgrade == null) {
                        ChatUtil.sendError(sender, MessagePath.GENERIC_ERROR_UNKNOWN_NAME.getMessage(upgradeName));
                        return;
                    }
                    try {
                        upgradeLevel = Integer.parseInt(upgradeLevelStr);
                    }
                    catch (NumberFormatException e) {
                        ChatUtil.printDebug("Failed to parse string as int: " + e.getMessage());
                        this.sendInvalidArgMessage(sender);
                        return;
                    }
                    if (upgradeLevel < 0 || upgradeLevel > upgrade.getMaxLevel()) {
                        ChatUtil.sendError(sender, MessagePath.COMMAND_TOWN_ERROR_UPGRADE_LEVEL.getMessage(0, upgrade.getMaxLevel()));
                        return;
                    }
                    if (!konquest.getUpgradeManager().applyTownUpgrade(town, upgrade, upgradeLevel)) break;
                    ChatUtil.sendNotice(sender, MessagePath.MENU_UPGRADE_ADD.getMessage(upgrade.getName(), upgradeLevel, town.getName()));
                    break;
                }
                this.sendInvalidArgMessage(sender);
                break;
            }
            case "option": {
                assert (town != null);
                if (args.size() == 2) {
                    for (KonTownOption option : KonTownOption.values()) {
                        if (!konquest.getKingdomManager().isTownOptionFeatureEnabled(option)) continue;
                        String optionInfo = this.formatOptionLine(option, town);
                        ChatUtil.sendMessage(sender, optionInfo);
                    }
                    break;
                }
                if (args.size() >= 3) {
                    String optionName = args.get(2);
                    KonTownOption option = KonTownOption.getOption(optionName);
                    if (option == null) {
                        ChatUtil.sendError(sender, MessagePath.GENERIC_ERROR_UNKNOWN_NAME.getMessage(optionName));
                        return;
                    }
                    if (!konquest.getKingdomManager().isTownOptionFeatureEnabled(option)) {
                        ChatUtil.sendError(sender, MessagePath.GENERIC_ERROR_DISABLED.getMessage(new Object[0]));
                        return;
                    }
                    if (args.size() == 3) {
                        String optionInfo = this.formatOptionLine(option, town);
                        ChatUtil.sendMessage(sender, optionInfo);
                        break;
                    }
                    if (args.size() == 4) {
                        String newValStr = args.get(3);
                        if (newValStr.equalsIgnoreCase("true")) {
                            konquest.getKingdomManager().setTownOption(option, town, sender, true);
                            break;
                        }
                        if (newValStr.equalsIgnoreCase("false")) {
                            konquest.getKingdomManager().setTownOption(option, town, sender, false);
                            break;
                        }
                        ChatUtil.sendError(sender, MessagePath.GENERIC_ERROR_UNKNOWN_NAME.getMessage(newValStr));
                        return;
                    }
                    this.sendInvalidArgMessage(sender);
                    break;
                }
                this.sendInvalidArgMessage(sender);
                break;
            }
            case "shield": {
                assert (town != null);
                if (!konquest.getShieldManager().isShieldsEnabled()) {
                    ChatUtil.sendError(sender, MessagePath.GENERIC_ERROR_DISABLED.getMessage(new Object[0]));
                    return;
                }
                if (args.size() == 2) {
                    String shieldTime = HelperUtil.getTimeFormat(town.getRemainingShieldTimeSeconds(), "");
                    ChatUtil.sendNotice(sender, MessagePath.COMMAND_TOWN_NOTICE_SHIELD_LIST.getMessage(shieldTime, town.getName()));
                    break;
                }
                if (args.size() == 3) {
                    if (args.get(2).equalsIgnoreCase("clear")) {
                        town.deactivateShield();
                        ChatUtil.sendNotice(sender, MessagePath.GENERIC_NOTICE_SUCCESS.getMessage(new Object[0]));
                        break;
                    }
                    this.sendInvalidArgMessage(sender);
                    break;
                }
                if (args.size() == 4) {
                    int shieldVal;
                    String shieldValStr = args.get(3);
                    try {
                        shieldVal = Integer.parseInt(shieldValStr);
                    }
                    catch (NumberFormatException e) {
                        ChatUtil.printDebug("Failed to parse string as int: " + e.getMessage());
                        this.sendInvalidArgMessage(sender);
                        return;
                    }
                    if (args.get(2).equalsIgnoreCase("set")) {
                        if (konquest.getShieldManager().shieldSet(town, shieldVal)) {
                            ChatUtil.sendNotice(sender, MessagePath.GENERIC_NOTICE_SUCCESS.getMessage(new Object[0]));
                            break;
                        }
                        this.sendInvalidArgMessage(sender);
                        break;
                    }
                    if (args.get(2).equalsIgnoreCase("add")) {
                        if (konquest.getShieldManager().shieldAdd(town, shieldVal)) {
                            ChatUtil.sendNotice(sender, MessagePath.GENERIC_NOTICE_SUCCESS.getMessage(new Object[0]));
                            break;
                        }
                        this.sendInvalidArgMessage(sender);
                        break;
                    }
                    this.sendInvalidArgMessage(sender);
                    break;
                }
                this.sendInvalidArgMessage(sender);
                break;
            }
            case "armor": {
                assert (town != null);
                if (!konquest.getShieldManager().isArmorsEnabled()) {
                    ChatUtil.sendError(sender, MessagePath.GENERIC_ERROR_DISABLED.getMessage(new Object[0]));
                    return;
                }
                if (args.size() == 2) {
                    String armorBlocks = "" + town.getArmorBlocks();
                    ChatUtil.sendNotice(sender, MessagePath.COMMAND_TOWN_NOTICE_ARMOR_LIST.getMessage(armorBlocks, town.getName()));
                    break;
                }
                if (args.size() == 3) {
                    if (args.get(2).equalsIgnoreCase("clear")) {
                        town.deactivateArmor();
                        ChatUtil.sendNotice(sender, MessagePath.GENERIC_NOTICE_SUCCESS.getMessage(new Object[0]));
                        break;
                    }
                    this.sendInvalidArgMessage(sender);
                    break;
                }
                if (args.size() == 4) {
                    int armorVal;
                    String armorValStr = args.get(3);
                    try {
                        armorVal = Integer.parseInt(armorValStr);
                    }
                    catch (NumberFormatException e) {
                        ChatUtil.printDebug("Failed to parse string as int: " + e.getMessage());
                        this.sendInvalidArgMessage(sender);
                        return;
                    }
                    if (args.get(2).equalsIgnoreCase("set")) {
                        if (konquest.getShieldManager().armorSet(town, armorVal)) {
                            ChatUtil.sendNotice(sender, MessagePath.GENERIC_NOTICE_SUCCESS.getMessage(new Object[0]));
                            break;
                        }
                        ChatUtil.sendError(sender, MessagePath.GENERIC_ERROR_FAILED.getMessage(new Object[0]));
                        break;
                    }
                    if (args.get(2).equalsIgnoreCase("add")) {
                        if (konquest.getShieldManager().armorAdd(town, armorVal)) {
                            ChatUtil.sendNotice(sender, MessagePath.GENERIC_NOTICE_SUCCESS.getMessage(new Object[0]));
                            break;
                        }
                        ChatUtil.sendError(sender, MessagePath.GENERIC_ERROR_FAILED.getMessage(new Object[0]));
                        break;
                    }
                    this.sendInvalidArgMessage(sender);
                    break;
                }
                this.sendInvalidArgMessage(sender);
                break;
            }
            case "resident": {
                if (args.size() != 4) {
                    this.sendInvalidArgMessage(sender);
                }
                assert (town != null);
                String residentSubCmd = args.get(2);
                String residentPlayerName = args.get(3);
                KonOfflinePlayer residentPlayer = konquest.getPlayerManager().getOfflinePlayerFromName(residentPlayerName);
                if (residentPlayer == null) {
                    ChatUtil.sendError(sender, MessagePath.GENERIC_ERROR_UNKNOWN_NAME.getMessage(residentPlayerName));
                    return;
                }
                UUID residentID = residentPlayer.getOfflineBukkitPlayer().getUniqueId();
                String playerName = residentPlayer.getOfflineBukkitPlayer().getName();
                switch (residentSubCmd.toLowerCase()) {
                    case "add": {
                        if (!residentPlayer.getKingdom().equals(town.getKingdom())) {
                            ChatUtil.sendError(sender, MessagePath.GENERIC_ERROR_ENEMY_PLAYER.getMessage(new Object[0]));
                            return;
                        }
                        if (town.addPlayerResident(residentPlayer.getOfflineBukkitPlayer(), false)) {
                            town.removeJoinRequest(residentID);
                            ChatUtil.sendNotice(sender, MessagePath.COMMAND_TOWN_NOTICE_ADD_RESIDENT.getMessage(playerName, townName));
                            break;
                        }
                        ChatUtil.sendError(sender, MessagePath.COMMAND_TOWN_ERROR_INVITE_MEMBER.getMessage(playerName));
                        break;
                    }
                    case "kick": {
                        if (town.removePlayerResident(residentPlayer.getOfflineBukkitPlayer())) {
                            town.removeJoinRequest(residentID);
                            ChatUtil.sendNotice(sender, MessagePath.COMMAND_TOWN_NOTICE_KICK_RESIDENT.getMessage(playerName, townName));
                            break;
                        }
                        ChatUtil.sendError(sender, MessagePath.COMMAND_TOWN_ERROR_KICK_FAIL.getMessage(playerName, townName));
                        break;
                    }
                    case "promote": {
                        if (!town.isPlayerResident(residentPlayer.getOfflineBukkitPlayer())) {
                            ChatUtil.sendError(sender, MessagePath.COMMAND_TOWN_ERROR_KNIGHT_RESIDENT.getMessage(new Object[0]));
                            return;
                        }
                        if (town.isPlayerLord(residentPlayer.getOfflineBukkitPlayer())) {
                            ChatUtil.sendError(sender, MessagePath.GENERIC_ERROR_NO_ALLOW.getMessage(new Object[0]));
                            return;
                        }
                        if (town.setPlayerKnight(residentPlayer.getOfflineBukkitPlayer(), true)) {
                            ChatUtil.sendNotice(sender, MessagePath.COMMAND_TOWN_NOTICE_KNIGHT_SET.getMessage(playerName, townName));
                            break;
                        }
                        ChatUtil.sendError(sender, MessagePath.GENERIC_ERROR_INTERNAL.getMessage(new Object[0]));
                        break;
                    }
                    case "demote": {
                        if (!town.isPlayerResident(residentPlayer.getOfflineBukkitPlayer())) {
                            ChatUtil.sendError(sender, MessagePath.COMMAND_TOWN_ERROR_KNIGHT_RESIDENT.getMessage(new Object[0]));
                            return;
                        }
                        if (town.isPlayerLord(residentPlayer.getOfflineBukkitPlayer())) {
                            ChatUtil.sendError(sender, MessagePath.GENERIC_ERROR_NO_ALLOW.getMessage(new Object[0]));
                            return;
                        }
                        if (town.setPlayerKnight(residentPlayer.getOfflineBukkitPlayer(), false)) {
                            ChatUtil.sendNotice(sender, MessagePath.COMMAND_TOWN_NOTICE_KNIGHT_CLEAR.getMessage(playerName, townName));
                            break;
                        }
                        ChatUtil.sendError(sender, MessagePath.GENERIC_ERROR_INTERNAL.getMessage(new Object[0]));
                        break;
                    }
                    case "lord": {
                        if (!residentPlayer.getKingdom().equals(town.getKingdom())) {
                            ChatUtil.sendError(sender, MessagePath.GENERIC_ERROR_ENEMY_PLAYER.getMessage(new Object[0]));
                            return;
                        }
                        town.setPlayerLord(residentPlayer.getOfflineBukkitPlayer());
                        town.removeJoinRequest(residentID);
                        ChatUtil.sendNotice(sender, MessagePath.COMMAND_TOWN_NOTICE_LORD_SUCCESS.getMessage(townName, playerName));
                        break;
                    }
                    default: {
                        this.sendInvalidArgMessage(sender);
                        return;
                    }
                }
                KonPlayer onlinePlayer = konquest.getPlayerManager().getPlayerFromID(residentID);
                if (onlinePlayer == null) break;
                konquest.getKingdomManager().updatePlayerMembershipStats(onlinePlayer);
                break;
            }
            case "plots": {
                assert (town != null);
                if (!isSenderPlayer) {
                    ChatUtil.sendError(sender, MessagePath.GENERIC_ERROR_NO_PLAYER.getMessage(new Object[0]));
                    return;
                }
                konquest.getDisplayManager().displayTownPlotMenu(player, town);
            }
        }
    }

    @Override
    public List<String> tabComplete(Konquest konquest, CommandSender sender, List<String> args) {
        ArrayList<String> tabList;
        block68: {
            int numArgs;
            block70: {
                block69: {
                    block67: {
                        tabList = new ArrayList<String>();
                        numArgs = args.size();
                        if (numArgs != 1) break block67;
                        tabList.add("menu");
                        tabList.add("create");
                        tabList.add("remove");
                        tabList.add("rename");
                        tabList.add("option");
                        tabList.add("resident");
                        if (konquest.getKingdomManager().getIsDiscountEnable()) {
                            tabList.add("specialize");
                        }
                        if (konquest.getShieldManager().isArmorsEnabled()) {
                            tabList.add("armor");
                        }
                        if (konquest.getShieldManager().isShieldsEnabled()) {
                            tabList.add("shield");
                        }
                        if (konquest.getUpgradeManager().isEnabled()) {
                            tabList.add("upgrade");
                        }
                        if (konquest.getPlotManager().isEnabled()) {
                            tabList.add("plots");
                        }
                        break block68;
                    }
                    if (numArgs != 2) break block69;
                    String subCmd = args.get(0);
                    if (subCmd.equalsIgnoreCase("create")) {
                        tabList.add("***");
                    } else if (subCmd.equalsIgnoreCase("remove")) {
                        tabList.addAll(konquest.getKingdomManager().getTownNames());
                    } else {
                        tabList.addAll(konquest.getKingdomManager().getTownNames());
                        tabList.addAll(konquest.getKingdomManager().getKingdomNames());
                    }
                    break block68;
                }
                if (numArgs != 3) break block70;
                switch (args.get(0).toLowerCase()) {
                    case "create": 
                    case "remove": {
                        tabList.addAll(konquest.getKingdomManager().getKingdomNames());
                        break;
                    }
                    case "rename": {
                        tabList.add("***");
                        break;
                    }
                    case "specialize": {
                        if (!konquest.getKingdomManager().getIsDiscountEnable()) break;
                        for (Villager.Profession profession : CompatibilityUtil.getProfessions()) {
                            tabList.add(CompatibilityUtil.getProfessionName(profession));
                        }
                        break block68;
                    }
                    case "upgrade": {
                        if (!konquest.getUpgradeManager().isEnabled()) break;
                        for (KonUpgrade upgrade : KonUpgrade.values()) {
                            tabList.add(upgrade.toString());
                        }
                        break block68;
                    }
                    case "option": {
                        KonTown town = konquest.getKingdomManager().getTownCapital(args.get(1));
                        if (town == null) {
                            return Collections.emptyList();
                        }
                        for (KonTownOption option : KonTownOption.values()) {
                            if (town.isTownOptionOverridden(option)) continue;
                            tabList.add(option.toString());
                        }
                        break block68;
                    }
                    case "shield": {
                        if (!konquest.getShieldManager().isShieldsEnabled()) break;
                        tabList.add("clear");
                        tabList.add("set");
                        tabList.add("add");
                        break;
                    }
                    case "armor": {
                        if (!konquest.getShieldManager().isArmorsEnabled()) break;
                        tabList.add("clear");
                        tabList.add("set");
                        tabList.add("add");
                        break;
                    }
                    case "resident": {
                        tabList.add("add");
                        tabList.add("kick");
                        tabList.add("promote");
                        tabList.add("demote");
                        tabList.add("lord");
                    }
                }
                break block68;
            }
            if (numArgs != 4) break block68;
            switch (args.get(0).toLowerCase()) {
                case "shield": 
                case "armor": {
                    if (!args.get(2).equalsIgnoreCase("set") && !args.get(2).equalsIgnoreCase("add")) break;
                    tabList.add("#");
                    break;
                }
                case "upgrade": {
                    tabList.add("#");
                    break;
                }
                case "option": {
                    tabList.add("true");
                    tabList.add("false");
                    break;
                }
                case "resident": {
                    KonTown town = konquest.getKingdomManager().getTownCapital(args.get(1));
                    if (town == null) {
                        return Collections.emptyList();
                    }
                    switch (args.get(2).toLowerCase()) {
                        case "add": {
                            for (KonOfflinePlayer offlinePlayer : konquest.getPlayerManager().getAllKonquestOfflinePlayers()) {
                                String name = offlinePlayer.getOfflineBukkitPlayer().getName();
                                if (name == null || !town.getKingdom().equals(offlinePlayer.getKingdom()) || town.isPlayerResident(offlinePlayer.getOfflineBukkitPlayer())) continue;
                                tabList.add(name);
                            }
                            break block68;
                        }
                        case "kick": {
                            for (KonOfflinePlayer offlinePlayer : konquest.getPlayerManager().getAllKonquestOfflinePlayers()) {
                                String name = offlinePlayer.getOfflineBukkitPlayer().getName();
                                if (name == null || !town.isPlayerResident(offlinePlayer.getOfflineBukkitPlayer())) continue;
                                tabList.add(name);
                            }
                            break block68;
                        }
                        case "promote": {
                            for (OfflinePlayer offlinePlayer : town.getPlayerResidentsOnly()) {
                                String name = offlinePlayer.getName();
                                if (name == null) continue;
                                tabList.add(name);
                            }
                            break block68;
                        }
                        case "demote": {
                            for (OfflinePlayer offlinePlayer : town.getPlayerKnightsOnly()) {
                                String name = offlinePlayer.getName();
                                if (name == null) continue;
                                tabList.add(name);
                            }
                            break block68;
                        }
                        case "lord": {
                            for (OfflinePlayer offlinePlayer : town.getKingdom().getPlayerMembers()) {
                                String name = offlinePlayer.getName();
                                if (name == null || town.isLord(offlinePlayer.getUniqueId())) continue;
                                tabList.add(name);
                            }
                        }
                    }
                }
            }
        }
        return this.matchLastArgToList(tabList, args);
    }
}

