/*
 * Decompiled with CFR 0.152.
 */
package com.github.rumsfield.konquest.command.admin;

import com.github.rumsfield.konquest.Konquest;
import com.github.rumsfield.konquest.command.CommandBase;
import com.github.rumsfield.konquest.model.KonCamp;
import com.github.rumsfield.konquest.model.KonKingdom;
import com.github.rumsfield.konquest.model.KonMonumentTemplate;
import com.github.rumsfield.konquest.model.KonOfflinePlayer;
import com.github.rumsfield.konquest.model.KonPlayer;
import com.github.rumsfield.konquest.model.KonRuin;
import com.github.rumsfield.konquest.model.KonSanctuary;
import com.github.rumsfield.konquest.model.KonTown;
import com.github.rumsfield.konquest.utility.ChatUtil;
import com.github.rumsfield.konquest.utility.MessagePath;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;

public class TravelAdminCommand
extends CommandBase {
    public TravelAdminCommand() {
        super("travel", true, true);
        this.setOptionalArgs(true);
        this.addArgument(this.newArg("menu", true, false));
        List<String> argNames = Arrays.asList("town", "kingdom", "sanctuary", "camp", "ruin", "monument");
        this.addArgument(this.newArg(argNames, true, false).sub(this.newArg("name", false, false)));
    }

    @Override
    public void execute(Konquest konquest, CommandSender sender, List<String> args) {
        KonPlayer player = konquest.getPlayerManager().getPlayer(sender);
        if (player == null) {
            this.sendInvalidSenderMessage(sender);
            return;
        }
        if (args.isEmpty() || args.get(0).equalsIgnoreCase("menu")) {
            konquest.getDisplayManager().displayTravelMenu(player, true);
            return;
        }
        if (args.size() != 2) {
            this.sendInvalidArgMessage(sender);
            return;
        }
        String destinationName = args.get(1);
        Location destination = null;
        switch (args.get(0).toLowerCase()) {
            case "town": {
                KonTown town;
                if (!konquest.getKingdomManager().isTown(destinationName) || (town = konquest.getKingdomManager().getTown(destinationName)) == null) break;
                destination = town.getSpawnLoc();
                break;
            }
            case "kingdom": {
                KonKingdom kingdom;
                if (!konquest.getKingdomManager().isKingdom(destinationName) || (kingdom = konquest.getKingdomManager().getKingdom(destinationName)) == null) break;
                destination = kingdom.getCapital().getSpawnLoc();
                break;
            }
            case "camp": {
                KonCamp camp;
                KonOfflinePlayer campPlayer = konquest.getPlayerManager().getOfflinePlayerFromName(destinationName);
                if (campPlayer == null || !konquest.getCampManager().isCampSet(campPlayer) || (camp = konquest.getCampManager().getCamp(campPlayer)) == null) break;
                destination = camp.getSpawnLoc();
                break;
            }
            case "ruin": {
                KonRuin ruin;
                if (!konquest.getRuinManager().isRuin(destinationName) || (ruin = konquest.getRuinManager().getRuin(destinationName)) == null) break;
                destination = ruin.getSpawnLoc();
                break;
            }
            case "sanctuary": {
                KonSanctuary sanctuary;
                if (!konquest.getSanctuaryManager().isSanctuary(destinationName) || (sanctuary = konquest.getSanctuaryManager().getSanctuary(destinationName)) == null) break;
                destination = sanctuary.getSpawnLoc();
                break;
            }
            case "monument": {
                KonMonumentTemplate monument;
                if (!konquest.getSanctuaryManager().isTemplate(destinationName) || (monument = konquest.getSanctuaryManager().getTemplate(destinationName)) == null) break;
                destination = monument.getSpawnLoc();
                break;
            }
            default: {
                this.sendInvalidArgMessage(sender);
            }
        }
        if (destination == null) {
            ChatUtil.sendError(sender, MessagePath.GENERIC_ERROR_UNKNOWN_NAME.getMessage(destinationName));
            return;
        }
        konquest.telePlayerLocation(player.getBukkitPlayer(), destination);
    }

    @Override
    public List<String> tabComplete(Konquest konquest, CommandSender sender, List<String> args) {
        ArrayList<String> tabList = new ArrayList<String>();
        if (args.size() == 1) {
            tabList.add("menu");
            tabList.add("town");
            tabList.add("kingdom");
            tabList.add("camp");
            tabList.add("ruin");
            tabList.add("sanctuary");
            tabList.add("monument");
        } else if (args.size() == 2) {
            switch (args.get(0)) {
                case "town": {
                    for (KonKingdom kingdom : konquest.getKingdomManager().getKingdoms()) {
                        tabList.addAll(kingdom.getTownNames());
                    }
                    break;
                }
                case "kingdom": {
                    tabList.addAll(konquest.getKingdomManager().getKingdomNames());
                    break;
                }
                case "camp": {
                    for (KonCamp camp : konquest.getCampManager().getCamps()) {
                        tabList.add(camp.getOwner().getName());
                    }
                    break;
                }
                case "ruin": {
                    tabList.addAll(konquest.getRuinManager().getRuinNames());
                    break;
                }
                case "sanctuary": {
                    tabList.addAll(konquest.getSanctuaryManager().getSanctuaryNames());
                    break;
                }
                case "monument": {
                    tabList.addAll(konquest.getSanctuaryManager().getAllTemplateNames());
                }
            }
        }
        return this.matchLastArgToList(tabList, args);
    }
}

