/*
 * Decompiled with CFR 0.152.
 */
package com.github.rumsfield.konquest.command.admin;

import com.github.rumsfield.konquest.Konquest;
import com.github.rumsfield.konquest.command.CommandBase;
import com.github.rumsfield.konquest.model.KonPlayer;
import com.github.rumsfield.konquest.utility.ChatUtil;
import com.github.rumsfield.konquest.utility.MessagePath;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;

public class UnclaimAdminCommand
extends CommandBase {
    public UnclaimAdminCommand() {
        super("unclaim", true, true);
        this.setOptionalArgs(true);
        this.addArgument(this.newArg("auto", true, false));
        this.addArgument(this.newArg("radius", true, false).sub(this.newArg("value", false, false)));
    }

    @Override
    public void execute(Konquest konquest, CommandSender sender, List<String> args) {
        KonPlayer player = konquest.getPlayerManager().getPlayer(sender);
        if (player == null) {
            this.sendInvalidSenderMessage(sender);
            return;
        }
        Location playerLoc = player.getBukkitPlayer().getLocation();
        if (!konquest.isWorldValid(playerLoc.getWorld())) {
            ChatUtil.sendError(sender, MessagePath.GENERIC_ERROR_INVALID_WORLD.getMessage(new Object[0]));
            return;
        }
        if (args.isEmpty()) {
            konquest.getTerritoryManager().unclaimForAdmin(player, playerLoc);
            return;
        }
        switch (args.get(0).toLowerCase()) {
            case "radius": {
                int radius;
                if (args.size() != 2) {
                    this.sendInvalidArgMessage(sender);
                    return;
                }
                try {
                    radius = Integer.parseInt(args.get(1));
                }
                catch (NumberFormatException e) {
                    ChatUtil.sendError(sender, MessagePath.GENERIC_ERROR_INTERNAL_MESSAGE.getMessage(e.getMessage()));
                    return;
                }
                boolean min = true;
                int max = 16;
                if (radius < 1 || radius > 16) {
                    ChatUtil.sendError(sender, MessagePath.COMMAND_UNCLAIM_ERROR_RADIUS.getMessage(1, 16));
                    return;
                }
                konquest.getTerritoryManager().unclaimRadiusForAdmin(player, playerLoc, radius);
                break;
            }
            case "auto": {
                boolean isUnclaimSuccess;
                boolean doAuto = false;
                if (player.isAutoFollowActive()) {
                    if (player.getAutoFollow().equals((Object)KonPlayer.FollowType.ADMIN_UNCLAIM)) {
                        ChatUtil.sendNotice(sender, MessagePath.GENERIC_NOTICE_DISABLE_AUTO.getMessage(new Object[0]));
                        player.setAutoFollow(KonPlayer.FollowType.NONE);
                    } else {
                        doAuto = true;
                    }
                } else {
                    doAuto = true;
                }
                if (!doAuto || !(isUnclaimSuccess = konquest.getTerritoryManager().unclaimForAdmin(player, playerLoc))) break;
                ChatUtil.sendNotice(sender, MessagePath.GENERIC_NOTICE_ENABLE_AUTO.getMessage(new Object[0]));
                player.setAutoFollow(KonPlayer.FollowType.ADMIN_UNCLAIM);
                break;
            }
            default: {
                this.sendInvalidArgMessage(sender);
            }
        }
    }

    @Override
    public List<String> tabComplete(Konquest konquest, CommandSender sender, List<String> args) {
        ArrayList<String> tabList = new ArrayList<String>();
        if (args.size() == 1) {
            tabList.add("radius");
            tabList.add("auto");
        } else if (args.size() == 2 && args.get(0).equalsIgnoreCase("radius")) {
            tabList.add("#");
        }
        return this.matchLastArgToList(tabList, args);
    }
}

