/*
 * Decompiled with CFR 0.152.
 */
package com.github.rumsfield.konquest.database;

import com.github.rumsfield.konquest.database.DatabaseConnection;
import com.github.rumsfield.konquest.utility.ChatUtil;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.concurrent.Callable;

public class AsyncQuerySQL
implements Callable<ResultSet> {
    private final DatabaseConnection connection;
    private final String query;

    AsyncQuerySQL(DatabaseConnection connection, String query) {
        this.connection = connection;
        this.query = query;
    }

    @Override
    public ResultSet call() {
        try {
            ChatUtil.printDebug("Executing SQL Query: " + this.query);
            PreparedStatement statement = this.connection.prepare(this.query);
            return statement.executeQuery();
        }
        catch (SQLException e) {
            ChatUtil.printConsoleError("Failed to execute SQL query, attempting to reconnect");
            ChatUtil.printDebug(e.getMessage());
            try {
                this.connection.connect();
                PreparedStatement statement = this.connection.prepare(this.query);
                return statement.executeQuery();
            }
            catch (SQLException r) {
                ChatUtil.printConsoleError("Failed to execute SQL query after reconnect. Check your database settings.");
                r.printStackTrace();
                return null;
            }
        }
    }
}

