/*
 * Decompiled with CFR 0.152.
 */
package com.github.rumsfield.konquest.database;

import com.github.rumsfield.konquest.database.DatabaseConnection;
import com.github.rumsfield.konquest.utility.ChatUtil;
import java.sql.SQLException;
import java.sql.Statement;

public class AsyncUpdateSQL
implements Runnable {
    private final DatabaseConnection connection;
    private final String query;

    public AsyncUpdateSQL(DatabaseConnection connection, String query) {
        this.connection = connection;
        this.query = query;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Statement statement = null;
        Statement backupStatement = null;
        try {
            ChatUtil.printDebug("Executing SQL Update: " + this.query);
            statement = this.connection.getConnection().createStatement();
            statement.executeUpdate(this.query);
        }
        catch (SQLException e) {
            ChatUtil.printConsoleError("Failed to execute SQL update, attempting to reconnect");
            ChatUtil.printDebug(e.getMessage());
            try {
                this.connection.connect();
                backupStatement = this.connection.getConnection().createStatement();
                backupStatement.executeUpdate(this.query);
            }
            catch (SQLException r) {
                ChatUtil.printConsoleError("Failed to execute SQL query after reconnect. Check your database settings.");
                r.printStackTrace();
            }
            finally {
                if (backupStatement != null) {
                    try {
                        backupStatement.close();
                    }
                    catch (SQLException s2) {
                        ChatUtil.printConsoleError("Failed to close SQL update backup statement");
                        s2.printStackTrace();
                    }
                }
            }
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException s1) {
                    ChatUtil.printConsoleError("Failed to close SQL update statement");
                    s1.printStackTrace();
                }
            }
        }
    }
}

