/*
 * Decompiled with CFR 0.152.
 */
package com.github.rumsfield.konquest.database;

import com.github.rumsfield.konquest.Konquest;
import com.github.rumsfield.konquest.database.AsyncQuerySQL;
import com.github.rumsfield.konquest.database.AsyncUpdateSQL;
import com.github.rumsfield.konquest.database.DatabaseType;
import com.github.rumsfield.konquest.utility.ChatUtil;
import com.github.rumsfield.konquest.utility.CorePath;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.bukkit.configuration.file.FileConfiguration;
import org.jetbrains.annotations.NotNull;

public class DatabaseConnection {
    private Connection connection;
    private final ExecutorService queryExecutor = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
    private final DatabaseType type;

    public DatabaseConnection(DatabaseType type) {
        this.type = type;
    }

    public void connect() throws SQLException {
        if (this.connection != null && !this.connection.isClosed()) {
            ChatUtil.printConsoleAlert("Could not connect to SQL database of type " + this.type.toString() + ", connection is already open.");
            return;
        }
        Properties properties = new Properties();
        switch (this.type) {
            case SQLITE: {
                try {
                    ChatUtil.printConsoleAlert("Connecting to SQLite database");
                    File databaseFile = this.migrateDatabaseFile();
                    this.connection = DriverManager.getConnection("jdbc:sqlite:" + databaseFile.getAbsolutePath(), properties);
                    return;
                }
                catch (SQLException e) {
                    ChatUtil.printConsoleAlert("Failed to connect to SQLite database!");
                    e.printStackTrace();
                    break;
                }
            }
            case MYSQL: {
                try {
                    ChatUtil.printConsoleAlert("Connecting to MySQL database");
                    FileConfiguration coreConfig = Konquest.getInstance().getCore();
                    String hostname = coreConfig.getString(CorePath.DATABASE_MYSQL_HOSTNAME.getPath());
                    String port = coreConfig.getString(CorePath.DATABASE_MYSQL_PORT.getPath());
                    String database = coreConfig.getString(CorePath.DATABASE_MYSQL_DATABASE.getPath());
                    String username = coreConfig.getString(CorePath.DATABASE_MYSQL_USERNAME.getPath(), "");
                    properties.put("user", username);
                    String password = coreConfig.getString(CorePath.DATABASE_MYSQL_PASSWORD.getPath(), "");
                    properties.put("password", password);
                    for (String nameValuePair : coreConfig.getStringList(CorePath.DATABASE_MYSQL_PROPERTIES.getPath())) {
                        String[] propNameValue = nameValuePair.split("=", 2);
                        if (propNameValue.length != 2) continue;
                        properties.put(propNameValue[0], propNameValue[1]);
                    }
                    ChatUtil.printDebug("Applying connection properties...");
                    for (String key : properties.stringPropertyNames()) {
                        String value = properties.getProperty(key);
                        ChatUtil.printDebug("  " + key + " = " + value);
                    }
                    this.connection = DriverManager.getConnection("jdbc:mysql://" + hostname + ":" + port + "/" + database, properties);
                    return;
                }
                catch (SQLException e) {
                    ChatUtil.printConsoleAlert("Failed to connect to MySQL database!");
                    e.printStackTrace();
                    break;
                }
            }
            default: {
                ChatUtil.printConsoleError("Could not connect to unknown database type " + String.valueOf((Object)this.type));
            }
        }
    }

    public void disconnect() {
        try {
            if (this.connection != null) {
                this.queryExecutor.shutdown();
                this.queryExecutor.awaitTermination(5L, TimeUnit.SECONDS);
                this.connection.close();
            }
        }
        catch (InterruptedException | SQLException e) {
            e.printStackTrace();
        }
        this.connection = null;
    }

    public PreparedStatement prepare(String sql) {
        if (this.connection == null) {
            return null;
        }
        try {
            return this.connection.prepareStatement(sql);
        }
        catch (SQLException e) {
            e.printStackTrace();
            ChatUtil.printConsoleError("Failed to prepare SQL statement, is the connection closed?");
            return null;
        }
    }

    public ResultSet scheduleQuery(String query) {
        if (this.testConnection(true)) {
            ChatUtil.printConsoleAlert("Successfully reconnected to database");
        }
        Future<ResultSet> futureResult = this.queryExecutor.submit(new AsyncQuerySQL(this, query));
        try {
            return futureResult.get();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            ChatUtil.printConsoleError("Failed to schedule SQL query, InterruptedException");
        }
        catch (ExecutionException e) {
            e.printStackTrace();
            ChatUtil.printConsoleError("Failed to schedule SQL query, ExecutionException");
        }
        return null;
    }

    public void scheduleUpdate(String query) {
        if (this.testConnection(true)) {
            ChatUtil.printConsoleAlert("Successfully reconnected to database");
        }
        this.queryExecutor.execute(new AsyncUpdateSQL(this, query));
    }

    public boolean pingDatabase() {
        boolean result = false;
        try {
            Statement statement = this.connection.createStatement();
            statement.executeQuery("SELECT 1;");
            statement.close();
            result = true;
        }
        catch (SQLException e) {
            ChatUtil.printDebug("Failed to ping SQL database, caught exception:");
            ChatUtil.printDebug(e.getMessage());
        }
        return result;
    }

    public Connection getConnection() {
        return this.connection;
    }

    private boolean testConnection(boolean reconnect) {
        boolean result = false;
        try {
            Statement statement = this.connection.createStatement();
            statement.executeQuery("SELECT 1;");
            statement.close();
        }
        catch (SQLException e) {
            if (reconnect) {
                ChatUtil.printConsoleError("Failed to connect to database, trying to reconnect");
                try {
                    this.connect();
                    result = true;
                }
                catch (SQLException r) {
                    e.printStackTrace();
                    r.printStackTrace();
                }
            }
            ChatUtil.printConsoleError("Failed to connect to database :(");
            e.printStackTrace();
        }
        return result;
    }

    @NotNull
    private File migrateDatabaseFile() {
        String oldFileName = "Konquestdatabase.db";
        String newFileName = "data/KonquestDatabase.db";
        File oldFile = new File(Konquest.getInstance().getPlugin().getDataFolder(), "Konquestdatabase.db");
        File newFile = new File(Konquest.getInstance().getPlugin().getDataFolder(), "data/KonquestDatabase.db");
        if (!oldFile.exists()) {
            return newFile;
        }
        Path source = oldFile.toPath();
        Path destination = newFile.toPath();
        try {
            Files.move(source, destination, StandardCopyOption.REPLACE_EXISTING);
            oldFile.delete();
            ChatUtil.printConsoleAlert("Migrated database file Konquestdatabase.db to data/KonquestDatabase.db");
        }
        catch (IOException e) {
            e.printStackTrace();
            ChatUtil.printDebug("Failed to move database file Konquestdatabase.db to data/KonquestDatabase.db");
        }
        return newFile;
    }
}

