/*
 * Decompiled with CFR 0.152.
 */
package com.github.rumsfield.konquest.database;

import com.github.rumsfield.konquest.Konquest;
import com.github.rumsfield.konquest.database.DatabaseType;
import com.github.rumsfield.konquest.database.KonquestDB;
import com.github.rumsfield.konquest.model.KonPlayer;
import com.github.rumsfield.konquest.utility.ChatUtil;
import com.github.rumsfield.konquest.utility.CorePath;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

public class DatabaseThread
implements Runnable {
    private final Konquest konquest;
    private KonquestDB database;
    private final Thread thread;
    private int sleepSeconds;
    private boolean running = false;

    public DatabaseThread(Konquest konquest) {
        this.konquest = konquest;
        this.sleepSeconds = 3600;
        this.thread = new Thread(this);
    }

    @Override
    public void run() {
        this.running = true;
        long delayTicks = 200L;
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.konquest.getPlugin(), () -> {
            if (this.database.isReady()) {
                ChatUtil.printConsoleAlert("Konquest Database passed startup check.");
            } else {
                ChatUtil.printConsoleError("Something went wrong when starting the Konquest Database, and the plugin will not behave correctly! Please report this to the Konquest developer.");
            }
        }, delayTicks);
        this.createDatabase();
        this.database.initialize();
        Thread databaseFlusher = new Thread(() -> {
            while (true) {
                try {
                    Thread.sleep((long)this.sleepSeconds * 1000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                this.flushDatabase();
            }
        });
        databaseFlusher.start();
    }

    public boolean isRunning() {
        return this.running;
    }

    public void createDatabase() {
        String dbType = this.konquest.getCore().getString(CorePath.DATABASE_CONNECTION.getPath(), "sqlite");
        DatabaseType type = DatabaseType.getType(dbType);
        this.database = new KonquestDB(type, this.konquest);
    }

    public Thread getThread() {
        return this.thread;
    }

    public KonquestDB getDatabase() {
        return this.database;
    }

    public void setSleepSeconds(int val) {
        this.sleepSeconds = val;
    }

    public void flushDatabase() {
        ChatUtil.printDebug("Flushing entire database for all online players");
        for (KonPlayer player : this.konquest.getPlayerManager().getPlayersOnline()) {
            this.database.flushPlayerData(player.getBukkitPlayer());
        }
    }
}

