/*
 * Decompiled with CFR 0.152.
 */
package com.github.rumsfield.konquest.database;

import com.github.rumsfield.konquest.utility.ChatUtil;

public enum DatabaseType {
    MYSQL("mysql.jar"),
    SQLITE("sqlite.jar");

    private final String driver;

    private DatabaseType(String driver) {
        this.driver = driver;
    }

    public String getDriver() {
        return this.driver;
    }

    public static DatabaseType getType(String str) {
        for (DatabaseType type : DatabaseType.values()) {
            if (!type.toString().equalsIgnoreCase(str)) continue;
            return type;
        }
        ChatUtil.printConsoleError("Failed to determine database connection type, " + str + ". Using default SQLite.");
        return SQLITE;
    }
}

