/*
 * Decompiled with CFR 0.152.
 */
package com.github.rumsfield.konquest.database;

import com.github.rumsfield.konquest.Konquest;
import com.github.rumsfield.konquest.database.Column;
import com.github.rumsfield.konquest.database.Database;
import com.github.rumsfield.konquest.database.DatabaseType;
import com.github.rumsfield.konquest.database.Table;
import com.github.rumsfield.konquest.model.KonDirective;
import com.github.rumsfield.konquest.model.KonOfflinePlayer;
import com.github.rumsfield.konquest.model.KonPlayer;
import com.github.rumsfield.konquest.model.KonPrefixType;
import com.github.rumsfield.konquest.model.KonStats;
import com.github.rumsfield.konquest.model.KonStatsType;
import com.github.rumsfield.konquest.utility.ChatUtil;
import com.github.rumsfield.konquest.utility.MessagePath;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class KonquestDB
extends Database {
    private boolean isReady;
    private final Konquest konquest;

    public KonquestDB(DatabaseType type, Konquest konquest) {
        super(type);
        this.konquest = konquest;
        this.isReady = false;
    }

    @Override
    public void initialize() {
        try {
            this.getDatabaseConnection().connect();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        this.konquest.initializePostDB();
        this.isReady = true;
        ChatUtil.printConsole("SQL database is ready");
    }

    public boolean isReady() {
        return this.isReady;
    }

    public void spawnTables() {
        Table players = new Table("players", this);
        Column column = new Column("uuid");
        column.setType("CHAR(36)");
        column.setPrimary(true);
        players.add(column);
        column = new Column("kingdom");
        column.setType("VARCHAR(255)");
        column.setDefaultValue("'" + this.konquest.getKingdomManager().getBarbarians().getName() + "'");
        players.add(column);
        column = new Column("exileKingdom");
        column.setType("VARCHAR(255)");
        column.setDefaultValue("'" + this.konquest.getKingdomManager().getBarbarians().getName() + "'");
        players.add(column);
        column = new Column("barbarian");
        column.setType("TINYINT");
        column.setDefaultValue("1");
        players.add(column);
        column = new Column("prefix");
        column.setType("VARCHAR(255)");
        players.add(column);
        column = new Column("prefixOn");
        column.setType("TINYINT(1)");
        column.setDefaultValue("0");
        players.add(column);
        column = new Column("custom");
        column.setType("VARCHAR(255)");
        players.add(column);
        players.execute();
        Table stats = new Table("stats", this);
        column = new Column("uuid");
        column.setType("CHAR(36)");
        column.setPrimary(true);
        stats.add(column);
        for (KonStatsType stat : KonStatsType.values()) {
            String name = stat.toString();
            String value = String.valueOf(0);
            column = new Column(name);
            column.setType("INTEGER");
            column.setDefaultValue(value);
            stats.add(column);
        }
        stats.execute();
        Table directives = new Table("directives", this);
        column = new Column("uuid");
        column.setType("CHAR(36)");
        column.setPrimary(true);
        directives.add(column);
        for (KonDirective dir : KonDirective.values()) {
            String name = dir.toString();
            column = new Column(name);
            column.setType("INTEGER");
            column.setDefaultValue("0");
            directives.add(column);
        }
        directives.execute();
        Table customs = new Table("customs", this);
        column = new Column("uuid");
        column.setType("CHAR(36)");
        column.setPrimary(true);
        customs.add(column);
        for (String label : this.konquest.getAccomplishmentManager().getCustomPrefixLabels()) {
            column = new Column(label);
            column.setType("TINYINT(1)");
            column.setDefaultValue("0");
            customs.add(column);
        }
        customs.execute();
    }

    public ArrayList<KonOfflinePlayer> getAllSavedPlayers() {
        ArrayList<KonOfflinePlayer> players = new ArrayList<KonOfflinePlayer>();
        ResultSet player = this.selectAll("players");
        try {
            while (player.next()) {
                OfflinePlayer offlineBukkitPlayer;
                boolean isBarbarian;
                String uuid = player.getString("uuid");
                String kingdomName = player.getString("kingdom");
                boolean bl = isBarbarian = player.getInt("barbarian") == 1;
                if (kingdomName == null) {
                    kingdomName = this.konquest.getKingdomManager().getBarbarians().getName();
                }
                if ((offlineBukkitPlayer = Bukkit.getOfflinePlayer((UUID)UUID.fromString(uuid))).getName() == null) continue;
                players.add(new KonOfflinePlayer(offlineBukkitPlayer, this.konquest.getKingdomManager().getKingdom(kingdomName), isBarbarian));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            ChatUtil.printConsoleError("A problem occured while getting all saved players from the database");
        }
        ChatUtil.printDebug("Fetched " + players.size() + " players from database.");
        return players;
    }

    public void setOfflinePlayers(ArrayList<KonOfflinePlayer> offlinePlayers) {
        for (KonOfflinePlayer offlinePlayer : offlinePlayers) {
            this.setOfflinePlayer(offlinePlayer);
        }
    }

    public void setOfflinePlayer(KonOfflinePlayer offlinePlayer) {
        if (this.konquest.getPlayerManager().isOfflinePlayer(offlinePlayer.getOfflineBukkitPlayer())) {
            String playerUUIDString = offlinePlayer.getOfflineBukkitPlayer().getUniqueId().toString();
            String[] col = new String[]{"kingdom", "barbarian"};
            String[] val = new String[col.length];
            val[0] = "'" + offlinePlayer.getKingdom().getName() + "'";
            val[1] = offlinePlayer.isBarbarian() ? "1" : "0";
            this.set("players", col, val, "uuid", playerUUIDString);
        } else {
            ChatUtil.printDebug("Failed to flush non-existent offlinePlayer to database");
        }
    }

    public boolean fetchPlayerData(Player bukkitPlayer) {
        if (!this.exists("players", "uuid", bukkitPlayer.getUniqueId().toString())) {
            this.createPlayerData(bukkitPlayer);
            this.konquest.getPlayerManager().createKonPlayer(bukkitPlayer);
            return false;
        }
        this.assertPlayerData(bukkitPlayer);
        ResultSet playerInfo = this.select("players", "uuid", bukkitPlayer.getUniqueId().toString());
        String kingdomName = "";
        String exileKingdomName = "";
        boolean isBarbarian = true;
        String mainPrefix = "";
        boolean enablePrefix = false;
        String customPrefix = "";
        try {
            while (playerInfo.next()) {
                kingdomName = playerInfo.getString("kingdom");
                exileKingdomName = playerInfo.getString("exileKingdom");
                isBarbarian = playerInfo.getBoolean("barbarian");
                mainPrefix = playerInfo.getString("prefix");
                enablePrefix = playerInfo.getBoolean("prefixOn");
                customPrefix = playerInfo.getString("custom");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            ChatUtil.printDebug("Aborting player import " + bukkitPlayer.getName());
            return true;
        }
        if (kingdomName == null) {
            kingdomName = this.konquest.getKingdomManager().getBarbarians().getName();
        }
        if (exileKingdomName == null) {
            exileKingdomName = this.konquest.getKingdomManager().getBarbarians().getName();
        }
        KonPlayer player = this.konquest.getPlayerManager().importKonPlayer(bukkitPlayer, kingdomName, exileKingdomName, isBarbarian);
        ResultSet stats = this.select("stats", "uuid", bukkitPlayer.getUniqueId().toString());
        ResultSet directives = this.select("directives", "uuid", bukkitPlayer.getUniqueId().toString());
        try {
            while (stats.next()) {
                for (Enum enum_ : KonStatsType.values()) {
                    int statProgress = stats.getInt(enum_.toString());
                    player.getPlayerStats().setStat((KonStatsType)enum_, statProgress);
                }
            }
            while (directives.next()) {
                for (Enum enum_ : KonDirective.values()) {
                    int directiveProgress = directives.getInt(enum_.toString());
                    player.setDirectiveProgress((KonDirective)enum_, directiveProgress);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            ChatUtil.printDebug("Could not get stats and directives for " + bukkitPlayer.getName());
        }
        ResultSet customs = this.select("customs", "uuid", bukkitPlayer.getUniqueId().toString());
        try {
            while (customs.next()) {
                for (String label : this.konquest.getAccomplishmentManager().getCustomPrefixLabels()) {
                    boolean bl = customs.getBoolean(label);
                    if (!bl) continue;
                    player.getPlayerPrefix().addAvailableCustom(label);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            ChatUtil.printDebug("Could not get custom prefixes for " + bukkitPlayer.getName());
        }
        this.konquest.getAccomplishmentManager().initPlayerPrefixes(player);
        boolean prefixStatus = false;
        if (customPrefix != null && !customPrefix.equals("") && this.konquest.getAccomplishmentManager().isEnabled()) {
            prefixStatus = this.konquest.getAccomplishmentManager().setPlayerCustomPrefix(player, customPrefix);
        } else if (mainPrefix != null && !mainPrefix.equals("") && this.konquest.getAccomplishmentManager().isEnabled()) {
            prefixStatus = player.getPlayerPrefix().setPrefix(KonPrefixType.getPrefix(mainPrefix));
        } else {
            enablePrefix = false;
        }
        if (!prefixStatus && this.konquest.getAccomplishmentManager().isEnabled()) {
            ChatUtil.printDebug("Failed to assign main prefix or custom prefix to player " + bukkitPlayer.getName());
            Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.konquest.getPlugin(), () -> ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.COMMAND_PREFIX_ERROR_DEFAULT.getMessage(new Object[0])), 20L);
        }
        player.getPlayerPrefix().setEnable(enablePrefix);
        return true;
    }

    public KonStats pullPlayerStats(OfflinePlayer offlineBukkitPlayer) {
        KonStats playerStats = new KonStats();
        ResultSet stats = this.select("stats", "uuid", offlineBukkitPlayer.getUniqueId().toString());
        try {
            while (stats.next()) {
                for (KonStatsType statEnum : KonStatsType.values()) {
                    int statProgress = stats.getInt(statEnum.toString());
                    playerStats.setStat(statEnum, statProgress);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            ChatUtil.printDebug("Could not pull stats for " + offlineBukkitPlayer.getName());
        }
        return playerStats;
    }

    public void pushPlayerStats(OfflinePlayer offlineBukkitPlayer, KonStats stats) {
        String[] col = new String[KonStatsType.values().length];
        String[] val = new String[KonStatsType.values().length];
        int i = 0;
        for (KonStatsType iter : KonStatsType.values()) {
            col[i] = iter.toString();
            val[i] = Integer.toString(stats.getStat(iter));
            ++i;
        }
        this.set("stats", col, val, "uuid", offlineBukkitPlayer.getUniqueId().toString());
    }

    private void createPlayerData(Player bukkitPlayer) {
        String uuid = bukkitPlayer.getUniqueId().toString();
        this.insert("players", new String[]{"uuid"}, new String[]{uuid});
        this.insert("stats", new String[]{"uuid"}, new String[]{uuid});
        this.insert("directives", new String[]{"uuid"}, new String[]{uuid});
        this.insert("customs", new String[]{"uuid"}, new String[]{uuid});
    }

    private void assertPlayerData(Player bukkitPlayer) {
        String uuid = bukkitPlayer.getUniqueId().toString();
        if (!this.exists("players", "uuid", uuid)) {
            this.insert("players", new String[]{"uuid"}, new String[]{uuid});
        }
        if (!this.exists("stats", "uuid", uuid)) {
            this.insert("stats", new String[]{"uuid"}, new String[]{uuid});
        }
        if (!this.exists("directives", "uuid", uuid)) {
            this.insert("directives", new String[]{"uuid"}, new String[]{uuid});
        }
        if (!this.exists("customs", "uuid", uuid)) {
            this.insert("customs", new String[]{"uuid"}, new String[]{uuid});
        }
    }

    public void flushPlayerData(Player bukkitPlayer) {
        if (!this.konquest.getPlayerManager().isOnlinePlayer(bukkitPlayer)) {
            ChatUtil.printDebug("Failed to flush non-existent player to database");
            return;
        }
        String playerUUIDString = bukkitPlayer.getUniqueId().toString();
        KonPlayer player = this.konquest.getPlayerManager().getPlayer(bukkitPlayer);
        String[] col = new String[]{"kingdom", "exileKingdom", "barbarian", "prefix", "prefixOn", "custom"};
        String[] val = new String[col.length];
        val[0] = "'" + player.getKingdom().getName() + "'";
        val[1] = "'" + player.getExileKingdom().getName() + "'";
        val[2] = player.isBarbarian() ? "1" : "0";
        val[3] = "'" + player.getPlayerPrefix().getMainPrefix().toString() + "'";
        val[4] = player.getPlayerPrefix().isEnabled() ? "1" : "0";
        val[5] = "'" + player.getPlayerPrefix().getCustom() + "'";
        this.set("players", col, val, "uuid", playerUUIDString);
        col = new String[KonStatsType.values().length];
        val = new String[KonStatsType.values().length];
        int i = 0;
        for (KonStatsType konStatsType : KonStatsType.values()) {
            col[i] = konStatsType.toString();
            val[i] = Integer.toString(player.getPlayerStats().getStat(konStatsType));
            ++i;
        }
        this.set("stats", col, val, "uuid", playerUUIDString);
        col = new String[KonDirective.values().length];
        val = new String[KonDirective.values().length];
        i = 0;
        for (Enum enum_ : KonDirective.values()) {
            col[i] = enum_.toString();
            val[i] = Integer.toString(player.getDirectiveProgress((KonDirective)enum_));
            ++i;
        }
        this.set("directives", col, val, "uuid", playerUUIDString);
        Set<String> labels = this.konquest.getAccomplishmentManager().getCustomPrefixLabels();
        if (!labels.isEmpty()) {
            col = new String[labels.size()];
            val = new String[labels.size()];
            i = 0;
            Iterator<String> iterator = labels.iterator();
            while (iterator.hasNext()) {
                String iter;
                col[i] = iter = iterator.next();
                val[i] = player.getPlayerPrefix().isCustomAvailable(iter) ? "1" : "0";
                ++i;
            }
            this.set("customs", col, val, "uuid", playerUUIDString);
        }
    }
}

