/*
 * Decompiled with CFR 0.152.
 */
package com.github.rumsfield.konquest.database;

import com.github.rumsfield.konquest.database.Column;
import com.github.rumsfield.konquest.database.Database;
import com.github.rumsfield.konquest.utility.ChatUtil;
import java.util.ArrayList;

public class Table {
    private final String name;
    private final Database database;
    private final ArrayList<Column> columns;

    public Table(String name, Database database) {
        this.name = name;
        this.database = database;
        this.columns = new ArrayList();
    }

    public void add(Column column) {
        column.setTable(this);
        this.columns.add(column);
    }

    public void execute() {
        if (this.database.exists(this.name)) {
            for (Column col : this.columns) {
                if (this.database.exists(this.name, col.getName())) continue;
                ChatUtil.printConsole("SQL database is missing column '" + col.getName() + "' in table '" + this.name + "', adding it now.");
                StringBuilder addBuffer = new StringBuilder("ALTER TABLE ");
                addBuffer.append(this.name).append(" ADD COLUMN ");
                addBuffer.append(col.getName()).append(" ");
                addBuffer.append(col.getType()).append(" ");
                if (!col.getDefaultValue().isEmpty()) {
                    addBuffer.append("DEFAULT ");
                    addBuffer.append(col.getDefaultValue()).append(" ");
                }
                this.database.getDatabaseConnection().scheduleUpdate(addBuffer.toString());
            }
            return;
        }
        ChatUtil.printConsole("SQL database is missing table '" + this.name + "', creating it now.");
        StringBuilder buffer = new StringBuilder("CREATE TABLE IF NOT EXISTS ");
        buffer.append(this.name);
        buffer.append(" ( ");
        for (int i = 0; i < this.columns.size(); ++i) {
            Column column = this.columns.get(i);
            buffer.append(column.getName()).append(" ");
            buffer.append(column.getType()).append(" ");
            if (column.isPrimary()) {
                buffer.append("PRIMARY KEY ");
            }
            if (!column.getDefaultValue().isEmpty()) {
                buffer.append("DEFAULT ");
                buffer.append(column.getDefaultValue()).append(" ");
            }
            if (i == this.columns.size() - 1) continue;
            buffer.append(",");
            buffer.append(" ");
        }
        buffer.append(" );");
        this.database.getDatabaseConnection().scheduleUpdate(buffer.toString());
    }
}

