/*
 * Decompiled with CFR 0.152.
 */
package com.github.rumsfield.konquest.display;

import com.github.rumsfield.konquest.Konquest;
import com.github.rumsfield.konquest.display.icon.MenuIcon;
import com.github.rumsfield.konquest.display.icon.PlayerIcon;
import com.github.rumsfield.konquest.manager.DisplayManager;
import com.github.rumsfield.konquest.utility.ChatUtil;
import java.util.ArrayList;
import java.util.HashMap;
import org.bukkit.Bukkit;
import org.bukkit.inventory.Inventory;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class DisplayView {
    private final Inventory inventory;
    private final HashMap<Integer, MenuIcon> iconMap;
    private final Runnable updateTask;
    private BukkitTask executionTask;
    private int refreshTickRate;

    public DisplayView(int rows, String label) {
        if (rows > 5) {
            ChatUtil.printConsoleError("Failed to create menu display with " + rows + " rows: " + label);
        }
        int invRows = Math.min(rows, 5) + 1;
        this.inventory = Bukkit.createInventory(null, (int)(invRows * 9), (String)(DisplayManager.titleFormat + label));
        this.iconMap = new HashMap();
        this.refreshTickRate = 0;
        this.executionTask = null;
        this.updateTask = () -> {
            ArrayList<MenuIcon> heads = new ArrayList<MenuIcon>();
            for (MenuIcon icon : this.iconMap.values()) {
                if (icon instanceof PlayerIcon) {
                    heads.add(icon);
                    continue;
                }
                if (icon.getIndex() >= this.inventory.getSize()) continue;
                this.inventory.setItem(icon.getIndex(), icon.getItem());
            }
            for (MenuIcon icon : heads) {
                if (icon.getIndex() >= this.inventory.getSize()) continue;
                this.inventory.setItem(icon.getIndex(), icon.getItem());
            }
        };
    }

    public void setRefreshTickRate(int ticks) {
        this.refreshTickRate = ticks;
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    public void addIcon(MenuIcon icon) {
        this.iconMap.put(icon.getIndex(), icon);
    }

    public MenuIcon getIcon(int index) {
        return this.iconMap.get(index);
    }

    public void updateIcons() {
        this.executionTask = this.refreshTickRate > 0 ? Bukkit.getScheduler().runTaskTimer((Plugin)Konquest.getInstance().getPlugin(), this.updateTask, 0L, (long)this.refreshTickRate) : Bukkit.getScheduler().runTaskAsynchronously((Plugin)Konquest.getInstance().getPlugin(), this.updateTask);
    }

    public void clearUpdates() {
        if (this.executionTask != null) {
            this.executionTask.cancel();
        }
    }
}

