/*
 * Decompiled with CFR 0.152.
 */
package com.github.rumsfield.konquest.display;

import com.github.rumsfield.konquest.Konquest;
import com.github.rumsfield.konquest.api.model.KonquestOfflinePlayer;
import com.github.rumsfield.konquest.api.model.KonquestRelationshipType;
import com.github.rumsfield.konquest.display.DisplayView;
import com.github.rumsfield.konquest.display.icon.InfoIcon;
import com.github.rumsfield.konquest.display.icon.MenuIcon;
import com.github.rumsfield.konquest.model.KonCamp;
import com.github.rumsfield.konquest.model.KonGlobalEvent;
import com.github.rumsfield.konquest.model.KonKingdom;
import com.github.rumsfield.konquest.model.KonMonumentTemplate;
import com.github.rumsfield.konquest.model.KonOfflinePlayer;
import com.github.rumsfield.konquest.model.KonPrefixType;
import com.github.rumsfield.konquest.model.KonRuin;
import com.github.rumsfield.konquest.model.KonSanctuary;
import com.github.rumsfield.konquest.model.KonTown;
import com.github.rumsfield.konquest.utility.MessagePath;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import javax.annotation.Nullable;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;

public abstract class StateMenu {
    private final Konquest konquest;
    private State currentState;
    private Access menuAccess;
    private final HashMap<State, ArrayList<DisplayView>> viewPages = new HashMap();
    private int currentPage = 0;
    protected final Comparator<KonTown> townComparator;
    protected final Comparator<KonTown> townNameComparator;
    protected final Comparator<KonKingdom> kingdomComparator;
    protected final Comparator<KonKingdom> kingdomNameComparator;
    protected final Comparator<KonCamp> campComparator;
    protected final Comparator<KonRuin> ruinComparator;
    protected final Comparator<KonSanctuary> sanctuaryComparator;
    protected final Comparator<KonMonumentTemplate> templateComparator;
    protected final Comparator<KonOfflinePlayer> playerComparator;
    protected final Comparator<KonPrefixType> prefixComparator;
    protected final Comparator<KonOfflinePlayer> playerScoreComparator;
    protected final Comparator<KonKingdom> kingdomScoreComparator;
    protected final Comparator<KonGlobalEvent> eventStartComparator;
    protected final int MAX_ICONS_PER_PAGE = 45;
    protected final int MAX_ROW_SIZE = 9;
    protected final int INDEX_HOME = 3;
    protected final int INDEX_CLOSE = 4;
    protected final int INDEX_RETURN = 5;
    protected final int INDEX_BACK = 0;
    protected final int INDEX_NEXT = 8;

    public StateMenu(Konquest konquest, State initialState, Access initialAccess) {
        this.currentState = initialState;
        this.menuAccess = initialAccess;
        this.konquest = konquest;
        this.townComparator = (townOne, townTwo) -> {
            int g2Land;
            int result = 0;
            int g1Land = townOne.getChunkList().size();
            if (g1Land < (g2Land = townTwo.getChunkList().size())) {
                result = 1;
            } else if (g1Land > g2Land) {
                result = -1;
            } else {
                int g2Pop;
                int g1Pop = townOne.getNumResidents();
                if (g1Pop < (g2Pop = townTwo.getNumResidents())) {
                    result = 1;
                } else if (g1Pop > g2Pop) {
                    result = -1;
                }
            }
            return result;
        };
        this.kingdomComparator = (kingdomOne, kingdomTwo) -> {
            int g2Land;
            int result = 0;
            int g1Land = kingdomOne.getNumLand();
            if (g1Land < (g2Land = kingdomTwo.getNumLand())) {
                result = 1;
            } else if (g1Land > g2Land) {
                result = -1;
            } else {
                int g2Pop;
                int g1Pop = kingdomOne.getNumMembers();
                if (g1Pop < (g2Pop = kingdomTwo.getNumMembers())) {
                    result = 1;
                } else if (g1Pop > g2Pop) {
                    result = -1;
                }
            }
            return result;
        };
        this.townNameComparator = (townOne, townTwo) -> {
            String s1 = townOne.getName();
            String s2 = townTwo.getName();
            assert (s1 != null);
            assert (s2 != null);
            return s1.toLowerCase().compareTo(s2.toLowerCase());
        };
        this.kingdomNameComparator = (kingdomOne, kingdomTwo) -> {
            String s1 = kingdomOne.getName();
            String s2 = kingdomTwo.getName();
            assert (s1 != null);
            assert (s2 != null);
            return s1.toLowerCase().compareTo(s2.toLowerCase());
        };
        this.campComparator = (campOne, campTwo) -> {
            String s1 = campOne.getOwner().getName();
            String s2 = campTwo.getOwner().getName();
            assert (s1 != null);
            assert (s2 != null);
            return s1.toLowerCase().compareTo(s2.toLowerCase());
        };
        this.ruinComparator = (ruinOne, ruinTwo) -> {
            String s1 = ruinOne.getName();
            String s2 = ruinTwo.getName();
            assert (s1 != null);
            assert (s2 != null);
            return s1.toLowerCase().compareTo(s2.toLowerCase());
        };
        this.sanctuaryComparator = (sanctuaryOne, sanctuaryTwo) -> {
            String s1 = sanctuaryOne.getName();
            String s2 = sanctuaryTwo.getName();
            assert (s1 != null);
            assert (s2 != null);
            return s1.toLowerCase().compareTo(s2.toLowerCase());
        };
        this.templateComparator = (templateOne, templateTwo) -> {
            String s1 = templateOne.getName();
            String s2 = templateTwo.getName();
            assert (s1 != null);
            assert (s2 != null);
            return s1.toLowerCase().compareTo(s2.toLowerCase());
        };
        this.playerComparator = (playerOne, playerTwo) -> {
            String s1 = playerOne.getOfflineBukkitPlayer().getName();
            String s2 = playerTwo.getOfflineBukkitPlayer().getName();
            assert (s1 != null);
            assert (s2 != null);
            return s1.toLowerCase().compareTo(s2.toLowerCase());
        };
        this.prefixComparator = (prefixOne, prefixTwo) -> {
            int result = 0;
            if (prefixOne.level() < prefixTwo.level()) {
                result = -1;
            } else if (prefixOne.level() > prefixTwo.level()) {
                result = 1;
            }
            return result;
        };
        this.playerScoreComparator = (playerOne, playerTwo) -> {
            int scoreOne = konquest.getKingdomManager().getPlayerScore((KonOfflinePlayer)playerOne);
            int scoreTwo = konquest.getKingdomManager().getPlayerScore((KonOfflinePlayer)playerTwo);
            int result = 0;
            if (scoreOne < scoreTwo) {
                result = 1;
            } else if (scoreOne > scoreTwo) {
                result = -1;
            }
            return result;
        };
        this.kingdomScoreComparator = (kingdomOne, kingdomTwo) -> {
            int scoreOne = konquest.getKingdomManager().getKingdomScore((KonKingdom)kingdomOne);
            int scoreTwo = konquest.getKingdomManager().getKingdomScore((KonKingdom)kingdomTwo);
            int result = 0;
            if (scoreOne < scoreTwo) {
                result = 1;
            } else if (scoreOne > scoreTwo) {
                result = -1;
            }
            return result;
        };
        this.eventStartComparator = (eventOne, eventTwo) -> {
            long startOne = eventOne.getStartTime();
            long startTwo = eventTwo.getStartTime();
            int result = 0;
            if (startOne < startTwo) {
                result = 1;
            } else if (startOne > startTwo) {
                result = -1;
            }
            return result;
        };
    }

    public Konquest getKonquest() {
        return this.konquest;
    }

    public State getCurrentState() {
        return this.currentState;
    }

    public Access getAccess() {
        return this.menuAccess;
    }

    public void setAccess(Access access) {
        this.menuAccess = access;
    }

    public boolean isAccess(Access checkAccess) {
        return this.menuAccess.equals(checkAccess);
    }

    public boolean isState(State checkState) {
        return this.currentState.equals(checkState);
    }

    public abstract ArrayList<DisplayView> createView(State var1);

    public abstract DisplayView updateState(int var1, boolean var2);

    public DisplayView setCurrentView(State context) {
        return this.setCurrentView(context, false);
    }

    public DisplayView refreshCurrentView() {
        return this.setCurrentView(this.currentState, true);
    }

    public DisplayView refreshNewView(State context) {
        return this.setCurrentView(context, true);
    }

    private DisplayView setCurrentView(State context, boolean refresh) {
        if (!this.hasView(context) || refresh) {
            this.viewPages.put(context, this.createView(context));
        }
        this.currentState = context;
        this.currentPage = 0;
        DisplayView view = this.getCurrentView();
        if (view != null) {
            view.updateIcons();
        }
        return view;
    }

    public int getCurrentNumPages() {
        return this.getCurrentViewPages() == null ? 0 : this.getCurrentViewPages().size();
    }

    @Nullable
    public ArrayList<DisplayView> getCurrentViewPages() {
        return this.viewPages.get(this.currentState);
    }

    @Nullable
    public DisplayView getCurrentView() {
        DisplayView view = null;
        if (this.getCurrentViewPages() != null && !this.getCurrentViewPages().isEmpty() && this.currentPage < this.getCurrentNumPages()) {
            view = this.getCurrentViewPages().get(this.currentPage);
        }
        return view;
    }

    public boolean hasView(State checkState) {
        return this.viewPages.containsKey(checkState);
    }

    public void stopIconUpdates() {
        for (ArrayList<DisplayView> pages : this.viewPages.values()) {
            for (DisplayView view : pages) {
                view.clearUpdates();
            }
        }
    }

    protected boolean isCurrentNavSlot(int slot) {
        DisplayView view = this.getCurrentView();
        if (view == null) {
            return false;
        }
        int invSize = view.getInventory().getSize();
        int navStop = Math.max(invSize - 1, 0);
        int navStart = Math.max(invSize - 9, 0);
        return slot <= navStop && slot >= navStart;
    }

    protected boolean isCurrentMenuSlot(int slot) {
        DisplayView view = this.getCurrentView();
        if (view == null) {
            return false;
        }
        int invSize = view.getInventory().getSize();
        int navStart = Math.max(invSize - 9, 0);
        return slot < navStart;
    }

    protected int getCurrentNavIndex(int slot) {
        DisplayView view = this.getCurrentView();
        if (view == null) {
            return 0;
        }
        int invSize = view.getInventory().getSize();
        int navStart = Math.max(invSize - 9, 0);
        return Math.min(Math.max(slot - navStart, 0), 8);
    }

    protected int getNavStartSlot(DisplayView view) {
        if (view == null) {
            return 0;
        }
        int navStart = view.getInventory().getSize() - 9;
        return Math.max(navStart, 0);
    }

    public void addNavClose(DisplayView view) {
        if (view == null) {
            return;
        }
        view.addIcon(this.navIconClose(this.getNavStartSlot(view) + 4));
    }

    public void addNavReturn(DisplayView view) {
        if (view == null) {
            return;
        }
        view.addIcon(this.navIconReturn(this.getNavStartSlot(view) + 5));
    }

    public void addNavHome(DisplayView view) {
        if (view == null) {
            return;
        }
        view.addIcon(this.navIconHome(this.getNavStartSlot(view) + 3));
    }

    public void addNavBack(DisplayView view) {
        if (view == null) {
            return;
        }
        view.addIcon(this.navIconBack(this.getNavStartSlot(view) + 0));
    }

    public void addNavNext(DisplayView view) {
        if (view == null) {
            return;
        }
        view.addIcon(this.navIconNext(this.getNavStartSlot(view) + 8));
    }

    public void addNavEmpty(DisplayView view) {
        int start;
        if (view == null) {
            return;
        }
        for (int i = start = this.getNavStartSlot(view); i < start + 9; ++i) {
            view.addIcon(this.navIconEmpty(i));
        }
    }

    protected boolean isNavIndex(int slot, int index) {
        if (this.isCurrentNavSlot(slot)) {
            int navIndex = this.getCurrentNavIndex(slot);
            return navIndex == index;
        }
        return false;
    }

    protected boolean isNavClose(int slot) {
        return this.isNavIndex(slot, 4);
    }

    protected boolean isNavReturn(int slot) {
        return this.isNavIndex(slot, 5);
    }

    protected boolean isNavHome(int slot) {
        return this.isNavIndex(slot, 3);
    }

    protected boolean isNavBack(int slot) {
        return this.isNavIndex(slot, 0);
    }

    protected boolean isNavNext(int slot) {
        return this.isNavIndex(slot, 8);
    }

    protected int getTotalPages(int numElements) {
        int pageTotal = (int)Math.ceil((double)numElements / 45.0);
        pageTotal = Math.max(pageTotal, 1);
        return pageTotal;
    }

    protected int getNumPageRows(int numElements, int pageIndex) {
        int numPageRows = (int)Math.ceil((double)(numElements - pageIndex * 45) / 9.0);
        numPageRows = Math.max(numPageRows, 1);
        numPageRows = Math.min(numPageRows, 5);
        return numPageRows;
    }

    protected DisplayView goPageBack() {
        this.currentPage = Math.max(this.currentPage - 1, 0);
        DisplayView view = this.getCurrentView();
        if (view != null) {
            view.updateIcons();
        }
        return view;
    }

    protected DisplayView goPageNext() {
        this.currentPage = Math.min(this.currentPage + 1, this.getCurrentNumPages());
        DisplayView view = this.getCurrentView();
        if (view != null) {
            view.updateIcons();
        }
        return view;
    }

    protected ArrayList<DisplayView> makePages(List<MenuIcon> icons, String baseTitle) {
        ArrayList<DisplayView> result = new ArrayList<DisplayView>();
        ListIterator<MenuIcon> iconIter = icons.listIterator();
        int numIcons = icons.size();
        int pageTotal = this.getTotalPages(numIcons);
        for (int i = 0; i < pageTotal; ++i) {
            int pageRows = this.getNumPageRows(numIcons, i);
            Object pageLabel = pageTotal > 1 ? baseTitle + " " + (i + 1) + "/" + pageTotal : baseTitle;
            DisplayView page = new DisplayView(pageRows, (String)pageLabel);
            for (int slotIndex = 0; slotIndex < 45 && iconIter.hasNext(); ++slotIndex) {
                MenuIcon icon = iconIter.next();
                icon.setIndex(slotIndex);
                page.addIcon(icon);
            }
            this.addNavEmpty(page);
            this.addNavClose(page);
            this.addNavReturn(page);
            if (i > 0) {
                this.addNavBack(page);
            }
            if (i < pageTotal - 1) {
                this.addNavNext(page);
            }
            result.add(page);
        }
        return result;
    }

    protected InfoIcon navIconClose(int index) {
        return new InfoIcon(String.valueOf(ChatColor.GOLD) + MessagePath.LABEL_CLOSE.getMessage(new Object[0]), Material.STRUCTURE_VOID, index, true);
    }

    protected InfoIcon navIconBack(int index) {
        return new InfoIcon(String.valueOf(ChatColor.GOLD) + MessagePath.LABEL_BACK.getMessage(new Object[0]), Material.ENDER_PEARL, index, true);
    }

    protected InfoIcon navIconNext(int index) {
        return new InfoIcon(String.valueOf(ChatColor.GOLD) + MessagePath.LABEL_NEXT.getMessage(new Object[0]), Material.ENDER_PEARL, index, true);
    }

    protected InfoIcon navIconReturn(int index) {
        return new InfoIcon(String.valueOf(ChatColor.GOLD) + MessagePath.LABEL_RETURN.getMessage(new Object[0]), Material.FIREWORK_ROCKET, index, true);
    }

    protected InfoIcon navIconHome(int index) {
        return new InfoIcon(String.valueOf(ChatColor.GOLD) + MessagePath.MENU_MAIN_TITLE.getMessage(new Object[0]), Material.BELL, index, true);
    }

    protected InfoIcon navIconEmpty(int index) {
        return new InfoIcon(" ", Material.GRAY_STAINED_GLASS_PANE, index, false);
    }

    protected void playStatusSound(Player bukkitPlayer, boolean status) {
        if (status) {
            Konquest.playSuccessSound(bukkitPlayer);
        } else {
            Konquest.playFailSound(bukkitPlayer);
        }
    }

    protected String getColor(KonOfflinePlayer displayPlayer, KonOfflinePlayer targetPlayer) {
        return this.konquest.getDisplaySecondaryColor((KonquestOfflinePlayer)displayPlayer, targetPlayer);
    }

    protected String getColor(KonOfflinePlayer displayPlayer, KonTown targetTown) {
        return this.konquest.getDisplaySecondaryColor((KonquestOfflinePlayer)displayPlayer, targetTown);
    }

    protected String getColor(KonOfflinePlayer displayPlayer, KonKingdom targetKingdom) {
        return this.konquest.getDisplaySecondaryColor(displayPlayer.getKingdom(), targetKingdom);
    }

    protected String getColor(KonKingdom displayKingdom, KonKingdom targetKingdom) {
        return this.konquest.getDisplaySecondaryColor(displayKingdom, targetKingdom);
    }

    protected KonquestRelationshipType getRelation(KonOfflinePlayer displayPlayer, KonOfflinePlayer targetPlayer) {
        return this.konquest.getKingdomManager().getRelationRole(displayPlayer.getKingdom(), targetPlayer.getKingdom());
    }

    protected KonquestRelationshipType getRelation(KonOfflinePlayer displayPlayer, KonTown targetTown) {
        return this.konquest.getKingdomManager().getRelationRole(displayPlayer.getKingdom(), targetTown.getKingdom());
    }

    protected KonquestRelationshipType getRelation(KonOfflinePlayer displayPlayer, KonKingdom targetKingdom) {
        return this.konquest.getKingdomManager().getRelationRole(displayPlayer.getKingdom(), targetKingdom);
    }

    protected KonquestRelationshipType getRelation(KonKingdom displayKingdom, KonKingdom targetKingdom) {
        return this.konquest.getKingdomManager().getRelationRole(displayKingdom, targetKingdom);
    }

    public static interface State {
    }

    public static interface Access {
    }
}

