/*
 * Decompiled with CFR 0.152.
 */
package com.github.rumsfield.konquest.display.icon;

import com.github.rumsfield.konquest.command.admin.AdminCommandType;
import com.github.rumsfield.konquest.display.icon.MenuIcon;
import com.github.rumsfield.konquest.manager.DisplayManager;
import com.github.rumsfield.konquest.utility.CompatibilityUtil;
import com.github.rumsfield.konquest.utility.MessagePath;
import org.bukkit.inventory.ItemStack;

public class AdminCommandIcon
extends MenuIcon {
    private final AdminCommandType command;
    private final boolean permission;

    public AdminCommandIcon(AdminCommandType command, boolean permission, int index) {
        super(index);
        this.command = command;
        this.permission = permission;
        if (!permission) {
            this.addAlert(MessagePath.LABEL_NO_PERMISSION.getMessage(new Object[0]));
        }
        this.addDescription(command.description());
    }

    public AdminCommandType getCommand() {
        return this.command;
    }

    @Override
    public String getName() {
        return DisplayManager.adminFormat + this.command.toString();
    }

    @Override
    public ItemStack getItem() {
        return CompatibilityUtil.buildItem(this.command.iconMaterial(), this.getName(), this.getLore());
    }

    @Override
    public boolean isClickable() {
        return this.permission;
    }
}

