/*
 * Decompiled with CFR 0.152.
 */
package com.github.rumsfield.konquest.display.icon;

import com.github.rumsfield.konquest.KonquestPlugin;
import com.github.rumsfield.konquest.display.icon.MenuIcon;
import com.github.rumsfield.konquest.manager.DisplayManager;
import com.github.rumsfield.konquest.model.KonArmor;
import com.github.rumsfield.konquest.utility.CompatibilityUtil;
import com.github.rumsfield.konquest.utility.MessagePath;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;

public class ArmorIcon
extends MenuIcon {
    private final KonArmor armor;

    public ArmorIcon(KonArmor armor, int cost, int index) {
        super(index);
        this.armor = armor;
        this.addNameValue(MessagePath.LABEL_ARMOR.getMessage(new Object[0]), String.valueOf(ChatColor.DARK_AQUA) + armor.getBlocks());
        this.addNameValue(MessagePath.LABEL_COST.getMessage(new Object[0]), KonquestPlugin.getCurrencyFormat(cost));
        this.addHint(MessagePath.MENU_HINT_CHARGE.getMessage(new Object[0]));
    }

    public KonArmor getArmor() {
        return this.armor;
    }

    @Override
    public String getName() {
        return DisplayManager.nameFormat + this.armor.getId() + " " + MessagePath.LABEL_ARMOR.getMessage(new Object[0]);
    }

    @Override
    public ItemStack getItem() {
        return CompatibilityUtil.buildItem(Material.CHAINMAIL_CHESTPLATE, this.getName(), this.getLore(), true);
    }

    @Override
    public boolean isClickable() {
        return true;
    }
}

