/*
 * Decompiled with CFR 0.152.
 */
package com.github.rumsfield.konquest.display.icon;

import com.github.rumsfield.konquest.Konquest;
import com.github.rumsfield.konquest.display.icon.MenuIcon;
import com.github.rumsfield.konquest.model.KonCamp;
import com.github.rumsfield.konquest.utility.CompatibilityUtil;
import com.github.rumsfield.konquest.utility.MessagePath;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;

public class CampIcon
extends MenuIcon {
    private final KonCamp camp;
    private final boolean isClickable;

    public CampIcon(KonCamp camp, int index, boolean isClickable) {
        super(index);
        this.camp = camp;
        this.isClickable = isClickable;
        this.addProperty(MessagePath.TERRITORY_CAMP.getMessage(new Object[0]));
        if (camp.isProtected()) {
            this.addAlert(MessagePath.LABEL_PROTECTED.getMessage(new Object[0]));
        }
        this.addNameValue(MessagePath.LABEL_OWNER.getMessage(new Object[0]), camp.getOwner().getName());
    }

    public KonCamp getCamp() {
        return this.camp;
    }

    @Override
    public String getName() {
        return Konquest.barbarianColor2 + this.camp.getName();
    }

    @Override
    public ItemStack getItem() {
        return CompatibilityUtil.buildItem(Material.ORANGE_BED, this.getName(), this.getLore(), this.camp.isProtected());
    }

    @Override
    public boolean isClickable() {
        return this.isClickable;
    }
}

