/*
 * Decompiled with CFR 0.152.
 */
package com.github.rumsfield.konquest.display.icon;

import com.github.rumsfield.konquest.KonquestPlugin;
import com.github.rumsfield.konquest.command.CommandType;
import com.github.rumsfield.konquest.display.icon.MenuIcon;
import com.github.rumsfield.konquest.manager.DisplayManager;
import com.github.rumsfield.konquest.utility.CompatibilityUtil;
import com.github.rumsfield.konquest.utility.MessagePath;
import org.bukkit.inventory.ItemStack;

public class CommandIcon
extends MenuIcon {
    private final CommandType command;
    private final boolean permission;

    public CommandIcon(CommandType command, boolean permission, int cost, int cost_incr, int index) {
        super(index);
        this.command = command;
        this.permission = permission;
        if (!permission) {
            this.addAlert(MessagePath.LABEL_NO_PERMISSION.getMessage(new Object[0]));
        }
        if (cost > 0) {
            this.addNameValue(MessagePath.LABEL_COST.getMessage(new Object[0]), KonquestPlugin.getCurrencyFormat(cost));
        }
        if (cost_incr > 0) {
            this.addNameValue(MessagePath.LABEL_INCREMENT_COST.getMessage(new Object[0]), cost_incr);
        }
        this.addDescription(command.description());
    }

    public CommandType getCommand() {
        return this.command;
    }

    @Override
    public String getName() {
        return DisplayManager.nameFormat + this.command.toString();
    }

    @Override
    public ItemStack getItem() {
        return CompatibilityUtil.buildItem(this.command.iconMaterial(), this.getName(), this.getLore());
    }

    @Override
    public boolean isClickable() {
        return this.permission;
    }
}

