/*
 * Decompiled with CFR 0.152.
 */
package com.github.rumsfield.konquest.display.icon;

import com.github.rumsfield.konquest.Konquest;
import com.github.rumsfield.konquest.api.model.KonquestDiplomacyType;
import com.github.rumsfield.konquest.display.icon.MenuIcon;
import com.github.rumsfield.konquest.utility.CompatibilityUtil;
import com.github.rumsfield.konquest.utility.Labeler;
import org.bukkit.ChatColor;
import org.bukkit.inventory.ItemStack;

public class DiplomacyIcon
extends MenuIcon {
    private final KonquestDiplomacyType relation;
    private final boolean isClickable;

    public DiplomacyIcon(KonquestDiplomacyType relation, int index, boolean isClickable) {
        super(index);
        this.relation = relation;
        this.isClickable = isClickable;
    }

    public KonquestDiplomacyType getRelation() {
        return this.relation;
    }

    @Override
    public String getName() {
        Object nameColor = String.valueOf(ChatColor.GOLD);
        switch (this.relation) {
            case WAR: {
                nameColor = Konquest.enemyColor2;
                break;
            }
            case PEACE: {
                nameColor = Konquest.peacefulColor2;
                break;
            }
            case TRADE: {
                nameColor = Konquest.tradeColor2;
                break;
            }
            case ALLIANCE: {
                nameColor = Konquest.alliedColor2;
                break;
            }
        }
        return (String)nameColor + Labeler.lookup(this.relation);
    }

    @Override
    public ItemStack getItem() {
        return CompatibilityUtil.buildItem(this.relation.getIcon(), this.getName(), this.getLore());
    }

    @Override
    public boolean isClickable() {
        return this.isClickable;
    }
}

