/*
 * Decompiled with CFR 0.152.
 */
package com.github.rumsfield.konquest.display.icon;

import com.github.rumsfield.konquest.api.model.KonquestRelationshipType;
import com.github.rumsfield.konquest.display.icon.MenuIcon;
import com.github.rumsfield.konquest.model.KonKingdom;
import com.github.rumsfield.konquest.model.KonTown;
import com.github.rumsfield.konquest.utility.CompatibilityUtil;
import com.github.rumsfield.konquest.utility.Labeler;
import com.github.rumsfield.konquest.utility.MessagePath;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;

public class KingdomIcon
extends MenuIcon {
    private final KonKingdom kingdom;
    private final String contextColor;
    private final KonquestRelationshipType relation;
    private final boolean isClickable;

    public KingdomIcon(KonKingdom kingdom, String contextColor, KonquestRelationshipType relation, int index, boolean isClickable) {
        super(index);
        this.kingdom = kingdom;
        this.contextColor = contextColor;
        this.relation = relation;
        this.isClickable = isClickable;
        if (kingdom.isCreated()) {
            if (kingdom.isOfflineProtected()) {
                this.addAlert(MessagePath.LABEL_PROTECTED.getMessage(new Object[0]));
            }
            if (kingdom.isAdminOperated()) {
                this.addProperty(MessagePath.LABEL_ADMIN_KINGDOM.getMessage(new Object[0]));
            } else {
                this.addProperty(MessagePath.LABEL_KINGDOM.getMessage(new Object[0]));
            }
        }
        if (relation != null) {
            this.addProperty(Labeler.lookup(relation));
        }
        if (kingdom.isCreated()) {
            if (kingdom.isPeaceful()) {
                this.addProperty(MessagePath.LABEL_PEACEFUL.getMessage(new Object[0]));
            }
            if (kingdom.isOpen()) {
                this.addProperty(MessagePath.LABEL_OPEN.getMessage(new Object[0]));
            }
            if (kingdom.isSmallest()) {
                this.addProperty(MessagePath.LABEL_SMALLEST.getMessage(new Object[0]));
            }
            int numKingdomLand = 0;
            for (KonTown town : kingdom.getCapitalTowns()) {
                numKingdomLand += town.getNumLand();
            }
            this.addNameValue(MessagePath.LABEL_MEMBERS.getMessage(new Object[0]), kingdom.getNumMembers());
            this.addNameValue(MessagePath.LABEL_TOWNS.getMessage(new Object[0]), kingdom.getNumTowns());
            this.addNameValue(MessagePath.LABEL_LAND.getMessage(new Object[0]), numKingdomLand);
        }
    }

    public KonKingdom getKingdom() {
        return this.kingdom;
    }

    @Override
    public String getName() {
        return this.contextColor + this.kingdom.getName();
    }

    @Override
    public ItemStack getItem() {
        Material iconMat = Material.DIAMOND_HELMET;
        if (this.relation != null) {
            switch (this.relation) {
                case FRIENDLY: {
                    iconMat = Material.GOLDEN_HELMET;
                    break;
                }
                case BARBARIAN: {
                    iconMat = Material.STONE_AXE;
                }
            }
        }
        return CompatibilityUtil.buildItem(iconMat, this.getName(), this.getLore(), this.kingdom.isOfflineProtected());
    }

    @Override
    public boolean isClickable() {
        return this.isClickable;
    }
}

