/*
 * Decompiled with CFR 0.152.
 */
package com.github.rumsfield.konquest.display.icon;

import com.github.rumsfield.konquest.display.StateMenu;
import com.github.rumsfield.konquest.manager.DisplayManager;
import com.github.rumsfield.konquest.utility.HelperUtil;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.bukkit.ChatColor;
import org.bukkit.inventory.ItemStack;

public abstract class MenuIcon {
    private int index;
    private StateMenu.State state;
    private final List<String> alerts;
    private final List<String> properties;
    private final List<String> values;
    private final List<String> descriptions;
    private final List<String> hints;

    public MenuIcon(int index) {
        this.index = index;
        this.state = null;
        this.alerts = new ArrayList<String>();
        this.properties = new ArrayList<String>();
        this.values = new ArrayList<String>();
        this.descriptions = new ArrayList<String>();
        this.hints = new ArrayList<String>();
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int val) {
        this.index = val;
    }

    @Nullable
    public StateMenu.State getState() {
        return this.state;
    }

    public void setState(StateMenu.State state) {
        this.state = state;
    }

    public void addAlert(String alert) {
        this.alerts.addAll(HelperUtil.stringPaginate(alert, DisplayManager.alertFormat));
    }

    public void addProperty(String property) {
        this.properties.addAll(HelperUtil.stringPaginate(property, DisplayManager.propertyFormat));
    }

    public void addNameValue(String name, String value) {
        this.values.add(DisplayManager.loreFormat + name + ": " + DisplayManager.valueFormat + value);
    }

    public void addNameValue(String name, int value) {
        this.values.add(DisplayManager.loreFormat + name + ": " + DisplayManager.valueFormat + value);
    }

    public void addDescription(String description) {
        this.descriptions.addAll(HelperUtil.stringPaginate(description, DisplayManager.loreFormat));
    }

    public void addDescription(String description, ChatColor color) {
        this.descriptions.addAll(HelperUtil.stringPaginate(description, color));
    }

    public void addDescription(String description, String color) {
        this.descriptions.addAll(HelperUtil.stringPaginate(description, color));
    }

    public void addDescriptionSingle(String description) {
        this.descriptions.add(description);
    }

    public void addError(String description) {
        this.descriptions.addAll(HelperUtil.stringPaginate(description, DisplayManager.errorFormat));
    }

    public void addHint(String hint) {
        this.hints.addAll(HelperUtil.stringPaginate(hint, DisplayManager.hintFormat));
    }

    public List<String> getLore() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.addAll(this.alerts);
        lore.addAll(this.properties);
        lore.addAll(this.values);
        lore.addAll(this.descriptions);
        lore.addAll(this.hints);
        return lore;
    }

    public abstract String getName();

    public abstract ItemStack getItem();

    public abstract boolean isClickable();
}

