/*
 * Decompiled with CFR 0.152.
 */
package com.github.rumsfield.konquest.display.icon;

import com.github.rumsfield.konquest.Konquest;
import com.github.rumsfield.konquest.display.icon.MenuIcon;
import com.github.rumsfield.konquest.model.KonRuin;
import com.github.rumsfield.konquest.utility.CompatibilityUtil;
import com.github.rumsfield.konquest.utility.MessagePath;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;

public class RuinIcon
extends MenuIcon {
    private final KonRuin ruin;
    private final boolean isClickable;

    public RuinIcon(KonRuin ruin, int index, boolean isClickable) {
        super(index);
        this.ruin = ruin;
        this.isClickable = isClickable;
        this.addProperty(MessagePath.TERRITORY_RUIN.getMessage(new Object[0]));
        if (ruin.isCaptureDisabled()) {
            this.addProperty(MessagePath.LABEL_CAPTURED.getMessage(new Object[0]));
        }
        this.addNameValue(MessagePath.LABEL_WORLD.getMessage(new Object[0]), ruin.getWorld().getName());
    }

    public KonRuin getRuin() {
        return this.ruin;
    }

    @Override
    public String getName() {
        return Konquest.neutralColor2 + this.ruin.getName();
    }

    @Override
    public ItemStack getItem() {
        return CompatibilityUtil.buildItem(Material.MOSSY_COBBLESTONE, this.getName(), this.getLore(), this.ruin.isCaptureDisabled());
    }

    @Override
    public boolean isClickable() {
        return this.isClickable;
    }
}

