/*
 * Decompiled with CFR 0.152.
 */
package com.github.rumsfield.konquest.display.icon;

import com.github.rumsfield.konquest.KonquestPlugin;
import com.github.rumsfield.konquest.display.icon.MenuIcon;
import com.github.rumsfield.konquest.manager.DisplayManager;
import com.github.rumsfield.konquest.model.KonShield;
import com.github.rumsfield.konquest.utility.CompatibilityUtil;
import com.github.rumsfield.konquest.utility.HelperUtil;
import com.github.rumsfield.konquest.utility.MessagePath;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;

public class ShieldIcon
extends MenuIcon {
    private final KonShield shield;

    public ShieldIcon(KonShield shield, int cost, int index) {
        super(index);
        this.shield = shield;
        this.addNameValue(MessagePath.LABEL_SHIELD.getMessage(new Object[0]), HelperUtil.getTimeFormat(shield.getDurationSeconds(), ChatColor.DARK_AQUA));
        this.addNameValue(MessagePath.LABEL_COST.getMessage(new Object[0]), KonquestPlugin.getCurrencyFormat(cost));
        this.addHint(MessagePath.MENU_HINT_CHARGE.getMessage(new Object[0]));
    }

    public KonShield getShield() {
        return this.shield;
    }

    @Override
    public String getName() {
        return DisplayManager.nameFormat + this.shield.getId() + " " + MessagePath.LABEL_SHIELD.getMessage(new Object[0]);
    }

    @Override
    public ItemStack getItem() {
        return CompatibilityUtil.buildItem(Material.SHIELD, this.getName(), this.getLore(), true);
    }

    @Override
    public boolean isClickable() {
        return true;
    }
}

