/*
 * Decompiled with CFR 0.152.
 */
package com.github.rumsfield.konquest.display.icon;

import com.github.rumsfield.konquest.display.icon.MenuIcon;
import com.github.rumsfield.konquest.manager.DisplayManager;
import com.github.rumsfield.konquest.model.KonStatsType;
import com.github.rumsfield.konquest.utility.CompatibilityUtil;
import com.github.rumsfield.konquest.utility.MessagePath;
import org.bukkit.inventory.ItemStack;

public class StatIcon
extends MenuIcon {
    private final boolean isClickable;
    private final KonStatsType stat;

    public StatIcon(KonStatsType stat, int level, int index, boolean isClickable) {
        super(index);
        this.stat = stat;
        this.isClickable = isClickable;
        this.addProperty(stat.getCategory().getTitle());
        this.addDescription(stat.description());
        this.addNameValue(MessagePath.LABEL_TOTAL.getMessage(new Object[0]), level);
    }

    public KonStatsType getStat() {
        return this.stat;
    }

    @Override
    public String getName() {
        return DisplayManager.nameFormat + this.stat.displayName();
    }

    @Override
    public ItemStack getItem() {
        return CompatibilityUtil.buildItem(this.stat.getMaterial(), this.getName(), this.getLore());
    }

    @Override
    public boolean isClickable() {
        return this.isClickable;
    }
}

