/*
 * Decompiled with CFR 0.152.
 */
package com.github.rumsfield.konquest.display.icon;

import com.github.rumsfield.konquest.display.icon.MenuIcon;
import com.github.rumsfield.konquest.manager.DisplayManager;
import com.github.rumsfield.konquest.model.KonMonumentTemplate;
import com.github.rumsfield.konquest.utility.CompatibilityUtil;
import com.github.rumsfield.konquest.utility.MessagePath;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;

public class TemplateIcon
extends MenuIcon {
    private final KonMonumentTemplate template;
    private final boolean isClickable;

    public TemplateIcon(KonMonumentTemplate template, int index, boolean isClickable) {
        super(index);
        this.template = template;
        this.isClickable = isClickable;
        if (template != null) {
            if (!template.isValid()) {
                if (template.isBlanking()) {
                    this.addAlert(MessagePath.LABEL_UNAVAILABLE.getMessage(new Object[0]));
                    this.addDescription(MessagePath.PROTECTION_ERROR_TEMPLATE_MODIFY.getMessage(new Object[0]));
                } else {
                    this.addAlert(MessagePath.LABEL_INVALID.getMessage(new Object[0]));
                }
            }
            this.addProperty(MessagePath.LABEL_MONUMENT_TEMPLATE.getMessage(new Object[0]));
            this.addNameValue(MessagePath.LABEL_CRITICAL_HITS.getMessage(new Object[0]), template.getNumCriticals());
            this.addNameValue(MessagePath.LABEL_LOOT_CHESTS.getMessage(new Object[0]), template.getNumLootChests());
        }
    }

    public KonMonumentTemplate getTemplate() {
        return this.template;
    }

    @Override
    public String getName() {
        Object result = "";
        if (this.template != null) {
            result = DisplayManager.nameFormat + this.template.getName();
        }
        return result;
    }

    @Override
    public ItemStack getItem() {
        return CompatibilityUtil.buildItem(Material.CRAFTING_TABLE, this.getName(), this.getLore());
    }

    @Override
    public boolean isClickable() {
        return this.isClickable;
    }
}

