/*
 * Decompiled with CFR 0.152.
 */
package com.github.rumsfield.konquest.display.icon;

import com.github.rumsfield.konquest.api.model.KonquestRelationshipType;
import com.github.rumsfield.konquest.api.model.KonquestTerritoryType;
import com.github.rumsfield.konquest.display.icon.MenuIcon;
import com.github.rumsfield.konquest.model.KonCapital;
import com.github.rumsfield.konquest.model.KonTown;
import com.github.rumsfield.konquest.utility.CompatibilityUtil;
import com.github.rumsfield.konquest.utility.Labeler;
import com.github.rumsfield.konquest.utility.MessagePath;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;

public class TownIcon
extends MenuIcon {
    private final KonTown town;
    private final String contextColor;
    private final boolean isClickable;
    private final Material material;

    public TownIcon(KonTown town, String contextColor, KonquestRelationshipType relation, int index, boolean isClickable) {
        super(index);
        this.town = town;
        this.contextColor = contextColor;
        this.isClickable = isClickable;
        this.material = town.isAttacked() ? Material.REDSTONE_BLOCK : (town instanceof KonCapital ? (town.getKingdom().isCapitalImmune() ? Material.BEDROCK : (town.isArmored() ? Material.NETHER_BRICKS : Material.NETHERITE_BLOCK)) : (town.isArmored() ? Material.STONE_BRICKS : Material.OBSIDIAN));
        if (town.getTerritoryType().equals((Object)KonquestTerritoryType.CAPITAL) && town.getKingdom().isCapitalImmune()) {
            this.addAlert(MessagePath.LABEL_IMMUNITY.getMessage(new Object[0]));
        }
        if (!town.isLordValid()) {
            this.addAlert(MessagePath.LABEL_NO_LORD.getMessage(new Object[0]));
        }
        if (town.isAttacked()) {
            this.addAlert(MessagePath.PROTECTION_NOTICE_ATTACKED.getMessage(new Object[0]));
        }
        if (town.getTerritoryType().equals((Object)KonquestTerritoryType.CAPITAL)) {
            this.addProperty(MessagePath.TERRITORY_CAPITAL.getMessage(new Object[0]));
        } else {
            this.addProperty(MessagePath.TERRITORY_TOWN.getMessage(new Object[0]));
        }
        if (relation != null) {
            this.addProperty(Labeler.lookup(relation));
        }
        if (town.isOpen()) {
            this.addProperty(MessagePath.LABEL_OPEN.getMessage(new Object[0]));
        }
        if (town.isArmored()) {
            this.addProperty(MessagePath.LABEL_ARMOR.getMessage(new Object[0]));
        }
        if (town.isShielded()) {
            this.addProperty(MessagePath.LABEL_SHIELD.getMessage(new Object[0]));
        }
        this.addNameValue(MessagePath.LABEL_POPULATION.getMessage(new Object[0]), town.getNumResidents());
        this.addNameValue(MessagePath.LABEL_LAND.getMessage(new Object[0]), town.getNumLand());
    }

    public KonTown getTown() {
        return this.town;
    }

    @Override
    public String getName() {
        return this.contextColor + this.town.getName();
    }

    @Override
    public ItemStack getItem() {
        return CompatibilityUtil.buildItem(this.material, this.getName(), this.getLore(), this.town.isShielded());
    }

    @Override
    public boolean isClickable() {
        return this.isClickable;
    }
}

