/*
 * Decompiled with CFR 0.152.
 */
package com.github.rumsfield.konquest.display.icon;

import com.github.rumsfield.konquest.KonquestPlugin;
import com.github.rumsfield.konquest.display.icon.MenuIcon;
import com.github.rumsfield.konquest.manager.DisplayManager;
import com.github.rumsfield.konquest.model.KonUpgrade;
import com.github.rumsfield.konquest.utility.CompatibilityUtil;
import com.github.rumsfield.konquest.utility.MessagePath;
import org.bukkit.inventory.ItemStack;

public class UpgradeIcon
extends MenuIcon {
    private final KonUpgrade upgrade;
    private final int level;

    public UpgradeIcon(KonUpgrade upgrade, int level, int index, int cost, int pop) {
        super(index);
        this.upgrade = upgrade;
        this.level = level;
        this.addNameValue(MessagePath.LABEL_LEVEL.getMessage(new Object[0]), level);
        this.addNameValue(MessagePath.LABEL_COST.getMessage(new Object[0]), KonquestPlugin.getCurrencyFormat(cost));
        this.addNameValue(MessagePath.LABEL_POPULATION.getMessage(new Object[0]), pop);
        this.addDescription(upgrade.getLevelDescription(level));
    }

    public KonUpgrade getUpgrade() {
        return this.upgrade;
    }

    public int getLevel() {
        return this.level;
    }

    @Override
    public String getName() {
        return DisplayManager.nameFormat + this.upgrade.getName();
    }

    @Override
    public ItemStack getItem() {
        return CompatibilityUtil.buildItem(this.upgrade.getIcon(), this.getName(), this.getLore());
    }

    @Override
    public boolean isClickable() {
        return true;
    }
}

