/*
 * Decompiled with CFR 0.152.
 */
package com.github.rumsfield.konquest.display.menu;

import com.github.rumsfield.konquest.Konquest;
import com.github.rumsfield.konquest.display.DisplayView;
import com.github.rumsfield.konquest.display.StateMenu;
import com.github.rumsfield.konquest.display.icon.DateIcon;
import com.github.rumsfield.konquest.display.icon.InfoIcon;
import com.github.rumsfield.konquest.display.icon.MenuIcon;
import com.github.rumsfield.konquest.manager.DisplayManager;
import com.github.rumsfield.konquest.model.KonGlobalEvent;
import com.github.rumsfield.konquest.model.KonGlobalEventEffect;
import com.github.rumsfield.konquest.model.KonPlayer;
import com.github.rumsfield.konquest.utility.ChatUtil;
import com.github.rumsfield.konquest.utility.HelperUtil;
import com.github.rumsfield.konquest.utility.MessagePath;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;

public class EventMenu
extends StateMenu {
    private final KonPlayer player;
    private Date listDate;
    private Calendar calendarView;

    public EventMenu(Konquest konquest, KonPlayer player) {
        super(konquest, MenuState.ROOT, null);
        this.player = player;
        this.listDate = null;
        this.calendarView = null;
        this.setCurrentView(MenuState.ROOT);
    }

    private DisplayView createRootView() {
        if (!this.getKonquest().getGlobalEventManager().isEnabled()) {
            ChatUtil.sendError((CommandSender)this.player.getBukkitPlayer(), MessagePath.GENERIC_ERROR_DISABLED.getMessage(new Object[0]));
            return null;
        }
        int rows = 1;
        int SLOT_ACTIVE_INFO = 0;
        int SLOT_NEXT_INFO = 2;
        int SLOT_CALENDAR = 4;
        int SLOT_LIST_EVENTS = 6;
        int SLOT_LIST_EFFECTS = 8;
        DisplayView result = new DisplayView(rows, this.getTitle(MenuState.ROOT));
        int numEvents = this.getKonquest().getGlobalEventManager().getEventNames().size();
        int numEffects = KonGlobalEventEffect.values().length;
        ArrayList<KonGlobalEvent> activeEvents = this.getKonquest().getGlobalEventManager().getEvents(true);
        KonGlobalEvent nextEvent = this.getKonquest().getGlobalEventManager().getNextEvent();
        InfoIcon icon = new InfoIcon(MessagePath.COMMAND_EVENT_NOTICE_INFO.getMessage(new Object[0]), Material.OAK_SIGN, SLOT_ACTIVE_INFO, false);
        if (activeEvents.isEmpty()) {
            icon.addAlert(MessagePath.COMMAND_EVENT_NOTICE_INFO_NO_ACTIVE.getMessage(new Object[0]));
        } else {
            icon.addDescription(MessagePath.COMMAND_EVENT_NOTICE_INFO_EFFECTS.getMessage(new Object[0]));
            ArrayList<String> enabledEffectNames = new ArrayList<String>();
            for (KonGlobalEventEffect effect : this.getKonquest().getGlobalEventManager().getValidEffects()) {
                enabledEffectNames.add(effect.getTitle());
            }
            String effectListFormat = MessagePath.LABEL_NONE.getMessage(new Object[0]);
            if (!enabledEffectNames.isEmpty()) {
                effectListFormat = HelperUtil.formatCommaSeparatedList(enabledEffectNames);
            }
            icon.addDescription(effectListFormat, DisplayManager.valueFormat);
            icon.addDescription(MessagePath.COMMAND_EVENT_NOTICE_INFO_EVENTS.getMessage(new Object[0]));
            int eventPos = 1;
            for (KonGlobalEvent globalEvent : activeEvents) {
                if (!globalEvent.isEnabled()) continue;
                String eventDescription = eventPos + ") " + globalEvent.getName() + " " + MessagePath.COMMAND_EVENT_NOTICE_ENDS.getMessage(globalEvent.getNextEndDateFormat());
                icon.addDescriptionSingle(DisplayManager.valueFormat + eventDescription);
                ++eventPos;
            }
        }
        result.addIcon(icon);
        icon = new InfoIcon(MessagePath.COMMAND_EVENT_NOTICE_INFO_NEXT.getMessage(new Object[0]), Material.SPRUCE_SIGN, SLOT_NEXT_INFO, false);
        if (nextEvent == null) {
            icon.addAlert(MessagePath.COMMAND_EVENT_NOTICE_INFO_NO_UPCOMING.getMessage(new Object[0]));
        } else {
            String eventDescription = nextEvent.getName() + " " + MessagePath.COMMAND_EVENT_NOTICE_STARTS.getMessage(nextEvent.getNextStartDateFormat());
            icon.addDescriptionSingle(DisplayManager.valueFormat + eventDescription);
        }
        result.addIcon(icon);
        icon = new InfoIcon(MessagePath.MENU_EVENT_CALENDAR.getMessage(new Object[0]), Material.DAYLIGHT_DETECTOR, SLOT_CALENDAR, true);
        icon.addDescription(MessagePath.MENU_EVENT_DESCRIPTION_CALENDAR.getMessage(new Object[0]));
        icon.addHint(MessagePath.MENU_HINT_OPEN.getMessage(new Object[0]));
        icon.setState(MenuState.CALENDAR);
        result.addIcon(icon);
        icon = new InfoIcon(MessagePath.MENU_EVENT_EVENTS.getMessage(new Object[0]), Material.ORANGE_BANNER, SLOT_LIST_EVENTS, true);
        icon.addDescription(MessagePath.MENU_EVENT_DESCRIPTION_EVENTS.getMessage(new Object[0]));
        icon.addNameValue(MessagePath.LABEL_TOTAL.getMessage(new Object[0]), numEvents);
        icon.addHint(MessagePath.MENU_HINT_VIEW.getMessage(new Object[0]));
        icon.setState(MenuState.EVENT_LIST_ALL);
        result.addIcon(icon);
        icon = new InfoIcon(MessagePath.MENU_EVENT_EFFECTS.getMessage(new Object[0]), Material.PURPLE_BANNER, SLOT_LIST_EFFECTS, true);
        icon.addDescription(MessagePath.MENU_EVENT_DESCRIPTION_EFFECTS.getMessage(new Object[0]));
        icon.addNameValue(MessagePath.LABEL_TOTAL.getMessage(new Object[0]), numEffects);
        icon.addHint(MessagePath.MENU_HINT_VIEW.getMessage(new Object[0]));
        icon.setState(MenuState.EFFECT_LIST);
        result.addIcon(icon);
        this.addNavEmpty(result);
        this.addNavClose(result);
        this.addNavHome(result);
        return result;
    }

    private List<DisplayView> createEventView(MenuState context) {
        ArrayList<MenuIcon> icons = new ArrayList<MenuIcon>();
        ArrayList<KonGlobalEvent> events = new ArrayList<KonGlobalEvent>();
        DateFormat dateFormat = DateFormat.getDateInstance(1);
        String viewTitle = this.getTitle(context);
        switch (context.ordinal()) {
            case 2: {
                events.addAll(this.getKonquest().getGlobalEventManager().getEvents(false));
                break;
            }
            case 3: {
                if (this.listDate == null) break;
                events.addAll(this.getKonquest().getGlobalEventManager().getEventsOnDay(this.listDate));
                viewTitle = dateFormat.format(this.listDate);
                break;
            }
            default: {
                return Collections.emptyList();
            }
        }
        events.sort(this.eventStartComparator);
        for (KonGlobalEvent currentEvent : events) {
            Material iconMat = currentEvent.isActive() ? Material.BEACON : Material.GLASS;
            InfoIcon icon = new InfoIcon(currentEvent.getName(), iconMat, 0, false);
            icon.addProperty(MessagePath.MENU_EVENT_GLOBAL_EVENT.getMessage(new Object[0]));
            if (currentEvent.isActive()) {
                icon.addAlert(MessagePath.LABEL_ACTIVE.getMessage(new Object[0]));
            }
            if (!currentEvent.isEnabled()) {
                icon.addAlert(MessagePath.LABEL_DISABLED.getMessage(new Object[0]));
            }
            icon.addNameValue(MessagePath.COMMAND_EVENT_PROPERTY_DURATION.getMessage(new Object[0]), String.format("%.2f", currentEvent.getDurationHours()));
            icon.addNameValue(MessagePath.COMMAND_EVENT_PROPERTY_REPETITION.getMessage(new Object[0]), String.format("%.2f", currentEvent.getRepetitionDays()));
            icon.addNameValue(MessagePath.COMMAND_EVENT_PROPERTY_START_INITIAL.getMessage(new Object[0]), currentEvent.getStartDateFormat());
            icon.addNameValue(MessagePath.COMMAND_EVENT_PROPERTY_START_NEXT.getMessage(new Object[0]), currentEvent.getNextStartDateFormat());
            icon.addNameValue(MessagePath.COMMAND_EVENT_PROPERTY_END_NEXT.getMessage(new Object[0]), currentEvent.getNextEndDateFormat());
            icon.addDescription(MessagePath.MENU_EVENT_EFFECTS.getMessage(new Object[0]), DisplayManager.nameFormat);
            int effectPos = 1;
            for (KonGlobalEventEffect currentEffect : currentEvent.getEffects()) {
                icon.addDescription(effectPos + ") " + currentEffect.getTitle() + " > " + currentEffect.getDescription(), DisplayManager.valueFormat);
                ++effectPos;
            }
            icons.add(icon);
        }
        return new ArrayList<DisplayView>(this.makePages(icons, viewTitle));
    }

    private List<DisplayView> createEffectView() {
        ArrayList<MenuIcon> icons = new ArrayList<MenuIcon>();
        for (KonGlobalEventEffect currentEffect : KonGlobalEventEffect.values()) {
            boolean isValid = this.getKonquest().getGlobalEventManager().isEffectValid(currentEffect);
            Material iconMat = isValid ? Material.EXPERIENCE_BOTTLE : Material.GLASS_BOTTLE;
            InfoIcon icon = new InfoIcon(currentEffect.getTitle(), iconMat, 0, false);
            icon.addProperty(MessagePath.MENU_EVENT_GLOBAL_EFFECT.getMessage(new Object[0]));
            if (isValid) {
                icon.addAlert(MessagePath.LABEL_ACTIVE.getMessage(new Object[0]));
            }
            icon.addDescription(currentEffect.getDescription());
            icons.add(icon);
        }
        return new ArrayList<DisplayView>(this.makePages(icons, this.getTitle(MenuState.EFFECT_LIST)));
    }

    private List<DisplayView> createCalendarView() {
        ArrayList<DisplayView> result = new ArrayList<DisplayView>();
        if (this.calendarView == null) {
            return result;
        }
        Calendar nowCal = Calendar.getInstance();
        String monthName = this.calendarView.getDisplayName(2, 2, Locale.getDefault());
        String yearFormat = "" + this.calendarView.get(1);
        int numDaysInMonth = this.calendarView.getActualMaximum(5);
        DisplayView page = new DisplayView(5, this.getTitle(MenuState.CALENDAR) + " - " + monthName + " " + yearFormat);
        DateFormat dateFormat = DateFormat.getDateInstance(1);
        Calendar dateCal = dateFormat.getCalendar();
        dateCal.set(1, this.calendarView.get(1));
        dateCal.set(2, this.calendarView.get(2));
        dateCal.set(10, 0);
        dateCal.set(12, 0);
        dateCal.set(13, 0);
        dateCal.set(14, 0);
        int iconIndex = 1;
        for (int n = 1; n <= numDaysInMonth; ++n) {
            dateCal.set(5, n);
            Date day = dateCal.getTime();
            String dayFormat = dateFormat.format(day);
            String dayName = dateCal.getDisplayName(7, 2, Locale.getDefault());
            boolean isToday = dateCal.get(1) == nowCal.get(1) && dateCal.get(6) == nowCal.get(6);
            ArrayList<KonGlobalEvent> dayEvents = this.getKonquest().getGlobalEventManager().getEventsOnDay(day);
            boolean isClickable = !dayEvents.isEmpty();
            Material iconMat = isClickable ? Material.GREEN_TERRACOTTA : Material.GRAY_TERRACOTTA;
            DateIcon icon = new DateIcon(dayName, day, iconMat, iconIndex, isToday, isClickable);
            if (isToday) {
                icon.addProperty(MessagePath.MENU_EVENT_TODAY.getMessage(new Object[0]));
            }
            icon.addNameValue(MessagePath.LABEL_DATE.getMessage(new Object[0]), dayFormat);
            if (isClickable) {
                icon.addDescription(MessagePath.MENU_EVENT_EVENTS.getMessage(new Object[0]), DisplayManager.nameFormat);
                int eventPos = 1;
                for (KonGlobalEvent dayEvent : dayEvents) {
                    icon.addDescription(eventPos + ") " + dayEvent.getName(), DisplayManager.valueFormat);
                    ++eventPos;
                }
                icon.addHint(MessagePath.MENU_HINT_VIEW.getMessage(new Object[0]));
            } else {
                icon.addAlert(MessagePath.COMMAND_EVENT_NOTICE_INFO_NO_ACTIVE.getMessage(new Object[0]));
            }
            icon.setState(MenuState.EVENT_LIST_DAY);
            iconIndex = Math.floorMod(iconIndex + 2, 9) == 0 ? (iconIndex += 3) : ++iconIndex;
            page.addIcon(icon);
        }
        this.addNavEmpty(page);
        this.addNavClose(page);
        this.addNavReturn(page);
        this.addNavBack(page);
        this.addNavNext(page);
        result.add(page);
        return result;
    }

    @Override
    public ArrayList<DisplayView> createView(StateMenu.State context) {
        ArrayList<DisplayView> result = new ArrayList<DisplayView>();
        MenuState currentState = (MenuState)context;
        switch (currentState.ordinal()) {
            case 0: {
                result.add(this.createRootView());
                break;
            }
            case 2: 
            case 3: {
                result.addAll(this.createEventView(currentState));
                break;
            }
            case 4: {
                result.addAll(this.createEffectView());
                break;
            }
            case 1: {
                result.addAll(this.createCalendarView());
                break;
            }
        }
        return result;
    }

    @Override
    public DisplayView updateState(int slot, boolean clickType) {
        DisplayView result = null;
        MenuState currentState = (MenuState)this.getCurrentState();
        if (currentState == null) {
            return null;
        }
        if (this.isCurrentNavSlot(slot)) {
            if (this.isNavClose(slot)) {
                return null;
            }
            if (this.isNavHome(slot)) {
                this.getKonquest().getDisplayManager().displayMainMenu(this.player);
            } else if (this.isNavReturn(slot)) {
                if (currentState == MenuState.EVENT_LIST_DAY) {
                    this.listDate = null;
                    result = this.setCurrentView(MenuState.CALENDAR);
                } else {
                    result = this.refreshNewView(MenuState.ROOT);
                }
            } else if (this.isNavBack(slot)) {
                if (currentState == MenuState.CALENDAR) {
                    this.previousMonth();
                    result = this.refreshNewView(MenuState.CALENDAR);
                } else {
                    result = this.goPageBack();
                }
            } else if (this.isNavNext(slot)) {
                if (currentState == MenuState.CALENDAR) {
                    this.nextMonth();
                    result = this.refreshNewView(MenuState.CALENDAR);
                } else {
                    result = this.goPageNext();
                }
            }
        } else if (this.isCurrentMenuSlot(slot)) {
            DisplayView view = this.getCurrentView();
            if (view == null) {
                return null;
            }
            MenuIcon clickedIcon = view.getIcon(slot);
            MenuState nextState = (MenuState)clickedIcon.getState();
            switch (currentState.ordinal()) {
                case 0: {
                    if (nextState == null) {
                        return null;
                    }
                    switch (nextState.ordinal()) {
                        case 1: {
                            this.calendarView = Calendar.getInstance();
                            result = this.refreshNewView(nextState);
                            break;
                        }
                        case 2: 
                        case 4: {
                            result = this.refreshNewView(nextState);
                        }
                    }
                    break;
                }
                case 1: {
                    if (!(clickedIcon instanceof DateIcon)) break;
                    DateIcon icon = (DateIcon)clickedIcon;
                    this.listDate = icon.getDate();
                    if (this.listDate == null) {
                        ChatUtil.printDebug("Failed to get null calendar date for event list");
                    }
                    result = this.refreshNewView(MenuState.EVENT_LIST_DAY);
                    break;
                }
            }
        }
        return result;
    }

    private String getTitle(MenuState context) {
        String result = "error";
        switch (context.ordinal()) {
            case 0: {
                result = MessagePath.MENU_EVENT_TITLE.getMessage(new Object[0]);
                break;
            }
            case 1: {
                result = MessagePath.MENU_EVENT_CALENDAR.getMessage(new Object[0]);
                break;
            }
            case 2: 
            case 3: {
                result = MessagePath.MENU_EVENT_EVENTS.getMessage(new Object[0]);
                break;
            }
            case 4: {
                result = MessagePath.MENU_EVENT_EFFECTS.getMessage(new Object[0]);
                break;
            }
        }
        return result;
    }

    private void nextMonth() {
        if (this.calendarView == null) {
            return;
        }
        this.calendarView.add(2, 1);
    }

    private void previousMonth() {
        if (this.calendarView == null) {
            return;
        }
        this.calendarView.add(2, -1);
    }

    static enum MenuState implements StateMenu.State
    {
        ROOT,
        CALENDAR,
        EVENT_LIST_ALL,
        EVENT_LIST_DAY,
        EFFECT_LIST;

    }
}

