/*
 * Decompiled with CFR 0.152.
 */
package com.github.rumsfield.konquest.display.menu;

import com.github.rumsfield.konquest.Konquest;
import com.github.rumsfield.konquest.command.CommandType;
import com.github.rumsfield.konquest.command.admin.AdminCommandType;
import com.github.rumsfield.konquest.display.DisplayView;
import com.github.rumsfield.konquest.display.StateMenu;
import com.github.rumsfield.konquest.display.icon.AdminCommandIcon;
import com.github.rumsfield.konquest.display.icon.CommandIcon;
import com.github.rumsfield.konquest.display.icon.InfoIcon;
import com.github.rumsfield.konquest.display.icon.MenuIcon;
import com.github.rumsfield.konquest.model.KonPlayer;
import com.github.rumsfield.konquest.utility.ChatUtil;
import com.github.rumsfield.konquest.utility.CorePath;
import com.github.rumsfield.konquest.utility.MessagePath;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;

public class HelpMenu
extends StateMenu {
    private final KonPlayer player;

    public HelpMenu(Konquest konquest, KonPlayer player) {
        super(konquest, MenuState.ROOT, null);
        this.player = player;
        this.setCurrentView(MenuState.ROOT);
    }

    private DisplayView createRootView() {
        int ROOT_SLOT_START = 0;
        int ROOT_SLOT_COMMUNITY = 2;
        int ROOT_SLOT_MAIN = 4;
        int ROOT_SLOT_COMMANDS = 6;
        int ROOT_SLOT_COMMANDS_ADMIN = 8;
        DisplayView result = new DisplayView(1, MessagePath.MENU_MAIN_HELP.getMessage(new Object[0]));
        InfoIcon icon = new InfoIcon(MessagePath.MENU_HELP_START.getMessage(new Object[0]), Material.WOODEN_PICKAXE, ROOT_SLOT_START, true);
        icon.addDescription(MessagePath.MENU_HELP_DESCRIPTION_START.getMessage(new Object[0]));
        icon.addHint(MessagePath.MENU_HINT_OPEN.getMessage(new Object[0]));
        icon.setState(MenuState.START);
        result.addIcon(icon);
        String communityLink = this.getKonquest().getCore().getString(CorePath.COMMUNITY_LINK.getPath(), "");
        InfoIcon communityIcon = new InfoIcon(MessagePath.MENU_HELP_COMMUNITY.getMessage(new Object[0]), Material.MINECART, ROOT_SLOT_COMMUNITY, true);
        communityIcon.addDescription(MessagePath.MENU_HELP_DESCRIPTION_COMMUNITY.getMessage(new Object[0]));
        communityIcon.addHint(MessagePath.MENU_HINT_OPEN.getMessage(new Object[0]));
        communityIcon.setInfo(String.valueOf(ChatColor.LIGHT_PURPLE) + String.valueOf(ChatColor.UNDERLINE) + communityLink);
        communityIcon.setState(MenuState.COMMUNITY);
        result.addIcon(communityIcon);
        icon = new InfoIcon(MessagePath.MENU_HELP_MAIN.getMessage(new Object[0]), CommandType.MENU.iconMaterial(), ROOT_SLOT_MAIN, true);
        icon.addDescription(MessagePath.MENU_HELP_DESCRIPTION_MAIN.getMessage(new Object[0]));
        icon.addHint(MessagePath.MENU_HINT_OPEN.getMessage(new Object[0]));
        icon.setState(MenuState.MAIN);
        result.addIcon(icon);
        icon = new InfoIcon(MessagePath.MENU_HELP_COMMANDS.getMessage(new Object[0]), CommandType.HELP.iconMaterial(), ROOT_SLOT_COMMANDS, true);
        icon.addDescription(MessagePath.MENU_HELP_DESCRIPTION_COMMANDS.getMessage(new Object[0]));
        icon.addHint(MessagePath.MENU_HINT_OPEN.getMessage(new Object[0]));
        icon.setState(MenuState.COMMANDS);
        result.addIcon(icon);
        icon = new InfoIcon(MessagePath.MENU_HELP_ADMIN.getMessage(new Object[0]), CommandType.ADMIN.iconMaterial(), ROOT_SLOT_COMMANDS_ADMIN, true);
        icon.addDescription(MessagePath.MENU_HELP_DESCRIPTION_ADMIN.getMessage(new Object[0]));
        icon.addHint(MessagePath.MENU_HINT_OPEN.getMessage(new Object[0]));
        icon.setState(MenuState.COMMANDS_ADMIN);
        result.addIcon(icon);
        this.addNavEmpty(result);
        this.addNavClose(result);
        return result;
    }

    private DisplayView createStartView() {
        InfoIcon icon;
        int numRows = 1;
        boolean isQuestEnabled = false;
        int START_SLOT_QUEST = 13;
        if (this.getKonquest().getDirectiveManager().isEnabled()) {
            numRows = 2;
            isQuestEnabled = true;
        }
        DisplayView result = new DisplayView(numRows, MessagePath.MENU_HELP_TITLE_START.getMessage(new Object[0]));
        String[] tips = new String[]{MessagePath.MENU_HELP_TIP_1.getMessage(new Object[0]), MessagePath.MENU_HELP_TIP_2.getMessage(new Object[0]), MessagePath.MENU_HELP_TIP_3.getMessage(new Object[0]), MessagePath.MENU_HELP_TIP_4.getMessage(new Object[0]), MessagePath.MENU_HELP_TIP_5.getMessage(new Object[0]), MessagePath.MENU_HELP_TIP_6.getMessage(new Object[0]), MessagePath.MENU_HELP_TIP_7.getMessage(new Object[0]), MessagePath.MENU_HELP_TIP_8.getMessage(new Object[0]), MessagePath.MENU_HELP_TIP_9.getMessage(new Object[0])};
        Material[] iconMaterials = new Material[]{Material.ORANGE_BANNER, Material.YELLOW_BANNER, Material.LIME_BANNER, Material.GREEN_BANNER, Material.CYAN_BANNER, Material.LIGHT_BLUE_BANNER, Material.BLUE_BANNER, Material.PURPLE_BANNER, Material.MAGENTA_BANNER};
        for (int i = 0; i < 9; ++i) {
            icon = new InfoIcon(MessagePath.LABEL_INFORMATION.getMessage(new Object[0]), iconMaterials[i], i, false);
            icon.addDescription(tips[i]);
            result.addIcon(icon);
        }
        if (isQuestEnabled) {
            icon = new InfoIcon(MessagePath.MENU_HELP_QUEST.getMessage(new Object[0]), CommandType.QUEST.iconMaterial(), START_SLOT_QUEST, true);
            icon.addDescription(MessagePath.MENU_HELP_DESCRIPTION_QUEST.getMessage(new Object[0]));
            icon.addHint(MessagePath.MENU_HINT_OPEN.getMessage(new Object[0]));
            icon.setState(MenuState.QUEST);
            result.addIcon(icon);
        }
        this.addNavEmpty(result);
        this.addNavClose(result);
        this.addNavReturn(result);
        return result;
    }

    private List<DisplayView> createCommandView(MenuState context) {
        ArrayList<MenuIcon> commandIcons = new ArrayList<MenuIcon>();
        String title = "";
        switch (context.ordinal()) {
            case 4: {
                title = MessagePath.MENU_HELP_TITLE_COMMANDS.getMessage(new Object[0]);
                double cost_spy = this.getKonquest().getCore().getDouble(CorePath.FAVOR_COST_SPY.getPath(), 0.0);
                double cost_settle = this.getKonquest().getCore().getDouble(CorePath.FAVOR_TOWNS_COST_SETTLE.getPath(), 0.0);
                double cost_settle_incr = this.getKonquest().getCore().getDouble(CorePath.FAVOR_TOWNS_COST_SETTLE_INCREMENT.getPath(), 0.0);
                double cost_claim = this.getKonquest().getCore().getDouble(CorePath.FAVOR_COST_CLAIM.getPath(), 0.0);
                double cost_travel = this.getKonquest().getCore().getDouble(CorePath.FAVOR_COST_TRAVEL.getPath(), 0.0);
                for (CommandType cmd : CommandType.values()) {
                    int cost_incr;
                    int cost;
                    switch (cmd) {
                        case SPY: {
                            cost = (int)cost_spy;
                            cost_incr = 0;
                            break;
                        }
                        case SETTLE: {
                            cost = (int)cost_settle;
                            cost_incr = (int)cost_settle_incr;
                            break;
                        }
                        case CLAIM: {
                            cost = (int)cost_claim;
                            cost_incr = 0;
                            break;
                        }
                        case TRAVEL: {
                            cost = (int)cost_travel;
                            cost_incr = 0;
                            break;
                        }
                        default: {
                            cost = 0;
                            cost_incr = 0;
                        }
                    }
                    boolean isPermission = this.player.getBukkitPlayer().hasPermission(cmd.permission());
                    CommandIcon icon = new CommandIcon(cmd, isPermission, cost, cost_incr, 0);
                    if (isPermission) {
                        icon.addHint(MessagePath.MENU_HINT_VIEW.getMessage(new Object[0]));
                    }
                    commandIcons.add(icon);
                }
                break;
            }
            case 5: {
                title = MessagePath.MENU_HELP_TITLE_ADMIN.getMessage(new Object[0]);
                for (AdminCommandType adminCmd : AdminCommandType.values()) {
                    boolean isPermission = this.player.getBukkitPlayer().hasPermission(adminCmd.permission());
                    AdminCommandIcon icon = new AdminCommandIcon(adminCmd, isPermission, 0);
                    if (isPermission) {
                        icon.addHint(MessagePath.MENU_HINT_VIEW.getMessage(new Object[0]));
                    }
                    commandIcons.add(icon);
                }
                break;
            }
        }
        return new ArrayList<DisplayView>(this.makePages(commandIcons, title));
    }

    @Override
    public ArrayList<DisplayView> createView(StateMenu.State context) {
        ArrayList<DisplayView> result = new ArrayList<DisplayView>();
        switch (((MenuState)context).ordinal()) {
            case 0: {
                result.add(this.createRootView());
                break;
            }
            case 1: {
                result.add(this.createStartView());
                break;
            }
            case 4: {
                result.addAll(this.createCommandView(MenuState.COMMANDS));
                break;
            }
            case 5: {
                result.addAll(this.createCommandView(MenuState.COMMANDS_ADMIN));
                break;
            }
        }
        return result;
    }

    @Override
    public DisplayView updateState(int slot, boolean clickType) {
        DisplayView result = null;
        if (this.isCurrentNavSlot(slot)) {
            if (this.isNavClose(slot)) {
                return null;
            }
            if (this.isNavReturn(slot)) {
                result = this.setCurrentView(MenuState.ROOT);
            } else if (this.isNavBack(slot)) {
                result = this.goPageBack();
            } else if (this.isNavNext(slot)) {
                result = this.goPageNext();
            }
        } else if (this.isCurrentMenuSlot(slot)) {
            DisplayView view = this.getCurrentView();
            if (view == null) {
                return null;
            }
            MenuIcon clickedIcon = view.getIcon(slot);
            MenuState currentState = (MenuState)this.getCurrentState();
            if (currentState == null) {
                return null;
            }
            MenuState nextState = (MenuState)clickedIcon.getState();
            switch (currentState.ordinal()) {
                case 0: {
                    if (nextState == null) {
                        return null;
                    }
                    switch (nextState.ordinal()) {
                        case 1: 
                        case 4: 
                        case 5: {
                            result = this.setCurrentView(nextState);
                            break;
                        }
                        case 2: {
                            if (!(clickedIcon instanceof InfoIcon)) break;
                            ChatUtil.sendNotice((CommandSender)this.player.getBukkitPlayer(), ((InfoIcon)clickedIcon).getInfo());
                            break;
                        }
                        case 3: {
                            this.getKonquest().getDisplayManager().displayMainMenu(this.player);
                        }
                    }
                    break;
                }
                case 1: {
                    if (nextState == null || !nextState.equals(MenuState.QUEST)) break;
                    Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.getKonquest().getPlugin(), () -> this.getKonquest().getDirectiveManager().displayBook(this.player), 5L);
                    break;
                }
                case 4: {
                    if (clickedIcon instanceof CommandIcon) {
                        CommandIcon icon = (CommandIcon)clickedIcon;
                        for (String usageLine : icon.getCommand().argumentUsage()) {
                            ChatUtil.sendNotice((CommandSender)this.player.getBukkitPlayer(), usageLine);
                        }
                    }
                    result = view;
                    break;
                }
                case 5: {
                    if (clickedIcon instanceof AdminCommandIcon) {
                        AdminCommandIcon icon = (AdminCommandIcon)clickedIcon;
                        for (String usageLine : icon.getCommand().argumentUsage()) {
                            ChatUtil.sendNotice((CommandSender)this.player.getBukkitPlayer(), usageLine);
                        }
                    }
                    result = view;
                    break;
                }
            }
        }
        return result;
    }

    static enum MenuState implements StateMenu.State
    {
        ROOT,
        START,
        COMMUNITY,
        MAIN,
        COMMANDS,
        COMMANDS_ADMIN,
        QUEST;

    }
}

