/*
 * Decompiled with CFR 0.152.
 */
package com.github.rumsfield.konquest.display.menu;

import com.github.rumsfield.konquest.Konquest;
import com.github.rumsfield.konquest.KonquestPlugin;
import com.github.rumsfield.konquest.api.model.KonquestDiplomacyType;
import com.github.rumsfield.konquest.api.model.KonquestRelationshipType;
import com.github.rumsfield.konquest.api.model.KonquestTerritoryType;
import com.github.rumsfield.konquest.command.CommandType;
import com.github.rumsfield.konquest.display.DisplayView;
import com.github.rumsfield.konquest.display.StateMenu;
import com.github.rumsfield.konquest.display.icon.CampIcon;
import com.github.rumsfield.konquest.display.icon.DiplomacyIcon;
import com.github.rumsfield.konquest.display.icon.InfoIcon;
import com.github.rumsfield.konquest.display.icon.KingdomIcon;
import com.github.rumsfield.konquest.display.icon.MenuIcon;
import com.github.rumsfield.konquest.display.icon.OptionIcon;
import com.github.rumsfield.konquest.display.icon.PlayerIcon;
import com.github.rumsfield.konquest.display.icon.ProfessionIcon;
import com.github.rumsfield.konquest.display.icon.RuinIcon;
import com.github.rumsfield.konquest.display.icon.SanctuaryIcon;
import com.github.rumsfield.konquest.display.icon.StatIcon;
import com.github.rumsfield.konquest.display.icon.TemplateIcon;
import com.github.rumsfield.konquest.display.icon.TownIcon;
import com.github.rumsfield.konquest.manager.DisplayManager;
import com.github.rumsfield.konquest.model.KonCamp;
import com.github.rumsfield.konquest.model.KonCampGroup;
import com.github.rumsfield.konquest.model.KonKingdom;
import com.github.rumsfield.konquest.model.KonMonumentTemplate;
import com.github.rumsfield.konquest.model.KonOfflinePlayer;
import com.github.rumsfield.konquest.model.KonPlayer;
import com.github.rumsfield.konquest.model.KonPropertyFlag;
import com.github.rumsfield.konquest.model.KonRuin;
import com.github.rumsfield.konquest.model.KonSanctuary;
import com.github.rumsfield.konquest.model.KonStats;
import com.github.rumsfield.konquest.model.KonStatsType;
import com.github.rumsfield.konquest.model.KonTown;
import com.github.rumsfield.konquest.model.KonTownOption;
import com.github.rumsfield.konquest.model.KonUpgrade;
import com.github.rumsfield.konquest.utility.ChatUtil;
import com.github.rumsfield.konquest.utility.CompatibilityUtil;
import com.github.rumsfield.konquest.utility.CorePath;
import com.github.rumsfield.konquest.utility.HelperUtil;
import com.github.rumsfield.konquest.utility.Labeler;
import com.github.rumsfield.konquest.utility.MessagePath;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;

public class InfoMenu
extends StateMenu {
    private final Material flagMaterial = Material.ORANGE_BANNER;
    private final Material propMaterial = Material.PAPER;
    private final HashMap<MenuState, MenuState> returnStack;
    private final KonPlayer player;
    private KonOfflinePlayer infoPlayer;
    private KonKingdom infoKingdom;
    private KonTown infoTown;
    private KonCamp infoCamp;
    private KonRuin infoRuin;
    private KonSanctuary infoSanctuary;
    private KonMonumentTemplate infoTemplate;

    public InfoMenu(Konquest konquest, KonPlayer player) {
        super(konquest, MenuState.ROOT, null);
        this.player = player;
        this.infoPlayer = null;
        this.infoKingdom = null;
        this.infoTown = null;
        this.infoCamp = null;
        this.infoRuin = null;
        this.infoSanctuary = null;
        this.infoTemplate = null;
        this.returnStack = new HashMap();
        this.setCurrentView(MenuState.ROOT);
    }

    public void goToPlayerInfo(KonOfflinePlayer player) {
        this.infoPlayer = player;
        this.refreshNewView(MenuState.PLAYER_INFO);
    }

    public void goToKingdomInfo(KonKingdom kingdom) {
        this.infoKingdom = kingdom;
        this.refreshNewView(MenuState.KINGDOM_INFO);
    }

    public void goToTownInfo(KonTown town) {
        this.infoTown = town;
        this.refreshNewView(MenuState.TOWN_INFO);
    }

    public void goToCampInfo(KonCamp camp) {
        this.infoCamp = camp;
        this.refreshNewView(MenuState.CAMP_INFO);
    }

    public void goToRuinInfo(KonRuin ruin) {
        this.infoRuin = ruin;
        this.refreshNewView(MenuState.RUIN_INFO);
    }

    public void goToSanctuaryInfo(KonSanctuary sanctuary) {
        this.infoSanctuary = sanctuary;
        this.refreshNewView(MenuState.SANCTUARY_INFO);
    }

    public void goToTemplateInfo(KonMonumentTemplate template) {
        this.infoTemplate = template;
        this.refreshNewView(MenuState.MONUMENT_INFO);
    }

    public void goToTemplateListInfo() {
        this.refreshNewView(MenuState.MONUMENT_LIST);
    }

    private DisplayView createRootView() {
        int ROOT_SLOT_PLAYERS = 1;
        int ROOT_SLOT_KINGDOMS = 3;
        int ROOT_SLOT_CAMPS = 5;
        int ROOT_SLOT_RUINS = 7;
        int ROOT_SLOT_CAPITALS = 9;
        int ROOT_SLOT_TOWNS = 11;
        int ROOT_SLOT_SANCTUARIES = 15;
        int ROOT_SLOT_MONUMENTS = 17;
        DisplayView result = new DisplayView(2, this.getTitle(MenuState.ROOT));
        InfoIcon icon = new InfoIcon(MessagePath.LABEL_PLAYERS.getMessage(new Object[0]), Material.PLAYER_HEAD, ROOT_SLOT_PLAYERS, true);
        icon.addProperty(MessagePath.LABEL_INFORMATION.getMessage(new Object[0]));
        int numPlayers = this.getKonquest().getPlayerManager().getAllKonquestOfflinePlayers().size();
        icon.addNameValue(MessagePath.LABEL_TOTAL.getMessage(new Object[0]), numPlayers);
        icon.addHint(MessagePath.MENU_HINT_OPEN.getMessage(new Object[0]));
        icon.setState(MenuState.PLAYER_LIST);
        result.addIcon(icon);
        icon = new InfoIcon(MessagePath.LABEL_KINGDOMS.getMessage(new Object[0]), Material.DIAMOND_HELMET, ROOT_SLOT_KINGDOMS, true);
        icon.addProperty(MessagePath.LABEL_INFORMATION.getMessage(new Object[0]));
        int numKingdoms = this.getKonquest().getKingdomManager().getKingdoms().size();
        icon.addNameValue(MessagePath.LABEL_TOTAL.getMessage(new Object[0]), numKingdoms);
        icon.addHint(MessagePath.MENU_HINT_OPEN.getMessage(new Object[0]));
        icon.setState(MenuState.KINGDOM_LIST);
        result.addIcon(icon);
        icon = new InfoIcon(MessagePath.LABEL_CAMPS.getMessage(new Object[0]), Material.ORANGE_BED, ROOT_SLOT_CAMPS, true);
        icon.addProperty(MessagePath.LABEL_INFORMATION.getMessage(new Object[0]));
        int numCamps = this.getKonquest().getCampManager().getCamps().size();
        icon.addNameValue(MessagePath.LABEL_TOTAL.getMessage(new Object[0]), numCamps);
        icon.addHint(MessagePath.MENU_HINT_OPEN.getMessage(new Object[0]));
        icon.setState(MenuState.CAMP_LIST);
        result.addIcon(icon);
        icon = new InfoIcon(MessagePath.LABEL_RUINS.getMessage(new Object[0]), Material.MOSSY_COBBLESTONE, ROOT_SLOT_RUINS, true);
        icon.addProperty(MessagePath.LABEL_INFORMATION.getMessage(new Object[0]));
        int numRuins = this.getKonquest().getRuinManager().getRuins().size();
        icon.addNameValue(MessagePath.LABEL_TOTAL.getMessage(new Object[0]), numRuins);
        icon.addHint(MessagePath.MENU_HINT_OPEN.getMessage(new Object[0]));
        icon.setState(MenuState.RUIN_LIST);
        result.addIcon(icon);
        icon = new InfoIcon(MessagePath.LABEL_CAPITALS.getMessage(new Object[0]), Material.NETHERITE_BLOCK, ROOT_SLOT_CAPITALS, true);
        icon.addProperty(MessagePath.LABEL_INFORMATION.getMessage(new Object[0]));
        icon.addNameValue(MessagePath.LABEL_TOTAL.getMessage(new Object[0]), numKingdoms);
        icon.addHint(MessagePath.MENU_HINT_OPEN.getMessage(new Object[0]));
        icon.setState(MenuState.CAPITAL_LIST);
        result.addIcon(icon);
        icon = new InfoIcon(MessagePath.LABEL_TOWNS.getMessage(new Object[0]), Material.OBSIDIAN, ROOT_SLOT_TOWNS, true);
        icon.addProperty(MessagePath.LABEL_INFORMATION.getMessage(new Object[0]));
        int numTowns = 0;
        for (KonKingdom kingdom : this.getKonquest().getKingdomManager().getKingdoms()) {
            numTowns += kingdom.getNumTowns();
        }
        icon.addNameValue(MessagePath.LABEL_TOTAL.getMessage(new Object[0]), numTowns);
        icon.addHint(MessagePath.MENU_HINT_OPEN.getMessage(new Object[0]));
        icon.setState(MenuState.TOWN_LIST);
        result.addIcon(icon);
        icon = new InfoIcon(MessagePath.LABEL_SANCTUARIES.getMessage(new Object[0]), Material.SMOOTH_QUARTZ, ROOT_SLOT_SANCTUARIES, true);
        icon.addProperty(MessagePath.LABEL_INFORMATION.getMessage(new Object[0]));
        int numSanctuaries = this.getKonquest().getSanctuaryManager().getSanctuaries().size();
        icon.addNameValue(MessagePath.LABEL_TOTAL.getMessage(new Object[0]), numSanctuaries);
        icon.addHint(MessagePath.MENU_HINT_OPEN.getMessage(new Object[0]));
        icon.setState(MenuState.SANCTUARY_LIST);
        result.addIcon(icon);
        icon = new InfoIcon(MessagePath.LABEL_MONUMENT_TEMPLATES.getMessage(new Object[0]), Material.CRAFTING_TABLE, ROOT_SLOT_MONUMENTS, true);
        icon.addProperty(MessagePath.LABEL_INFORMATION.getMessage(new Object[0]));
        int numTemplates = this.getKonquest().getSanctuaryManager().getNumTemplates();
        icon.addNameValue(MessagePath.LABEL_TOTAL.getMessage(new Object[0]), numTemplates);
        icon.addHint(MessagePath.MENU_HINT_OPEN.getMessage(new Object[0]));
        icon.setState(MenuState.MONUMENT_LIST);
        result.addIcon(icon);
        this.addNavEmpty(result);
        this.addNavHome(result);
        this.addNavClose(result);
        return result;
    }

    private List<DisplayView> createPlayerView(MenuState context) {
        ArrayList<MenuIcon> icons = new ArrayList<MenuIcon>();
        ArrayList<KonOfflinePlayer> players = new ArrayList<KonOfflinePlayer>();
        switch (context.ordinal()) {
            case 1: {
                players.addAll(this.getKonquest().getPlayerManager().getAllKonquestOfflinePlayers());
                break;
            }
            case 10: {
                if (this.infoKingdom == null) break;
                for (OfflinePlayer officer : this.infoKingdom.getPlayerOfficersOnly()) {
                    players.add(this.getKonquest().getPlayerManager().getOfflinePlayer(officer));
                }
                break;
            }
            case 11: {
                if (this.infoKingdom == null) break;
                for (OfflinePlayer member : this.infoKingdom.getPlayerMembersOnly()) {
                    players.add(this.getKonquest().getPlayerManager().getOfflinePlayer(member));
                }
                break;
            }
            case 18: {
                if (this.infoTown == null) break;
                for (OfflinePlayer knight : this.infoTown.getPlayerKnightsOnly()) {
                    players.add(this.getKonquest().getPlayerManager().getOfflinePlayer(knight));
                }
                break;
            }
            case 19: {
                if (this.infoTown == null) break;
                for (OfflinePlayer resident : this.infoTown.getPlayerResidentsOnly()) {
                    players.add(this.getKonquest().getPlayerManager().getOfflinePlayer(resident));
                }
                break;
            }
        }
        players.sort(this.playerComparator);
        for (KonOfflinePlayer currentPlayer : players) {
            PlayerIcon icon = new PlayerIcon(currentPlayer.getOfflineBukkitPlayer(), this.getColor((KonOfflinePlayer)this.player, currentPlayer), this.getRelation((KonOfflinePlayer)this.player, currentPlayer), 0, true);
            switch (context.ordinal()) {
                case 1: {
                    if (currentPlayer.isBarbarian()) break;
                    icon.addNameValue(MessagePath.LABEL_KINGDOM.getMessage(new Object[0]), currentPlayer.getKingdom().getName());
                    break;
                }
                case 10: {
                    icon.addProperty(MessagePath.RELATIONSHIP_RANK_OFFICER.getMessage(new Object[0]));
                    break;
                }
                case 11: {
                    icon.addProperty(MessagePath.RELATIONSHIP_RANK_MEMBER.getMessage(new Object[0]));
                    break;
                }
                case 18: {
                    icon.addProperty(MessagePath.RELATIONSHIP_ROLE_KNIGHT.getMessage(new Object[0]));
                    break;
                }
                case 19: {
                    icon.addProperty(MessagePath.RELATIONSHIP_ROLE_RESIDENT.getMessage(new Object[0]));
                    break;
                }
            }
            icon.addHint(MessagePath.MENU_HINT_OPEN.getMessage(new Object[0]));
            icon.setState(MenuState.PLAYER_INFO);
            icons.add(icon);
        }
        return new ArrayList<DisplayView>(this.makePages(icons, this.getTitle(context)));
    }

    private List<DisplayView> createKingdomView(MenuState context) {
        ArrayList<MenuIcon> icons = new ArrayList<MenuIcon>();
        ArrayList<KonKingdom> kingdoms = new ArrayList<KonKingdom>();
        switch (context.ordinal()) {
            case 5: {
                kingdoms.addAll(this.getKonquest().getKingdomManager().getKingdoms());
                break;
            }
            case 29: {
                if (this.infoTemplate == null) break;
                for (KonKingdom kingdom : this.getKonquest().getKingdomManager().getKingdoms()) {
                    KonMonumentTemplate kingdomTemplate = kingdom.getMonumentTemplate();
                    if (kingdomTemplate == null || !kingdomTemplate.equals(this.infoTemplate)) continue;
                    kingdoms.add(kingdom);
                }
                break;
            }
            case 7: {
                if (this.infoKingdom == null) break;
                kingdoms.addAll(this.infoKingdom.getActiveRelationKingdoms(KonquestDiplomacyType.WAR));
                break;
            }
            case 8: {
                if (this.infoKingdom == null) break;
                kingdoms.addAll(this.infoKingdom.getActiveRelationKingdoms(KonquestDiplomacyType.ALLIANCE));
                break;
            }
            case 9: {
                if (this.infoKingdom == null) break;
                kingdoms.addAll(this.infoKingdom.getActiveRelationKingdoms(KonquestDiplomacyType.TRADE));
                break;
            }
        }
        kingdoms.sort(this.kingdomComparator);
        for (KonKingdom currentKingdom : kingdoms) {
            KingdomIcon icon = new KingdomIcon(currentKingdom, this.getColor((KonOfflinePlayer)this.player, currentKingdom), this.getRelation((KonOfflinePlayer)this.player, currentKingdom), 0, true);
            icon.addHint(MessagePath.MENU_HINT_OPEN.getMessage(new Object[0]));
            icon.setState(MenuState.KINGDOM_INFO);
            icons.add(icon);
        }
        return new ArrayList<DisplayView>(this.makePages(icons, this.getTitle(context)));
    }

    private List<DisplayView> createTownView(MenuState context) {
        ArrayList<MenuIcon> icons = new ArrayList<MenuIcon>();
        ArrayList<KonTown> towns = new ArrayList<KonTown>();
        switch (context.ordinal()) {
            case 14: {
                for (KonKingdom kingdom : this.getKonquest().getKingdomManager().getKingdoms()) {
                    towns.addAll(kingdom.getTowns());
                }
                break;
            }
            case 13: {
                for (KonKingdom kingdom : this.getKonquest().getKingdomManager().getKingdoms()) {
                    towns.add(kingdom.getCapital());
                }
                break;
            }
            case 3: {
                if (this.infoPlayer == null) break;
                towns.addAll(this.getKonquest().getKingdomManager().getPlayerResidenceTowns(this.infoPlayer));
                break;
            }
            case 12: {
                if (this.infoKingdom == null) break;
                towns.addAll(this.infoKingdom.getTowns());
                break;
            }
        }
        towns.sort(this.townComparator);
        for (KonTown currentTown : towns) {
            String townRole;
            TownIcon icon = new TownIcon(currentTown, this.getColor((KonOfflinePlayer)this.player, currentTown), this.getRelation((KonOfflinePlayer)this.player, currentTown), 0, true);
            if (context.equals(MenuState.PLAYER_INFO_TOWNS) && this.infoPlayer != null && !(townRole = currentTown.getPlayerRoleName(this.infoPlayer)).isEmpty()) {
                icon.addNameValue(MessagePath.LABEL_TOWN_ROLE.getMessage(new Object[0]), townRole);
            }
            icon.addHint(MessagePath.MENU_HINT_OPEN.getMessage(new Object[0]));
            icon.setState(MenuState.TOWN_INFO);
            icons.add(icon);
        }
        return new ArrayList<DisplayView>(this.makePages(icons, this.getTitle(context)));
    }

    private List<DisplayView> createCampView() {
        ArrayList<MenuIcon> icons = new ArrayList<MenuIcon>();
        ArrayList<KonCamp> camps = new ArrayList<KonCamp>(this.getKonquest().getCampManager().getCamps());
        camps.sort(this.campComparator);
        for (KonCamp currentCamp : camps) {
            CampIcon icon = new CampIcon(currentCamp, 0, true);
            icon.addHint(MessagePath.MENU_HINT_OPEN.getMessage(new Object[0]));
            icon.setState(MenuState.CAMP_INFO);
            icons.add(icon);
        }
        return new ArrayList<DisplayView>(this.makePages(icons, this.getTitle(MenuState.CAMP_LIST)));
    }

    private List<DisplayView> createRuinView() {
        ArrayList<MenuIcon> icons = new ArrayList<MenuIcon>();
        ArrayList<KonRuin> ruins = new ArrayList<KonRuin>(this.getKonquest().getRuinManager().getRuins());
        ruins.sort(this.ruinComparator);
        for (KonRuin currentRuin : ruins) {
            RuinIcon icon = new RuinIcon(currentRuin, 0, true);
            icon.addHint(MessagePath.MENU_HINT_OPEN.getMessage(new Object[0]));
            icon.setState(MenuState.RUIN_INFO);
            icons.add(icon);
        }
        return new ArrayList<DisplayView>(this.makePages(icons, this.getTitle(MenuState.RUIN_LIST)));
    }

    private List<DisplayView> createSanctuaryView() {
        ArrayList<MenuIcon> icons = new ArrayList<MenuIcon>();
        ArrayList<KonSanctuary> sanctuaries = new ArrayList<KonSanctuary>(this.getKonquest().getSanctuaryManager().getSanctuaries());
        sanctuaries.sort(this.sanctuaryComparator);
        for (KonSanctuary currentSanctuary : sanctuaries) {
            SanctuaryIcon icon = new SanctuaryIcon(currentSanctuary, 0, true);
            icon.addHint(MessagePath.MENU_HINT_OPEN.getMessage(new Object[0]));
            icon.setState(MenuState.SANCTUARY_INFO);
            icons.add(icon);
        }
        return new ArrayList<DisplayView>(this.makePages(icons, this.getTitle(MenuState.SANCTUARY_LIST)));
    }

    private List<DisplayView> createMonumentView(MenuState context) {
        MenuIcon icon;
        ArrayList<MenuIcon> icons = new ArrayList<MenuIcon>();
        ArrayList<KonMonumentTemplate> templates = new ArrayList<KonMonumentTemplate>();
        switch (context.ordinal()) {
            case 27: {
                templates.addAll(this.getKonquest().getSanctuaryManager().getAllTemplates());
                break;
            }
            case 22: {
                if (this.infoSanctuary == null) break;
                templates.addAll(this.infoSanctuary.getTemplates());
                break;
            }
        }
        templates.sort(this.templateComparator);
        for (KonMonumentTemplate currentTemplate : templates) {
            icon = new TemplateIcon(currentTemplate, 0, true);
            if (context.equals(MenuState.MONUMENT_LIST)) {
                icon.addNameValue(MessagePath.TERRITORY_SANCTUARY.getMessage(new Object[0]), this.getKonquest().getSanctuaryManager().getSanctuaryNameOfTemplate(currentTemplate.getName()));
            }
            icon.addHint(MessagePath.MENU_HINT_OPEN.getMessage(new Object[0]));
            icon.setState(MenuState.MONUMENT_INFO);
            icons.add(icon);
        }
        if (templates.isEmpty()) {
            icon = new InfoIcon(String.valueOf(ChatColor.DARK_RED) + MessagePath.LABEL_MONUMENT_TEMPLATE.getMessage(new Object[0]), Material.BARRIER, 0, false);
            icon.addError(MessagePath.COMMAND_ADMIN_KINGDOM_ERROR_NO_TEMPLATES.getMessage(new Object[0]));
            icons.add(icon);
        }
        return new ArrayList<DisplayView>(this.makePages(icons, this.getTitle(context)));
    }

    private List<DisplayView> createStatsView() {
        if (this.infoPlayer == null) {
            return Collections.emptyList();
        }
        ArrayList<MenuIcon> icons = new ArrayList<MenuIcon>();
        KonPlayer onlineInfoPlayer = this.getKonquest().getPlayerManager().getPlayerFromID(this.infoPlayer.getOfflineBukkitPlayer().getUniqueId());
        KonStats stats = onlineInfoPlayer == null ? this.getKonquest().getDatabaseThread().getDatabase().pullPlayerStats(this.infoPlayer.getOfflineBukkitPlayer()) : onlineInfoPlayer.getPlayerStats();
        for (KonStatsType stat : KonStatsType.values()) {
            int statValue = stats.getStat(stat);
            StatIcon icon = new StatIcon(stat, statValue, 0, false);
            icons.add(icon);
        }
        return new ArrayList<DisplayView>(this.makePages(icons, this.getTitle(MenuState.PLAYER_INFO_STATS)));
    }

    private List<DisplayView> createOptionsView() {
        if (this.infoTown == null) {
            return Collections.emptyList();
        }
        ArrayList<MenuIcon> icons = new ArrayList<MenuIcon>();
        for (KonTownOption option : KonTownOption.values()) {
            boolean optionValue = this.infoTown.getTownOption(option);
            String currentValue = DisplayManager.boolean2Lang(optionValue) + " " + DisplayManager.boolean2Symbol(optionValue);
            OptionIcon icon = new OptionIcon(option, 0, false);
            icon.addNameValue(MessagePath.LABEL_CURRENT.getMessage(new Object[0]), currentValue);
            icons.add(icon);
        }
        return new ArrayList<DisplayView>(this.makePages(icons, this.getTitle(MenuState.TOWN_INFO_OPTIONS)));
    }

    private List<DisplayView> createUpgradesView() {
        if (this.infoTown == null || !this.getKonquest().getUpgradeManager().isEnabled()) {
            return Collections.emptyList();
        }
        ArrayList<MenuIcon> icons = new ArrayList<MenuIcon>();
        for (KonUpgrade upgrade : KonUpgrade.values()) {
            boolean isDisabled;
            String upgradeName;
            int upgradeLevel;
            int currentLevel = this.infoTown.getRawUpgradeLevel(upgrade);
            if (currentLevel <= 0) continue;
            if (this.infoTown.isUpgradeDisabled(upgrade)) {
                int reducedLevel;
                upgradeLevel = reducedLevel = this.infoTown.getUpgradeLevel(upgrade);
                upgradeName = reducedLevel > 0 ? upgrade.getName() + " " + String.valueOf(ChatColor.GRAY) + reducedLevel : String.valueOf(ChatColor.GRAY) + String.valueOf(ChatColor.STRIKETHROUGH) + upgrade.getName() + " " + reducedLevel;
                isDisabled = true;
            } else {
                upgradeLevel = currentLevel;
                upgradeName = upgrade.getName() + " " + currentLevel;
                isDisabled = false;
            }
            InfoIcon icon = new InfoIcon(upgradeName, upgrade.getIcon(), 0, false);
            icon.addDescription(upgrade.getLevelDescription(upgradeLevel));
            if (isDisabled) {
                icon.addAlert(MessagePath.LABEL_DISABLED.getMessage(new Object[0]));
                icon.addError(MessagePath.UPGRADE_DISABLED.getMessage(new Object[0]));
            }
            icons.add(icon);
        }
        return new ArrayList<DisplayView>(this.makePages(icons, this.getTitle(MenuState.TOWN_INFO_UPGRADES)));
    }

    private DisplayView createPlayerInfoView() {
        if (this.infoPlayer == null) {
            return null;
        }
        int rows = 1;
        int SLOT_PLAYER = 1;
        int SLOT_KINGDOM_CAMP = 3;
        int SLOT_SCORE = 4;
        int SLOT_TOWNS = 6;
        int SLOT_STATS = 7;
        String contextColor = this.getColor((KonOfflinePlayer)this.player, this.infoPlayer);
        KonquestRelationshipType relation = this.getRelation((KonOfflinePlayer)this.player, this.infoPlayer);
        String title = MessagePath.LABEL_PLAYER.getMessage(new Object[0]) + " " + this.infoPlayer.getOfflineBukkitPlayer().getName();
        DisplayView result = new DisplayView(rows, title);
        MenuIcon icon = new PlayerIcon(this.infoPlayer.getOfflineBukkitPlayer(), contextColor, relation, SLOT_PLAYER, false);
        if (!this.infoPlayer.isBarbarian()) {
            icon.addNameValue(MessagePath.LABEL_KINGDOM_RANK.getMessage(new Object[0]), this.infoPlayer.getKingdom().getPlayerRankName(this.infoPlayer));
        }
        result.addIcon(icon);
        if (this.infoPlayer.isBarbarian()) {
            if (this.getKonquest().getCampManager().isCampSet(this.infoPlayer)) {
                icon = new CampIcon(this.getKonquest().getCampManager().getCamp(this.infoPlayer), SLOT_KINGDOM_CAMP, true);
                icon.addDescription(MessagePath.MENU_INFO_CAMP_PLACED.getMessage(new Object[0]));
                icon.addHint(MessagePath.MENU_HINT_OPEN.getMessage(new Object[0]));
                icon.setState(MenuState.CAMP_INFO);
            } else {
                icon = new InfoIcon(MessagePath.TERRITORY_CAMP.getMessage(new Object[0]), Material.BARRIER, SLOT_KINGDOM_CAMP, false);
                icon.addProperty(MessagePath.LABEL_BARBARIANS.getMessage(new Object[0]));
                icon.addDescription(MessagePath.MENU_INFO_CAMP_MISSING.getMessage(new Object[0]));
            }
        } else {
            icon = new KingdomIcon(this.infoPlayer.getKingdom(), contextColor, relation, SLOT_KINGDOM_CAMP, true);
            icon.addHint(MessagePath.MENU_HINT_OPEN.getMessage(new Object[0]));
            icon.setState(MenuState.KINGDOM_INFO);
        }
        result.addIcon(icon);
        boolean isScoreClickable = !this.infoPlayer.isBarbarian() && !this.infoPlayer.getKingdom().isPeaceful();
        icon = new InfoIcon(MessagePath.MENU_SCORE_PLAYER_SCORE.getMessage(new Object[0]), CommandType.SCORE.iconMaterial(), SLOT_SCORE, isScoreClickable);
        if (isScoreClickable) {
            int playerScore = this.getKonquest().getKingdomManager().getPlayerScore(this.infoPlayer);
            icon.addNameValue(MessagePath.LABEL_SCORE.getMessage(new Object[0]), playerScore);
            icon.addHint(MessagePath.MENU_HINT_OPEN.getMessage(new Object[0]));
            icon.setState(MenuState.DISPLAY_PLAYER_SCORE);
        } else {
            icon.addAlert(MessagePath.LABEL_UNAVAILABLE.getMessage(new Object[0]));
            if (this.infoPlayer.isBarbarian()) {
                icon.addError(MessagePath.COMMAND_SCORE_ERROR_BARBARIAN.getMessage(this.infoPlayer.getOfflineBukkitPlayer().getName()));
            } else {
                icon.addError(MessagePath.COMMAND_SCORE_ERROR_PEACEFUL.getMessage(this.infoPlayer.getKingdom().getName()));
            }
        }
        result.addIcon(icon);
        boolean isTownClickable = !this.infoPlayer.isBarbarian();
        icon = new InfoIcon(MessagePath.LABEL_TOWNS.getMessage(new Object[0]), CommandType.TOWN.iconMaterial(), SLOT_TOWNS, isTownClickable);
        if (isTownClickable) {
            int numTowns = this.getKonquest().getKingdomManager().getPlayerResidencies(this.infoPlayer);
            icon.addNameValue(MessagePath.LABEL_TOTAL.getMessage(new Object[0]), numTowns);
            icon.addHint(MessagePath.MENU_HINT_VIEW.getMessage(new Object[0]));
            icon.setState(MenuState.PLAYER_INFO_TOWNS);
        } else {
            icon.addAlert(MessagePath.LABEL_UNAVAILABLE.getMessage(new Object[0]));
        }
        result.addIcon(icon);
        icon = new InfoIcon(MessagePath.MENU_PREFIX_TITLE_STATS.getMessage(new Object[0]), CommandType.STATS.iconMaterial(), SLOT_STATS, true);
        icon.addHint(MessagePath.MENU_HINT_VIEW.getMessage(new Object[0]));
        icon.setState(MenuState.PLAYER_INFO_STATS);
        result.addIcon(icon);
        this.addNavEmpty(result);
        this.addNavClose(result);
        this.addNavReturn(result);
        return result;
    }

    private DisplayView createKingdomInfoView() {
        if (this.infoKingdom == null) {
            return null;
        }
        int rows = 3;
        int SLOT_KINGDOM = 0;
        int SLOT_DIPLOMACY = 1;
        int SLOT_FLAGS = 2;
        int SLOT_PROPS = 3;
        int SLOT_CAPITAL = 5;
        int SLOT_MASTER = 6;
        int SLOT_MONUMENT = 7;
        int SLOT_SCORE = 8;
        int SLOT_OFFICERS = 12;
        int SLOT_MEMBERS = 13;
        int SLOT_TOWNS = 14;
        int SLOT_ENEMIES = 21;
        int SLOT_ALLIES = 22;
        int SLOT_TRADERS = 23;
        boolean isClickable = this.infoKingdom.isCreated();
        String contextColor = this.getColor((KonOfflinePlayer)this.player, this.infoKingdom);
        KonquestRelationshipType relation = this.getRelation((KonOfflinePlayer)this.player, this.infoKingdom);
        Object title = this.infoKingdom.isCreated() ? MessagePath.LABEL_KINGDOM.getMessage(new Object[0]) + " " + this.infoKingdom.getName() : this.infoKingdom.getName();
        DisplayView result = new DisplayView(rows, (String)title);
        int numKingdomPlayers = this.getKonquest().getPlayerManager().getPlayersInKingdom(this.infoKingdom).size();
        int numKingdomOfficers = this.infoKingdom.getPlayerOfficersOnly().size();
        int numKingdomFavor = 0;
        for (KonOfflinePlayer kingdomPlayer : this.getKonquest().getPlayerManager().getAllPlayersInKingdom(this.infoKingdom)) {
            numKingdomFavor += (int)KonquestPlugin.getBalance(kingdomPlayer.getOfflineBukkitPlayer());
        }
        int currentWebColor = this.infoKingdom.getWebColor();
        String colorName = "default";
        if (currentWebColor != -1) {
            colorName = ChatUtil.reverseLookupColorRGB(currentWebColor);
        }
        String webColorFormat = this.infoKingdom.getWebColorString() + colorName;
        MenuIcon icon = new KingdomIcon(this.infoKingdom, contextColor, relation, SLOT_KINGDOM, false);
        icon.addNameValue(MessagePath.LABEL_ONLINE_PLAYERS.getMessage(new Object[0]), numKingdomPlayers);
        if (this.infoKingdom.isCreated()) {
            icon.addNameValue(MessagePath.LABEL_OFFICERS.getMessage(new Object[0]), numKingdomOfficers);
            icon.addNameValue(MessagePath.LABEL_FAVOR.getMessage(new Object[0]), numKingdomFavor);
            icon.addNameValue(MessagePath.LABEL_MAP_COLOR.getMessage(new Object[0]), webColorFormat);
        }
        result.addIcon(icon);
        KonquestDiplomacyType currentDiplomacy = this.getKonquest().getKingdomManager().getDiplomacy(this.player.getKingdom(), this.infoKingdom);
        icon = new DiplomacyIcon(currentDiplomacy, SLOT_DIPLOMACY, false);
        icon.addProperty(MessagePath.LABEL_DIPLOMACY.getMessage(new Object[0]));
        if (this.player.getKingdom().hasRelationRequest(this.infoKingdom) || this.infoKingdom.hasRelationRequest(this.player.getKingdom())) {
            icon.addAlert(MessagePath.MENU_KINGDOM_REQUESTS.getMessage(new Object[0]));
        }
        if (this.player.getKingdom().hasRelationRequest(this.infoKingdom)) {
            String ourRequestStatus = Labeler.lookup(this.player.getKingdom().getRelationRequest(this.infoKingdom));
            icon.addNameValue(MessagePath.MENU_KINGDOM_THEY_REQUESTED.getMessage(new Object[0]), ourRequestStatus);
        }
        if (this.infoKingdom.hasRelationRequest(this.player.getKingdom())) {
            KonPropertyFlag[] theirRequestStatus = Labeler.lookup(this.infoKingdom.getRelationRequest(this.player.getKingdom()));
            icon.addNameValue(MessagePath.MENU_KINGDOM_WE_REQUESTED.getMessage(new Object[0]), (String)theirRequestStatus);
        }
        switch (currentDiplomacy) {
            case PEACE: {
                icon.addDescription(MessagePath.MENU_KINGDOM_DIPLOMACY_PEACE_INFO.getMessage(new Object[0]));
                break;
            }
            case TRADE: {
                icon.addDescription(MessagePath.MENU_KINGDOM_DIPLOMACY_TRADE_INFO.getMessage(new Object[0]));
                break;
            }
            case WAR: {
                icon.addDescription(MessagePath.MENU_KINGDOM_DIPLOMACY_WAR_INFO.getMessage(new Object[0]));
                break;
            }
            case ALLIANCE: {
                icon.addDescription(MessagePath.MENU_KINGDOM_DIPLOMACY_ALLIANCE_INFO.getMessage(new Object[0]));
                break;
            }
        }
        result.addIcon(icon);
        icon = new InfoIcon(MessagePath.LABEL_FLAGS.getMessage(new Object[0]), this.flagMaterial, SLOT_FLAGS, false);
        for (KonPropertyFlag flag : KonPropertyFlag.values()) {
            if (!this.infoKingdom.hasPropertyValue(flag)) continue;
            String flagDisplaySymbol = DisplayManager.boolean2Symbol(this.infoKingdom.getPropertyValue(flag));
            icon.addNameValue(flag.getName(), flagDisplaySymbol);
        }
        result.addIcon(icon);
        icon = new InfoIcon(MessagePath.LABEL_PROPERTIES.getMessage(new Object[0]), this.propMaterial, SLOT_PROPS, false);
        icon.addNameValue(MessagePath.LABEL_ADMIN_KINGDOM.getMessage(new Object[0]), DisplayManager.boolean2Symbol(this.infoKingdom.isAdminOperated()));
        icon.addNameValue(MessagePath.LABEL_PROTECTED.getMessage(new Object[0]), DisplayManager.boolean2Symbol(this.infoKingdom.isOfflineProtected()));
        icon.addNameValue(MessagePath.LABEL_OPEN.getMessage(new Object[0]), DisplayManager.boolean2Symbol(this.infoKingdom.isOpen()));
        icon.addNameValue(MessagePath.LABEL_SMALLEST.getMessage(new Object[0]), DisplayManager.boolean2Symbol(this.infoKingdom.isSmallest()));
        icon.addNameValue(MessagePath.LABEL_PEACEFUL.getMessage(new Object[0]), DisplayManager.boolean2Symbol(this.infoKingdom.isPeaceful()));
        result.addIcon(icon);
        if (isClickable) {
            icon = new TownIcon(this.infoKingdom.getCapital(), contextColor, relation, SLOT_CAPITAL, true);
            icon.addHint(MessagePath.MENU_HINT_OPEN.getMessage(new Object[0]));
            icon.setState(MenuState.TOWN_INFO);
        } else {
            icon = new InfoIcon(MessagePath.TERRITORY_CAPITAL.getMessage(new Object[0]), Material.NETHERITE_BLOCK, SLOT_CAPITAL, false);
            icon.addAlert(MessagePath.LABEL_UNAVAILABLE.getMessage(new Object[0]));
        }
        result.addIcon(icon);
        if (this.infoKingdom.isCreated() && !this.infoKingdom.isAdminOperated()) {
            if (this.infoKingdom.isMasterValid()) {
                icon = new PlayerIcon(this.infoKingdom.getPlayerMaster(), contextColor, relation, SLOT_MASTER, true);
                icon.addHint(MessagePath.MENU_HINT_OPEN.getMessage(new Object[0]));
                icon.setState(MenuState.PLAYER_INFO);
            } else {
                icon = new InfoIcon(MessagePath.RELATIONSHIP_RANK_MASTER.getMessage(new Object[0]), Material.BARRIER, SLOT_MASTER, false);
                icon.addAlert(MessagePath.LABEL_INVALID.getMessage(new Object[0]));
            }
        } else {
            icon = new InfoIcon(MessagePath.RELATIONSHIP_RANK_MASTER.getMessage(new Object[0]), Material.IRON_HELMET, SLOT_MASTER, false);
            icon.addAlert(MessagePath.LABEL_UNAVAILABLE.getMessage(new Object[0]));
        }
        result.addIcon(icon);
        if (isClickable) {
            if (this.infoKingdom.hasMonumentTemplate()) {
                icon = new TemplateIcon(this.infoKingdom.getMonumentTemplate(), SLOT_MONUMENT, true);
                icon.addNameValue(MessagePath.LABEL_LOOT_TYPE.getMessage(new Object[0]), this.getKonquest().getLootManager().getMonumentLootDisplayName(this.infoKingdom.getMonumentTemplate()));
                icon.addHint(MessagePath.MENU_HINT_OPEN.getMessage(new Object[0]));
                icon.setState(MenuState.MONUMENT_INFO);
            } else {
                icon = new InfoIcon(MessagePath.LABEL_MONUMENT_TEMPLATE.getMessage(new Object[0]), Material.BARRIER, SLOT_MONUMENT, false);
                icon.addAlert(MessagePath.LABEL_INVALID.getMessage(new Object[0]));
            }
        } else {
            icon = new InfoIcon(MessagePath.LABEL_MONUMENT_TEMPLATE.getMessage(new Object[0]), Material.CRAFTING_TABLE, SLOT_MONUMENT, false);
            icon.addAlert(MessagePath.LABEL_UNAVAILABLE.getMessage(new Object[0]));
        }
        result.addIcon(icon);
        boolean isScoreClickable = this.infoKingdom.isCreated() && !this.infoKingdom.isPeaceful();
        icon = new InfoIcon(MessagePath.MENU_SCORE_KINGDOM_SCORE.getMessage(new Object[0]), CommandType.SCORE.iconMaterial(), SLOT_SCORE, isScoreClickable);
        if (isScoreClickable) {
            int kingdomScore = this.getKonquest().getKingdomManager().getKingdomScore(this.infoKingdom);
            icon.addNameValue(MessagePath.LABEL_SCORE.getMessage(new Object[0]), kingdomScore);
            icon.addHint(MessagePath.MENU_HINT_OPEN.getMessage(new Object[0]));
            icon.setState(MenuState.DISPLAY_KINGDOM_SCORE);
        } else {
            icon.addAlert(MessagePath.LABEL_UNAVAILABLE.getMessage(new Object[0]));
            if (this.infoKingdom.isCreated()) {
                icon.addDescription(MessagePath.COMMAND_SCORE_ERROR_PEACEFUL.getMessage(this.infoKingdom.getName()));
            } else {
                icon.addDescription(MessagePath.COMMAND_SCORE_ERROR_KINGDOM.getMessage(new Object[0]));
            }
        }
        result.addIcon(icon);
        int numOfficers = this.infoKingdom.getPlayerOfficersOnly().size();
        icon = new InfoIcon(MessagePath.LABEL_OFFICERS.getMessage(new Object[0]), Material.IRON_HORSE_ARMOR, SLOT_OFFICERS, isClickable);
        if (isClickable) {
            icon.addNameValue(MessagePath.LABEL_TOTAL.getMessage(new Object[0]), numOfficers);
            icon.addHint(MessagePath.MENU_HINT_VIEW.getMessage(new Object[0]));
            icon.setState(MenuState.KINGDOM_INFO_OFFICERS);
        } else {
            icon.addAlert(MessagePath.LABEL_UNAVAILABLE.getMessage(new Object[0]));
        }
        result.addIcon(icon);
        int numMembers = this.infoKingdom.getPlayerMembersOnly().size();
        icon = new InfoIcon(MessagePath.LABEL_MEMBERS.getMessage(new Object[0]), Material.LEATHER_CHESTPLATE, SLOT_MEMBERS, true);
        icon.addNameValue(MessagePath.LABEL_TOTAL.getMessage(new Object[0]), numMembers);
        icon.addHint(MessagePath.MENU_HINT_VIEW.getMessage(new Object[0]));
        icon.setState(MenuState.KINGDOM_INFO_MEMBERS);
        result.addIcon(icon);
        int numTowns = this.infoKingdom.getNumTowns();
        icon = new InfoIcon(MessagePath.LABEL_TOWNS.getMessage(new Object[0]), CommandType.TOWN.iconMaterial(), SLOT_TOWNS, isClickable);
        if (isClickable) {
            icon.addNameValue(MessagePath.LABEL_TOTAL.getMessage(new Object[0]), numTowns);
            icon.addHint(MessagePath.MENU_HINT_VIEW.getMessage(new Object[0]));
            icon.setState(MenuState.KINGDOM_INFO_TOWNS);
        } else {
            icon.addAlert(MessagePath.LABEL_UNAVAILABLE.getMessage(new Object[0]));
        }
        result.addIcon(icon);
        int numEnemies = this.infoKingdom.getActiveRelationKingdoms(KonquestDiplomacyType.WAR).size();
        icon = new InfoIcon(MessagePath.DIPLOMACY_WAR.getMessage(new Object[0]), Material.GUNPOWDER, SLOT_ENEMIES, isClickable);
        if (isClickable) {
            icon.addNameValue(MessagePath.LABEL_KINGDOMS.getMessage(new Object[0]), numEnemies);
            icon.addHint(MessagePath.MENU_HINT_VIEW.getMessage(new Object[0]));
            icon.setState(MenuState.KINGDOM_INFO_ENEMIES);
        } else {
            icon.addAlert(MessagePath.LABEL_UNAVAILABLE.getMessage(new Object[0]));
        }
        result.addIcon(icon);
        int numAllies = this.infoKingdom.getActiveRelationKingdoms(KonquestDiplomacyType.ALLIANCE).size();
        icon = new InfoIcon(MessagePath.DIPLOMACY_ALLIANCE.getMessage(new Object[0]), Material.DIAMOND, SLOT_ALLIES, isClickable);
        if (isClickable) {
            icon.addNameValue(MessagePath.LABEL_KINGDOMS.getMessage(new Object[0]), numAllies);
            icon.addHint(MessagePath.MENU_HINT_VIEW.getMessage(new Object[0]));
            icon.setState(MenuState.KINGDOM_INFO_ALLIES);
        } else {
            icon.addAlert(MessagePath.LABEL_UNAVAILABLE.getMessage(new Object[0]));
        }
        result.addIcon(icon);
        int numTraders = this.infoKingdom.getActiveRelationKingdoms(KonquestDiplomacyType.TRADE).size();
        icon = new InfoIcon(MessagePath.DIPLOMACY_TRADE.getMessage(new Object[0]), Material.EMERALD, SLOT_TRADERS, isClickable);
        if (isClickable) {
            icon.addNameValue(MessagePath.LABEL_KINGDOMS.getMessage(new Object[0]), numTraders);
            icon.addHint(MessagePath.MENU_HINT_VIEW.getMessage(new Object[0]));
            icon.setState(MenuState.KINGDOM_INFO_TRADERS);
        } else {
            icon.addAlert(MessagePath.LABEL_UNAVAILABLE.getMessage(new Object[0]));
        }
        result.addIcon(icon);
        this.addNavEmpty(result);
        this.addNavClose(result);
        this.addNavReturn(result);
        return result;
    }

    private DisplayView createTownInfoView() {
        if (this.infoTown == null) {
            return null;
        }
        int rows = 2;
        int SLOT_TOWN = 1;
        int SLOT_FLAGS = 2;
        int SLOT_PROPS = 3;
        int SLOT_SPECIAL = 4;
        int SLOT_KINGDOM = 6;
        int SLOT_LORD = 7;
        int SLOT_KNIGHTS = 12;
        int SLOT_RESIDENTS = 13;
        int SLOT_OPTIONS = 14;
        int SLOT_UPGRADES = 15;
        boolean isCapital = this.infoTown.getTerritoryType().equals((Object)KonquestTerritoryType.CAPITAL);
        String contextColor = this.getColor((KonOfflinePlayer)this.player, this.infoTown);
        KonquestRelationshipType relation = this.getRelation((KonOfflinePlayer)this.player, this.infoTown);
        Object title = isCapital ? this.infoTown.getName() : MessagePath.TERRITORY_TOWN.getMessage(new Object[0]) + " " + this.infoTown.getName();
        DisplayView result = new DisplayView(rows, (String)title);
        String lootTableName = this.getKonquest().getLootManager().getMonumentLootDisplayName(this.infoTown);
        int numTownPlayers = this.infoTown.getNumResidentsOnline();
        int maxCriticalHits = this.getKonquest().getCore().getInt(CorePath.MONUMENTS_DESTROY_AMOUNT.getPath());
        int remainingCriticalHits = maxCriticalHits - this.infoTown.getMonument().getCriticalHits();
        String townHealth = remainingCriticalHits + "/" + maxCriticalHits;
        String shieldTime = HelperUtil.getTimeFormat(this.infoTown.getRemainingShieldTimeSeconds(), "");
        int armorBlocks = this.infoTown.getArmorBlocks();
        MenuIcon icon = new TownIcon(this.infoTown, contextColor, relation, SLOT_TOWN, false);
        icon.addNameValue(MessagePath.LABEL_LOOT_TYPE.getMessage(new Object[0]), lootTableName);
        icon.addNameValue(MessagePath.LABEL_ONLINE_PLAYERS.getMessage(new Object[0]), numTownPlayers);
        icon.addNameValue(MessagePath.LABEL_HEALTH.getMessage(new Object[0]), townHealth);
        icon.addNameValue(MessagePath.LABEL_SHIELD.getMessage(new Object[0]), shieldTime);
        icon.addNameValue(MessagePath.LABEL_ARMOR.getMessage(new Object[0]), armorBlocks);
        result.addIcon(icon);
        icon = new InfoIcon(MessagePath.LABEL_FLAGS.getMessage(new Object[0]), this.flagMaterial, SLOT_FLAGS, false);
        for (KonPropertyFlag flag : KonPropertyFlag.values()) {
            if (!this.infoTown.hasPropertyValue(flag)) continue;
            String flagDisplaySymbol = DisplayManager.boolean2Symbol(this.infoTown.getPropertyValue(flag));
            icon.addNameValue(flag.getName(), flagDisplaySymbol);
        }
        result.addIcon(icon);
        icon = new InfoIcon(MessagePath.LABEL_PROPERTIES.getMessage(new Object[0]), this.propMaterial, SLOT_PROPS, false);
        if (isCapital) {
            icon.addNameValue(MessagePath.LABEL_IMMUNITY.getMessage(new Object[0]), DisplayManager.boolean2Symbol(this.infoTown.getKingdom().isCapitalImmune()));
        }
        icon.addNameValue(MessagePath.RELATIONSHIP_ROLE_LORD.getMessage(new Object[0]), DisplayManager.boolean2Symbol(this.infoTown.isLordValid()));
        icon.addNameValue(MessagePath.PROTECTION_NOTICE_ATTACKED.getMessage(new Object[0]), DisplayManager.boolean2Symbol(this.infoTown.isAttacked()));
        icon.addNameValue(MessagePath.LABEL_PROTECTED.getMessage(new Object[0]), DisplayManager.boolean2Symbol(this.infoTown.isCaptureDisabled() || this.infoTown.getKingdom().isOfflineProtected() || this.infoTown.isTownWatchProtected()));
        icon.addNameValue(MessagePath.LABEL_SHIELD.getMessage(new Object[0]), DisplayManager.boolean2Symbol(this.infoTown.isShielded()));
        icon.addNameValue(MessagePath.LABEL_ARMOR.getMessage(new Object[0]), DisplayManager.boolean2Symbol(this.infoTown.isArmored()));
        icon.addNameValue(MessagePath.LABEL_PEACEFUL.getMessage(new Object[0]), DisplayManager.boolean2Symbol(this.infoTown.getKingdom().isPeaceful()));
        result.addIcon(icon);
        if (this.getKonquest().getKingdomManager().getIsDiscountEnable()) {
            icon = new ProfessionIcon(this.infoTown.getSpecialization(), SLOT_SPECIAL, false);
            icon.addProperty(MessagePath.LABEL_SPECIALIZATION.getMessage(new Object[0]));
            if (this.getKonquest().getLootManager().isMonumentSpecialLootTable(CompatibilityUtil.getProfessionName(this.infoTown.getSpecialization()))) {
                icon.addDescription(MessagePath.MENU_TOWN_LOOT_SPECIAL.getMessage(new Object[0]));
            }
            icon.addDescription(MessagePath.MENU_TOWN_INFO_SPECIAL.getMessage(new Object[0]));
            result.addIcon(icon);
        }
        icon = new KingdomIcon(this.infoTown.getKingdom(), contextColor, relation, SLOT_KINGDOM, true);
        icon.addHint(MessagePath.MENU_HINT_OPEN.getMessage(new Object[0]));
        icon.setState(MenuState.KINGDOM_INFO);
        result.addIcon(icon);
        if (this.infoTown.isLordValid()) {
            icon = new PlayerIcon(this.infoTown.getPlayerLord(), contextColor, relation, SLOT_LORD, true);
            icon.addProperty(MessagePath.RELATIONSHIP_ROLE_LORD.getMessage(new Object[0]));
            icon.addHint(MessagePath.MENU_HINT_OPEN.getMessage(new Object[0]));
            icon.setState(MenuState.PLAYER_INFO);
        } else {
            icon = new InfoIcon(MessagePath.RELATIONSHIP_ROLE_LORD.getMessage(new Object[0]), Material.IRON_HELMET, SLOT_LORD, false);
            icon.addAlert(MessagePath.LABEL_NO_LORD.getMessage(new Object[0]));
            if (this.infoTown.canClaimLordship(this.player)) {
                icon.addError(MessagePath.COMMAND_TOWN_NOTICE_NO_LORD.getMessage(this.infoTown.getName(), this.infoTown.getTravelName()));
            }
        }
        result.addIcon(icon);
        int numTownKnights = this.infoTown.getPlayerKnightsOnly().size();
        icon = new InfoIcon(MessagePath.LABEL_KNIGHTS.getMessage(new Object[0]), Material.IRON_HORSE_ARMOR, SLOT_KNIGHTS, true);
        icon.addNameValue(MessagePath.LABEL_TOTAL.getMessage(new Object[0]), numTownKnights);
        icon.addHint(MessagePath.MENU_HINT_VIEW.getMessage(new Object[0]));
        icon.setState(MenuState.TOWN_INFO_KNIGHTS);
        result.addIcon(icon);
        int numTownResidents = this.infoTown.getPlayerResidentsOnly().size();
        icon = new InfoIcon(MessagePath.LABEL_RESIDENTS.getMessage(new Object[0]), Material.LEATHER_CHESTPLATE, SLOT_RESIDENTS, true);
        icon.addNameValue(MessagePath.LABEL_TOTAL.getMessage(new Object[0]), numTownResidents);
        icon.addHint(MessagePath.MENU_HINT_VIEW.getMessage(new Object[0]));
        icon.setState(MenuState.TOWN_INFO_RESIDENTS);
        result.addIcon(icon);
        int numOptions = KonTownOption.values().length;
        icon = new InfoIcon(MessagePath.LABEL_OPTIONS.getMessage(new Object[0]), Material.OAK_SIGN, SLOT_OPTIONS, true);
        icon.addNameValue(MessagePath.LABEL_TOTAL.getMessage(new Object[0]), numOptions);
        icon.addHint(MessagePath.MENU_HINT_VIEW.getMessage(new Object[0]));
        icon.setState(MenuState.TOWN_INFO_OPTIONS);
        result.addIcon(icon);
        int numUpgrades = this.infoTown.getUpgrades().size();
        icon = new InfoIcon(MessagePath.LABEL_UPGRADES.getMessage(new Object[0]), Material.GOLDEN_APPLE, SLOT_UPGRADES, true);
        icon.addNameValue(MessagePath.LABEL_TOTAL.getMessage(new Object[0]), numUpgrades);
        icon.addHint(MessagePath.MENU_HINT_VIEW.getMessage(new Object[0]));
        icon.setState(MenuState.TOWN_INFO_UPGRADES);
        result.addIcon(icon);
        this.addNavEmpty(result);
        this.addNavClose(result);
        this.addNavReturn(result);
        return result;
    }

    private DisplayView createSanctuaryInfoView() {
        if (this.infoSanctuary == null) {
            return null;
        }
        int rows = 1;
        int SLOT_SANCTUARY = 3;
        int SLOT_FLAGS = 4;
        int SLOT_MONUMENTS = 6;
        int numTemplates = this.infoSanctuary.getTemplates().size();
        String title = MessagePath.TERRITORY_SANCTUARY.getMessage(new Object[0]) + " " + this.infoSanctuary.getName();
        DisplayView result = new DisplayView(rows, title);
        MenuIcon icon = new SanctuaryIcon(this.infoSanctuary, SLOT_SANCTUARY, false);
        icon.addNameValue(MessagePath.LABEL_MONUMENT_TEMPLATES.getMessage(new Object[0]), numTemplates);
        icon.addNameValue(MessagePath.LABEL_LAND.getMessage(new Object[0]), this.infoSanctuary.getChunkList().size());
        result.addIcon(icon);
        icon = new InfoIcon(MessagePath.LABEL_FLAGS.getMessage(new Object[0]), this.flagMaterial, SLOT_FLAGS, false);
        for (KonPropertyFlag flag : KonPropertyFlag.values()) {
            if (!this.infoSanctuary.hasPropertyValue(flag)) continue;
            String flagDisplaySymbol = DisplayManager.boolean2Symbol(this.infoSanctuary.getPropertyValue(flag));
            icon.addNameValue(flag.getName(), flagDisplaySymbol);
        }
        result.addIcon(icon);
        icon = new InfoIcon(MessagePath.LABEL_MONUMENT_TEMPLATES.getMessage(new Object[0]), Material.CRAFTING_TABLE, SLOT_MONUMENTS, true);
        icon.addNameValue(MessagePath.LABEL_TOTAL.getMessage(new Object[0]), numTemplates);
        icon.addHint(MessagePath.MENU_HINT_VIEW.getMessage(new Object[0]));
        icon.setState(MenuState.SANCTUARY_INFO_MONUMENTS);
        result.addIcon(icon);
        this.addNavEmpty(result);
        this.addNavClose(result);
        this.addNavReturn(result);
        return result;
    }

    private DisplayView createRuinInfoView() {
        if (this.infoRuin == null) {
            return null;
        }
        int rows = 1;
        int SLOT_RUIN = 3;
        int SLOT_CAPTURE = 4;
        int SLOT_FLAGS = 5;
        String title = MessagePath.TERRITORY_RUIN.getMessage(new Object[0]) + " " + this.infoRuin.getName();
        DisplayView result = new DisplayView(rows, title);
        MenuIcon icon = new RuinIcon(this.infoRuin, SLOT_RUIN, false);
        icon.addNameValue(MessagePath.LABEL_CRITICAL_HITS.getMessage(new Object[0]), this.infoRuin.getMaxCriticalHits());
        icon.addNameValue(MessagePath.LABEL_GOLEM_SPAWNS.getMessage(new Object[0]), this.infoRuin.getSpawnLocations().size());
        icon.addNameValue(MessagePath.LABEL_LOOT_TYPE.getMessage(new Object[0]), this.getKonquest().getLootManager().getRuinLootDisplayName(this.infoRuin));
        result.addIcon(icon);
        Material captureMaterial = this.infoRuin.isCaptureDisabled() ? Material.POPPY : Material.IRON_BLOCK;
        icon = new InfoIcon(MessagePath.MENU_INFO_RUIN_STATUS.getMessage(new Object[0]), captureMaterial, SLOT_CAPTURE, false);
        if (this.infoRuin.isCaptureDisabled()) {
            icon.addDescription(MessagePath.PROTECTION_ERROR_CAPTURE.getMessage(this.infoRuin.getCaptureCooldownString()));
        } else {
            icon.addDescription(MessagePath.MENU_INFO_RUIN_CAPTURE.getMessage(new Object[0]));
        }
        result.addIcon(icon);
        icon = new InfoIcon(MessagePath.LABEL_FLAGS.getMessage(new Object[0]), this.flagMaterial, SLOT_FLAGS, false);
        for (KonPropertyFlag flag : KonPropertyFlag.values()) {
            if (!this.infoRuin.hasPropertyValue(flag)) continue;
            String flagDisplaySymbol = DisplayManager.boolean2Symbol(this.infoRuin.getPropertyValue(flag));
            icon.addNameValue(flag.getName(), flagDisplaySymbol);
        }
        result.addIcon(icon);
        this.addNavEmpty(result);
        this.addNavClose(result);
        this.addNavReturn(result);
        return result;
    }

    private DisplayView createCampInfoView() {
        if (this.infoCamp == null) {
            return null;
        }
        int rows = 1;
        int SLOT_CAMP = 3;
        int SLOT_CLAN = 4;
        int SLOT_OWNER = 5;
        String title = MessagePath.TERRITORY_CAMP.getMessage(new Object[0]) + " " + this.infoCamp.getOwner().getName();
        DisplayView result = new DisplayView(rows, title);
        MenuIcon icon = new CampIcon(this.infoCamp, SLOT_CAMP, false);
        result.addIcon(icon);
        icon = new InfoIcon(MessagePath.LABEL_CAMP_CLAN.getMessage(new Object[0]), Material.CHAIN, SLOT_CLAN, false);
        if (this.getKonquest().getCampManager().isCampGroupsEnabled()) {
            if (this.getKonquest().getCampManager().isCampGrouped(this.infoCamp)) {
                KonCampGroup clan = this.getKonquest().getCampManager().getCampGroup(this.infoCamp);
                int numClanCamps = clan.getCamps().size();
                icon.addNameValue(MessagePath.LABEL_TOTAL.getMessage(new Object[0]), numClanCamps);
            } else {
                icon.addAlert(MessagePath.LABEL_UNAVAILABLE.getMessage(new Object[0]));
            }
        } else {
            icon.addAlert(MessagePath.LABEL_DISABLED.getMessage(new Object[0]));
        }
        result.addIcon(icon);
        icon = new PlayerIcon(this.infoCamp.getOwner(), this.getColor((KonOfflinePlayer)this.player, this.infoCamp.getKingdom()), this.getRelation((KonOfflinePlayer)this.player, this.infoCamp.getKingdom()), SLOT_OWNER, true);
        icon.addHint(MessagePath.MENU_HINT_OPEN.getMessage(new Object[0]));
        icon.setState(MenuState.PLAYER_INFO);
        result.addIcon(icon);
        this.addNavEmpty(result);
        this.addNavClose(result);
        this.addNavReturn(result);
        return result;
    }

    private DisplayView createMonumentInfoView() {
        if (this.infoTemplate == null) {
            return null;
        }
        int rows = 1;
        int SLOT_TEMPLATE = 2;
        int SLOT_SANCTUARY = 4;
        int SLOT_KINGDOMS = 6;
        String title = MessagePath.LABEL_MONUMENT_TEMPLATE.getMessage(new Object[0]) + " " + this.infoTemplate.getName();
        DisplayView result = new DisplayView(rows, title);
        double totalCost = this.getKonquest().getKingdomManager().getCostTemplate() + this.infoTemplate.getCost();
        MenuIcon icon = new TemplateIcon(this.infoTemplate, SLOT_TEMPLATE, false);
        icon.addNameValue(MessagePath.LABEL_LOOT_TYPE.getMessage(new Object[0]), this.getKonquest().getLootManager().getMonumentLootDisplayName(this.infoTemplate));
        icon.addNameValue(MessagePath.LABEL_COST.getMessage(new Object[0]), KonquestPlugin.getCurrencyFormat(totalCost));
        result.addIcon(icon);
        KonSanctuary templateSanctuary = this.getKonquest().getSanctuaryManager().getSanctuaryOfTemplate(this.infoTemplate);
        if (templateSanctuary != null) {
            icon = new SanctuaryIcon(templateSanctuary, SLOT_SANCTUARY, true);
            icon.addHint(MessagePath.MENU_HINT_OPEN.getMessage(new Object[0]));
            icon.setState(MenuState.SANCTUARY_INFO);
            result.addIcon(icon);
        }
        int kingdomCount = 0;
        for (KonKingdom kingdom : this.getKonquest().getKingdomManager().getKingdoms()) {
            if (kingdom.getMonumentTemplate() == null || !kingdom.getMonumentTemplate().equals(this.infoTemplate)) continue;
            ++kingdomCount;
        }
        icon = new InfoIcon(MessagePath.LABEL_KINGDOMS.getMessage(new Object[0]), Material.DIAMOND_HELMET, SLOT_KINGDOMS, true);
        icon.addDescription(MessagePath.MENU_INFO_TEMPLATE_KINGDOMS.getMessage(new Object[0]));
        icon.addNameValue(MessagePath.LABEL_TOTAL.getMessage(new Object[0]), kingdomCount);
        icon.addHint(MessagePath.MENU_HINT_OPEN.getMessage(new Object[0]));
        icon.setState(MenuState.MONUMENT_INFO_KINGDOMS);
        result.addIcon(icon);
        this.addNavEmpty(result);
        this.addNavClose(result);
        this.addNavReturn(result);
        return result;
    }

    @Override
    public ArrayList<DisplayView> createView(StateMenu.State context) {
        ArrayList<DisplayView> result = new ArrayList<DisplayView>();
        MenuState currentState = (MenuState)context;
        switch (currentState.ordinal()) {
            case 0: {
                result.add(this.createRootView());
                break;
            }
            case 1: 
            case 10: 
            case 11: 
            case 18: 
            case 19: {
                result.addAll(this.createPlayerView(currentState));
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 29: {
                result.addAll(this.createKingdomView(currentState));
                break;
            }
            case 3: 
            case 12: 
            case 13: 
            case 14: {
                result.addAll(this.createTownView(currentState));
                break;
            }
            case 25: {
                result.addAll(this.createCampView());
                break;
            }
            case 23: {
                result.addAll(this.createRuinView());
                break;
            }
            case 20: {
                result.addAll(this.createSanctuaryView());
                break;
            }
            case 22: 
            case 27: {
                result.addAll(this.createMonumentView(currentState));
                break;
            }
            case 4: {
                result.addAll(this.createStatsView());
                break;
            }
            case 2: {
                result.add(this.createPlayerInfoView());
                break;
            }
            case 6: {
                result.add(this.createKingdomInfoView());
                break;
            }
            case 15: {
                result.add(this.createTownInfoView());
                break;
            }
            case 16: {
                result.addAll(this.createOptionsView());
                break;
            }
            case 17: {
                result.addAll(this.createUpgradesView());
                break;
            }
            case 21: {
                result.add(this.createSanctuaryInfoView());
                break;
            }
            case 24: {
                result.add(this.createRuinInfoView());
                break;
            }
            case 26: {
                result.add(this.createCampInfoView());
                break;
            }
            case 28: {
                result.add(this.createMonumentInfoView());
                break;
            }
        }
        return result;
    }

    @Override
    public DisplayView updateState(int slot, boolean clickType) {
        DisplayView result = null;
        MenuState currentState = (MenuState)this.getCurrentState();
        if (currentState == null) {
            return null;
        }
        if (this.isCurrentNavSlot(slot)) {
            if (this.isNavClose(slot)) {
                return null;
            }
            if (this.isNavHome(slot)) {
                this.getKonquest().getDisplayManager().displayMainMenu(this.player);
            } else if (this.isNavReturn(slot)) {
                MenuState returnState = this.popReturn(currentState);
                result = returnState == null ? this.setCurrentView(MenuState.ROOT) : this.setCurrentView(returnState);
            } else if (this.isNavBack(slot)) {
                result = this.goPageBack();
            } else if (this.isNavNext(slot)) {
                result = this.goPageNext();
            }
        } else if (this.isCurrentMenuSlot(slot)) {
            DisplayView view = this.getCurrentView();
            if (view == null) {
                return null;
            }
            MenuIcon clickedIcon = view.getIcon(slot);
            MenuState nextState = (MenuState)clickedIcon.getState();
            if (nextState == null) {
                return null;
            }
            switch (currentState.ordinal()) {
                case 0: {
                    this.clearReturn();
                    switch (nextState.ordinal()) {
                        case 1: 
                        case 5: 
                        case 13: 
                        case 14: 
                        case 20: 
                        case 23: 
                        case 25: 
                        case 27: {
                            result = this.setCurrentView(nextState);
                        }
                    }
                    break;
                }
                case 1: 
                case 10: 
                case 11: 
                case 18: 
                case 19: 
                case 26: {
                    if (!nextState.equals(MenuState.PLAYER_INFO) || !(clickedIcon instanceof PlayerIcon)) break;
                    this.infoPlayer = this.getKonquest().getPlayerManager().getOfflinePlayer(((PlayerIcon)clickedIcon).getOfflinePlayer());
                    result = this.refreshNewView(nextState);
                    break;
                }
                case 5: 
                case 7: 
                case 8: 
                case 9: 
                case 29: {
                    if (!nextState.equals(MenuState.KINGDOM_INFO) || !(clickedIcon instanceof KingdomIcon)) break;
                    this.infoKingdom = ((KingdomIcon)clickedIcon).getKingdom();
                    result = this.refreshNewView(nextState);
                    break;
                }
                case 3: 
                case 12: 
                case 13: 
                case 14: {
                    if (!nextState.equals(MenuState.TOWN_INFO) || !(clickedIcon instanceof TownIcon)) break;
                    this.infoTown = ((TownIcon)clickedIcon).getTown();
                    result = this.refreshNewView(nextState);
                    break;
                }
                case 25: {
                    if (!nextState.equals(MenuState.CAMP_INFO) || !(clickedIcon instanceof CampIcon)) break;
                    this.infoCamp = ((CampIcon)clickedIcon).getCamp();
                    result = this.refreshNewView(nextState);
                    break;
                }
                case 23: {
                    if (!nextState.equals(MenuState.RUIN_INFO) || !(clickedIcon instanceof RuinIcon)) break;
                    this.infoRuin = ((RuinIcon)clickedIcon).getRuin();
                    result = this.refreshNewView(nextState);
                    break;
                }
                case 20: {
                    if (!nextState.equals(MenuState.SANCTUARY_INFO) || !(clickedIcon instanceof SanctuaryIcon)) break;
                    this.infoSanctuary = ((SanctuaryIcon)clickedIcon).getSanctuary();
                    result = this.refreshNewView(nextState);
                    break;
                }
                case 22: 
                case 27: {
                    if (!nextState.equals(MenuState.MONUMENT_INFO) || !(clickedIcon instanceof TemplateIcon)) break;
                    this.infoTemplate = ((TemplateIcon)clickedIcon).getTemplate();
                    result = this.refreshNewView(nextState);
                    break;
                }
                case 2: {
                    switch (nextState.ordinal()) {
                        case 26: {
                            if (!(clickedIcon instanceof CampIcon)) break;
                            this.infoCamp = ((CampIcon)clickedIcon).getCamp();
                            result = this.refreshNewView(nextState);
                            break;
                        }
                        case 6: {
                            if (!(clickedIcon instanceof KingdomIcon)) break;
                            this.infoKingdom = ((KingdomIcon)clickedIcon).getKingdom();
                            result = this.refreshNewView(nextState);
                            break;
                        }
                        case 30: {
                            this.getKonquest().getDisplayManager().displayScorePlayerMenu(this.player, this.infoPlayer);
                            break;
                        }
                        case 3: 
                        case 4: {
                            result = this.refreshNewView(nextState);
                        }
                    }
                    break;
                }
                case 6: {
                    switch (nextState.ordinal()) {
                        case 15: {
                            if (!(clickedIcon instanceof TownIcon)) break;
                            this.infoTown = ((TownIcon)clickedIcon).getTown();
                            result = this.refreshNewView(nextState);
                            break;
                        }
                        case 2: {
                            if (!(clickedIcon instanceof PlayerIcon)) break;
                            this.infoPlayer = this.getKonquest().getPlayerManager().getOfflinePlayer(((PlayerIcon)clickedIcon).getOfflinePlayer());
                            result = this.refreshNewView(nextState);
                            break;
                        }
                        case 28: {
                            if (!(clickedIcon instanceof TemplateIcon)) break;
                            this.infoTemplate = ((TemplateIcon)clickedIcon).getTemplate();
                            result = this.refreshNewView(nextState);
                            break;
                        }
                        case 31: {
                            this.getKonquest().getDisplayManager().displayScoreKingdomMenu(this.player, this.infoKingdom);
                            break;
                        }
                        case 7: 
                        case 8: 
                        case 9: 
                        case 10: 
                        case 11: 
                        case 12: {
                            result = this.refreshNewView(nextState);
                        }
                    }
                    break;
                }
                case 15: {
                    switch (nextState.ordinal()) {
                        case 6: {
                            if (!(clickedIcon instanceof KingdomIcon)) break;
                            this.infoKingdom = ((KingdomIcon)clickedIcon).getKingdom();
                            result = this.refreshNewView(nextState);
                            break;
                        }
                        case 2: {
                            if (!(clickedIcon instanceof PlayerIcon)) break;
                            this.infoPlayer = this.getKonquest().getPlayerManager().getOfflinePlayer(((PlayerIcon)clickedIcon).getOfflinePlayer());
                            result = this.refreshNewView(nextState);
                            break;
                        }
                        case 16: 
                        case 17: 
                        case 18: 
                        case 19: {
                            result = this.refreshNewView(nextState);
                        }
                    }
                    break;
                }
                case 21: {
                    if (!nextState.equals(MenuState.SANCTUARY_INFO_MONUMENTS)) break;
                    result = this.refreshNewView(nextState);
                    break;
                }
                case 28: {
                    switch (nextState.ordinal()) {
                        case 21: {
                            if (!(clickedIcon instanceof SanctuaryIcon)) break;
                            this.infoSanctuary = ((SanctuaryIcon)clickedIcon).getSanctuary();
                            result = this.refreshNewView(nextState);
                            break;
                        }
                        case 29: {
                            result = this.refreshNewView(nextState);
                        }
                    }
                    break;
                }
            }
            this.pushReturn(currentState, nextState);
        }
        return result;
    }

    private String getTitle(MenuState context) {
        String result = "error";
        switch (context.ordinal()) {
            case 0: {
                result = MessagePath.MENU_MAIN_INFO.getMessage(new Object[0]);
                break;
            }
            case 1: {
                result = MessagePath.LABEL_PLAYERS.getMessage(new Object[0]);
                break;
            }
            case 5: 
            case 29: {
                result = MessagePath.LABEL_KINGDOMS.getMessage(new Object[0]);
                break;
            }
            case 13: {
                result = MessagePath.LABEL_CAPITALS.getMessage(new Object[0]);
                break;
            }
            case 3: 
            case 12: 
            case 14: {
                result = MessagePath.LABEL_TOWNS.getMessage(new Object[0]);
                break;
            }
            case 25: {
                result = MessagePath.LABEL_CAMPS.getMessage(new Object[0]);
                break;
            }
            case 23: {
                result = MessagePath.LABEL_RUINS.getMessage(new Object[0]);
                break;
            }
            case 20: {
                result = MessagePath.LABEL_SANCTUARIES.getMessage(new Object[0]);
                break;
            }
            case 22: 
            case 27: {
                result = MessagePath.LABEL_MONUMENT_TEMPLATES.getMessage(new Object[0]);
                break;
            }
            case 4: {
                result = MessagePath.MENU_PREFIX_TITLE_STATS.getMessage(new Object[0]);
                break;
            }
            case 10: {
                result = MessagePath.LABEL_OFFICERS.getMessage(new Object[0]);
                break;
            }
            case 11: {
                result = MessagePath.LABEL_MEMBERS.getMessage(new Object[0]);
                break;
            }
            case 7: {
                result = MessagePath.DIPLOMACY_WAR.getMessage(new Object[0]);
                break;
            }
            case 8: {
                result = MessagePath.DIPLOMACY_ALLIANCE.getMessage(new Object[0]);
                break;
            }
            case 9: {
                result = MessagePath.DIPLOMACY_TRADE.getMessage(new Object[0]);
                break;
            }
            case 18: {
                result = MessagePath.LABEL_KNIGHTS.getMessage(new Object[0]);
                break;
            }
            case 19: {
                result = MessagePath.LABEL_RESIDENTS.getMessage(new Object[0]);
                break;
            }
            case 16: {
                result = MessagePath.LABEL_OPTIONS.getMessage(new Object[0]);
                break;
            }
            case 17: {
                result = MessagePath.LABEL_UPGRADES.getMessage(new Object[0]);
                break;
            }
        }
        return result;
    }

    private void pushReturn(MenuState currentState, MenuState nextState) {
        if (!this.returnStack.containsKey(nextState)) {
            this.returnStack.put(nextState, currentState);
        }
    }

    private MenuState popReturn(MenuState currentState) {
        return this.returnStack.get(currentState);
    }

    private void clearReturn() {
        this.returnStack.clear();
    }

    static enum MenuState implements StateMenu.State
    {
        ROOT,
        PLAYER_LIST,
        PLAYER_INFO,
        PLAYER_INFO_TOWNS,
        PLAYER_INFO_STATS,
        KINGDOM_LIST,
        KINGDOM_INFO,
        KINGDOM_INFO_ENEMIES,
        KINGDOM_INFO_ALLIES,
        KINGDOM_INFO_TRADERS,
        KINGDOM_INFO_OFFICERS,
        KINGDOM_INFO_MEMBERS,
        KINGDOM_INFO_TOWNS,
        CAPITAL_LIST,
        TOWN_LIST,
        TOWN_INFO,
        TOWN_INFO_OPTIONS,
        TOWN_INFO_UPGRADES,
        TOWN_INFO_KNIGHTS,
        TOWN_INFO_RESIDENTS,
        SANCTUARY_LIST,
        SANCTUARY_INFO,
        SANCTUARY_INFO_MONUMENTS,
        RUIN_LIST,
        RUIN_INFO,
        CAMP_LIST,
        CAMP_INFO,
        MONUMENT_LIST,
        MONUMENT_INFO,
        MONUMENT_INFO_KINGDOMS,
        DISPLAY_PLAYER_SCORE,
        DISPLAY_KINGDOM_SCORE;

    }
}

