/*
 * Decompiled with CFR 0.152.
 */
package com.github.rumsfield.konquest.display.menu;

import com.github.rumsfield.konquest.Konquest;
import com.github.rumsfield.konquest.KonquestPlugin;
import com.github.rumsfield.konquest.api.model.KonquestDiplomacyType;
import com.github.rumsfield.konquest.command.CommandType;
import com.github.rumsfield.konquest.display.DisplayView;
import com.github.rumsfield.konquest.display.StateMenu;
import com.github.rumsfield.konquest.display.icon.ConfirmationIcon;
import com.github.rumsfield.konquest.display.icon.DiplomacyIcon;
import com.github.rumsfield.konquest.display.icon.InfoIcon;
import com.github.rumsfield.konquest.display.icon.KingdomIcon;
import com.github.rumsfield.konquest.display.icon.MenuIcon;
import com.github.rumsfield.konquest.display.icon.PlayerIcon;
import com.github.rumsfield.konquest.display.icon.TemplateIcon;
import com.github.rumsfield.konquest.display.icon.TownIcon;
import com.github.rumsfield.konquest.manager.DisplayManager;
import com.github.rumsfield.konquest.manager.KingdomManager;
import com.github.rumsfield.konquest.model.KonKingdom;
import com.github.rumsfield.konquest.model.KonMonumentTemplate;
import com.github.rumsfield.konquest.model.KonOfflinePlayer;
import com.github.rumsfield.konquest.model.KonPlayer;
import com.github.rumsfield.konquest.model.KonTown;
import com.github.rumsfield.konquest.utility.ChatUtil;
import com.github.rumsfield.konquest.utility.CorePath;
import com.github.rumsfield.konquest.utility.Labeler;
import com.github.rumsfield.konquest.utility.MessagePath;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;

public class KingdomMenu
extends StateMenu {
    private final KingdomManager manager;
    private final KonPlayer player;
    private final KonKingdom kingdom;
    private KonKingdom diplomacyKingdom;
    private KonTown purchaseOfferTown;
    private double purchaseOfferAmount;
    private double purchaseOfferModify;
    private boolean isCreatedKingdom;
    private final boolean isAdmin;

    public KingdomMenu(Konquest konquest, KonPlayer player, KonKingdom kingdom, boolean isAdmin) {
        super(konquest, MenuState.ROOT, AccessType.REGULAR);
        this.manager = konquest.getKingdomManager();
        this.player = player;
        this.kingdom = kingdom;
        this.diplomacyKingdom = null;
        this.purchaseOfferTown = null;
        this.purchaseOfferAmount = 0.0;
        this.purchaseOfferModify = 1.0;
        this.isCreatedKingdom = false;
        this.isAdmin = isAdmin;
        if (kingdom.isCreated()) {
            this.isCreatedKingdom = true;
            UUID id = player.getBukkitPlayer().getUniqueId();
            if (isAdmin) {
                this.setAccess(AccessType.MASTER);
            } else if (kingdom.isMaster(id)) {
                this.setAccess(AccessType.MASTER);
            } else if (kingdom.isOfficer(id)) {
                this.setAccess(AccessType.OFFICER);
            } else if (kingdom.isMember(id)) {
                this.setAccess(AccessType.REGULAR);
            }
        }
        this.setCurrentView(MenuState.ROOT);
    }

    private DisplayView createRootView() {
        int ROOT_SLOT_JOIN = 0;
        int ROOT_SLOT_CREATE = 1;
        int ROOT_SLOT_EXILE = 2;
        int ROOT_SLOT_INFO = 4;
        int ROOT_SLOT_INVITE = 6;
        int ROOT_SLOT_LIST = 8;
        int ROOT_SLOT_RELATIONSHIPS = 11;
        int ROOT_SLOT_PURCHASE = 12;
        int ROOT_SLOT_OFFERS = 14;
        int ROOT_SLOT_REQUESTS = 15;
        int ROOT_SLOT_PROMOTE = 18;
        int ROOT_SLOT_DEMOTE = 19;
        int ROOT_SLOT_TRANSFER = 20;
        int ROOT_SLOT_OPEN = 21;
        int ROOT_SLOT_TEMPLATE = 23;
        int ROOT_SLOT_DISBAND = 24;
        int ROOT_SLOT_DESTROY = 25;
        int ROOT_SLOT_CAPITAL = 26;
        int rows = 1;
        if (this.getAccess().equals(AccessType.OFFICER)) {
            rows = 2;
        } else if (this.getAccess().equals(AccessType.MASTER)) {
            rows = 3;
        }
        DisplayView result = new DisplayView(rows, this.getTitle(MenuState.ROOT));
        boolean isJoinClickable = !this.isAdmin;
        MenuIcon icon = new InfoIcon(MessagePath.MENU_KINGDOM_JOIN.getMessage(new Object[0]), Material.SADDLE, ROOT_SLOT_JOIN, isJoinClickable);
        icon.addDescription(MessagePath.MENU_KINGDOM_DESCRIPTION_JOIN.getMessage(new Object[0]));
        if (isJoinClickable) {
            icon.addHint(MessagePath.MENU_HINT_OPEN.getMessage(new Object[0]));
        } else {
            icon.addAlert(MessagePath.LABEL_UNAVAILABLE.getMessage(new Object[0]));
        }
        icon.setState(MenuState.A_JOIN);
        result.addIcon(icon);
        if (!this.getKonquest().getKingdomManager().isKingdomCreateAdminOnly()) {
            double cost_create = this.getKonquest().getCore().getDouble(CorePath.FAVOR_KINGDOMS_COST_CREATE.getPath(), 0.0);
            icon = new InfoIcon(MessagePath.MENU_KINGDOM_CREATE.getMessage(new Object[0]), Material.PUFFERFISH_SPAWN_EGG, ROOT_SLOT_CREATE, true);
            icon.addDescription(MessagePath.MENU_KINGDOM_DESCRIPTION_CREATE.getMessage(new Object[0]));
            icon.addNameValue(MessagePath.LABEL_COST.getMessage(new Object[0]), KonquestPlugin.getCurrencyFormat(cost_create));
            icon.addHint(MessagePath.MENU_HINT_VIEW.getMessage(new Object[0]));
            icon.setState(MenuState.A_CREATE);
            result.addIcon(icon);
        }
        boolean isExileClickable = !this.isAdmin && this.isCreatedKingdom;
        icon = new InfoIcon(MessagePath.MENU_KINGDOM_EXILE.getMessage(new Object[0]), Material.ARROW, ROOT_SLOT_EXILE, isExileClickable);
        icon.addDescription(MessagePath.MENU_KINGDOM_DESCRIPTION_EXILE.getMessage(new Object[0]));
        if (isExileClickable) {
            icon.addHint(MessagePath.MENU_HINT_OPEN.getMessage(new Object[0]));
        } else {
            icon.addAlert(MessagePath.LABEL_UNAVAILABLE.getMessage(new Object[0]));
            icon.addError(MessagePath.GENERIC_ERROR_DENY_BARBARIAN.getMessage(new Object[0]));
        }
        icon.setState(MenuState.A_EXILE);
        result.addIcon(icon);
        boolean isInvitesClickable = !this.isAdmin;
        int numInvites = this.manager.getInviteKingdoms(this.player).size();
        Material inviteMat = numInvites > 0 ? Material.WRITABLE_BOOK : Material.BOOK;
        icon = new InfoIcon(MessagePath.MENU_KINGDOM_INVITES.getMessage(new Object[0]), inviteMat, ROOT_SLOT_INVITE, isInvitesClickable);
        icon.addDescription(MessagePath.MENU_KINGDOM_DESCRIPTION_INVITES.getMessage(new Object[0]));
        icon.addNameValue(MessagePath.LABEL_TOTAL.getMessage(new Object[0]), numInvites);
        if (isInvitesClickable) {
            icon.addHint(MessagePath.MENU_HINT_OPEN.getMessage(new Object[0]));
        } else {
            icon.addAlert(MessagePath.LABEL_UNAVAILABLE.getMessage(new Object[0]));
        }
        if (numInvites > 0) {
            icon.addNameValue(MessagePath.MENU_KINGDOM_INVITES.getMessage(new Object[0]), numInvites);
        }
        icon.setState(MenuState.A_INVITE);
        result.addIcon(icon);
        int numList = this.manager.getKingdoms().size();
        icon = new InfoIcon(MessagePath.MENU_KINGDOM_LIST.getMessage(new Object[0]), Material.PAPER, ROOT_SLOT_LIST, true);
        icon.addDescription(MessagePath.MENU_KINGDOM_DESCRIPTION_LIST.getMessage(new Object[0]));
        icon.addNameValue(MessagePath.LABEL_TOTAL.getMessage(new Object[0]), numList);
        icon.addHint(MessagePath.MENU_HINT_OPEN.getMessage(new Object[0]));
        icon.setState(MenuState.A_LIST);
        result.addIcon(icon);
        if (this.isCreatedKingdom) {
            boolean isInfoClickable = !this.isAdmin;
            icon = new KingdomIcon(this.kingdom, this.getColor((KonOfflinePlayer)this.player, this.kingdom), this.getRelation((KonOfflinePlayer)this.player, this.kingdom), ROOT_SLOT_INFO, isInfoClickable);
            icon.addProperty(MessagePath.LABEL_INFORMATION.getMessage(new Object[0]));
            if (isInfoClickable) {
                icon.addHint(MessagePath.MENU_HINT_VIEW.getMessage(new Object[0]));
            }
            icon.setState(MenuState.A_INFO);
            result.addIcon(icon);
            if (this.getAccess().equals(AccessType.OFFICER) || this.getAccess().equals(AccessType.MASTER)) {
                int numRequests;
                boolean isRelationsClickable = !this.kingdom.isPeaceful();
                icon = new InfoIcon(MessagePath.MENU_KINGDOM_RELATION.getMessage(new Object[0]), Material.GOLDEN_SWORD, ROOT_SLOT_RELATIONSHIPS, isRelationsClickable);
                icon.addDescription(MessagePath.MENU_KINGDOM_DESCRIPTION_RELATION.getMessage(new Object[0]));
                icon.addProperty(MessagePath.RELATIONSHIP_RANK_OFFICER.getMessage(new Object[0]));
                if (isRelationsClickable) {
                    icon.addHint(MessagePath.MENU_HINT_OPEN.getMessage(new Object[0]));
                } else {
                    icon.addAlert(MessagePath.LABEL_UNAVAILABLE.getMessage(new Object[0]));
                }
                icon.setState(MenuState.B_RELATIONSHIP);
                result.addIcon(icon);
                if (this.getKonquest().getKingdomManager().getIsTownPurchaseEnable()) {
                    boolean isPurchaseClickable = !this.isAdmin;
                    icon = new InfoIcon(MessagePath.MENU_KINGDOM_PURCHASE.getMessage(new Object[0]), Material.GOLDEN_HOE, ROOT_SLOT_PURCHASE, isPurchaseClickable);
                    icon.addDescription(MessagePath.MENU_KINGDOM_DESCRIPTION_PURCHASE.getMessage(new Object[0]));
                    icon.addProperty(MessagePath.RELATIONSHIP_RANK_OFFICER.getMessage(new Object[0]));
                    if (isPurchaseClickable) {
                        icon.addHint(MessagePath.MENU_HINT_OPEN.getMessage(new Object[0]));
                    } else {
                        icon.addAlert(MessagePath.LABEL_UNAVAILABLE.getMessage(new Object[0]));
                    }
                    icon.setState(MenuState.B_PURCHASE);
                    result.addIcon(icon);
                    int numOffers = this.getKonquest().getKingdomManager().getNumTownPurchaseOffers(this.kingdom);
                    Material offerMat = numOffers > 0 ? Material.GOLD_INGOT : Material.BOWL;
                    icon = new InfoIcon(MessagePath.MENU_KINGDOM_OFFERS.getMessage(new Object[0]), offerMat, ROOT_SLOT_OFFERS, true);
                    icon.addDescription(MessagePath.MENU_KINGDOM_DESCRIPTION_OFFERS.getMessage(new Object[0]));
                    icon.addNameValue(MessagePath.LABEL_TOTAL.getMessage(new Object[0]), numOffers);
                    icon.addProperty(MessagePath.RELATIONSHIP_RANK_OFFICER.getMessage(new Object[0]));
                    icon.addHint(MessagePath.MENU_HINT_OPEN.getMessage(new Object[0]));
                    icon.setState(MenuState.B_OFFERS);
                    result.addIcon(icon);
                }
                Material requestMat = (numRequests = this.kingdom.getJoinRequests().size()) > 0 ? Material.HONEY_BOTTLE : Material.GLASS_BOTTLE;
                icon = new InfoIcon(MessagePath.MENU_KINGDOM_REQUESTS.getMessage(new Object[0]), requestMat, ROOT_SLOT_REQUESTS, true);
                icon.addDescription(MessagePath.MENU_KINGDOM_DESCRIPTION_REQUESTS.getMessage(new Object[0]));
                icon.addNameValue(MessagePath.LABEL_TOTAL.getMessage(new Object[0]), numRequests);
                icon.addProperty(MessagePath.RELATIONSHIP_RANK_OFFICER.getMessage(new Object[0]));
                icon.addHint(MessagePath.MENU_HINT_OPEN.getMessage(new Object[0]));
                icon.setState(MenuState.B_REQUESTS);
                result.addIcon(icon);
            }
            if (this.getAccess().equals(AccessType.MASTER)) {
                boolean isPromoteClickable = this.kingdom.isPromoteable() || this.isAdmin;
                icon = new InfoIcon(MessagePath.MENU_KINGDOM_PROMOTE.getMessage(new Object[0]), Material.IRON_HORSE_ARMOR, ROOT_SLOT_PROMOTE, isPromoteClickable);
                icon.addDescription(MessagePath.MENU_KINGDOM_DESCRIPTION_PROMOTE.getMessage(new Object[0]));
                icon.addProperty(MessagePath.RELATIONSHIP_RANK_MASTER.getMessage(new Object[0]));
                if (isPromoteClickable) {
                    icon.addHint(MessagePath.MENU_HINT_OPEN.getMessage(new Object[0]));
                } else {
                    icon.addAlert(MessagePath.LABEL_UNAVAILABLE.getMessage(new Object[0]));
                }
                icon.setState(MenuState.C_PROMOTE);
                result.addIcon(icon);
                boolean isDemoteClickable = this.kingdom.isDemoteable() || this.isAdmin;
                icon = new InfoIcon(MessagePath.MENU_KINGDOM_DEMOTE.getMessage(new Object[0]), Material.LEATHER_CHESTPLATE, ROOT_SLOT_DEMOTE, isDemoteClickable);
                icon.addDescription(MessagePath.MENU_KINGDOM_DESCRIPTION_DEMOTE.getMessage(new Object[0]));
                icon.addProperty(MessagePath.RELATIONSHIP_RANK_MASTER.getMessage(new Object[0]));
                if (isDemoteClickable) {
                    icon.addHint(MessagePath.MENU_HINT_OPEN.getMessage(new Object[0]));
                } else {
                    icon.addAlert(MessagePath.LABEL_UNAVAILABLE.getMessage(new Object[0]));
                }
                icon.setState(MenuState.C_DEMOTE);
                result.addIcon(icon);
                if (!this.kingdom.isAdminOperated()) {
                    boolean isTransferClickable = this.kingdom.isTransferable() || this.isAdmin;
                    icon = new InfoIcon(MessagePath.MENU_KINGDOM_TRANSFER.getMessage(new Object[0]), Material.IRON_HELMET, ROOT_SLOT_TRANSFER, isTransferClickable);
                    icon.addDescription(MessagePath.MENU_KINGDOM_DESCRIPTION_TRANSFER.getMessage(new Object[0]));
                    icon.addProperty(MessagePath.RELATIONSHIP_RANK_MASTER.getMessage(new Object[0]));
                    if (isTransferClickable) {
                        icon.addHint(MessagePath.MENU_HINT_OPEN.getMessage(new Object[0]));
                    } else {
                        icon.addAlert(MessagePath.LABEL_UNAVAILABLE.getMessage(new Object[0]));
                    }
                    icon.setState(MenuState.C_TRANSFER);
                    result.addIcon(icon);
                }
                if (this.getKonquest().getKingdomManager().getIsTownDestroyMasterEnable()) {
                    icon = new InfoIcon(MessagePath.MENU_TOWN_DESTROY.getMessage(new Object[0]), Material.FLINT_AND_STEEL, ROOT_SLOT_DESTROY, true);
                    icon.addDescription(MessagePath.MENU_TOWN_DESCRIPTION_DESTROY.getMessage(new Object[0]));
                    icon.addProperty(MessagePath.RELATIONSHIP_RANK_MASTER.getMessage(new Object[0]));
                    icon.addHint(MessagePath.MENU_HINT_OPEN.getMessage(new Object[0]));
                    icon.setState(MenuState.C_DESTROY);
                    result.addIcon(icon);
                }
                if (this.getKonquest().getKingdomManager().getIsCapitalSwapEnable()) {
                    icon = new InfoIcon(MessagePath.MENU_KINGDOM_CAPITAL.getMessage(new Object[0]), Material.PISTON, ROOT_SLOT_CAPITAL, true);
                    icon.addDescription(MessagePath.MENU_KINGDOM_DESCRIPTION_CAPITAL.getMessage(new Object[0]));
                    icon.addProperty(MessagePath.RELATIONSHIP_RANK_MASTER.getMessage(new Object[0]));
                    icon.addHint(MessagePath.MENU_HINT_OPEN.getMessage(new Object[0]));
                    icon.setState(MenuState.C_CAPITAL);
                    result.addIcon(icon);
                }
                String currentValue = DisplayManager.boolean2Lang(this.kingdom.isOpen()) + " " + DisplayManager.boolean2Symbol(this.kingdom.isOpen());
                icon = new InfoIcon(MessagePath.LABEL_OPEN.getMessage(new Object[0]), Material.IRON_DOOR, ROOT_SLOT_OPEN, true);
                icon.addProperty(MessagePath.RELATIONSHIP_RANK_MASTER.getMessage(new Object[0]));
                icon.addNameValue(MessagePath.LABEL_CURRENT.getMessage(new Object[0]), currentValue);
                icon.addHint(MessagePath.MENU_HINT_CHANGE.getMessage(new Object[0]));
                icon.setState(MenuState.C_OPEN);
                result.addIcon(icon);
                boolean isTemplateClickable = this.kingdom.isMonumentTemplateValid();
                icon = new InfoIcon(MessagePath.MENU_KINGDOM_TEMPLATE.getMessage(new Object[0]), Material.CRAFTING_TABLE, ROOT_SLOT_TEMPLATE, isTemplateClickable);
                icon.addProperty(MessagePath.RELATIONSHIP_RANK_MASTER.getMessage(new Object[0]));
                icon.addDescription(MessagePath.MENU_KINGDOM_DESCRIPTION_TEMPLATE.getMessage(new Object[0]));
                icon.addNameValue(MessagePath.LABEL_MONUMENT_TEMPLATE.getMessage(new Object[0]), this.kingdom.getMonumentTemplateName());
                icon.addNameValue(MessagePath.LABEL_CRITICAL_HITS.getMessage(new Object[0]), this.kingdom.getMonumentTemplate().getNumCriticals());
                icon.addNameValue(MessagePath.LABEL_LOOT_CHESTS.getMessage(new Object[0]), this.kingdom.getMonumentTemplate().getNumLootChests());
                if (isTemplateClickable) {
                    icon.addHint(MessagePath.MENU_HINT_OPEN.getMessage(new Object[0]));
                    icon.setState(MenuState.C_TEMPLATE);
                } else if (this.kingdom.getMonumentTemplate().isBlanking()) {
                    icon.addAlert(MessagePath.LABEL_UNAVAILABLE.getMessage(new Object[0]));
                    icon.addDescription(MessagePath.PROTECTION_ERROR_TEMPLATE_MODIFY.getMessage(new Object[0]));
                } else {
                    icon.addAlert(MessagePath.LABEL_INVALID.getMessage(new Object[0]));
                }
                result.addIcon(icon);
                if (!this.kingdom.isAdminOperated()) {
                    icon = new InfoIcon(MessagePath.MENU_KINGDOM_DISBAND.getMessage(new Object[0]), Material.BONE, ROOT_SLOT_DISBAND, true);
                    icon.addProperty(MessagePath.RELATIONSHIP_RANK_MASTER.getMessage(new Object[0]));
                    icon.addDescription(MessagePath.MENU_KINGDOM_DESCRIPTION_DISBAND.getMessage(new Object[0]));
                    icon.addHint(MessagePath.MENU_HINT_OPEN.getMessage(new Object[0]));
                    icon.setState(MenuState.C_DISBAND);
                    result.addIcon(icon);
                }
            }
        }
        this.addNavEmpty(result);
        this.addNavClose(result);
        if (!this.isAdmin) {
            this.addNavHome(result);
        }
        return result;
    }

    private DisplayView createExileView() {
        DisplayView result = new DisplayView(1, this.getTitle(MenuState.A_EXILE));
        int SLOT_YES = 3;
        int SLOT_NO = 5;
        ConfirmationIcon icon = new ConfirmationIcon(true, SLOT_YES);
        icon.addHint(MessagePath.MENU_KINGDOM_HINT_EXILE.getMessage(new Object[0]));
        icon.setState(MenuState.CONFIRM_YES);
        result.addIcon(icon);
        icon = new ConfirmationIcon(false, SLOT_NO);
        icon.addHint(MessagePath.MENU_HINT_EXIT.getMessage(new Object[0]));
        icon.setState(MenuState.CONFIRM_NO);
        result.addIcon(icon);
        this.addNavEmpty(result);
        this.addNavClose(result);
        this.addNavReturn(result);
        return result;
    }

    private DisplayView createDisbandView() {
        DisplayView result = new DisplayView(1, this.getTitle(MenuState.C_DISBAND));
        int SLOT_YES = 3;
        int SLOT_NO = 5;
        ConfirmationIcon icon = new ConfirmationIcon(true, SLOT_YES);
        icon.addHint(MessagePath.MENU_KINGDOM_HINT_DISBAND.getMessage(new Object[0]));
        icon.setState(MenuState.CONFIRM_YES);
        result.addIcon(icon);
        icon = new ConfirmationIcon(false, SLOT_NO);
        icon.addHint(MessagePath.MENU_HINT_EXIT.getMessage(new Object[0]));
        icon.setState(MenuState.CONFIRM_NO);
        result.addIcon(icon);
        this.addNavEmpty(result);
        this.addNavClose(result);
        this.addNavReturn(result);
        return result;
    }

    private List<DisplayView> createTemplateView() {
        ArrayList<MenuIcon> icons = new ArrayList<MenuIcon>();
        for (KonMonumentTemplate template : this.getKonquest().getSanctuaryManager().getAllTemplates()) {
            if (this.kingdom.getMonumentTemplate() != null && this.kingdom.getMonumentTemplate().equals(template)) continue;
            boolean isClickable = true;
            double totalCost = 0.0;
            if (template.isValid()) {
                if (!this.isAdmin && this.kingdom.hasMonumentTemplate()) {
                    totalCost = this.manager.getCostTemplate() + template.getCost();
                }
            } else {
                isClickable = false;
            }
            TemplateIcon icon = new TemplateIcon(template, 0, isClickable);
            icon.addNameValue(MessagePath.LABEL_LOOT_TYPE.getMessage(new Object[0]), this.getKonquest().getLootManager().getMonumentLootDisplayName(template));
            icon.addNameValue(MessagePath.LABEL_COST.getMessage(new Object[0]), KonquestPlugin.getCurrencyFormat(totalCost));
            if (isClickable) {
                icon.addHint(MessagePath.MENU_KINGDOM_HINT_TEMPLATE.getMessage(new Object[0]));
            }
            icons.add(icon);
        }
        return new ArrayList<DisplayView>(this.makePages(icons, this.getTitle(MenuState.C_TEMPLATE)));
    }

    private DisplayView createDiplomacyView() {
        if (this.diplomacyKingdom == null || this.diplomacyKingdom.equals(this.kingdom)) {
            return null;
        }
        int numIcons = KonquestDiplomacyType.values().length + 2;
        int numRows = (int)Math.ceil((double)numIcons / 9.0);
        int index = 0;
        DisplayView result = new DisplayView(numRows, this.getTitle(MenuState.B_DIPLOMACY));
        KonquestDiplomacyType currentDiplomacy = this.manager.getDiplomacy(this.kingdom, this.diplomacyKingdom);
        String diplomacyState = Labeler.lookup(currentDiplomacy);
        MenuIcon icon = new KingdomIcon(this.diplomacyKingdom, this.getColor(this.kingdom, this.diplomacyKingdom), this.getRelation(this.kingdom, this.diplomacyKingdom), index, false);
        icon.addNameValue(MessagePath.LABEL_DIPLOMACY.getMessage(new Object[0]), diplomacyState);
        if (this.kingdom.hasRelationRequest(this.diplomacyKingdom) || this.diplomacyKingdom.hasRelationRequest(this.kingdom)) {
            icon.addAlert(MessagePath.MENU_KINGDOM_REQUESTS.getMessage(new Object[0]));
        }
        if (this.kingdom.hasRelationRequest(this.diplomacyKingdom)) {
            String ourRequestStatus = Labeler.lookup(this.kingdom.getRelationRequest(this.diplomacyKingdom));
            icon.addNameValue(MessagePath.MENU_KINGDOM_THEY_REQUESTED.getMessage(new Object[0]), ourRequestStatus);
        }
        if (this.diplomacyKingdom.hasRelationRequest(this.kingdom)) {
            String theirRequestStatus = Labeler.lookup(this.diplomacyKingdom.getRelationRequest(this.kingdom));
            icon.addNameValue(MessagePath.MENU_KINGDOM_WE_REQUESTED.getMessage(new Object[0]), theirRequestStatus);
        }
        result.addIcon(icon);
        index = 2;
        if (this.isCreatedKingdom) {
            boolean isInstantWar = this.getKonquest().getCore().getBoolean(CorePath.KINGDOMS_INSTANT_WAR.getPath(), false);
            boolean isInstantPeace = this.getKonquest().getCore().getBoolean(CorePath.KINGDOMS_INSTANT_PEACE.getPath(), false);
            for (KonquestDiplomacyType relation : KonquestDiplomacyType.values()) {
                boolean isValidChoice = this.manager.isValidRelationChoice(this.kingdom, this.diplomacyKingdom, relation);
                ChatColor relationColor = ChatColor.GRAY;
                String description = MessagePath.LABEL_UNAVAILABLE.getMessage(new Object[0]);
                String detailedInfo = "";
                boolean isClickable = false;
                if (isValidChoice) {
                    isClickable = true;
                    relationColor = ChatColor.GOLD;
                    switch (relation) {
                        case PEACE: {
                            if (currentDiplomacy.equals((Object)KonquestDiplomacyType.WAR)) {
                                description = isInstantPeace ? MessagePath.MENU_KINGDOM_DIPLOMACY_PEACE_WAR_INSTANT.getMessage(new Object[0]) : MessagePath.MENU_KINGDOM_DIPLOMACY_PEACE_WAR_REQUEST.getMessage(new Object[0]);
                            } else if (currentDiplomacy.equals((Object)KonquestDiplomacyType.TRADE)) {
                                description = MessagePath.MENU_KINGDOM_DIPLOMACY_PEACE_TRADE.getMessage(new Object[0]);
                            } else if (currentDiplomacy.equals((Object)KonquestDiplomacyType.ALLIANCE)) {
                                description = MessagePath.MENU_KINGDOM_DIPLOMACY_PEACE_ALLIANCE.getMessage(new Object[0]);
                            }
                            detailedInfo = MessagePath.MENU_KINGDOM_DIPLOMACY_PEACE_INFO.getMessage(new Object[0]);
                            break;
                        }
                        case TRADE: {
                            if (currentDiplomacy.equals((Object)KonquestDiplomacyType.PEACE)) {
                                description = MessagePath.MENU_KINGDOM_DIPLOMACY_TRADE_PEACE.getMessage(new Object[0]);
                            } else if (currentDiplomacy.equals((Object)KonquestDiplomacyType.ALLIANCE)) {
                                description = MessagePath.MENU_KINGDOM_DIPLOMACY_TRADE_ALLIANCE.getMessage(new Object[0]);
                            }
                            detailedInfo = MessagePath.MENU_KINGDOM_DIPLOMACY_TRADE_INFO.getMessage(new Object[0]);
                            break;
                        }
                        case WAR: {
                            description = isInstantWar ? MessagePath.MENU_KINGDOM_DIPLOMACY_WAR_INSTANT.getMessage(new Object[0]) : MessagePath.MENU_KINGDOM_DIPLOMACY_WAR_REQUEST.getMessage(new Object[0]);
                            detailedInfo = MessagePath.MENU_KINGDOM_DIPLOMACY_WAR_INFO.getMessage(new Object[0]);
                            break;
                        }
                        case ALLIANCE: {
                            description = MessagePath.MENU_KINGDOM_DIPLOMACY_ALLIANCE.getMessage(new Object[0]);
                            detailedInfo = MessagePath.MENU_KINGDOM_DIPLOMACY_ALLIANCE_INFO.getMessage(new Object[0]);
                            break;
                        }
                    }
                }
                icon = new DiplomacyIcon(relation, index, isClickable);
                icon.addDescription(description, relationColor);
                if (isValidChoice) {
                    icon.addDescription(detailedInfo);
                    if (!this.isAdmin) {
                        double costRelation = this.manager.getRelationCost(relation);
                        icon.addNameValue(MessagePath.LABEL_COST.getMessage(new Object[0]), KonquestPlugin.getCurrencyFormat(costRelation));
                    }
                    icon.addHint(MessagePath.MENU_KINGDOM_HINT_DIPLOMACY.getMessage(new Object[0]));
                }
                result.addIcon(icon);
                ++index;
            }
        }
        this.addNavEmpty(result);
        this.addNavClose(result);
        this.addNavReturn(result);
        return result;
    }

    private List<DisplayView> createKingdomView(MenuState context) {
        ArrayList<MenuIcon> icons = new ArrayList<MenuIcon>();
        boolean isClickable = false;
        ArrayList<KonKingdom> kingdoms = new ArrayList<KonKingdom>();
        switch (context.ordinal()) {
            case 1: {
                kingdoms.addAll(this.manager.getKingdoms());
                if (this.isCreatedKingdom) {
                    kingdoms.remove(this.kingdom);
                }
                isClickable = true;
                break;
            }
            case 5: {
                kingdoms.addAll(this.manager.getInviteKingdoms(this.player));
                if (this.isCreatedKingdom) {
                    kingdoms.remove(this.kingdom);
                }
                isClickable = true;
                break;
            }
            case 6: {
                kingdoms.addAll(this.manager.getKingdoms());
                isClickable = true;
                break;
            }
            case 7: {
                for (KonKingdom otherKingdom : this.manager.getKingdoms()) {
                    if (otherKingdom.equals(this.kingdom) || otherKingdom.isPeaceful()) continue;
                    kingdoms.add(otherKingdom);
                }
                isClickable = true;
                break;
            }
        }
        kingdoms.sort(this.kingdomComparator);
        for (KonKingdom currentKingdom : kingdoms) {
            KingdomIcon icon = new KingdomIcon(currentKingdom, this.getColor((KonOfflinePlayer)this.player, currentKingdom), this.getRelation((KonOfflinePlayer)this.player, currentKingdom), 0, isClickable);
            if (this.isCreatedKingdom) {
                String diplomacyState = currentKingdom.equals(this.kingdom) ? MessagePath.DIPLOMACY_SELF.getMessage(new Object[0]) : Labeler.lookup(this.manager.getDiplomacy(this.kingdom, currentKingdom));
                icon.addNameValue(MessagePath.LABEL_DIPLOMACY.getMessage(new Object[0]), diplomacyState);
                if (this.kingdom.hasRelationRequest(currentKingdom) || currentKingdom.hasRelationRequest(this.kingdom)) {
                    icon.addAlert(MessagePath.MENU_KINGDOM_REQUESTS.getMessage(new Object[0]));
                }
                if (this.kingdom.hasRelationRequest(currentKingdom)) {
                    String ourRequestStatus = Labeler.lookup(this.kingdom.getRelationRequest(currentKingdom));
                    icon.addNameValue(MessagePath.MENU_KINGDOM_THEY_REQUESTED.getMessage(new Object[0]), ourRequestStatus);
                }
                if (currentKingdom.hasRelationRequest(this.kingdom)) {
                    String theirRequestStatus = Labeler.lookup(currentKingdom.getRelationRequest(this.kingdom));
                    icon.addNameValue(MessagePath.MENU_KINGDOM_WE_REQUESTED.getMessage(new Object[0]), theirRequestStatus);
                }
            }
            switch (context.ordinal()) {
                case 1: {
                    if (this.manager.isPlayerJoinKingdomAllowed(this.player, currentKingdom) != 0 || !currentKingdom.isJoinable() || this.kingdom.isCreated() && !this.kingdom.isLeaveable()) {
                        icon.addAlert(MessagePath.LABEL_UNAVAILABLE.getMessage(new Object[0]));
                    }
                    if (currentKingdom.isOpen()) {
                        icon.addHint(MessagePath.MENU_KINGDOM_HINT_JOIN_NOW.getMessage(new Object[0]));
                        break;
                    }
                    icon.addHint(MessagePath.MENU_KINGDOM_HINT_JOIN.getMessage(new Object[0]));
                    break;
                }
                case 5: {
                    if (this.manager.isPlayerJoinKingdomAllowed(this.player, currentKingdom) != 0 || !currentKingdom.isJoinable() || this.kingdom.isCreated() && !this.kingdom.isLeaveable()) {
                        icon.addAlert(MessagePath.LABEL_UNAVAILABLE.getMessage(new Object[0]));
                    }
                    icon.addHint(MessagePath.MENU_HINT_ACCEPT.getMessage(new Object[0]));
                    icon.addHint(MessagePath.MENU_HINT_DECLINE.getMessage(new Object[0]));
                    break;
                }
                case 6: {
                    icon.addProperty(MessagePath.LABEL_INFORMATION.getMessage(new Object[0]));
                    icon.addHint(MessagePath.MENU_HINT_VIEW.getMessage(new Object[0]));
                    break;
                }
                case 7: {
                    icon.addHint(MessagePath.MENU_KINGDOM_HINT_RELATION.getMessage(new Object[0]));
                    break;
                }
            }
            icons.add(icon);
        }
        return new ArrayList<DisplayView>(this.makePages(icons, this.getTitle(context)));
    }

    private List<DisplayView> createTownView(MenuState context) {
        ArrayList<MenuIcon> icons = new ArrayList<MenuIcon>();
        ArrayList<KonTown> towns = new ArrayList<KonTown>();
        switch (context.ordinal()) {
            case 10: {
                for (KonKingdom otherKingdom : this.getKonquest().getKingdomManager().getKingdoms()) {
                    if (otherKingdom.equals(this.kingdom)) continue;
                    towns.addAll(otherKingdom.getTowns());
                }
                break;
            }
            case 12: {
                for (KonTown town : this.kingdom.getTowns()) {
                    this.getKonquest().getKingdomManager().refreshPurchaseOffers(town);
                    if (!town.hasPurchaseOffers()) continue;
                    towns.add(town);
                }
                break;
            }
            case 18: 
            case 19: {
                towns.addAll(this.kingdom.getTowns());
                break;
            }
        }
        towns.sort(this.townComparator);
        for (KonTown currentTown : towns) {
            TownIcon icon = new TownIcon(currentTown, this.getColor((KonOfflinePlayer)this.player, currentTown), this.getRelation((KonOfflinePlayer)this.player, currentTown), 0, true);
            switch (context.ordinal()) {
                case 10: {
                    icon.addNameValue(MessagePath.LABEL_KINGDOM.getMessage(new Object[0]), currentTown.getKingdom().getName());
                    int numOffers = currentTown.getPurchaseOffers().size();
                    icon.addNameValue(MessagePath.MENU_KINGDOM_PURCHASE_OFFERS.getMessage(new Object[0]), numOffers);
                    double offerAmount = currentTown.getPurchaseOfferAmount(this.player.getBukkitPlayer().getUniqueId());
                    if (offerAmount >= 0.0) {
                        icon.addNameValue(MessagePath.MENU_KINGDOM_PURCHASE_YOUR_OFFER.getMessage(new Object[0]), KonquestPlugin.getCurrencyFormat(offerAmount));
                    }
                    icon.addHint(MessagePath.MENU_HINT_OPEN.getMessage(new Object[0]));
                    break;
                }
                case 12: {
                    int numOffers = currentTown.getPurchaseOffers().size();
                    icon.addNameValue(MessagePath.MENU_KINGDOM_PURCHASE_OFFERS.getMessage(new Object[0]), numOffers);
                    icon.addHint(MessagePath.MENU_HINT_VIEW.getMessage(new Object[0]));
                    break;
                }
                case 18: {
                    icon.addHint(MessagePath.MENU_TOWN_HINT_DESTROY.getMessage(new Object[0]));
                    break;
                }
                case 19: {
                    double costSwap = this.getKonquest().getKingdomManager().getCostCapitalSwap();
                    icon.addNameValue(MessagePath.LABEL_COST.getMessage(new Object[0]), KonquestPlugin.getCurrencyFormat(costSwap));
                    icon.addHint(MessagePath.MENU_KINGDOM_HINT_CAPITAL.getMessage(new Object[0]));
                    break;
                }
            }
            icons.add(icon);
        }
        return new ArrayList<DisplayView>(this.makePages(icons, this.getTitle(context)));
    }

    private List<DisplayView> createPlayerView(MenuState context) {
        ArrayList<MenuIcon> icons = new ArrayList<MenuIcon>();
        ArrayList<OfflinePlayer> players = new ArrayList<OfflinePlayer>();
        switch (context.ordinal()) {
            case 13: {
                if (this.purchaseOfferTown == null) break;
                this.getKonquest().getKingdomManager().refreshPurchaseOffers(this.purchaseOfferTown);
                for (UUID id : this.purchaseOfferTown.getPurchaseOffers()) {
                    OfflinePlayer offerPlayer = Bukkit.getOfflinePlayer((UUID)id);
                    if (!this.getKonquest().getPlayerManager().isOfflinePlayer(offerPlayer)) continue;
                    players.add(offerPlayer);
                }
                break;
            }
            case 9: {
                players.addAll(this.kingdom.getJoinRequests());
                break;
            }
            case 14: {
                players.addAll(this.kingdom.getPlayerMembersOnly());
                break;
            }
            case 15: {
                players.addAll(this.kingdom.getPlayerOfficersOnly());
                break;
            }
            case 16: {
                players.addAll(this.kingdom.getPlayerOfficersOnly());
                players.addAll(this.kingdom.getPlayerMembersOnly());
                break;
            }
        }
        for (OfflinePlayer currentPlayer : players) {
            KonOfflinePlayer offlinePlayer = this.getKonquest().getPlayerManager().getOfflinePlayer(currentPlayer);
            if (offlinePlayer == null) continue;
            PlayerIcon icon = new PlayerIcon(currentPlayer, this.getColor((KonOfflinePlayer)this.player, offlinePlayer), this.getRelation((KonOfflinePlayer)this.player, offlinePlayer), 0, true);
            String kingdomRole = this.kingdom.getPlayerRankName(currentPlayer);
            if (!kingdomRole.isEmpty()) {
                icon.addNameValue(MessagePath.LABEL_KINGDOM_RANK.getMessage(new Object[0]), kingdomRole);
            }
            switch (context.ordinal()) {
                case 13: {
                    OfflinePlayer kingdomMaster = this.kingdom.getPlayerMaster();
                    String receiverName = kingdomMaster == null ? this.player.getBukkitPlayer().getName() : kingdomMaster.getName();
                    String offerTownName = this.purchaseOfferTown.getName();
                    String otherKingdomName = offlinePlayer.getKingdom().getName();
                    String offerAmount = KonquestPlugin.getCurrencyFormat(this.purchaseOfferTown.getPurchaseOfferAmount(currentPlayer.getUniqueId()));
                    icon.addNameValue(MessagePath.LABEL_KINGDOM.getMessage(new Object[0]), otherKingdomName);
                    icon.addNameValue(MessagePath.TERRITORY_TOWN.getMessage(new Object[0]), offerTownName);
                    icon.addNameValue(MessagePath.MENU_KINGDOM_PURCHASE_THEIR_OFFER.getMessage(new Object[0]), offerAmount);
                    icon.addDescription(MessagePath.MENU_KINGDOM_DESCRIPTION_OFFER_ACCEPT.getMessage(offerTownName, otherKingdomName, receiverName, offerAmount, currentPlayer.getName()));
                    icon.addHint(MessagePath.MENU_HINT_ACCEPT.getMessage(new Object[0]));
                    icon.addHint(MessagePath.MENU_HINT_DECLINE.getMessage(new Object[0]));
                    break;
                }
                case 9: {
                    icon.addHint(MessagePath.MENU_HINT_ACCEPT.getMessage(new Object[0]));
                    icon.addHint(MessagePath.MENU_HINT_DECLINE.getMessage(new Object[0]));
                    break;
                }
                case 14: {
                    icon.addHint(MessagePath.MENU_KINGDOM_HINT_PROMOTE.getMessage(new Object[0]));
                    break;
                }
                case 15: {
                    icon.addHint(MessagePath.MENU_KINGDOM_HINT_DEMOTE.getMessage(new Object[0]));
                    break;
                }
                case 16: {
                    icon.addHint(MessagePath.MENU_KINGDOM_HINT_TRANSFER.getMessage(new Object[0]));
                    break;
                }
            }
            icons.add(icon);
        }
        return new ArrayList<DisplayView>(this.makePages(icons, this.getTitle(context)));
    }

    private DisplayView createPurchaseAmountView() {
        DisplayView result = new DisplayView(1, this.getTitle(MenuState.B_PURCHASE_AMOUNT));
        int SLOT_MODIFIER = 2;
        int SLOT_AMOUNT = 4;
        int SLOT_PURCHASE = 6;
        String townName = "";
        String kingdomName = "";
        boolean isClickable = false;
        double offerAmount = -1.0;
        if (this.purchaseOfferTown != null) {
            townName = this.purchaseOfferTown.getName();
            kingdomName = this.purchaseOfferTown.getKingdom().getName();
            isClickable = true;
            offerAmount = this.purchaseOfferTown.getPurchaseOfferAmount(this.player.getBukkitPlayer().getUniqueId());
        }
        String amount = KonquestPlugin.getCurrencyFormat(this.purchaseOfferAmount);
        String modify = KonquestPlugin.getCurrencyFormat(this.purchaseOfferModify);
        String currentOffer = KonquestPlugin.getCurrencyFormat(offerAmount);
        boolean isPurchaseClickable = isClickable && this.purchaseOfferAmount >= 1.0;
        InfoIcon icon = new InfoIcon(MessagePath.MENU_KINGDOM_PURCHASE_YOUR_OFFER.getMessage(new Object[0]), Material.WRITABLE_BOOK, SLOT_PURCHASE, isPurchaseClickable);
        icon.addNameValue(MessagePath.TERRITORY_TOWN.getMessage(new Object[0]), townName);
        icon.addNameValue(MessagePath.LABEL_KINGDOM.getMessage(new Object[0]), kingdomName);
        if (offerAmount >= 0.0) {
            icon.addNameValue(MessagePath.LABEL_CURRENT.getMessage(new Object[0]), currentOffer);
        }
        icon.addNameValue(MessagePath.LABEL_TOTAL.getMessage(new Object[0]), amount);
        icon.setInfo("purchase");
        if (isPurchaseClickable) {
            icon.addHint(MessagePath.MENU_KINGDOM_HINT_PURCHASE.getMessage(new Object[0]));
        } else {
            icon.addAlert(MessagePath.LABEL_UNAVAILABLE.getMessage(new Object[0]));
        }
        result.addIcon(icon);
        icon = new InfoIcon(MessagePath.LABEL_AMOUNT.getMessage(new Object[0]), Material.GOLD_INGOT, SLOT_AMOUNT, isClickable);
        icon.addNameValue(MessagePath.LABEL_TOTAL.getMessage(new Object[0]), amount);
        icon.addDescription("+" + modify + " -" + modify);
        if (isClickable) {
            icon.addHint(MessagePath.MENU_HINT_INCREASE.getMessage(new Object[0]));
            icon.addHint(MessagePath.MENU_HINT_DECREASE.getMessage(new Object[0]));
        }
        icon.setInfo("amount");
        result.addIcon(icon);
        icon = new InfoIcon(MessagePath.LABEL_MODIFIER.getMessage(new Object[0]), Material.GOLD_NUGGET, SLOT_MODIFIER, isClickable);
        icon.addNameValue(MessagePath.LABEL_TOTAL.getMessage(new Object[0]), modify);
        icon.addDescription("\u00d710 \u00f710");
        if (isClickable) {
            icon.addHint(MessagePath.MENU_HINT_INCREASE.getMessage(new Object[0]));
            icon.addHint(MessagePath.MENU_HINT_DECREASE.getMessage(new Object[0]));
        }
        icon.setInfo("modifier");
        result.addIcon(icon);
        this.addNavEmpty(result);
        this.addNavClose(result);
        this.addNavReturn(result);
        return result;
    }

    @Override
    public ArrayList<DisplayView> createView(StateMenu.State context) {
        ArrayList<DisplayView> result = new ArrayList<DisplayView>();
        MenuState currentState = (MenuState)context;
        switch (currentState.ordinal()) {
            case 0: {
                result.add(this.createRootView());
                break;
            }
            case 3: {
                result.add(this.createExileView());
                break;
            }
            case 8: {
                result.add(this.createDiplomacyView());
                break;
            }
            case 21: {
                result.add(this.createDisbandView());
                break;
            }
            case 11: {
                result.add(this.createPurchaseAmountView());
                break;
            }
            case 20: {
                result.addAll(this.createTemplateView());
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: {
                result.addAll(this.createKingdomView(currentState));
                break;
            }
            case 9: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                result.addAll(this.createPlayerView(currentState));
                break;
            }
            case 10: 
            case 12: 
            case 18: 
            case 19: {
                result.addAll(this.createTownView(currentState));
                break;
            }
        }
        return result;
    }

    @Override
    public DisplayView updateState(int slot, boolean clickType) {
        DisplayView result = null;
        MenuState currentState = (MenuState)this.getCurrentState();
        if (currentState == null) {
            return null;
        }
        if (this.isCurrentNavSlot(slot)) {
            if (this.isNavClose(slot)) {
                return null;
            }
            if (this.isNavHome(slot)) {
                this.getKonquest().getDisplayManager().displayMainMenu(this.player);
            } else if (this.isNavReturn(slot)) {
                switch (currentState.ordinal()) {
                    case 8: {
                        result = this.refreshNewView(MenuState.B_RELATIONSHIP);
                        break;
                    }
                    case 11: {
                        result = this.refreshNewView(MenuState.B_PURCHASE);
                        break;
                    }
                    case 13: {
                        result = this.refreshNewView(MenuState.B_OFFERS);
                        break;
                    }
                    default: {
                        result = this.refreshNewView(MenuState.ROOT);
                        break;
                    }
                }
            } else if (this.isNavBack(slot)) {
                result = this.goPageBack();
            } else if (this.isNavNext(slot)) {
                result = this.goPageNext();
            }
        } else if (this.isCurrentMenuSlot(slot)) {
            DisplayView view = this.getCurrentView();
            if (view == null) {
                return null;
            }
            MenuIcon clickedIcon = view.getIcon(slot);
            MenuState nextState = (MenuState)clickedIcon.getState();
            switch (currentState.ordinal()) {
                case 0: {
                    if (nextState == null) {
                        return null;
                    }
                    switch (nextState.ordinal()) {
                        case 1: 
                        case 3: 
                        case 5: 
                        case 6: 
                        case 7: 
                        case 9: 
                        case 10: 
                        case 12: 
                        case 14: 
                        case 15: 
                        case 16: 
                        case 18: 
                        case 19: 
                        case 20: 
                        case 21: {
                            result = this.refreshNewView(nextState);
                            break;
                        }
                        case 2: {
                            for (String usageLine : CommandType.KINGDOM.command().getArgumentUsage("create")) {
                                ChatUtil.sendNotice((CommandSender)this.player.getBukkitPlayer(), usageLine);
                            }
                            result = view;
                            break;
                        }
                        case 4: {
                            this.getKonquest().getDisplayManager().displayInfoKingdomMenu(this.player, this.kingdom);
                            break;
                        }
                        case 17: {
                            this.manager.menuToggleKingdomOpen(this.kingdom, this.player);
                            this.playStatusSound(this.player.getBukkitPlayer(), true);
                            result = this.refreshCurrentView();
                        }
                    }
                    break;
                }
                case 1: {
                    if (!(clickedIcon instanceof KingdomIcon)) break;
                    KingdomIcon icon = (KingdomIcon)clickedIcon;
                    KonKingdom clickKingdom = icon.getKingdom();
                    boolean status = this.manager.menuJoinKingdomRequest(this.player, clickKingdom);
                    this.playStatusSound(this.player.getBukkitPlayer(), status);
                    break;
                }
                case 3: {
                    if (nextState == null) {
                        return null;
                    }
                    if (!nextState.equals(MenuState.CONFIRM_YES)) break;
                    boolean status = this.manager.menuExileKingdom(this.player);
                    this.playStatusSound(this.player.getBukkitPlayer(), status);
                    break;
                }
                case 5: {
                    if (!(clickedIcon instanceof KingdomIcon)) break;
                    KingdomIcon icon = (KingdomIcon)clickedIcon;
                    KonKingdom clickKingdom = icon.getKingdom();
                    boolean status = this.manager.menuRespondKingdomInvite(this.player, clickKingdom, clickType);
                    this.playStatusSound(this.player.getBukkitPlayer(), status);
                    if (status) break;
                    result = this.refreshCurrentView();
                    break;
                }
                case 6: {
                    if (!(clickedIcon instanceof KingdomIcon)) break;
                    KingdomIcon icon = (KingdomIcon)clickedIcon;
                    KonKingdom clickKingdom = icon.getKingdom();
                    this.getKonquest().getDisplayManager().displayInfoKingdomMenu(this.player, clickKingdom);
                    break;
                }
                case 7: {
                    if (!(clickedIcon instanceof KingdomIcon)) break;
                    KingdomIcon icon = (KingdomIcon)clickedIcon;
                    this.diplomacyKingdom = icon.getKingdom();
                    result = this.refreshNewView(MenuState.B_DIPLOMACY);
                    break;
                }
                case 8: {
                    if (!(clickedIcon instanceof DiplomacyIcon)) break;
                    DiplomacyIcon icon = (DiplomacyIcon)clickedIcon;
                    KonquestDiplomacyType clickRelation = icon.getRelation();
                    boolean status = this.manager.menuChangeKingdomRelation(this.kingdom, this.diplomacyKingdom, clickRelation, this.player, this.isAdmin);
                    this.playStatusSound(this.player.getBukkitPlayer(), status);
                    this.diplomacyKingdom = null;
                    if (!status) break;
                    result = this.refreshNewView(MenuState.B_RELATIONSHIP);
                    break;
                }
                case 9: {
                    if (!(clickedIcon instanceof PlayerIcon)) break;
                    PlayerIcon icon = (PlayerIcon)clickedIcon;
                    KonOfflinePlayer clickPlayer = this.getKonquest().getPlayerManager().getOfflinePlayer(icon.getOfflinePlayer());
                    boolean status = this.manager.menuRespondKingdomRequest(this.player, clickPlayer, this.kingdom, clickType);
                    this.playStatusSound(this.player.getBukkitPlayer(), status);
                    result = this.refreshCurrentView();
                    break;
                }
                case 10: {
                    if (!(clickedIcon instanceof TownIcon)) break;
                    TownIcon icon = (TownIcon)clickedIcon;
                    this.purchaseOfferTown = icon.getTown();
                    this.purchaseOfferAmount = 0.0;
                    this.purchaseOfferModify = 1.0;
                    result = this.refreshNewView(MenuState.B_PURCHASE_AMOUNT);
                    break;
                }
                case 11: {
                    if (!(clickedIcon instanceof InfoIcon)) break;
                    InfoIcon icon = (InfoIcon)clickedIcon;
                    switch (icon.getInfo().toLowerCase()) {
                        case "purchase": {
                            boolean status = this.manager.applyTownPurchaseOffer(this.purchaseOfferTown, this.player, this.purchaseOfferAmount);
                            this.playStatusSound(this.player.getBukkitPlayer(), status);
                            result = this.refreshNewView(MenuState.B_PURCHASE);
                            break;
                        }
                        case "amount": {
                            if (clickType) {
                                double modifiedAmount = this.purchaseOfferAmount + this.purchaseOfferModify;
                                this.purchaseOfferAmount = Math.min(modifiedAmount, 1.0E9);
                            } else {
                                double modifiedAmount = this.purchaseOfferAmount - this.purchaseOfferModify;
                                this.purchaseOfferAmount = Math.max(modifiedAmount, 0.0);
                            }
                            result = this.refreshCurrentView();
                            break;
                        }
                        case "modifier": {
                            if (clickType) {
                                double shiftedModifier = this.purchaseOfferModify * 10.0;
                                this.purchaseOfferModify = Math.min(shiftedModifier, 1.0E8);
                            } else {
                                double shiftedModifier = this.purchaseOfferModify / 10.0;
                                this.purchaseOfferModify = Math.max(shiftedModifier, 1.0);
                            }
                            result = this.refreshCurrentView();
                        }
                    }
                    break;
                }
                case 12: {
                    if (!(clickedIcon instanceof TownIcon)) break;
                    TownIcon icon = (TownIcon)clickedIcon;
                    this.purchaseOfferTown = icon.getTown();
                    result = this.refreshNewView(MenuState.B_OFFERS_PLAYERS);
                    break;
                }
                case 13: {
                    if (!(clickedIcon instanceof PlayerIcon)) break;
                    PlayerIcon icon = (PlayerIcon)clickedIcon;
                    boolean status = this.manager.respondTownPurchaseOffer(this.purchaseOfferTown, this.player, icon.getOfflinePlayer().getUniqueId(), clickType);
                    this.playStatusSound(this.player.getBukkitPlayer(), status);
                    if (clickType) {
                        result = this.refreshNewView(MenuState.B_OFFERS);
                        break;
                    }
                    result = this.refreshCurrentView();
                    break;
                }
                case 14: {
                    if (!(clickedIcon instanceof PlayerIcon)) break;
                    PlayerIcon icon = (PlayerIcon)clickedIcon;
                    OfflinePlayer clickPlayer = icon.getOfflinePlayer();
                    boolean status = this.manager.menuPromoteOfficer(clickPlayer, this.kingdom);
                    this.playStatusSound(this.player.getBukkitPlayer(), status);
                    result = this.refreshCurrentView();
                    break;
                }
                case 15: {
                    if (!(clickedIcon instanceof PlayerIcon)) break;
                    PlayerIcon icon = (PlayerIcon)clickedIcon;
                    OfflinePlayer clickPlayer = icon.getOfflinePlayer();
                    boolean status = this.manager.menuDemoteOfficer(clickPlayer, this.kingdom);
                    this.playStatusSound(this.player.getBukkitPlayer(), status);
                    result = this.refreshCurrentView();
                    break;
                }
                case 16: {
                    if (!(clickedIcon instanceof PlayerIcon)) break;
                    PlayerIcon icon = (PlayerIcon)clickedIcon;
                    OfflinePlayer clickPlayer = icon.getOfflinePlayer();
                    boolean status = this.manager.menuTransferMaster(clickPlayer, this.kingdom, this.player);
                    this.playStatusSound(this.player.getBukkitPlayer(), status);
                    break;
                }
                case 18: {
                    if (!(clickedIcon instanceof TownIcon)) break;
                    TownIcon icon = (TownIcon)clickedIcon;
                    KonTown clickTown = icon.getTown();
                    boolean status = this.manager.menuDestroyTown(clickTown, this.player);
                    this.playStatusSound(this.player.getBukkitPlayer(), status);
                    break;
                }
                case 19: {
                    if (!(clickedIcon instanceof TownIcon)) break;
                    TownIcon icon = (TownIcon)clickedIcon;
                    KonTown clickTown = icon.getTown();
                    boolean status = this.manager.menuCapitalSwap(clickTown, this.player, this.isAdmin);
                    this.playStatusSound(this.player.getBukkitPlayer(), status);
                    break;
                }
                case 20: {
                    if (!(clickedIcon instanceof TemplateIcon)) break;
                    TemplateIcon icon = (TemplateIcon)clickedIcon;
                    KonMonumentTemplate template = icon.getTemplate();
                    boolean status = this.manager.menuChangeKingdomTemplate(this.kingdom, template, this.player, this.isAdmin);
                    this.playStatusSound(this.player.getBukkitPlayer(), status);
                    result = this.refreshCurrentView();
                    break;
                }
                case 21: {
                    if (nextState == null) {
                        return null;
                    }
                    if (!nextState.equals(MenuState.CONFIRM_YES)) break;
                    boolean status = this.manager.menuDisbandKingdom(this.kingdom, this.player);
                    this.playStatusSound(this.player.getBukkitPlayer(), status);
                    break;
                }
            }
        }
        return result;
    }

    private String getTitle(MenuState context) {
        Object result = "error";
        switch (context.ordinal()) {
            case 0: {
                result = MessagePath.MENU_MAIN_KINGDOM.getMessage(new Object[0]);
                break;
            }
            case 1: {
                result = MessagePath.MENU_KINGDOM_TITLE_JOIN.getMessage(new Object[0]);
                break;
            }
            case 3: {
                result = MessagePath.MENU_KINGDOM_TITLE_CONFIRM.getMessage(new Object[0]);
                break;
            }
            case 5: {
                result = MessagePath.MENU_KINGDOM_TITLE_INVITES.getMessage(new Object[0]);
                break;
            }
            case 6: {
                result = MessagePath.MENU_KINGDOM_TITLE_LIST.getMessage(new Object[0]);
                break;
            }
            case 7: {
                result = MessagePath.MENU_KINGDOM_TITLE_RELATIONS.getMessage(new Object[0]);
                break;
            }
            case 8: {
                result = MessagePath.MENU_KINGDOM_TITLE_DIPLOMACY.getMessage(new Object[0]);
                break;
            }
            case 9: {
                result = MessagePath.MENU_KINGDOM_TITLE_REQUESTS.getMessage(new Object[0]);
                break;
            }
            case 10: {
                result = MessagePath.MENU_KINGDOM_TITLE_PURCHASE.getMessage(new Object[0]);
                break;
            }
            case 11: {
                result = MessagePath.MENU_KINGDOM_TITLE_AMOUNT.getMessage(new Object[0]);
                break;
            }
            case 12: 
            case 13: {
                result = MessagePath.MENU_KINGDOM_TITLE_OFFERS.getMessage(new Object[0]);
                break;
            }
            case 14: {
                result = MessagePath.MENU_KINGDOM_TITLE_PROMOTION.getMessage(new Object[0]);
                break;
            }
            case 15: {
                result = MessagePath.MENU_KINGDOM_TITLE_DEMOTION.getMessage(new Object[0]);
                break;
            }
            case 16: {
                result = MessagePath.MENU_KINGDOM_TITLE_TRANSFER.getMessage(new Object[0]);
                break;
            }
            case 18: {
                result = MessagePath.MENU_TOWN_TITLE_DESTROY.getMessage(new Object[0]);
                break;
            }
            case 20: {
                result = MessagePath.MENU_KINGDOM_TITLE_TEMPLATE.getMessage(new Object[0]);
                break;
            }
            case 21: {
                result = MessagePath.MENU_KINGDOM_TITLE_DISBAND.getMessage(new Object[0]);
                break;
            }
            case 19: {
                result = MessagePath.MENU_KINGDOM_TITLE_CAPITAL.getMessage(new Object[0]);
                break;
            }
        }
        if (this.isAdmin) {
            result = DisplayManager.adminFormat + MessagePath.LABEL_ADMIN.getMessage(new Object[0]) + " - " + (String)result;
        }
        return result;
    }

    static enum MenuState implements StateMenu.State
    {
        ROOT,
        A_JOIN,
        A_CREATE,
        A_EXILE,
        A_INFO,
        A_INVITE,
        A_LIST,
        B_RELATIONSHIP,
        B_DIPLOMACY,
        B_REQUESTS,
        B_PURCHASE,
        B_PURCHASE_AMOUNT,
        B_OFFERS,
        B_OFFERS_PLAYERS,
        C_PROMOTE,
        C_DEMOTE,
        C_TRANSFER,
        C_OPEN,
        C_DESTROY,
        C_CAPITAL,
        C_TEMPLATE,
        C_DISBAND,
        CONFIRM_YES,
        CONFIRM_NO;

    }

    static enum AccessType implements StateMenu.Access
    {
        REGULAR,
        OFFICER,
        MASTER;

    }
}

